/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.BaseProducerSendTest;
import kafka.log.LogConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u000f\tI\u0002\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-\u001a:TK:$G+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t!\")Y:f!J|G-^2feN+g\u000e\u001a+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012a\u0005;fgR<&o\u001c8h'\u0016\u0014\u0018.\u00197ju\u0016\u0014H#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0005!i\u00113\u0005\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\nA\u0005\u0005\u0002&[5\taE\u0003\u0002(Q\u00051QM\u001d:peNT!!\u000b\u0016\u0002\r\r|W.\\8o\u0015\t)1F\u0003\u0002-=\u00051\u0011\r]1dQ\u0016L!A\f\u0014\u0003-M+'/[1mSj\fG/[8o\u000bb\u001cW\r\u001d;j_:DQ\u0001\r\u0001\u0005\u0002I\t\u0011\u0003^3ti\n\u000bGo\u00195TSj,',\u001a:pQ\ty#\u0004C\u00034\u0001\u0011\u0005!#\u0001\u0016uKN$8+\u001a8e\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3)\u0005IR\u0002\"\u0002\u001c\u0001\t\u0003\u0011\u0012!\f;fgR\u001cVM\u001c3O_:\u001cu.\u001c9sKN\u001cX\rZ'fgN\fw-Z,ji\"dunZ!qa\u0016tG\rV5nK\"\u0012QG\u0007\u0005\u0006s\u0001!\tAE\u0001\u0014i\u0016\u001cH/Q;u_\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u0015\u0003qiAQ\u0001\u0010\u0001\u0005\u0002I\tQ\u0004^3tiN+g\u000eZ,ji\"LeN^1mS\u0012\u001c%/Z1uKRKW.\u001a\u0015\u0003wi\u0001")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    @Test(expected=SerializationException.class)
    public void testWrongSerializer() {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.brokerList());
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record);
    }

    @Test
    public void testBatchSizeZero() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Test
    public void testSendCompressedMessageWithLogAppendTime() {
        String x$1 = this.brokerList();
        String x$2 = "gzip";
        int x$3 = Integer.MAX_VALUE;
        int x$4 = Integer.MAX_VALUE;
        int x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$5, x$2, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithLogAppendTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoCreateTopic() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        try {
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record).get()).offset());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testSendWithInvalidCreateTime() {
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        this.createTopic(this.topic(), 1, 2, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        try {
            try {
                producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
                throw this.fail("Should throw CorruptedRecordException", new Position("PlaintextProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTimestampException));
            }
        }
        finally {
            producer.close();
        }
        String x$7 = this.brokerList();
        String x$8 = "gzip";
        int x$9 = this.createProducer$default$2();
        int x$10 = this.createProducer$default$3();
        int x$11 = this.createProducer$default$4();
        long x$12 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$7, x$9, x$10, x$11, x$8, x$12);
        try {
            try {
                compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
                throw this.fail("Should throw CorruptedRecordException", new Position("PlaintextProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTimestampException));
            }
        }
        finally {
            compressedProducer.close();
        }
    }
}

