/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleanerTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0011%a\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000ba\u0006^3ti\u000ecW-\u00198TK\u001elWM\u001c;t/&$\bnQ8oGV\u0014(/\u001a8u'\u0016<W.\u001a8u\t\u0016dW\r^5p]\"\u00121\r\u0019\u0005\u0006O\u0002!\t\u0001U\u00010i\u0016\u001cHoU5{KR\u0013\u0018.\\7fI\u001a{'\u000f\u0015:fC2dwnY1uK\u0012\fe\u000eZ\"p[B\f7\r^3e)>\u0004\u0018n\u0019\u0015\u0003M\u0002DQA\u001b\u0001\u0005\u0002A\u000bq\u0004^3ti\u0012+\b\u000f\\5dCR,7\t[3dW\u00063G/\u001a:DY\u0016\fg.\u001b8hQ\tI\u0007\rC\u0003n\u0001\u0011\u0005\u0001+A\u0011uKN$()Y:jGR\u0013\u0018M\\:bGRLwN\\!xCJ,7\t\\3b]&tw\r\u000b\u0002mA\")\u0001\u000f\u0001C\u0001!\u0006IC/Z:u\u00072,\u0017M\\,ji\"$&/\u00198tC\u000e$\u0018n\u001c8t'B\fgN\\5oON+w-\\3oiND#a\u001c1\t\u000bM\u0004A\u0011\u0001)\u0002/Q,7\u000f^\"p[6LG/T1sW\u0016\u0014(+Z7pm\u0006d\u0007F\u0001:a\u0011\u00151\b\u0001\"\u0001Q\u0003\u0011\"Xm\u001d;EK2,G/\u001a3CCR\u001c\u0007.Z:XSRDgj\\'fgN\fw-Z:SK\u0006$\u0007FA;a\u0011\u0015I\b\u0001\"\u0001Q\u0003\u001d\"Xm\u001d;D_6l\u0017\u000e^'be.,'OU3uK:$\u0018n\u001c8XSRDW)\u001c9us\n\u000bGo\u00195)\u0005a\u0004\u0007\"\u0002?\u0001\t\u0003\u0001\u0016A\u0007;fgR\u001cE.Z1o\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007FA>a\u0011\u0015y\b\u0001\"\u0001Q\u0003!\"Xm\u001d;D_6l\u0017\u000e\u001e;fIR\u0013\u0018M\\:bGRLwN\\*qC:t\u0017N\\4TK\u001elWM\u001c;tQ\tq\b\r\u0003\u0004\u0002\u0006\u0001!\t\u0001U\u0001'i\u0016\u001cH/\u00112peR,G\r\u0016:b]N\f7\r^5p]N\u0003\u0018M\u001c8j]\u001e\u001cVmZ7f]R\u001c\bfAA\u0002A\"1\u00111\u0002\u0001\u0005\u0002A\u000ba\u0003^3ti\u0006\u0013wN\u001d;NCJ\\WM\u001d*f[>4\u0018\r\u001c\u0015\u0004\u0003\u0013\u0001\u0007BBA\t\u0001\u0011\u0005\u0001+\u0001\u0014uKN$X)\u001c9us\n\u000bGo\u00195SK6|g/\u00197XSRD7+Z9vK:\u001cWMU3vg\u0016D3!a\u0004a\u0011\u0019\t9\u0002\u0001C\u0001!\u00061C/Z:u\u0003\n|'\u000f^'be.,'OU3uK:$\u0018n\u001c8XSRDW)\u001c9us\n\u000bGo\u00195)\u0007\u0005U\u0001\r\u0003\u0004\u0002\u001e\u0001!\t\u0001U\u0001\u0011i\u0016\u001cH\u000fT1sO\u0016lUm]:bO\u0016D3!a\u0007a\u0011\u0019\t\u0019\u0003\u0001C\u0001!\u0006\u0019C/Z:u\u001b\u0016\u001c8/Y4f\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=NKN\u001c\u0018mZ3TSj,\u0007fAA\u0011A\"1\u0011\u0011\u0006\u0001\u0005\u0002A\u000bA\u0007^3ti6+7o]1hK2\u000b'oZ3s)\"\fg.T1y\u001b\u0016\u001c8/Y4f'&TXmV5uQ\u000e{'O];qi\"+\u0017\rZ3sQ\r\t9\u0003\u0019\u0005\u0007\u0003_\u0001A\u0011\u0001)\u0002]Q,7\u000f^\"peJ,\b\u000f^'fgN\fw-Z*ju\u0016d\u0015M]4feRC\u0017M\u001c\"zi\u0016\u001c\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0004\u0003[\u0001\u0007bBA\u001b\u0001\u0011\u0005\u0011qG\u0001'GJ,\u0017\r^3M_\u001e<\u0016\u000e\u001e5NKN\u001c\u0018mZ3t\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=TSj,G\u0003BA\u001d\u0003\u0017\u0002rAUA\u001e\u0003\u007f\t)%C\u0002\u0002>M\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001\f\u0002B%\u0019\u00111\t\u0002\u0003\u00071{w\rE\u0002\u0017\u0003\u000fJ1!!\u0013\u0003\u000551\u0015m[3PM\u001a\u001cX\r^'ba\"A\u0011QJA\u001a\u0001\u0004\ty%\u0001\tmCJ<W-T3tg\u0006<WmU5{KB\u0019!+!\u0015\n\u0007\u0005M3KA\u0002J]RDa!a\u0016\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cE.Z1oS:<w+\u001b;i\t\u0016dW\r^3tQ\r\t)\u0006\u0019\u0005\u0007\u0003;\u0002A\u0011\u0001)\u0002'Q,7\u000f\u001e'pO\u000ecW-\u00198feN#\u0018\r^:\t\r\u0005\u0005\u0004\u0001\"\u0001Q\u0003%\"Xm\u001d;M_\u001e\u001cE.Z1oKJ\u0014V\r^1j]N\u0004&o\u001c3vG\u0016\u0014H*Y:u'\u0016\fX/\u001a8dK\"\u001a\u0011q\f1\t\r\u0005\u001d\u0004\u0001\"\u0001Q\u0003e\"Xm\u001d;M_\u001e\u001cE.Z1oKJ\u0014V\r^1j]Nd\u0015m\u001d;TKF,XM\\2f\u000bZ,g.\u00134Ue\u0006t7/Y2uS>t\u0017IY8si\u0016$\u0007fAA3A\"1\u0011Q\u000e\u0001\u0005\u0002A\u000bq\u0003^3tiB\u000b'\u000f^5bYN+w-\\3oi\u000ecW-\u00198)\u0007\u0005-\u0004\r\u0003\u0004\u0002t\u0001!\t\u0001U\u0001#i\u0016\u001cHo\u00117fC:LgnZ,ji\",fn\u00197fC:\f'\r\\3TK\u000e$\u0018n\u001c8)\u0007\u0005E\u0004\r\u0003\u0004\u0002z\u0001!\t\u0001U\u0001\u000fi\u0016\u001cH\u000fT8h)>\u001cE.Z1oQ\r\t9\b\u0019\u0005\u0007\u0003\u007f\u0002A\u0011\u0001)\u0002IQ,7\u000f\u001e'pOR{7\t\\3b]^KG\u000f[+oG2,\u0017M\\1cY\u0016\u001cVm\u0019;j_:D3!! a\u0011\u0019\t)\t\u0001C\u0001!\u0006yB/Z:u\u00072,\u0017M\\5oO^KG\u000f[+oW\u0016LX\rZ'fgN\fw-Z:)\u0007\u0005\r\u0005\rC\u0004\u0002\f\u0002!\t!!$\u000211\f7\u000f^(gMN,Go\u001d)fe\n\u000bGo\u00195J]2{w\r\u0006\u0003\u0002\u0010\u0006\u0005\u0006CBAI\u0003/\u000bY*\u0004\u0002\u0002\u0014*\u0019\u0011QS*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0006M%\u0001C%uKJ\f'\r\\3\u0011\u0007I\u000bi*C\u0002\u0002 N\u0013A\u0001T8oO\"91!!#A\u0002\u0005}\u0002bBAS\u0001\u0011\u0005\u0011qU\u0001\u0013Y\u0006\u001cHoU3rk\u0016t7-Z:J]2{w\r\u0006\u0003\u0002*\u0006=\u0006\u0003CAI\u0003W\u000bY*a\u0014\n\t\u00055\u00161\u0013\u0002\u0004\u001b\u0006\u0004\bbB\u0002\u0002$\u0002\u0007\u0011q\b\u0005\b\u0003g\u0003A\u0011AA[\u00031ygMZ:fiNLe\u000eT8h)\u0011\ty)a.\t\u000f\r\t\t\f1\u0001\u0002@!9\u00111\u0018\u0001\u0005\u0002\u0005u\u0016\u0001G;oW\u0016LX\rZ'fgN\fw-Z\"pk:$\u0018J\u001c'pOR!\u0011qJA`\u0011\u001d\u0019\u0011\u0011\u0018a\u0001\u0003\u007fAq!a1\u0001\t\u0003\t)-\u0001\bbE>\u0014Ho\u00115fG.$uN\\3\u0015\u0007E\u000b9\r\u0003\u0005\u0002J\u0006\u0005\u0007\u0019AAf\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!4\u0002Z6\u0011\u0011q\u001a\u0006\u0005\u0003#\f\u0019.\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005U'bAAl\u001d\u00051\u0011\r]1dQ\u0016LA!a7\u0002P\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBAp\u0001\u0011\u0005\u0001+\u0001\u000euKN$8\t\\3b]N+w-\\3oiN<\u0016\u000e\u001e5BE>\u0014H\u000fK\u0002\u0002^\u0002Da!!:\u0001\t\u0003\u0001\u0016a\u0005;fgR\u001cVmZ7f]R<%o\\;qS:<\u0007fAArA\"1\u00111\u001e\u0001\u0005\u0002A\u000bA\u0005^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001e<\u0016\u000e\u001e5Ta\u0006\u00148/Z(gMN,Go\u001d\u0015\u0004\u0003S\u0004\u0007BBAy\u0001\u0011\u0005\u0001+A\u0016uKN$8+Z4nK:$xI]8va&twMR8mY><\u0018N\\4M_\u0006$wJ\u001a.fe>Le\u000eZ3yQ\r\ty\u000f\u0019\u0005\b\u0003o\u0004A\u0011BA}\u0003E\u0019\u0007.Z2l'\u0016<W.\u001a8u\u001fJ$WM\u001d\u000b\u0004#\u0006m\b\u0002CA\u007f\u0003k\u0004\r!a@\u0002\r\u001d\u0014x.\u001e9t!\u0019\t\tJ!\u0001\u0003\u0006%!!1AAJ\u0005\r\u0019V-\u001d\t\u0007\u0003#\u0013\tAa\u0002\u0011\u0007Y\u0011I!C\u0002\u0003\f\t\u0011!\u0002T8h'\u0016<W.\u001a8u\u0011\u0019\u0011y\u0001\u0001C\u0001!\u0006\u0011B/Z:u\u0005VLG\u000eZ(gMN,G/T1qQ\r\u0011i\u0001\u0019\u0005\u0007\u0005+\u0001A\u0011\u0001)\u0002;Q,7\u000f^*fO6,g\u000e^,ji\"|eMZ:fi>3XM\u001d4m_^D3Aa\u0005a\u0011\u0019\u0011Y\u0002\u0001C\u0001!\u00061B/Z:u%\u0016\u001cwN^3ss\u00063G/\u001a:De\u0006\u001c\b\u000eK\u0002\u0003\u001a\u0001DaA!\t\u0001\t\u0003\u0001\u0016a\u0007;fgR\u0014U/\u001b7e\u001f\u001a47/\u001a;NCB4\u0015m[3MCJ<W\rK\u0002\u0003 \u0001DaAa\n\u0001\t\u0003\u0001\u0016!\u0007;fgR\u0014U/\u001b7e!\u0006\u0014H/[1m\u001f\u001a47/\u001a;NCBD3A!\na\u0011\u0019\u0011i\u0003\u0001C\u0001!\u0006QB/Z:u\u00072,\u0017M\\\"peJ,\b\u000f^'fgN\fw-Z*fi\"\u001a!1\u00061\t\r\tM\u0002\u0001\"\u0001Q\u0003\u0015\"Xm\u001d;DY&,g\u000e\u001e%b]\u0012d\u0017N\\4PM\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002\u00032\u0001DaA!\u000f\u0001\t\u0003\u0001\u0016A\u0005;fgR\u001cE.Z1o)>l'm\u001d;p]\u0016D3Aa\u000ea\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003\n!b\u001e:ji\u0016$v\u000eT8h)!\tyIa\u0011\u0003F\t5\u0003bB\u0002\u0003>\u0001\u0007\u0011q\b\u0005\t\u0005\u000f\u0012i\u00041\u0001\u0003J\u0005i1.Z=t\u0003:$g+\u00197vKN\u0004b!!%\u0002\u0018\n-\u0003c\u0002*\u0002<\u0005=\u0013q\n\u0005\t\u0005\u001f\u0012i\u00041\u0001\u0002\u0010\u0006IqN\u001a4tKR\u001cV-\u001d\u0005\b\u0005'\u0002A\u0011\u0002B+\u0003UIgN^1mS\u0012\u001cE.Z1oK\u0012lUm]:bO\u0016$\u0002Ba\u0016\u0003d\t\u001d$\u0011\u000e\t\u0005\u00053\u0012y&\u0004\u0002\u0003\\)!!QLAh\u0003\u0019\u0011XmY8sI&!!\u0011\rB.\u00055iU-\\8ssJ+7m\u001c:eg\"A!Q\rB)\u0001\u0004\tY*A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u0005\t\u0005\u000f\u0012\t\u00061\u0001\u0003J!Q!1\u000eB)!\u0003\u0005\rA!\u001c\u0002\u000b\r|G-Z2\u0011\t\te#qN\u0005\u0005\u0005c\u0012YFA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0011\u001d\u0011)\b\u0001C\u0005\u0005o\n\u0011#\\3tg\u0006<WmV5uQ>3gm]3u)!\u00119F!\u001f\u0003\n\n5\u0005\u0002\u0003B>\u0005g\u0002\rA! \u0002\u0007-,\u0017\u0010E\u0003S\u0005\u007f\u0012\u0019)C\u0002\u0003\u0002N\u0013Q!\u0011:sCf\u00042A\u0015BC\u0013\r\u00119i\u0015\u0002\u0005\u0005f$X\r\u0003\u0005\u0003\f\nM\u0004\u0019\u0001B?\u0003\u00151\u0018\r\\;f\u0011!\u0011yIa\u001dA\u0002\u0005m\u0015AB8gMN,G\u000fC\u0004\u0003v\u0001!IAa%\u0015\u0011\t]#Q\u0013BL\u00053C\u0001Ba\u001f\u0003\u0012\u0002\u0007\u0011q\n\u0005\t\u0005\u0017\u0013\t\n1\u0001\u0002P!A!q\u0012BI\u0001\u0004\tY\nC\u0004\u0003\u001e\u0002!IAa(\u0002\u000f5\f7.\u001a'pORA\u0011q\bBQ\u0005G\u00139\u000b\u0003\u0005&\u00057\u0003\n\u00111\u0001\u001b\u0011%\u0011)Ka'\u0011\u0002\u0003\u0007a'\u0001\u0004d_:4\u0017n\u001a\u0005\u000b\u0005S\u0013Y\n%AA\u0002\u0005m\u0015!\u0004:fG>4XM]=Q_&tG\u000fC\u0004\u0003.\u0002!IAa,\u0002\u00175\f7.Z\"mK\u0006tWM\u001d\u000b\t\u0005c\u00139La/\u0003FB\u0019aCa-\n\u0007\tU&AA\u0004DY\u0016\fg.\u001a:\t\u0011\te&1\u0016a\u0001\u0003\u001f\n\u0001bY1qC\u000eLG/\u001f\u0005\u000b\u0005{\u0013Y\u000b%AA\u0002\t}\u0016!C2iK\u000e\\Gi\u001c8f!\u0019\u0011&\u0011YAf#&\u0019!1Y*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0003Bd\u0005W\u0003\n\u00111\u0001\u0002P\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007b\u0002B \u0001\u0011%!1\u001a\u000b\u0007\u0003\u001f\u0013iMa4\t\u000f\r\u0011I\r1\u0001\u0002@!A!\u0011\u001bBe\u0001\u0004\u0011I%A\u0002tKFDqAa\u001f\u0001\t\u0013\u0011)\u000e\u0006\u0003\u0003X\n\r\b\u0003\u0002Bm\u0005?l!Aa7\u000b\u0007\tug$A\u0002oS>LAA!9\u0003\\\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\t\u0015(1\u001ba\u0001\u00037\u000b!!\u001b3\t\u000f\tu\u0003\u0001\"\u0003\u0003jRq!q\u000bBv\u0005[\u0014yOa=\u0003~\u000e\u0005\u0001\u0002\u0003B>\u0005O\u0004\r!a\u0014\t\u0011\t-%q\u001da\u0001\u0003\u001fB!B!=\u0003hB\u0005\t\u0019AAN\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\u000b\u0005k\u00149\u000f%AA\u0002\t]\u0018!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002S\u0005sL1Aa?T\u0005\u0015\u0019\u0006n\u001c:u\u0011)\u0011yPa:\u0011\u0002\u0003\u0007\u0011qJ\u0001\tg\u0016\fX/\u001a8dK\"Q11\u0001Bt!\u0003\u0005\r!a\u0014\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011\u001d\u00199\u0001\u0001C\u0005\u0007\u0013\t1$\u00199qK:$GK]1og\u0006\u001cG/[8oC2\f5\u000fT3bI\u0016\u0014H\u0003DB\u0006\u0007+\u00199b!\u0007\u0004\u001c\r}\u0001c\u0002*\u0003B\u000e51q\u0002\t\u0007\u0003#\u0013\t!a\u0014\u0011\u0007Y\u0019\t\"C\u0002\u0004\u0014\t\u0011Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bB\u0002\u0004\u0006\u0001\u0007\u0011q\b\u0005\t\u0005c\u001c)\u00011\u0001\u0002\u001c\"A!Q_B\u0003\u0001\u0004\u00119\u0010\u0003\u0006\u0004\u001e\r\u0015\u0001\u0013!a\u0001\u0003\u001f\n1\u0002\\3bI\u0016\u0014X\t]8dQ\"Q1\u0011EB\u0003!\u0003\u0005\raa\t\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\u0011\u0007I\u001b)#C\u0002\u0004(M\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0004,\u0001!Ia!\f\u00021\u0005\u0004\b/\u001a8e\u0013\u0012,W\u000e]8uK:$\u0018i\u001d'fC\u0012,'\u000f\u0006\b\u0004\f\r=2\u0011GB\u001a\u0007k\u0019Ida\u000f\t\u000f\r\u0019I\u00031\u0001\u0002@!A!\u0011_B\u0015\u0001\u0004\tY\n\u0003\u0005\u0003v\u000e%\u0002\u0019\u0001B|\u0011)\u00199d!\u000b\u0011\u0002\u0003\u000711E\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bY\"Q1QDB\u0015!\u0003\u0005\r!a\u0014\t\u0015\r\u00052\u0011\u0006I\u0001\u0002\u0004\u0019\u0019\u0003C\u0004\u0004@\u0001!Ia!\u0011\u0002\u0019\r|W.\\5u\u001b\u0006\u00148.\u001a:\u0015\u0011\t]31IB#\u0007\u000fB\u0001B!=\u0004>\u0001\u0007\u00111\u0014\u0005\t\u0005k\u001ci\u00041\u0001\u0003x\"Q1\u0011JB\u001f!\u0003\u0005\r!a'\u0002\u0013QLW.Z:uC6\u0004\bbBB'\u0001\u0011%1qJ\u0001\fC\n|'\u000f^'be.,'\u000f\u0006\u0005\u0003X\rE31KB+\u0011!\u0011\tpa\u0013A\u0002\u0005m\u0005\u0002\u0003B{\u0007\u0017\u0002\rAa>\t\u0015\r%31\nI\u0001\u0002\u0004\tY\nC\u0004\u0004Z\u0001!Iaa\u0017\u0002\u0019\u0015tG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015\u0019\t]3QLB0\u0007C\u001aYg!\u001c\t\u0011\tE8q\u000ba\u0001\u00037C\u0001B!>\u0004X\u0001\u0007!q\u001f\u0005\t\u0007G\u001a9\u00061\u0001\u0004f\u0005\t2m\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\u0011\t\te3qM\u0005\u0005\u0007S\u0012YFA\tD_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016D\u0001Ba$\u0004X\u0001\u0007\u00111\u0014\u0005\t\u0007\u0013\u001a9\u00061\u0001\u0002\u001c\"9!Q\f\u0001\u0005\n\rEDC\u0002B,\u0007g\u001a)\b\u0003\u0005\u0003|\r=\u0004\u0019AA(\u0011!\u0011Yia\u001cA\u0002\tu\u0004bBB=\u0001\u0011%11P\u0001\u000ek:\\W-_3e%\u0016\u001cwN\u001d3\u0015\t\t]3Q\u0010\u0005\t\u0005\u0017\u001b9\b1\u0001\u0002P!91\u0011\u0011\u0001\u0005\n\r\r\u0015a\u0004;p[\n\u001cHo\u001c8f%\u0016\u001cwN\u001d3\u0015\t\t]3Q\u0011\u0005\t\u0005w\u001ay\b1\u0001\u0002P!91\u0011\u0012\u0001\u0005\n\r-\u0015a\u0004:fG>4XM]!oI\u000eCWmY6\u0015\r\u0005}2QRBH\u0011\u001d\u0011)ka\"A\u0002YB\u0001b!%\u0004\b\u0002\u0007\u0011qR\u0001\rKb\u0004Xm\u0019;fI.+\u0017p\u001d\u0005\n\u0007+\u0003\u0011\u0013!C\u0005\u0007/\u000bQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u001a*\"!qXBNW\t\u0019i\n\u0005\u0003\u0004 \u000e%VBABQ\u0015\u0011\u0019\u0019k!*\u0002\u0013Ut7\r[3dW\u0016$'bABT'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r-6\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CBX\u0001E\u0005I\u0011BBY\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIM*\"aa-+\t\u0005=31\u0014\u0005\n\u0007o\u0003\u0011\u0013!C\u0005\u0007s\u000b\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YLK\u0002\u001b\u00077C\u0011ba0\u0001#\u0003%Ia!1\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$#'\u0006\u0002\u0004D*\u001aaga'\t\u0013\r\u001d\u0007!%A\u0005\n\r%\u0017!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u001a\u0016\u0005\u00037\u001bY\nC\u0005\u0004P\u0002\t\n\u0011\"\u0003\u0004J\u0006\u0001\"/Z2pe\u0012$C-\u001a4bk2$He\r\u0005\n\u0007'\u0004\u0011\u0013!C\u0005\u0007+\f\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r]'\u0006\u0002B|\u00077C\u0011ba7\u0001#\u0003%Ia!-\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012*\u0004\"CBp\u0001E\u0005I\u0011BBY\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$c\u0007C\u0005\u0004d\u0002\t\n\u0011\"\u0003\u0004f\u0006\u0011\u0013\r\u001d9f]\u0012LE-Z7q_R,g\u000e^!t\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uIQ*\"aa:+\t\r\r21\u0014\u0005\n\u0007W\u0004\u0011\u0013!C\u0005\u0007c\u000b!%\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012*\u0004\"CBx\u0001E\u0005I\u0011BBs\u0003\t\n\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%m!I11\u001f\u0001\u0012\u0002\u0013%1\u0011W\u0001&CB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:%I\u00164\u0017-\u001e7uIQB\u0011ba>\u0001#\u0003%Ia!:\u0002K\u0005\u0004\b/\u001a8e)J\fgn]1di&|g.\u00197Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012*\u0004\"CB~\u0001E\u0005I\u0011BBe\u0003U\t'm\u001c:u\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIMB\u0011ba@\u0001#\u0003%Ia!3\u0002-\r|W.\\5u\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uIMB\u0011\u0002b\u0001\u0001#\u0003%I\u0001\"\u0002\u0002?%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u0005\b)\"!QNBN\u0001")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$43 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$44 = this.makeLog$default$1();
        long x$45 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$44, x$43, x$45);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        Seq segments = ((TraversableOnce)log2.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log2, segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(long x$2) {
                return this.apply$mcZJ$sp(x$2);
            }

            public boolean apply$mcZJ$sp(long x$2) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToLong((long)x$2));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        Log log2 = new Log(this, deleteStartLatch, deleteCompleteLatch, logProps, topicPartition, producerStateManager){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
                    return;
                }
                throw new IllegalStateException("Log segment deletion timed out");
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super($outer.dir(), LogConfig$.MODULE$.fromProps($outer.logConfig().originals(), logProps$1), 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition$1, producerStateManager$1, new LogDirFailureChannel(10));
            }
        };
        Thread t = new Thread(this, deleteStartLatch, deleteCompleteLatch, log2){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;
            private final Log log$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset());
                this.log$1.onHighWatermarkIncremented(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                this.log$1 = log$1;
            }
        };
        t.start();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            log2.roll(log2.roll$default$1());
        }
        Assert.assertEquals((long)3L, (long)log2.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log2.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Seq segments = log2.logSegments(0L, log2.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 0L, log2.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log2, segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assert.assertEquals((long)2L, (long)log2.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$46 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$47 = this.makeLog$default$1();
        long x$48 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$47, x$46, x$48);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log2.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$49 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$50 = this.makeLog$default$1();
        long x$51 = this.makeLog$default$3();
        ObjectRef log2 = ObjectRef.create((Object)this.makeLog(x$50, x$49, x$51));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log2.elem;
        Option x$52 = qual$1.roll$default$1();
        qual$1.roll(x$52);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTest$.MODULE$.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log2.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log2.elem;
        Option x$56 = qual$2.roll$default$1();
        qual$2.roll(x$56);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTest$.MODULE$.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$57 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$58 = this.makeLog$default$1();
        long x$59 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$58, x$57, x$59);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        List abortedTransactions = log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)abortedTransactions, (Object)log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$60 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$61 = this.makeLog$default$1();
        long x$62 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$61, x$60, x$62);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log2, pid3, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log2.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log2.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTest$.MODULE$.keysInLog(log2));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, dirtyOffset, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTest$.MODULE$.keysInLog(log2));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$63 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$64 = this.makeLog$default$1();
        long x$65 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$64, x$63, x$65);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log2));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$66 = Integer.MAX_VALUE;
        int x$67 = 100;
        Function1<TopicPartition, BoxedUnit> x$68 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$66, x$68, x$67);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$69 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$70 = this.makeLog$default$1();
        long x$71 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$70, x$69, x$71);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$72 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$73 = this.makeLog$default$1();
        long x$74 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$73, x$72, x$74);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log2, 1L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log2, 2L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        producer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.roll(log2.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log2));
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$75 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$76 = this.makeLog$default$1();
        long x$77 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$76, x$75, x$77);
        short producerEpoch = (short)0;
        log2.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$78 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$79 = this.makeLog$default$1();
        long x$80 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$79, x$78, x$80);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendTransaction = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendTransaction.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$81 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$82 = this.makeLog$default$1();
        long x$83 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$82, x$81, x$83);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendTransaction = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendTransaction.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$84 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$85 = this.makeLog$default$1();
        long x$86 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$85, x$84, x$86);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        Log log2;
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$87 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$88 = this.makeLog$default$1();
        long x$89 = this.makeLog$default$3();
        Log x$90 = log2 = this.makeLog(x$88, x$87, x$89);
        long x$91 = producerId;
        short x$92 = producerEpoch;
        boolean x$93 = false;
        int x$94 = this.appendTransactionalAsLeader$default$4();
        Function1<Seq<Object>, LogAppendInfo> appendFirstTransaction = this.appendTransactionalAsLeader(x$90, x$91, x$92, x$94, x$93);
        appendFirstTransaction.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        Log x$95 = log2;
        long x$96 = producerId;
        short x$97 = producerEpoch;
        boolean x$98 = false;
        int x$99 = this.appendTransactionalAsLeader$default$4();
        Function1<Seq<Object>, LogAppendInfo> appendSecondTransaction = this.appendTransactionalAsLeader(x$95, x$96, x$97, x$99, x$98);
        appendSecondTransaction.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$100 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$101 = this.makeLog$default$1();
        long x$102 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$101, x$100, x$102);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((long)0L, (long)log2.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$103 = Integer.MAX_VALUE;
        int x$104 = 1024;
        Function1<TopicPartition, BoxedUnit> x$105 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$103, x$105, x$104);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$106 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$107 = this.makeLog$default$1();
        long x$108 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$107, x$106, x$108);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$2.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log2.logSegments().head()})), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToLong((long)x$3));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log2));
    }

    @Test
    public void testMessageLargerThanMaxMessageSize() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            int x$109 = Integer.MAX_VALUE;
            int x$110 = 1024;
            Function1<TopicPartition, BoxedUnit> x$111 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$109, x$111, x$110);
            cleaner.cleanSegments(log3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log3.logSegments().head()})), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log3).filter((Function1)new Serializable(this, offsetMap2){
                public static final long serialVersionUID = 0L;
                private final FakeOffsetMap offsetMap$1;

                public final boolean apply(long k) {
                    return this.apply$mcZJ$sp(k);
                }

                public boolean apply$mcZJ$sp(long k) {
                    return !this.offsetMap$1.map().containsKey(((Object)BoxesRunTime.boxToLong((long)k)).toString());
                }
                {
                    this.offsetMap$1 = offsetMap$1;
                }
            });
            Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log3));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            RandomAccessFile file = new RandomAccessFile(((LogSegment)log3.logSegments().head()).log().file(), "rw");
            file.seek(16L);
            file.write(255);
            file.close();
            int x$112 = Integer.MAX_VALUE;
            int x$113 = 1024;
            Function1<TopicPartition, BoxedUnit> x$114 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$112, x$114, x$113);
            this.intercept((Function0)new Serializable(this, log3, offsetMap2, cleaner){
                public static final long serialVersionUID = 0L;
                private final Log log$5;
                private final FakeOffsetMap offsetMap$2;
                private final Cleaner cleaner$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.cleaner$1.cleanSegments(this.log$5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)this.log$5.logSegments().head()})), (OffsetMap)this.offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
                }
                {
                    this.log$5 = log$5;
                    this.offsetMap$2 = offsetMap$2;
                    this.cleaner$1 = cleaner$1;
                }
            }, ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            RandomAccessFile file = new RandomAccessFile(((LogSegment)log3.logSegments().head()).log().file(), "rw");
            file.setLength(1024L);
            file.close();
            int x$115 = Integer.MAX_VALUE;
            int x$116 = 1024;
            Function1<TopicPartition, BoxedUnit> x$117 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$115, x$117, x$116);
            this.intercept((Function0)new Serializable(this, log3, offsetMap2, cleaner){
                public static final long serialVersionUID = 0L;
                private final Log log$6;
                private final FakeOffsetMap offsetMap$3;
                private final Cleaner cleaner$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.cleaner$2.cleanSegments(this.log$6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)this.log$6.logSegments().head()})), (OffsetMap)this.offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
                }
                {
                    this.log$6 = log$6;
                    this.offsetMap$3 = offsetMap$3;
                    this.cleaner$2 = cleaner$2;
                }
            }, ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$118 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$119 = this.makeLog$default$1();
        long x$120 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$119, x$118, x$120);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log2.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        return new Tuple2((Object)log2, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$121 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$122 = this.makeLog$default$1();
        long x$123 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$122, x$121, x$123);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        long leo = log2.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$7;

            public final LogAppendInfo apply(int key) {
                return this.log$7.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$tombstoneRecord(key), 0, this.log$7.appendAsLeader$default$3(), this.log$7.appendAsLeader$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$7 = log$7;
            }
        });
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Set keys = LogTest$.MODULE$.keysInLog(log2).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$7) {
                return this.apply$mcZI$sp(x$7);
            }

            public boolean apply$mcZI$sp(int x$7) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToLong((long)x$7));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$124 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$125 = this.makeLog$default$1();
        long x$126 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$125, x$124, x$126);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        long initialLogSize = log2.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long endOffset = tuple2._1$mcJ$sp();
            CleanerStats stats = (CleanerStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
            long endOffset2 = tuple23._1$mcJ$sp();
            CleanerStats stats2 = (CleanerStats)tuple23._2();
            Assert.assertEquals((long)5L, (long)endOffset2);
            Assert.assertEquals((long)5L, (long)stats2.messagesRead());
            Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
            Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
            Assert.assertEquals((long)log2.size(), (long)stats2.bytesWritten());
            Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
            Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$127 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$128 = this.makeLog$default$1();
        long x$129 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$128, x$127, x$129);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 1, 1L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 2, 2L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 3, 3L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, 2L, (short)0, 1, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$130 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$131 = this.makeLog$default$1();
        long x$132 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$131, x$130, x$132);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$133 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$134 = this.makeLog$default$1();
        long x$135 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$134, x$133, x$135);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 3L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 4L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$136 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$137 = this.makeLog$default$1();
        long x$138 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$137, x$136, x$138);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log2.numberOfSegments() <= numCleanableSegments) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        long firstUncleanableOffset = log2.logEndOffset() + 1L;
        while (log2.numberOfSegments() < numTotalSegments - 1) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log2).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$9) {
                return this.apply$mcZI$sp(x$9);
            }

            public boolean apply$mcZI$sp(int x$9) {
                return x$9 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$139 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$140 = this.makeLog$default$1();
        long x$141 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$140, x$139, x$141);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$9;

            public final LogAppendInfo apply(int _) {
                return this.log$9.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecorcs$1(), 0, this.log$9.appendAsLeader$default$3(), this.log$9.appendAsLeader$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$9 = log$9;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, log2.activeSegment().baseOffset(), log2.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log2.size() - (long)log2.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$142 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$143 = this.makeLog$default$1();
        long x$144 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$143, x$142, x$144);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$10;

            public final LogAppendInfo apply(int _) {
                return this.log$10.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecords$1(), 0, this.log$10.appendAsLeader$default$3(), this.log$10.appendAsLeader$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$10 = log$10;
            }
        });
        Seq segs = log2.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$10) {
                return x$10.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$11) {
                return x$11.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$145 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$146 = this.makeLog$default$1();
        long x$147 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$146, x$145, x$147);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.unkeyedRecord((int)log2.logEndOffset()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log2);
        long sizeWithUnkeyedMessages = log2.size();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        long expectedSizeAfterCleaning = log2.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            CleanerStats stats;
            CleanerStats cleanerStats;
            CleanerStats stats2 = cleanerStats = (stats = (CleanerStats)tuple2._2());
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log2));
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log2.size());
            Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return batch.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log2) {
        return ((TraversableOnce)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch() && batch.hasProducerId();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$12) {
                        return x$12.hasValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$13) {
                        return x$13.hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Record m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log2) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$14) {
                        return x$14.hasValue();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record m) {
                        return !m.hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.abortCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$148 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$149 = this.makeLog$default$1();
        long x$150 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$149, x$148, x$150);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Iterable<Object> keys = LogTest$.MODULE$.keysInLog(log2);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$4.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log2, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$3;
            private final Log log$11;
            private final FakeOffsetMap map$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$3.cleanSegments(this.log$11, ((TraversableOnce)this.log$11.logSegments().take(3)).toSeq(), (OffsetMap)this.map$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            }
            {
                this.cleaner$3 = cleaner$3;
                this.log$11 = log$11;
                this.map$4 = map$4;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1085));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$151 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$152 = this.makeLog$default$1();
        long x$153 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$152, x$151, x$153);
        int i = 0;
        while (log2.numberOfSegments() < 10) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), 1, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$15) {
                return x$15.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, 1, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$16) {
                return x$16.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$17) {
                return x$17.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), logSize, Integer.MAX_VALUE, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$18) {
                return x$18.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$19) {
                return x$19.offsetIndex().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, indexSize, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$20) {
                return x$20.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$154 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$155 = this.makeLog$default$1();
        long x$156 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$155, x$154, x$156);
        while (log2.numberOfSegments() == 1) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        MemoryRecords records2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log2.appendAsFollower(records2);
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log2.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)(log2.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$157 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$158 = this.makeLog$default$1();
        long x$159 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$158, x$157, x$159);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log2.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log2.appendAsFollower(record2);
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log2.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log2.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log2.logEndOffset() - 1L - log2.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log2.logSegments().last()).offsetIndex().lastOffset() - log2.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$21) {
                return (Seq)x$21.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$22) {
                        return x$22.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log2.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log2.logEndOffset(), log2, cleaner);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTest$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        LogConfig x$160 = config;
        long x$161 = Long.MAX_VALUE;
        File x$162 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$162, x$160, x$161);
        LogSegment segmentWithOverflow = (LogSegment)LogTest$.MODULE$.firstOverflowSegment(log2).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Failed to create log with a segment which has overflowed offsets", new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1280));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numSegmentsInitial = log2.logSegments().size();
        List allKeys = LogTest$.MODULE$.keysInLog(log2).toList();
        MutableList expectedKeysAfterCleaning = (MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)new Serializable(this, allKeys, expectedKeysAfterCleaning, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final List allKeys$1;
            private final MutableList expectedKeysAfterCleaning$1;
            private final FakeOffsetMap offsetMap$4;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.expectedKeysAfterCleaning$1.$plus$eq(this.allKeys$1.apply(k - 1));
                this.offsetMap$4.put(this.$outer.kafka$log$LogCleanerTest$$key(BoxesRunTime.unboxToLong((Object)this.allKeys$1.apply(k))), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allKeys$1 = allKeys$1;
                this.expectedKeysAfterCleaning$1 = expectedKeysAfterCleaning$1;
                this.offsetMap$4 = offsetMap$4;
            }
        });
        this.assertThrows((Function0)new Serializable(this, cleaner, log2, segmentWithOverflow, offsetMap){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$5;
            private final Log log$15;
            private final LogSegment segmentWithOverflow$1;
            private final FakeOffsetMap offsetMap$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$5.cleanSegments(this.log$15, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.segmentWithOverflow$1})), (OffsetMap)this.offsetMap$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            }
            {
                this.cleaner$5 = cleaner$5;
                this.log$15 = log$15;
                this.segmentWithOverflow$1 = segmentWithOverflow$1;
                this.offsetMap$4 = offsetMap$4;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
        Assert.assertEquals((long)(numSegmentsInitial + 1), (long)log2.logSegments().size());
        Assert.assertEquals((Object)allKeys, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log2));
        log2.logSegments().foreach((Function1)new Serializable(this, cleaner, log2, offsetMap){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$5;
            private final Log log$15;
            private final FakeOffsetMap offsetMap$4;

            public final void apply(LogSegment segmentToClean) {
                this.cleaner$5.cleanSegments(this.log$15, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{segmentToClean})), (OffsetMap)this.offsetMap$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            }
            {
                this.cleaner$5 = cleaner$5;
                this.log$15 = log$15;
                this.offsetMap$4 = offsetMap$4;
            }
        });
        Assert.assertEquals((Object)expectedKeysAfterCleaning, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log2));
        log2.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$163 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$164 = this.makeLog$default$1();
        long x$165 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$164, x$163, x$165);
        int messageCount = 0;
        while (log2.numberOfSegments() < 10) {
            Log qual$3 = log2;
            MemoryRecords x$166 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$167 = 0;
            boolean x$168 = qual$3.appendAsLeader$default$3();
            ApiVersion x$169 = qual$3.appendAsLeader$default$4();
            qual$3.appendAsLeader(x$166, x$167, x$168, x$169);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTest$.MODULE$.keysInLog(log2);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$4 = log2;
            MemoryRecords x$170 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$171 = 0;
            boolean x$172 = qual$4.appendAsLeader$default$3();
            ApiVersion x$173 = qual$4.appendAsLeader$default$4();
            qual$4.appendAsLeader(x$170, x$171, x$172, x$173);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log2 = this.recoverAndCheck(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$5 = log2;
            MemoryRecords x$174 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$175 = 0;
            boolean x$176 = qual$5.appendAsLeader$default$3();
            ApiVersion x$177 = qual$5.appendAsLeader$default$4();
            qual$5.appendAsLeader(x$174, x$175, x$176, x$177);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        log2 = this.recoverAndCheck(config, cleanedKeys);
        log2.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$178 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$179 = this.makeLog$default$1();
        long x$180 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$179, x$178, x$180);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log2, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)offsetEnd, (long)map.latestOffset());
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(keyEnd - keyStart), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0L)));
        Assert.assertEquals((String)"Map should contain second value", (long)offsetEnd, (long)map.get(this.kafka$log$LogCleanerTest$$key(1L)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(4, 4, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0L)));
        Assert.assertEquals((long)2L, (long)map.get(this.kafka$log$LogCleanerTest$$key(2L)));
        Assert.assertEquals((long)3L, (long)map.get(this.kafka$log$LogCleanerTest$$key(3L)));
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(4L)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$181 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$182 = this.makeLog$default$1();
        long x$183 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$182, x$181, x$183);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log2.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(Record record) {
                                Assert.assertTrue((boolean)record.hasMagic(this.batch$1.magic()));
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)record.offset(), (long)value);
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Record logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$184 = logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$185 = this.makeLog$default$1();
        long x$186 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$185, x$184, x$186);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$187 = "0".getBytes();
        byte[] x$188 = "0".getBytes();
        long x$189 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$190 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$191 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$187, x$188, x$190, x$189, x$191), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        byte[] x$192 = null;
        byte[] x$193 = "0".getBytes();
        long x$194 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$195 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$196 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$192, x$193, x$195, x$194, x$196), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 1L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$197 = "1".getBytes();
        byte[] x$198 = "1".getBytes();
        long x$199 = this.time().milliseconds();
        CompressionType x$200 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$201 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$197, x$198, x$200, x$199, x$201), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$14;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$23) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$23;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$14.appendAsFollower(this.$outer.kafka$log$LogCleanerTest$$messageWithOffset(key, value, offset)).lastOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$14 = log$14;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(Tuple2<Object, Object> kv) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$24) {
                return x$24.sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$1;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$1.elem, record);
                ++this.offset$1.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    public MemoryRecords kafka$log$LogCleanerTest$$messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$33 = dir;
        LogConfig x$34 = config;
        long x$35 = 0L;
        long x$36 = recoveryPoint;
        MockScheduler x$37 = this.time().scheduler();
        MockTime x$38 = this.time();
        BrokerTopicStats x$39 = new BrokerTopicStats();
        int x$40 = 3600000;
        int x$41 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$42 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$33, x$34, x$35, x$36, (Scheduler)x$37, x$39, (Time)x$38, x$40, x$41, x$42);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TopicPartition x$25) {
            }
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$13;

            public final long apply(Tuple2<Object, Object> x$26) {
                Tuple2<Object, Object> tuple2 = x$26;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = BoxesRunTime.unboxToLong((Object)this.log$13.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$record(key, value, this.$outer.kafka$log$LogCleanerTest$$record$default$3(), this.$outer.kafka$log$LogCleanerTest$$record$default$4(), this.$outer.kafka$log$LogCleanerTest$$record$default$5(), this.$outer.kafka$log$LogCleanerTest$$record$default$6()), 0, this.log$13.appendAsLeader$default$3(), this.log$13.appendAsLeader$default$4()).firstOffset().get());
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$13 = log$13;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer kafka$log$LogCleanerTest$$key(long id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)id)).toString().getBytes());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log2, long producerId, short producerEpoch, int leaderEpoch, boolean isFromClient) {
        Log x$202 = log2;
        long x$203 = producerId;
        short x$204 = producerEpoch;
        boolean x$205 = true;
        boolean x$206 = isFromClient;
        int x$207 = this.appendIdempotentAsLeader$default$5();
        return this.appendIdempotentAsLeader(x$202, x$203, x$204, x$205, x$207, x$206);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private boolean appendTransactionalAsLeader$default$5() {
        return true;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log2, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, boolean isFromClient) {
        IntRef sequence = IntRef.create((int)0);
        return new Serializable(this, log2, producerId, producerEpoch, isTransactional, leaderEpoch, isFromClient, sequence){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$3;
            private final long producerId$1;
            private final short producerEpoch$1;
            private final boolean isTransactional$1;
            private final int leaderEpoch$1;
            private final boolean isFromClient$1;
            private final IntRef sequence$1;

            public final LogAppendInfo apply(Seq<Object> keys) {
                Seq simpleRecords = (Seq)keys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$appendIdempotentAsLeader$1 $outer;

                    public final SimpleRecord apply(int key) {
                        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        return new SimpleRecord(this.$outer.kafka$log$LogCleanerTest$$anonfun$$$outer().time().milliseconds(), keyBytes, keyBytes);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                MemoryRecords records2 = this.isTransactional$1 ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
                this.sequence$1.elem += simpleRecords.size();
                return this.log$3.appendAsLeader(records2, this.leaderEpoch$1, this.isFromClient$1, this.log$3.appendAsLeader$default$4());
            }

            public /* synthetic */ LogCleanerTest kafka$log$LogCleanerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$3 = log$3;
                this.producerId$1 = producerId$1;
                this.producerEpoch$1 = producerEpoch$1;
                this.isTransactional$1 = isTransactional$1;
                this.leaderEpoch$1 = leaderEpoch$1;
                this.isFromClient$1 = isFromClient$1;
                this.sequence$1 = sequence$1;
            }
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private boolean appendIdempotentAsLeader$default$6() {
        return true;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$208 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$209 = value;
        CompressionType x$210 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$211 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$212 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$209, x$208, x$210, x$211, x$212);
    }

    public long kafka$log$LogCleanerTest$$record$default$3() {
        return -1L;
    }

    public short kafka$log$LogCleanerTest$$record$default$4() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$5() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTest$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler(), LogTest$.MODULE$.recoverAndCheck$default$7());
    }

    private final void reloadLog$1(Properties logProps$2, ObjectRef log$2) {
        ((Log)log$2.elem).close();
        LogConfig x$53 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$2);
        long x$54 = 0L;
        File x$55 = this.makeLog$default$1();
        log$2.elem = this.makeLog(x$55, x$53, x$54);
    }

    private final void assertAbortedTransactionIndexed$1(Log log$4, long producerId$2) {
        List abortedTxns = log$4.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$2, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    private final Seq distinctValuesBySegment$1(Log log$8) {
        return ((TraversableOnce)log$8.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Record record) {
                        return TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$12, Cleaner cleaner$4) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$4.buildOffsetMap(log$12, (long)start2, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$5.get(this.$outer.kafka$log$LogCleanerTest$$key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$5 = map$5;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(end)));
        Assert.assertEquals((long)(end - start2), (long)stats.mapMessagesRead());
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$27 = Double.MAX_VALUE;
        long x$28 = Long.MAX_VALUE;
        MockTime x$29 = this.time();
        boolean x$30 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$31 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$32 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$27, x$28, x$30, x$31, x$32, (Time)x$29);
    }
}

