/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001A\u0002\u0013\u0005\u0011$\u0001\u0004m_\u001e$\u0015N]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011\u001d\u0019\u0003\u00011A\u0005\u0002\u0011\n!\u0002\\8h\t&\u0014x\fJ3r)\t)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bb\u0002\u0017#\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004B\u0002\u0018\u0001A\u0003&!$A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000fA\u0002\u0001\u0019!C\u0001c\u0005a1\u000f^1uK6\u000bg.Y4feV\t!\u0007\u0005\u0002\u0017g%\u0011AG\u0001\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000fY\u0002\u0001\u0019!C\u0001o\u0005\u00012\u000f^1uK6\u000bg.Y4fe~#S-\u001d\u000b\u0003KaBq\u0001L\u001b\u0002\u0002\u0003\u0007!\u0007\u0003\u0004;\u0001\u0001\u0006KAM\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002}A\u0011q(R\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0019%B\u0001#\u000f\u0003\u0019\t\u0007/Y2iK&\u0011a\t\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019A\u0005\u0001)A\u0005}\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006Q\u0001O]8ek\u000e,'/\u00133\u0016\u00031\u0003\"AJ'\n\u00059;#\u0001\u0002'p]\u001eDa\u0001\u0015\u0001!\u0002\u0013a\u0015a\u00039s_\u0012,8-\u001a:JI\u0002BqA\u0015\u0001C\u0002\u0013\u00051+\u0001\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001bX#\u0001+\u0011\u0005\u0019*\u0016B\u0001,(\u0005\rIe\u000e\u001e\u0005\u00071\u0002\u0001\u000b\u0011\u0002+\u0002'5\f\u0007\u0010U5e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\t\u000fi\u0003!\u0019!C\u00017\u0006!A/[7f+\u0005a\u0006CA/a\u001b\u0005q&BA0A\u0003\u0015)H/\u001b7t\u0013\t\tgL\u0001\u0005N_\u000e\\G+[7f\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006)A/[7fA!)Q\r\u0001C\u0001M\u0006)1/\u001a;VaR\tQ\u0005\u000b\u0002eQB\u0011\u0011n[\u0007\u0002U*\u00111BD\u0005\u0003Y*\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u00031\u0017\u0001\u0003;fCJ$un\u001e8)\u00055\u0004\bCA5r\u0013\t\u0011(NA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u0005a-\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007FA:w!\tIw/\u0003\u0002yU\n!A+Z:u\u0011\u0015Q\b\u0001\"\u0001g\u0003\u0019\"Xm\u001d;BaB,g\u000e\u001a+y]6\u000b'o[3s/&$\bNT8Qe>$WoY3s'R\fG/\u001a\u0015\u0003sZDQ! \u0001\u0005\u0002\u0019\fa\u0004^3tiB\u0013x\u000eZ;dKJ\u001cV-];f]\u000e,wK]1q\u0003J|WO\u001c3)\u0005q4\bBBA\u0001\u0001\u0011\u0005a-A\u0017uKN$\bK]8ek\u000e,'oU3rk\u0016t7-Z,ji\"<&/\u00199Be>,h\u000e\u001a\"bi\u000eD'+Z2pe\u0012D#a <\t\r\u0005\u001d\u0001\u0001\"\u0001g\u0003\u0015\"Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK&sg/\u00197jI^\u0013\u0018\r]!s_VtG\rK\u0004\u0002\u0006Y\fY!!\u0004\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006A\u0003\u0019)'O]8sg&!\u0011\u0011DA\n\u0005myU\u000f^(g\u001fJ$WM]*fcV,gnY3Fq\u000e,\u0007\u000f^5p]\"1\u0011Q\u0004\u0001\u0005\u0002\u0019\f!\u0006^3ti:{g+\u00197jI\u0006$\u0018n\u001c8P]\u001aK'o\u001d;F]R\u0014\u0018p\u00165f]2{\u0017\rZ5oO2{w\rK\u0002\u0002\u001cYDa!a\t\u0001\t\u00031\u0017a\u0007;fgR\u001cuN\u001c;s_2\u0014VmY8sI\n+X\u000e]:Fa>\u001c\u0007\u000eK\u0002\u0002\"YDa!!\u000b\u0001\t\u00031\u0017\u0001\t;fgR$\u0006P\u001c$jeN$xJ\u001a4tKRlU\r^1eCR\f7)Y2iK\u0012D3!a\nw\u0011\u0019\ty\u0003\u0001C\u0001M\u0006\u0001C/Z:u\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\u001cu.\u001c9mKR,G\r\u0016=oQ\r\tiC\u001e\u0005\u0007\u0003k\u0001A\u0011\u00014\u0002]Q,7\u000f\u001e(p]6\u000bGo\u00195j]\u001e$\u0006P\u001c$jeN$xJ\u001a4tKRlU\r^1eCR\fgj\u001c;DC\u000eDW\r\u001a\u0015\u0004\u0003g1\bBBA\u001e\u0001\u0011\u0005a-\u0001\u0010uKN$\bK]3qCJ,W\u000b\u001d3bi\u0016$u.Z:O_RlU\u000f^1uK\"\u001a\u0011\u0011\b<\t\r\u0005\u0005\u0003\u0001\"\u0001g\u0003y)\b\u000fZ1uKB\u0013x\u000eZ;dKJ$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rK\u0002\u0002@YDa!a\u0012\u0001\t\u00031\u0017\u0001\f;fgR|U\u000f^(g'\u0016\fX/\u001a8dK\u00063G/\u001a:D_:$(o\u001c7SK\u000e|'\u000fZ#q_\u000eD')^7qQ\r\t)E\u001e\u0005\u0007\u0003\u001b\u0002A\u0011\u00014\u0002aQ,7\u000f\u001e(p]R\u0013\u0018M\\:bGRLwN\\1m\u0003B\u0004XM\u001c3XSRDwJ\\4pS:<GK]1og\u0006\u001cG/[8oQ\u001d\tYE^A\u0006\u0003#\u001a#!a\u0015\u0011\t\u0005E\u0011QK\u0005\u0005\u0003/\n\u0019B\u0001\rJ]Z\fG.\u001b3Uq:\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:Da!a\u0017\u0001\t\u00031\u0017a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bfAA-m\"1\u0011\u0011\r\u0001\u0005\u0002\u0019\f\u0001\u0003^3tiR\u000b7.Z*oCB\u001c\bn\u001c;)\u0007\u0005}c\u000f\u0003\u0004\u0002h\u0001!\tAZ\u0001\u0018i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_RD3!!\u001aw\u0011\u0019\ti\u0007\u0001C\u0001M\u0006iB/Z:u%\u0016lwN^3FqBL'/\u001a3QS\u0012\u001cxJ\u001c*fY>\fG\rK\u0004\u0002lY\fY!!\u001d$\u0005\u0005M\u0004\u0003BA\t\u0003kJA!a\u001e\u0002\u0014\tQRK\\6o_^t\u0007K]8ek\u000e,'/\u00133Fq\u000e,\u0007\u000f^5p]\"1\u00111\u0010\u0001\u0005\u0002\u0019\fQ\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRDw.\u001e;Qe>$WoY3s'R\fG/Z(o%\u0016\u0004H.[2bQ\r\tIH\u001e\u0005\u0007\u0003\u0003\u0003A\u0011\u00014\u0002SQ,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i'\u0016\fX/\u001a8dK\u001e\u000b\u0007o](o%\u0016\u0004H.[2bQ\r\tyH\u001e\u0005\u0007\u0003\u000f\u0003A\u0011\u00014\u00023Q,7\u000f\u001e#fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u0015\u0004\u0003\u000b3\bBBAG\u0001\u0011\u0005a-\u0001\u0007uKN$HK];oG\u0006$X\rK\u0002\u0002\fZDa!a%\u0001\t\u00031\u0017A\n;fgR4\u0015N]:u+:\u001cH/\u00192mK>3gm]3u\u0003\u001a$XM\u001d+sk:\u001c\u0017\r^5p]\"\u001a\u0011\u0011\u0013<\t\r\u0005e\u0005\u0001\"\u0001g\u0003\u0011\"Xm\u001d;GSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G/\u00114uKJ,e/[2uS>t\u0007fAALm\"1\u0011q\u0014\u0001\u0005\u0002\u0019\f\u0001\u0003^3tiR\u0013XO\\2bi\u0016DU-\u00193)\u0007\u0005ue\u000f\u0003\u0004\u0002&\u0002!\tAZ\u00010i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\*oCB\u001c\bn\u001c;SK6|g/Z:O_:\u0014V\r^1j]\u0016$\u0007K]8ek\u000e,'o\u001d\u0015\u0004\u0003G3\bBBAV\u0001\u0011\u0005a-A\u0011uKN$8k[5q':\f\u0007o\u001d5pi&3wJ\u001a4tKR,fn\u00195b]\u001e,G\rK\u0002\u0002*ZDa!!-\u0001\t\u00031\u0017a\u0004;fgR\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007\u0005=f\u000f\u0003\u0004\u00028\u0002!\tAZ\u0001\u0019i\u0016\u001cH\u000fU5e\u000bb\u0004\u0018N]1uS>tG+[7f_V$\bfBA[m\u0006-\u0011\u0011\u000f\u0005\u0007\u0003{\u0003A\u0011\u00014\u0002/Q,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\bfAA^m\"1\u00111\u0019\u0001\u0005\u0002\u0019\fa\u0006^3tiB\u0013x\u000eZ;dKJ\u001cx+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|gn\u001d#p]R,\u0005\u0010]5sK\"\u001a\u0011\u0011\u0019<\t\r\u0005%\u0007\u0001\"\u0001g\u00035\"Xm\u001d;TKF,XM\\2f\u001d>$h+\u00197jI\u0006$X\r\u001a$pe\u001e\u0013x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0015\u0004\u0003\u000f4\bBBAh\u0001\u0011\u0005a-\u0001\u000fuKN$x\n\u001c3Fa>\u001c\u0007NR8s\u0007>tGO]8m%\u0016\u001cwN\u001d3)\u000f\u00055g/a\u0003\u0002T\u000e\u0012\u0011Q\u001b\t\u0005\u0003#\t9.\u0003\u0003\u0002Z\u0006M!a\u0006)s_\u0012,8-\u001a:GK:\u001cW\rZ#yG\u0016\u0004H/[8o\u0011\u0019\ti\u000e\u0001C\u0001M\u00061B/Z:u\u0007>|'\u000fZ5oCR|'OR3oG&tw\rK\u0002\u0002\\ZDa!a9\u0001\t\u00031\u0017\u0001\t;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ!gi\u0016\u0014(+\u001a7pC\u0012Ds!!9w\u0003\u0017\t9o\t\u0002\u0002jB!\u0011\u0011CAv\u0013\u0011\ti/a\u0005\u0003KQ\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J4UM\\2fI\u0016C8-\u001a9uS>t\u0007BBAy\u0001\u0011\u0005a-A\u000fuKN$Hj\\1e\rJ|W.R7qif\u001cf.\u00199tQ>$h)\u001b7fQ\r\tyO\u001e\u0005\u0007\u0003o\u0004A\u0011\u00014\u0002CQ,7\u000f\u001e'pC\u00124%o\\7UeVt7-\u0019;fINs\u0017\r]:i_R4\u0015\u000e\\3)\u0007\u0005Uh\u000f\u0003\u0004\u0002~\u0002!\tAZ\u0001 i\u0016\u001cH\u000fT8bI\u001a\u0013x.\\\"peJ,\b\u000f^*oCB\u001c\bn\u001c;GS2,\u0007fAA~m\"1!1\u0001\u0001\u0005\u0002\u0019\f1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007f\u0001B\u0001m\"9!\u0011\u0002\u0001\u0005\n\t-\u0011a\u0007;fgRdu.\u00193Ge>l7i\u001c:skB$8K\\1qg\"|G\u000fF\u0002&\u0005\u001bA\u0001Ba\u0004\u0003\b\u0001\u0007!\u0011C\u0001\u0010[\u0006\\WMR5mK\u000e{'O];qiB1aEa\u0005\u0003\u0018\u0015J1A!\u0006(\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0011\rD\u0017M\u001c8fYNT1A!\t\u001f\u0003\rq\u0017n\\\u0005\u0005\u0005K\u0011YBA\u0006GS2,7\t[1o]\u0016d\u0007b\u0002B\u0015\u0001\u0011%!1F\u0001\u0013CB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\u0006\t\u0003.\te\"Q\bB \u0005\u0013\u0012IF!\u0018\u0003bA1aEa\f\u000341K1A!\r(\u0005\u0019!V\u000f\u001d7feA\u0019aC!\u000e\n\u0007\t]\"A\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000eC\u0004\u0003<\t\u001d\u0002\u0019\u0001\u001a\u0002\u000f5\f\u0007\u000f]5oO\"1!Ja\nA\u00021C\u0001B!\u0011\u0003(\u0001\u0007!1I\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007\u0019\u0012)%C\u0002\u0003H\u001d\u0012Qa\u00155peRD\u0001Ba\u0013\u0003(\u0001\u0007!QJ\u0001\fG>tGO]8m)f\u0004X\r\u0005\u0003\u0003P\tUSB\u0001B)\u0015\r\u0011\u0019\u0006Q\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t]#\u0011\u000b\u0002\u0012\u0007>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007b\u0002B.\u0005O\u0001\r\u0001T\u0001\u0007_\u001a47/\u001a;\t\u0013\t}#q\u0005I\u0001\u0002\u0004!\u0016\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011%\u0011\u0019Ga\n\u0011\u0002\u0003\u0007A*A\u0005uS6,7\u000f^1na\"9!q\r\u0001\u0005\n\t%\u0014AB1qa\u0016tG\rF\t&\u0005W\u0012iGa\u001c\u0003r\tU$q\u000fB=\u0005\u0007Ca\u0001\rB3\u0001\u0004\u0011\u0004B\u0002&\u0003f\u0001\u0007A\n\u0003\u0005\u0003B\t\u0015\u0004\u0019\u0001B\"\u0011\u001d\u0011\u0019H!\u001aA\u0002Q\u000b1a]3r\u0011\u001d\u0011YF!\u001aA\u00021C\u0011Ba\u0019\u0003fA\u0005\t\u0019\u0001'\t\u0015\tm$Q\rI\u0001\u0002\u0004\u0011i(A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\r1#qP\u0005\u0004\u0005\u0003;#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005\u000b\u0013)\u0007%AA\u0002\tu\u0014\u0001D5t\rJ|Wn\u00117jK:$\bb\u0002B4\u0001\u0011%!\u0011\u0012\u000b\u000eK\t-%Q\u0012BH\u0005#\u0013\u0019J!(\t\rA\u00129\t1\u00013\u0011\u0019Q%q\u0011a\u0001\u0019\"A!\u0011\tBD\u0001\u0004\u0011\u0019\u0005C\u0004\u0003\\\t\u001d\u0005\u0019\u0001'\t\u0011\tU%q\u0011a\u0001\u0005/\u000bQAY1uG\"\u0004BAa\u0014\u0003\u001a&!!1\u0014B)\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u0011\t\u0015%q\u0011a\u0001\u0005{BqA!)\u0001\t\u0013\u0011\u0019+\u0001\fdkJ\u0014XM\u001c;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;t+\t\u0011)\u000bE\u0003\u0003(\nEF*\u0004\u0002\u0003**!!1\u0016BW\u0003%IW.\\;uC\ndWMC\u0002\u00030\u001e\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019L!+\u0003\u0007M+G\u000fC\u0005\u00038\u0002\t\n\u0011\"\u0003\u0003:\u0006\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HEN\u000b\u0003\u0005wS3\u0001\u0014B_W\t\u0011y\f\u0005\u0003\u0003B\n-WB\u0001Bb\u0015\u0011\u0011)Ma2\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BeO\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5'1\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003Bi\u0001E\u0005I\u0011\u0002Bj\u0003A\t\u0007\u000f]3oI\u0012\"WMZ1vYR$s'\u0006\u0002\u0003V*\"!Q\u0010B_\u0011%\u0011I\u000eAI\u0001\n\u0013\u0011\u0019.\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%q!I!Q\u001c\u0001\u0012\u0002\u0013%!q\\\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tOK\u0002U\u0005{C\u0011B!:\u0001#\u0003%IA!/\u00029\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class ProducerStateManagerTest
extends JUnitSuite {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 1, 0L, 1L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 5, 0L, 2L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.assertThrows((Function0)new Serializable(this, epoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.epoch$1, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$1 = epoch$1;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        this.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), (short)0, 0, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.assertThrows((Function0)new Serializable(this, producerEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short producerEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$ProducerStateManagerTest$$append(this.$outer.stateManager(), this.$outer.producerId(), this.producerEpoch$1, 17, 0L, 4L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerEpoch$1 = producerEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$19 = this.stateManager();
        long x$20 = this.producerId();
        short x$21 = epoch;
        int x$22 = sequence;
        long x$23 = offset;
        boolean x$24 = false;
        long x$25 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$26 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$19, x$20, x$21, x$22, x$23, x$25, x$26, x$24);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), false);
        appendInfo.append(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), 2000L, 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$27 = this.stateManager();
        long x$28 = this.producerId();
        short x$29 = epoch;
        int x$30 = sequence;
        long x$31 = offset;
        boolean x$32 = false;
        long x$33 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$34 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$27, x$28, x$29, x$30, x$31, x$33, x$34, x$32);
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$35 = this.stateManager();
        long x$36 = this.producerId();
        short x$37 = epoch;
        int x$38 = sequence;
        long x$39 = offset;
        boolean x$40 = false;
        long x$41 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$42 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$35, x$36, x$37, x$38, x$39, x$41, x$42, x$40);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
            long lastStableOffset = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
            CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
            long lastStableOffset2 = tuple23._2$mcJ$sp();
            Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
            Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
            Assert.assertEquals((long)2L, (long)lastStableOffset2);
            Assert.assertTrue((boolean)completedTxn2.isAborted());
            Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
            Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
            Assert.assertTrue((boolean)maybeLastEntry.isDefined());
            ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
            Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
            Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
            Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
            this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(ProducerStateEntry x$2) {
                    return x$2.firstSeq();
                }
            }));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)logOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, producerEpoch, segmentBaseOffset);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, producerEpoch, segmentBaseOffset);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, producerEpoch, segmentBaseOffset);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$3) {
                return x$3.messageOffset();
            }
        }));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$4) {
                return x$4.messageOffset();
            }
        }));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testNonMatchingTxnFirstOffsetMetadataNotCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset - 23429L, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), 15L, 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 26L, 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), 16L, 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 26L, 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnMetadata[]{new TxnMetadata(this.producerId(), 16L)})), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$43 = this.stateManager();
        long x$44 = this.producerId();
        short x$45 = epoch;
        int x$46 = 0;
        long x$47 = 0L;
        boolean x$48 = true;
        long x$49 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$50 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$43, x$44, x$45, x$46, x$47, x$49, x$48, x$50);
        ProducerStateManager x$51 = this.stateManager();
        long x$52 = this.producerId();
        short x$53 = epoch;
        int x$54 = 1;
        long x$55 = 1L;
        boolean x$56 = true;
        long x$57 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$58 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$51, x$52, x$53, x$54, x$55, x$57, x$56, x$58);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$59 = this.$outer.stateManager();
                long x$60 = this.$outer.producerId();
                short x$61 = this.bumpedEpoch$1;
                int x$62 = 2;
                long x$63 = 2L;
                boolean x$64 = true;
                long x$65 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                boolean x$66 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$59, x$60, x$61, x$62, x$63, x$65, x$64, x$66);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.assertThrows((Function0)new Serializable(this, bumpedEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short bumpedEpoch$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager x$67 = this.$outer.stateManager();
                long x$68 = this.$outer.producerId();
                short x$69 = (short)(this.bumpedEpoch$1 + 1);
                int x$70 = 2;
                long x$71 = 2L;
                boolean x$72 = true;
                long x$73 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$6();
                boolean x$74 = this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8();
                this.$outer.kafka$log$ProducerStateManagerTest$$append(x$67, x$68, x$69, x$70, x$71, x$73, x$72, x$74);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bumpedEpoch$1 = bumpedEpoch$1;
            }
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        ProducerStateManager x$75 = this.stateManager();
        long x$76 = this.producerId();
        short x$77 = bumpedEpoch;
        int x$78 = 0;
        long x$79 = 0L;
        boolean x$80 = true;
        long x$81 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$82 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$75, x$76, x$77, x$78, x$79, x$81, x$80, x$82);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$83 = this.stateManager();
        long x$84 = this.producerId();
        short x$85 = epoch;
        int x$86 = 0;
        long x$87 = 0L;
        boolean x$88 = true;
        long x$89 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$90 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$83, x$84, x$85, x$86, x$87, x$89, x$88, x$90);
        ProducerStateManager x$91 = this.stateManager();
        long x$92 = this.producerId();
        short x$93 = epoch;
        int x$94 = 1;
        long x$95 = 1L;
        boolean x$96 = false;
        long x$97 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$98 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$91, x$92, x$93, x$94, x$95, x$97, x$96, x$98);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)Predef$.MODULE$.refArrayOps((Object[])this.logDir().list()).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$99 = recoveredMapping;
        long x$100 = this.producerId();
        short x$101 = epoch;
        int x$102 = sequence;
        long x$103 = 2L;
        long x$104 = 70001L;
        boolean x$105 = false;
        boolean x$106 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
        this.kafka$log$ProducerStateManagerTest$$append(x$99, x$100, x$101, x$102, x$103, x$104, x$106, x$105);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$107 = this.stateManager();
            long x$108 = this.producerId();
            short x$109 = epoch;
            int x$110 = outOfOrderSequence;
            long x$111 = 1L;
            long x$112 = 1L;
            boolean x$113 = true;
            boolean x$114 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$107, x$108, x$109, x$110, x$111, x$112, x$114, x$113);
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        }
        catch (Exception exception) {
            throw this.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
            Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            ProducerStateManager x$115 = this.stateManager();
            long x$116 = this.producerId();
            short x$117 = epoch;
            int x$118 = outOfOrderSequence;
            long x$119 = 1L;
            long x$120 = 1L;
            boolean x$121 = false;
            boolean x$122 = this.kafka$log$ProducerStateManagerTest$$append$default$7();
            this.kafka$log$ProducerStateManagerTest$$append(x$115, x$116, x$117, x$118, x$119, x$120, x$122, x$121);
            Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
            return;
        }
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$123 = this.stateManager();
        long x$124 = this.producerId();
        short x$125 = epoch;
        int x$126 = sequence;
        long x$127 = 99L;
        boolean x$128 = true;
        long x$129 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$130 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$123, x$124, x$125, x$126, x$127, x$129, x$128, x$130);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$5) {
                return x$5.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$6) {
                return x$6.messageOffset();
            }
        }));
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$7) {
                return x$7.messageOffset();
            }
        }));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$8) {
                return x$8.messageOffset();
            }
        }));
    }

    @Test
    public void testFirstUnstableOffsetAfterEviction() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$131 = this.stateManager();
        long x$132 = this.producerId();
        short x$133 = epoch;
        int x$134 = sequence;
        long x$135 = 99L;
        boolean x$136 = true;
        long x$137 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$138 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$131, x$132, x$133, x$134, x$135, x$137, x$136, x$138);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$9) {
                return x$9.messageOffset();
            }
        }));
        ProducerStateManager x$139 = this.stateManager();
        long x$140 = 2L;
        short x$141 = epoch;
        int x$142 = 0;
        long x$143 = 106L;
        boolean x$144 = true;
        long x$145 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$146 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$139, x$140, x$141, x$142, x$143, x$145, x$144, x$146);
        this.stateManager().truncateHead(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)106)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$10) {
                return x$10.messageOffset();
            }
        }));
    }

    @Test
    public void testTruncateHead() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        long anotherPid = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), anotherPid, epoch, 0, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), anotherPid, epoch, 1, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        this.stateManager().truncateHead(2L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        Option maybeEntry = this.stateManager().lastEntry(anotherPid);
        Assert.assertTrue((boolean)maybeEntry.isDefined());
        Assert.assertEquals((long)3L, (long)((ProducerStateEntry)maybeEntry.get()).lastDataOffset());
        this.stateManager().truncateHead(3L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.currentSnapshotOffsets());
        Assert.assertEquals((long)4L, (long)this.stateManager().mapEndOffset());
        this.stateManager().truncateHead(5L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        Assert.assertEquals((long)5L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testLoadFromSnapshotRemovesNonRetainedProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid1, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(pid1));
        Option entry = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.assertThrows((Function0)new Serializable(this, epoch, pid2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManagerTest $outer;
            private final short epoch$2;
            private final long pid2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProducerStateManager recoveredMapping = new ProducerStateManager(this.$outer.partition(), this.$outer.logDir(), this.$outer.maxPidExpirationMs());
                recoveredMapping.truncateAndReload(0L, 1L, this.$outer.time().milliseconds());
                this.$outer.kafka$log$ProducerStateManagerTest$$append(recoveredMapping, this.pid2$1, this.epoch$2, 1, 4L, 5L, this.$outer.kafka$log$ProducerStateManagerTest$$append$default$7(), this.$outer.kafka$log$ProducerStateManagerTest$$append$default$8());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$2 = epoch$2;
                this.pid2$1 = pid2$1;
            }
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$147 = this.stateManager();
        long x$148 = this.producerId();
        short x$149 = epoch;
        int x$150 = sequence;
        long x$151 = 99L;
        boolean x$152 = true;
        long x$153 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$154 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$147, x$148, x$149, x$150, x$151, x$153, x$152, x$154);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$11) {
                return x$11.messageOffset();
            }
        }));
        long anotherPid = 2L;
        ProducerStateManager x$155 = this.stateManager();
        long x$156 = anotherPid;
        short x$157 = epoch;
        int x$158 = sequence;
        long x$159 = 105L;
        boolean x$160 = true;
        long x$161 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$162 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$155, x$156, x$157, x$158, x$159, x$161, x$160, x$162);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$12) {
                return x$12.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$13) {
                return x$13.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$14) {
                return x$14.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$15) {
                return x$15.messageOffset();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$16) {
                return x$16.messageOffset();
            }
        }));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogOffsetMetadata x$17) {
                return x$17.messageOffset();
            }
        }));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$163 = this.stateManager();
        long x$164 = this.producerId();
        short x$165 = epoch;
        int x$166 = sequence;
        long x$167 = 99L;
        boolean x$168 = true;
        long x$169 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$170 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$163, x$164, x$165, x$166, x$167, x$169, x$168, x$170);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$171 = stateManager;
        long x$172 = this.producerId();
        short x$173 = epoch;
        int x$174 = -1;
        long x$175 = 99L;
        boolean x$176 = true;
        long x$177 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$178 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$171, x$172, x$173, x$174, x$175, x$177, x$176, x$178);
        ProducerStateManager x$179 = stateManager;
        long x$180 = this.producerId();
        short x$181 = epoch;
        int x$182 = -1;
        long x$183 = 100L;
        boolean x$184 = true;
        long x$185 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$186 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$179, x$180, x$181, x$182, x$183, x$185, x$184, x$186);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$187 = this.stateManager();
        long x$188 = this.producerId();
        short x$189 = epoch;
        int x$190 = sequence;
        long x$191 = 99L;
        boolean x$192 = true;
        long x$193 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$194 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$187, x$188, x$189, x$190, x$191, x$193, x$192, x$194);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$195 = this.stateManager();
        long x$196 = this.producerId();
        short x$197 = epoch;
        int x$198 = sequence;
        long x$199 = 99L;
        boolean x$200 = true;
        long x$201 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$202 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$195, x$196, x$197, x$198, x$199, x$201, x$200, x$202);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ProducerStateEntry x$18) {
                return x$18.coordinatorEpoch();
            }
        }));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw this.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$203 = this.stateManager();
        long x$204 = this.producerId();
        short x$205 = producerEpoch;
        int x$206 = 0;
        long x$207 = 99L;
        boolean x$208 = true;
        long x$209 = this.kafka$log$ProducerStateManagerTest$$append$default$6();
        boolean x$210 = this.kafka$log$ProducerStateManagerTest$$append$default$8();
        this.kafka$log$ProducerStateManagerTest$$append(x$203, x$204, x$205, x$206, x$207, x$209, x$208, x$210);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                file.truncate(0L);
            }
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.truncate(file.size() / 2L);
            }
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileChannel file) {
                Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
                file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
            }
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, true);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    /*
     * WARNING - void declaration
     */
    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 0, 0L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        this.kafka$log$ProducerStateManagerTest$$append(this.stateManager(), producerId, epoch, 1, 1L, this.kafka$log$ProducerStateManagerTest$$append$default$6(), this.kafka$log$ProducerStateManagerTest$$append$default$7(), this.kafka$log$ProducerStateManagerTest$$append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);
        try {
            makeFileCorrupt.apply((Object)channel);
        }
        catch (Throwable throwable) {
            void var7_6;
            var7_6.close();
            throw throwable;
        }
        channel.close();
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    public void kafka$log$ProducerStateManagerTest$$append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, offset, offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(batch);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    public long kafka$log$ProducerStateManagerTest$$append$default$6() {
        return this.time().milliseconds();
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$7() {
        return false;
    }

    public boolean kafka$log$ProducerStateManagerTest$$append$default$8() {
        return true;
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private Set<Object> currentSnapshotOffsets() {
        return Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet();
    }

    private final void beginTxn$1(long producerId, long startOffset, short producerEpoch$2, long segmentBaseOffset$1) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch$2, 0, 0, this.time().milliseconds(), startOffset, startOffset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

