/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.FetchPartitionData;
import kafka.server.Fetching$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001\u001d\u0011QDU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bIR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005iF\u0002\b'F\u0001\u0017!\t9r$D\u0001\u0019\u0015\tI\"$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001\u0005\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011\u0003\u0001)A\u0005-\u0005)A/\r91A!9A\u0005\u0001b\u0001\n\u0013)\u0012\u0001\u0002;2aFBaA\n\u0001!\u0002\u00131\u0012!\u0002;2aF\u0002\u0003\"\u0002\u0015\u0001\t\u0013I\u0013AD8gMN,G/\u00118e\u000bB|7\r\u001b\u000b\u0004U5\u0012\u0004C\u0001\n,\u0013\ta#A\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000b9:\u0003\u0019A\u0018\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0003\u0013AJ!!\r\u0006\u0003\t1{gn\u001a\u0005\bg\u001d\u0002\n\u00111\u00015\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0005%)\u0014B\u0001\u001c\u000b\u0005\rIe\u000e\u001e\u0005\u0006q\u0001!\t!O\u0001#SN\u001cX/Z:Fa>\u001c\u0007NU3rk\u0016\u001cHO\u0012:p[2{7-\u00197SKBd\u0017nY1\u0015\u0003i\u0002\"!C\u001e\n\u0005qR!\u0001B+oSRD#a\u000e \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005k\u0012!\u00026v]&$\u0018BA\"A\u0005\u0011!Vm\u001d;\t\u000b\u0015\u0003A\u0011A\u001d\u0002{\u0019,Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193feNCw.\u001e7e\u0011\u0006tG\r\\3Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\$fi2{7-\u00197SKBd\u0017nY1)\u0005\u0011s\u0004\"\u0002%\u0001\t\u0003I\u0014!H:i_VdG\r\u0016:v]\u000e\fG/\u001a+p%\u0016\u0004H.[2b\u001f\u001a47/\u001a;)\u0005\u001ds\u0004\"B&\u0001\t\u0003I\u0014!L:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u000b:$wJ\u001a4tKR|e\rT1sO\u0016\u001cHoQ8n[>tW\t]8dQ\"\u0012!J\u0010\u0005\u0006\u001d\u0002!\t!O\u0001Bg\"|W\u000f\u001c3UeVt7-\u0019;f)>Le.\u001b;jC24U\r^2i\u001f\u001a47/\u001a;JMJ+\u0007\u000f\\5dCJ+G/\u001e:ogVsG-\u001a4j]\u0016$wJ\u001a4tKRD#!\u0014 \t\u000bE\u0003A\u0011A\u001d\u0002WMDw.\u001e7e!>dG.\u00138eK\u001aLg.\u001b;fYfLeMU3qY&\u001c\u0017MT8u\u0003Z\f\u0017\u000e\\1cY\u0016D#\u0001\u0015 \t\u000bQ\u0003A\u0011A\u001d\u0002MMDw.\u001e7e\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"|eNR5sgR4U\r^2i\u001f:d\u0017\u0010\u000b\u0002T}!)q\u000b\u0001C\u0001s\u0005a2\u000f[8vY\u00124U\r^2i\u001f:,'+\u001a9mS\u000e\f\u0017\t^!US6,\u0007F\u0001,?\u0011\u0015Q\u0006\u0001\"\u0001:\u00035\u001a\bn\\;mI\u001a+Go\u00195O_:$U\r\\1zK\u0012\fe\u000e\u001a(p]R\u0013XO\\2bi&twMU3qY&\u001c\u0017m\u001d\u0015\u00033zBQ!\u0018\u0001\u0005\u0002y\u000bAa\u001d;vER1qL\\:vof\u00042\u0001Y2f\u001b\u0005\t'B\u00012\u001e\u0003!)\u0017m]=n_\u000e\\\u0017B\u00013b\u0005MIU\t\u001f9fGR\fG/[8o'\u0016$H/\u001a:t!\rIa\r[\u0005\u0003O*\u0011aa\u00149uS>t\u0007CA5m\u001b\u0005Q'BA6\u0005\u0003\u001d\u0019G.^:uKJL!!\u001c6\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B8]\u0001\u0004\u0001\u0018a\u0003:fa2L7-\u0019+2aB\u0002\"![9\n\u0005IT'a\u0002*fa2L7-\u0019\u0005\u0006ir\u0003\r\u0001]\u0001\fe\u0016\u0004H.[2b)F\u0002\u0018\u0007C\u0003w9\u0002\u0007\u0001/A\u0007gkR,(/\u001a*fa2L7-\u0019\u0005\u0006qr\u0003\r\u0001[\u0001\na\u0006\u0014H/\u001b;j_:DQA\u001f/A\u0002m\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\u0013y&\u0011QP\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005)2\u000f^;c/&$\bNR3uG\"lUm]:bO\u0016\u001cHCDA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011q\u0002\t\u0004A\u000eT\u0004\"B8\u007f\u0001\u0004\u0001\b\"\u0002;\u007f\u0001\u0004\u0001\b\"\u0002<\u007f\u0001\u0004\u0001\b\"\u0002=\u007f\u0001\u0004A\u0007\"\u0002>\u007f\u0001\u0004Y\bbBA\t}\u0002\u0007\u00111C\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004R\u0001YA\u000b\u00033I1!a\u0006b\u0005\u001d\u0019\u0015\r\u001d;ve\u0016\u0004b!CA\u000e\u0003?Q\u0014bAA\u000f\u0015\tIa)\u001e8di&|g.\r\t\u0007\u0003C\t9#a\u000b\u000e\u0005\u0005\r\"bAA\u0013\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00121\u0005\u0002\u0004'\u0016\f\bCB\u0005\u0002.Y\t\t$C\u0002\u00020)\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\n\u00024%\u0019\u0011Q\u0007\u0002\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\n\u0003s\u0001\u0011\u0013!C\u0005\u0003w\t\u0001d\u001c4gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tiDK\u00025\u0003\u007fY#!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017R\u0011AC1o]>$\u0018\r^5p]&!\u0011qJA#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private OffsetAndEpoch offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    private int offsetAndEpoch$default$2() {
        return 1;
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).andReturn((Object)new EpochEndOffset(leaderEpochT1p0, (long)leoT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1(), false)).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).andReturn((Object)new EpochEndOffset(leaderEpochT1p1, (long)leoT1p1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, partitionT1p1, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, null, null);
        Map result = thread.fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpochT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpochT1p1))})));
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(Errors.NONE, leaderEpochT1p0, (long)leoT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(Errors.NONE, leaderEpochT1p1, (long)leoT1p1))}));
        Assert.assertEquals((String)"results from leader epoch request should have offset from local replica", (Object)expected, (Object)result);
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 2;
        int leo = 13;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)leo)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1(), false)).andThrow((Throwable)new KafkaStorageException()).once();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, null, null);
        Map result = thread.fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpoch))})));
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new EpochEndOffset(Errors.NONE, leaderEpoch, (long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new EpochEndOffset(Errors.KAFKA_STORAGE_ERROR, -1, -1L))}));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        Capture truncateCaptureT1p0 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Capture truncateCaptureT1p1 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replicaT1p0 = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica replicaT1p1 = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplicaT1p0 = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplicaT1p1 = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1(), false)).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andStubReturn((Object)futureReplicaT1p0);
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p1())).andStubReturn((Object)futureReplicaT1p1);
        partitionT1p0.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p0)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        partitionT1p1.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p1)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplicaT1p0.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplicaT1p1.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplicaT1p0.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureReplicaT1p0.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaT1p0LEO)).anyTimes();
        EasyMock.expect((Object)futureReplicaT1p1.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureReplicaT1p1.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaT1p1LEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(replicaT1p0, replicaT1p1, futureReplicaT1p0, partitionT1p0, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replicaT1p0, replicaT1p1, futureReplicaT1p0, partitionT1p0, partitionT1p1});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andStubReturn((Object)futureReplica);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)futureReplica.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2)))).once();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch - 1, (long)replicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplica.endOffsetForEpoch(leaderEpoch - 1)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).andReturn((Object)new EpochEndOffset(leaderEpoch - 2, (long)replicaEpochEndOffset)).anyTimes();
        EasyMock.expect((Object)futureReplica.endOffsetForEpoch(leaderEpoch - 2)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(replica, replica, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder().append((Object)"Expected offset ").append((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)).append((Object)" in captured truncation offsets ").append((Object)truncateToCapture.getValues()).toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)));
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int initialFetchOffset = 100;
        int futureReplicaLEO = 111;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andStubReturn((Object)futureReplica);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)futureReplica.latestEpoch()).andReturn((Object)None$.MODULE$).anyTimes();
        this.stubWithFetchMessages(replica, replica, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(initialFetchOffset, this.offsetAndEpoch$default$2()))})));
        thread.doWork();
        Assert.assertEquals((String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET", (long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andStubReturn((Object)futureReplica);
        EasyMock.expect((Object)futureReplica.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)futureReplica.endOffsetForEpoch(futureReplicaLeaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplica(this.t1p0())).andReturn((Object)new Some((Object)replica)).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplica(this.t1p0())).andReturn((Object)new Some((Object)futureReplica)).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andReturn((Object)futureReplica).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).andReturn((Object)new EpochEndOffset(Errors.REPLICA_NOT_AVAILABLE, -1, -1L)).times(3).andReturn((Object)new EpochEndOffset(futureReplicaLeaderEpoch, (long)replicaLEO));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (IsolationLevel)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, responseCallback){
            private final Capture responseCallback$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Seq$.MODULE$.empty());
            }
            {
                this.responseCallback$2 = responseCallback$2;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final ReplicaAlterLogDirsThread thread$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.thread$1.doWork();
            }
            {
                this.thread$1 = thread$1;
            }
        });
        Assert.assertEquals((long)0L, (long)truncated.getValues().size());
        thread.doWork();
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaLEO));
        partition.truncateTo((long)futureReplicaLEO, true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andStubReturn((Object)futureReplica);
        EasyMock.expect((Object)futureReplica.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureReplica.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(replica, replica, futureReplica, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, thread){
            public static final long serialVersionUID = 0L;
            private final ReplicaAlterLogDirsThread thread$2;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                this.thread$2.doWork();
            }
            {
                this.thread$2 = thread$2;
            }
        });
        EasyMock.verify((Object[])new Object[]{partition});
    }

    @Test
    public void shouldFetchOneReplicaAtATime() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)123L)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(replica, replica, futureReplica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply(150L, leaderEpoch, (ReplicaState)Fetching$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)PartitionFetchState$.MODULE$.apply(160L, leaderEpoch, (ReplicaState)Fetching$.MODULE$))})));
        if (resultWithPartitions != null) {
            Tuple2 tuple2;
            Option fetchRequestOpt = (Option)resultWithPartitions.result();
            Set partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fetchRequestOpt, (Object)partitionsWithError);
            Option fetchRequestOpt2 = (Option)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            Assert.assertTrue((boolean)fetchRequestOpt2.isDefined());
            FetchRequest.Builder fetchRequest = (FetchRequest.Builder)fetchRequestOpt2.get();
            Assert.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
            Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
            FetchRequest request = (FetchRequest)fetchRequest.build();
            Assert.assertEquals((long)0L, (long)request.minBytes());
            Seq fetchInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq();
            Assert.assertEquals((long)1L, (long)fetchInfos.length());
            Assert.assertEquals((String)"Expected fetch request for largest partition", (Object)this.t1p1(), (Object)((Tuple2)fetchInfos.head())._1());
            Assert.assertEquals((long)160L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
            return;
        }
        throw new MatchError((Object)resultWithPartitions);
    }

    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Replica replica = (Replica)EasyMock.createNiceMock(Replica.class);
        Replica futureReplica = (Replica)EasyMock.createNiceMock(Replica.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureReplica.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)123L)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(replica, replica, futureReplica, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, replica, futureReplica, partition});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.offsetAndEpoch(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.offsetAndEpoch(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply(150L, leaderEpoch, (ReplicaState)Fetching$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)PartitionFetchState$.MODULE$.apply(160L, leaderEpoch, (ReplicaState)Truncating$.MODULE$))})));
        if (resultWithPartitions != null) {
            Tuple2 tuple2;
            Option fetchRequestOpt = (Option)resultWithPartitions.result();
            Set partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fetchRequestOpt, (Object)partitionsWithError);
            Option fetchRequestOpt2 = (Option)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            Assert.assertTrue((boolean)fetchRequestOpt2.isDefined());
            FetchRequest.Builder fetchRequest = (FetchRequest.Builder)fetchRequestOpt2.get();
            Assert.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
            Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
            Seq fetchInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest.build()).fetchData()).asScala()).toSeq();
            Assert.assertEquals((long)1L, (long)fetchInfos.length());
            Assert.assertEquals((String)"Expected fetch request for non-truncating partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos.head())._1());
            Assert.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
            AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply(140L, leaderEpoch, (ReplicaState)Fetching$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(160L, leaderEpoch, new DelayedItem(5000L), (ReplicaState)Fetching$.MODULE$))})));
            if (resultWithPartitions2 != null) {
                Tuple2 tuple23;
                Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
                Set partitionsWithError22 = resultWithPartitions2.partitionsWithError();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)fetchRequest2Opt, (Object)partitionsWithError22);
                Option fetchRequest2Opt2 = (Option)tuple24._1();
                Set partitionsWithError23 = (Set)tuple24._2();
                Assert.assertTrue((boolean)fetchRequest2Opt2.isDefined());
                FetchRequest.Builder fetchRequest2 = (FetchRequest.Builder)fetchRequest2Opt2.get();
                Assert.assertFalse((boolean)fetchRequest2.fetchData().isEmpty());
                Assert.assertFalse((boolean)partitionsWithError23.nonEmpty());
                Seq fetchInfos2 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest2.build()).fetchData()).asScala()).toSeq();
                Assert.assertEquals((long)1L, (long)fetchInfos2.length());
                Assert.assertEquals((String)"Expected fetch request for non-delayed partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos2.head())._1());
                Assert.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
                AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState(140L, leaderEpoch, new DelayedItem(5000L), (ReplicaState)Fetching$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(160L, leaderEpoch, new DelayedItem(5000L), (ReplicaState)Fetching$.MODULE$))})));
                if (resultWithPartitions3 != null) {
                    Tuple2 tuple25;
                    Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
                    Set partitionsWithError3 = resultWithPartitions3.partitionsWithError();
                    Tuple2 tuple26 = tuple25 = new Tuple2((Object)fetchRequest3Opt, (Object)partitionsWithError3);
                    Option fetchRequest3Opt2 = (Option)tuple26._1();
                    Set partitionsWithError32 = (Set)tuple26._2();
                    Assert.assertTrue((String)"Expected no fetch requests since all partitions are delayed", (boolean)fetchRequest3Opt2.isEmpty());
                    Assert.assertFalse((boolean)partitionsWithError32.nonEmpty());
                    return;
                }
                throw new MatchError((Object)resultWithPartitions3);
            }
            throw new MatchError((Object)resultWithPartitions2);
        }
        throw new MatchError((Object)resultWithPartitions);
    }

    public IExpectationSetters<Option<Partition>> stub(Replica replicaT1p0, Replica replicaT1p1, Replica futureReplica, Partition partition, ReplicaManager replicaManager) {
        EasyMock.expect((Object)replicaManager.localReplica(this.t1p0())).andReturn((Object)new Some((Object)replicaT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplica(this.t1p0())).andReturn((Object)new Some((Object)futureReplica)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplicaOrException(this.t1p0())).andReturn((Object)replicaT1p0).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p0())).andReturn((Object)futureReplica).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplica(this.t1p1())).andReturn((Object)new Some((Object)replicaT1p1)).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplica(this.t1p1())).andReturn((Object)new Some((Object)futureReplica)).anyTimes();
        EasyMock.expect((Object)replicaManager.localReplicaOrException(this.t1p1())).andReturn((Object)replicaT1p1).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalReplicaOrException(this.t1p1())).andReturn((Object)futureReplica).anyTimes();
        return EasyMock.expect((Object)replicaManager.getPartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }

    public IExpectationSetters<BoxedUnit> stubWithFetchMessages(Replica replicaT1p0, Replica replicaT1p1, Replica futureReplica, Partition partition, ReplicaManager replicaManager, Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(replicaT1p0, replicaT1p1, futureReplica, partition, replicaManager);
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture(responseCallback), (IsolationLevel)EasyMock.anyObject());
        return EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, responseCallback){
            private final Capture responseCallback$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Seq$.MODULE$.empty());
            }
            {
                this.responseCallback$1 = responseCallback$1;
            }
        }).anyTimes();
    }
}

