/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u000f\t\u0019B)^7q\u0019><7+Z4nK:$8\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u0019!X\u000e\u001d#jeV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0003GS2,\u0007BB\u0010\u0001A\u0003%a#A\u0004u[B$\u0015N\u001d\u0011\t\u000f\u0005\u0002!\u0019!C\u0001+\u00051An\\4ESJDaa\t\u0001!\u0002\u00131\u0012a\u00027pO\u0012K'\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003\u001dawn\u001a$jY\u0016,\u0012a\n\t\u0003Q-r!!C\u0015\n\u0005)R\u0011A\u0002)sK\u0012,g-\u0003\u0002-[\t11\u000b\u001e:j]\u001eT!A\u000b\u0006\t\r=\u0002\u0001\u0015!\u0003(\u0003!awn\u001a$jY\u0016\u0004\u0003bB\u0019\u0001\u0005\u0004%\tAM\u0001\u0005i&lW-F\u00014!\t!t'D\u00016\u0015\t1D!A\u0003vi&d7/\u0003\u00029k\tAQj\\2l)&lW\r\u0003\u0004;\u0001\u0001\u0006IaM\u0001\u0006i&lW\r\t\u0005\u0006y\u0001!\t!P\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002}A\u0011\u0011bP\u0005\u0003\u0001*\u0011A!\u00168ji\"\u00121H\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bQA[;oSRT\u0011aR\u0001\u0004_J<\u0017BA%E\u0005\u0019\u0011UMZ8sK\")1\n\u0001C\u0001{\u0005AA/Z1s\t><h\u000e\u000b\u0002K\u001bB\u00111IT\u0005\u0003\u001f\u0012\u0013Q!\u00114uKJDQ!\u0015\u0001\u0005\u0002u\n\u0001\u0003^3tiB\u0013\u0018N\u001c;ECR\fGj\\4)\u0005A\u001b\u0006CA\"U\u0013\t)FI\u0001\u0003UKN$\b\"B,\u0001\t\u0013A\u0016A\u0005:v]\u0012+X\u000e\u001d'pON+w-\\3oiN$\"aJ-\t\u000bi3\u0006\u0019A.\u0002\t\u0005\u0014xm\u001d\t\u0004\u0013q;\u0013BA/\u000b\u0005\u0015\t%O]1z\u0001")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String logFile = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/00000000000000000000.log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir()}));
    private final MockTime time = new MockTime(0L, 0L);

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String logFile() {
        return this.logFile;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        File x$1 = this.logDir();
        LogConfig x$2 = LogConfig$.MODULE$.apply();
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log2 = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.flush();
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFile()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFile()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFile()}));
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)new Serializable(this, args){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DumpLogSegments$.MODULE$.main(this.args$1);
            }
            {
                this.args$1 = args$1;
            }
        });
        return outContent.toString();
    }

    private final void verifyRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data not printed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})), (lines.length > 2 ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable(this, lines){
            public static final long serialVersionUID = 0L;
            private final String[] lines$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String line = this.lines$1[this.lines$1.length - 6 + i];
                if (i % 3 == 0) {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid batch-level message record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baseOffset: ", " lastOffset: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i / 3 * 2))}))));
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid message record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DumpLogSegments$.MODULE$.RECORD_INDENT(), BoxesRunTime.boxToInteger((int)(i - 1 - i / 3))}))));
                }
            }
            {
                this.lines$1 = lines$1;
            }
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data should not have been printed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})), (boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"));
    }
}

