/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0001\u0003\u0001\u001d\u0011AcQ8n[\u0006tG\rT5oKV#\u0018\u000e\\:UKN$(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u0015!\u0002\u0001\"\u0001\u0016\u0003E!Xm\u001d;QCJ\u001cX-R7qif\f%o\u001a\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\"1C\u0007\u0012$!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\u0006AQ\r\u001f9fGR,GmI\u0001%!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0011\u0015i\u0003\u0001\"\u0001\u0016\u0003\u0001\"Xm\u001d;QCJ\u001cX-R7qif\f%oZ,ji\"tu\u000eR3mS6LG/\u001a:)\t1R\"e\t\u0005\u0006a\u0001!\t!F\u0001\u0019i\u0016\u001cH\u000fU1sg\u0016,U\u000e\u001d;z\u0003J<\u0017i\u001d,bY&$\u0007FA\u0018\u001b\u0011\u0015\u0019\u0004\u0001\"\u0001\u0016\u0003I!Xm\u001d;QCJ\u001cXmU5oO2,\u0017I]4)\u0005IR\u0002\"\u0002\u001c\u0001\t\u0003)\u0012!\u0004;fgR\u0004\u0016M]:f\u0003J<7\u000f\u000b\u000265!)\u0011\b\u0001C\u0001+\u0005\u0019C/Z:u!\u0006\u00148/Z!sON<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\t\u0016d\u0017.\\5uKJ\u001c\bF\u0001\u001d\u001b\u0011\u001da\u0004A1A\u0005\u0002u\nQ\u0001\u001d:paN,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\"\nA!\u001e;jY&\u00111\t\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB#\u0001A\u0003%a(\u0001\u0004qe>\u00048\u000f\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003\u0019\u0001\u0018M]:feV\t\u0011\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0003\u001d.\u0013Ab\u00149uS>t\u0007+\u0019:tKJDa\u0001\u0015\u0001!\u0002\u0013I\u0015a\u00029beN,'\u000f\t\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002M\u000b\u0011b\u001d;sS:<w\n\u001d;\u0016\u0003Q\u00032AS+X\u0013\t16J\u0001\u0006PaRLwN\\*qK\u000e\u0004\"\u0001W.\u000f\u0005%I\u0016B\u0001.\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iS\u0001\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0001a\u00035\u0019HO]5oO>\u0003Ho\u0018\u0013fcR\u0011a#\u0019\u0005\bEz\u000b\t\u00111\u0001U\u0003\rAH%\r\u0005\u0007I\u0002\u0001\u000b\u0015\u0002+\u0002\u0015M$(/\u001b8h\u001fB$\b\u0005C\u0005g\u0001\u0001\u0007\t\u0019!C\u0001O\u00061\u0011N\u001c;PaR,\u0012\u0001\u001b\t\u0004\u0015VK\u0007CA\u0013k\u0013\tYgEA\u0004J]R,w-\u001a:\t\u00135\u0004\u0001\u0019!a\u0001\n\u0003q\u0017AC5oi>\u0003Ho\u0018\u0013fcR\u0011ac\u001c\u0005\bE2\f\t\u00111\u0001i\u0011\u0019\t\b\u0001)Q\u0005Q\u00069\u0011N\u001c;PaR\u0004\u0003\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0001T\u0003Q\u0019HO]5oO>\u0003Ho\u00149uS>t\u0017\r\\!sO\"IQ\u000f\u0001a\u0001\u0002\u0004%\tA^\u0001\u0019gR\u0014\u0018N\\4PaR|\u0005\u000f^5p]\u0006d\u0017I]4`I\u0015\fHC\u0001\fx\u0011\u001d\u0011G/!AA\u0002QCa!\u001f\u0001!B\u0013!\u0016!F:ue&twm\u00149u\u001fB$\u0018n\u001c8bY\u0006\u0013x\r\t\u0005\nw\u0002\u0001\r\u00111A\u0005\u0002\u001d\f\u0011#\u001b8u\u001fB$x\n\u001d;j_:\fG.\u0011:h\u0011%i\b\u00011AA\u0002\u0013\u0005a0A\u000bj]R|\u0005\u000f^(qi&|g.\u00197Be\u001e|F%Z9\u0015\u0005Yy\bb\u00022}\u0003\u0003\u0005\r\u0001\u001b\u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003i\u0003IIg\u000e^(qi>\u0003H/[8oC2\f%o\u001a\u0011\t\u0015\u0005\u001d\u0001\u00011AA\u0002\u0013\u00051+A\u000ftiJLgnZ(qi>\u0003H/[8oC2\f%o\u001a(p\t\u00164\u0017-\u001e7u\u0011-\tY\u0001\u0001a\u0001\u0002\u0004%\t!!\u0004\u0002CM$(/\u001b8h\u001fB$x\n\u001d;j_:\fG.\u0011:h\u001d>$UMZ1vYR|F%Z9\u0015\u0007Y\ty\u0001\u0003\u0005c\u0003\u0013\t\t\u00111\u0001U\u0011\u001d\t\u0019\u0002\u0001Q!\nQ\u000bad\u001d;sS:<w\n\u001d;PaRLwN\\1m\u0003J<gj\u001c#fM\u0006,H\u000e\u001e\u0011\t\u0015\u0005]\u0001\u00011AA\u0002\u0013\u0005q-\u0001\u000ej]R|\u0005\u000f^(qi&|g.\u00197Be\u001etu\u000eR3gCVdG\u000fC\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\u0002\u0005u\u0011AH5oi>\u0003Ho\u00149uS>t\u0017\r\\!sO:{G)\u001a4bk2$x\fJ3r)\r1\u0012q\u0004\u0005\tE\u0006e\u0011\u0011!a\u0001Q\"9\u00111\u0005\u0001!B\u0013A\u0017aG5oi>\u0003Ho\u00149uS>t\u0017\r\\!sO:{G)\u001a4bk2$\b\u0005\u0003\u0004\u0002(\u0001!\t!F\u0001\rg\u0016$X\u000b](qi&|gn\u001d\u0005\u0007\u0003W\u0001A\u0011A\u000b\u0002MQ,7\u000f^'bs\n,W*\u001a:hK>\u0003H/[8og>3XM]<sSR,W\t_5ti&tw\rK\u0002\u0002*iAa!!\r\u0001\t\u0003)\u0012!\f;fgRl\u0015-\u001f2f\u001b\u0016\u0014x-Z(qi&|gn\u001d#fM\u0006,H\u000e^(wKJ<(/\u001b;f\u000bbL7\u000f^5oO\"\u001a\u0011q\u0006\u000e\t\r\u0005]\u0002\u0001\"\u0001\u0016\u0003-\"Xm\u001d;NCf\u0014W-T3sO\u0016|\u0005\u000f^5p]N$UMZ1vYR4\u0016\r\\;f\u0013\u001atu\u000e^#ySN$\bfAA\u001b5!1\u0011Q\b\u0001\u0005\u0002U\t\u0011\u0006^3ti6\u000b\u0017PY3NKJ<Wm\u00149uS>t7OT8u\u001fZ,'o\u001e:ji\u0016,\u00050[:uS:<\u0007fAA\u001e5\u0001")
public class CommandLineUtilsTest {
    private final Properties props = new Properties();
    private final OptionParser parser = new OptionParser(false);
    private OptionSpec<String> stringOpt;
    private OptionSpec<Integer> intOpt;
    private OptionSpec<String> stringOptOptionalArg;
    private OptionSpec<Integer> intOptOptionalArg;
    private OptionSpec<String> stringOptOptionalArgNoDefault;
    private OptionSpec<Integer> intOptOptionalArgNoDefault;

    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyArg() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property="});
        CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyArgWithNoDelimiter() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property"});
        CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), false);
    }

    @Test
    public void testParseEmptyArgAsValid() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property=", "my.empty.property1"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of a key with missing value should be an empty string", (Object)props.getProperty("my.empty.property"), (Object)"");
        Assert.assertEquals((String)"Value of a key with missing value with no delimiter should be an empty string", (Object)props.getProperty("my.empty.property1"), (Object)"");
    }

    @Test
    public void testParseSingleArg() {
        String[] argArray = (String[])((Object[])new String[]{"my.property=value"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of a single property should be 'value' ", (Object)props.getProperty("my.property"), (Object)"value");
    }

    @Test
    public void testParseArgs() {
        String[] argArray = (String[])((Object[])new String[]{"first.property=first", "second.property=second"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of first property should be 'first'", (Object)props.getProperty("first.property"), (Object)"first");
        Assert.assertEquals((String)"Value of second property should be 'second'", (Object)props.getProperty("second.property"), (Object)"second");
    }

    @Test
    public void testParseArgsWithMultipleDelimiters() {
        String[] argArray = (String[])((Object[])new String[]{"first.property==first", "second.property=second=", "third.property=thi=rd"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assert.assertEquals((String)"Value of first property should be '=first'", (Object)props.getProperty("first.property"), (Object)"=first");
        Assert.assertEquals((String)"Value of second property should be 'second='", (Object)props.getProperty("second.property"), (Object)"second=");
        Assert.assertEquals((String)"Value of second property should be 'thi=rd'", (Object)props.getProperty("third.property"), (Object)"thi=rd");
    }

    public Properties props() {
        return this.props;
    }

    public OptionParser parser() {
        return this.parser;
    }

    public OptionSpec<String> stringOpt() {
        return this.stringOpt;
    }

    public void stringOpt_$eq(OptionSpec<String> x$1) {
        this.stringOpt = x$1;
    }

    public OptionSpec<Integer> intOpt() {
        return this.intOpt;
    }

    public void intOpt_$eq(OptionSpec<Integer> x$1) {
        this.intOpt = x$1;
    }

    public OptionSpec<String> stringOptOptionalArg() {
        return this.stringOptOptionalArg;
    }

    public void stringOptOptionalArg_$eq(OptionSpec<String> x$1) {
        this.stringOptOptionalArg = x$1;
    }

    public OptionSpec<Integer> intOptOptionalArg() {
        return this.intOptOptionalArg;
    }

    public void intOptOptionalArg_$eq(OptionSpec<Integer> x$1) {
        this.intOptOptionalArg = x$1;
    }

    public OptionSpec<String> stringOptOptionalArgNoDefault() {
        return this.stringOptOptionalArgNoDefault;
    }

    public void stringOptOptionalArgNoDefault_$eq(OptionSpec<String> x$1) {
        this.stringOptOptionalArgNoDefault = x$1;
    }

    public OptionSpec<Integer> intOptOptionalArgNoDefault() {
        return this.intOptOptionalArgNoDefault;
    }

    public void intOptOptionalArgNoDefault_$eq(OptionSpec<Integer> x$1) {
        this.intOptOptionalArgNoDefault = x$1;
    }

    public void setUpOptions() {
        this.stringOpt_$eq((OptionSpec<String>)this.parser().accepts("str").withRequiredArg().ofType(String.class).defaultsTo((Object)"default-string", (Object[])new String[0]));
        this.intOpt_$eq((OptionSpec<Integer>)this.parser().accepts("int").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]));
        this.stringOptOptionalArg_$eq((OptionSpec<String>)this.parser().accepts("str-opt").withOptionalArg().ofType(String.class).defaultsTo((Object)"default-string-2", (Object[])new String[0]));
        this.intOptOptionalArg_$eq((OptionSpec<Integer>)this.parser().accepts("int-opt").withOptionalArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]));
        this.stringOptOptionalArgNoDefault_$eq((OptionSpec<String>)this.parser().accepts("str-opt-nodef").withOptionalArg().ofType(String.class));
        this.intOptOptionalArgNoDefault_$eq((OptionSpec<Integer>)this.parser().accepts("int-opt-nodef").withOptionalArg().ofType(Integer.class));
    }

    @Test
    public void testMaybeMergeOptionsOverwriteExisting() {
        this.setUpOptions();
        this.props().put("skey", "existing-string");
        this.props().put("ikey", "300");
        this.props().put("sokey", "existing-string-2");
        this.props().put("iokey", "400");
        this.props().put("sondkey", "existing-string-3");
        this.props().put("iondkey", "500");
        OptionSet options = this.parser().parse(new String[]{"--str", "some-string", "--int", "600", "--str-opt", "some-string-2", "--int-opt", "700", "--str-opt-nodef", "some-string-3", "--int-opt-nodef", "800"});
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"some-string", (Object)this.props().get("skey"));
        Assert.assertEquals((Object)"600", (Object)this.props().get("ikey"));
        Assert.assertEquals((Object)"some-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"700", (Object)this.props().get("iokey"));
        Assert.assertEquals((Object)"some-string-3", (Object)this.props().get("sondkey"));
        Assert.assertEquals((Object)"800", (Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultOverwriteExisting() {
        this.setUpOptions();
        this.props().put("sokey", "existing-string");
        this.props().put("iokey", "300");
        this.props().put("sondkey", "existing-string-2");
        this.props().put("iondkey", "400");
        OptionSet options = this.parser().parse(new String[]{"--str-opt", "--int-opt", "--str-opt-nodef", "--int-opt-nodef"});
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"default-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"200", (Object)this.props().get("iokey"));
        Assert.assertNull((Object)this.props().get("sondkey"));
        Assert.assertNull((Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultValueIfNotExist() {
        this.setUpOptions();
        OptionSet options = this.parser().parse(new String[0]);
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"default-string", (Object)this.props().get("skey"));
        Assert.assertEquals((Object)"100", (Object)this.props().get("ikey"));
        Assert.assertEquals((Object)"default-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"200", (Object)this.props().get("iokey"));
        Assert.assertNull((Object)this.props().get("sondkey"));
        Assert.assertNull((Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsNotOverwriteExisting() {
        this.setUpOptions();
        this.props().put("skey", "existing-string");
        this.props().put("ikey", "300");
        this.props().put("sokey", "existing-string-2");
        this.props().put("iokey", "400");
        this.props().put("sondkey", "existing-string-3");
        this.props().put("iondkey", "500");
        OptionSet options = this.parser().parse(new String[0]);
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"existing-string", (Object)this.props().get("skey"));
        Assert.assertEquals((Object)"300", (Object)this.props().get("ikey"));
        Assert.assertEquals((Object)"existing-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"400", (Object)this.props().get("iokey"));
        Assert.assertEquals((Object)"existing-string-3", (Object)this.props().get("sondkey"));
        Assert.assertEquals((Object)"500", (Object)this.props().get("iondkey"));
    }
}

