/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import javax.security.auth.login.Configuration;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZooKeeperTestHarness$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.IntegrationTest;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u0001\u0003\u0003\u00039!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u0002\u0004\t\u0005\u0011!p\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013\u0005q$A\n{W\u000e{gN\\3di&|g\u000eV5nK>,H/F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002)i\\7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;!\u0011\u001dI\u0003A1A\u0005\u0002}\t\u0001C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;\t\r-\u0002\u0001\u0015!\u0003!\u0003EQ8nU3tg&|g\u000eV5nK>,H\u000f\t\u0005\b[\u0001\u0011\r\u0011\"\u0001 \u0003UQ8.T1y\u0013:4E.[4iiJ+\u0017/^3tiNDaa\f\u0001!\u0002\u0013\u0001\u0013A\u0006>l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\t\u000bE\u0002A\u0011\u0003\u001a\u0002\u001bi\\\u0017i\u00197t\u000b:\f'\r\\3e+\u0005\u0019\u0004cA\u00115m%\u0011QG\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0005:\u0014B\u0001\u001d#\u0005\u001d\u0011un\u001c7fC:DqA\u000f\u0001A\u0002\u0013\u00051(\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005a\u0004C\u0001\u000f>\u0013\tq$AA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u00031Q8n\u00117jK:$x\fJ3r)\t\u0011U\t\u0005\u0002\"\u0007&\u0011AI\t\u0002\u0005+:LG\u000fC\u0004G\u007f\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013\u0007\u0003\u0004I\u0001\u0001\u0006K\u0001P\u0001\nu.\u001cE.[3oi\u0002BqA\u0013\u0001A\u0002\u0013\u00051*A\u0007bI6LgNW6DY&,g\u000e^\u000b\u0002\u0019B\u0011A$T\u0005\u0003\u001d\n\u0011Q\"\u00113nS:T6n\u00117jK:$\bb\u0002)\u0001\u0001\u0004%\t!U\u0001\u0012C\u0012l\u0017N\u001c.l\u00072LWM\u001c;`I\u0015\fHC\u0001\"S\u0011\u001d1u*!AA\u00021Ca\u0001\u0016\u0001!B\u0013a\u0015AD1e[&t'l[\"mS\u0016tG\u000f\t\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003%Qxn\\6fKB,'/F\u0001Y!\ta\u0012,\u0003\u0002[\u0005\t\tR)\u001c2fI\u0012,GMW8pW\u0016,\u0007/\u001a:\t\u000fq\u0003\u0001\u0019!C\u0001;\u0006i!p\\8lK\u0016\u0004XM]0%KF$\"A\u00110\t\u000f\u0019[\u0016\u0011!a\u00011\"1\u0001\r\u0001Q!\na\u000b!B_8pW\u0016,\u0007/\u001a:!\u0011\u0015\u0011\u0007\u0001\"\u0001 \u0003\u0019Q8\u000eU8si\")A\r\u0001C\u0001K\u0006I!p[\"p]:,7\r^\u000b\u0002MB\u0011qM\u001b\b\u0003C!L!!\u001b\u0012\u0002\rA\u0013X\rZ3g\u0013\tYGN\u0001\u0004TiJLgn\u001a\u0006\u0003S\nBQA\u001c\u0001\u0005\u0002=\fQa]3u+B$\u0012A\u0011\u0015\u0003[F\u0004\"A\u001d;\u000e\u0003MT!a\u0003\b\n\u0005U\u001c(A\u0002\"fM>\u0014X\rC\u0003x\u0001\u0011\u0005q.\u0001\u0005uK\u0006\u0014Hi\\<oQ\t1\u0018\u0010\u0005\u0002su&\u00111p\u001d\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006{\u0002!\tA`\u0001,GJ,\u0017\r^3[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u)>$&/[4hKJ\u001cVm]:j_:,\u0005\u0010]5ssR\u0019q0!\u0004\u0011\t\u0005\u0005\u0011\u0011B\u0007\u0003\u0003\u0007Q1AVA\u0003\u0015\r\t9AD\u0001\u0007CB\f7\r[3\n\t\u0005-\u00111\u0001\u0002\n5>|7*Z3qKJDa!a\u0004}\u0001\u0004y\u0018!\u0003>p_.+W\r]3sQ\u001d\u0001\u00111CA\u0012\u0003K\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0006dCR,wm\u001c:jKNT1!!\bt\u00031)\u0007\u0010]3sS6,g\u000e^1m\u0013\u0011\t\t#a\u0006\u0003\u0011\r\u000bG/Z4pef\fQA^1mk\u0016d#!a\n$\u0005\u0005%\u0002\u0003BA\u0016\u0003gi!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005i\u0016\u001cHOC\u0002\u0006\u0003\u000bIA!!\u000e\u0002.\ty\u0011J\u001c;fOJ\fG/[8o)\u0016\u001cHoB\u0004\u0002:\tA\t!a\u000f\u0002)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\ra\u0012Q\b\u0004\u0007\u0003\tA\t!a\u0010\u0014\r\u0005u\u0012\u0011IA$!\r\t\u00131I\u0005\u0004\u0003\u000b\u0012#AB!osJ+g\rE\u0002\"\u0003\u0013J1!a\u0013#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dI\u0012Q\bC\u0001\u0003\u001f\"\"!a\u000f\t\u0015\u0005M\u0013Q\bb\u0001\n\u0003\t)&A\r[W\u000ec\u0017.\u001a8u\u000bZ,g\u000e\u001e+ie\u0016\fGmU;gM&DXCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-C\u0002l\u00037B\u0011\"a\u001a\u0002>\u0001\u0006I!a\u0016\u00025i[7\t\\5f]R,e/\u001a8u)\"\u0014X-\u00193Tk\u001a4\u0017\u000e\u001f\u0011\t\u0015\u0005-\u0014Q\bb\u0001\n\u0003\ti'A\u000bv]\u0016D\b/Z2uK\u0012$\u0006N]3bI:\u000bW.Z:\u0016\u0005\u0005=\u0004CBA9\u0003o\n9&\u0004\u0002\u0002t)\u0019\u0011Q\u000f\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002z\u0005M$aA*fi\"I\u0011QPA\u001fA\u0003%\u0011qN\u0001\u0017k:,\u0007\u0010]3di\u0016$G\u000b\u001b:fC\u0012t\u0015-\\3tA!9\u0011\u0011QA\u001f\t\u0003y\u0017AC:fiV\u00038\t\\1tg\"\"\u0011qPAC!\r\u0011\u0018qQ\u0005\u0004\u0003\u0013\u001b(a\u0003\"fM>\u0014Xm\u00117bgNDq!!$\u0002>\u0011\u0005q.A\u0007uK\u0006\u0014Hi\\<o\u00072\f7o\u001d\u0015\u0005\u0003\u0017\u000b\t\nE\u0002s\u0003'K1!!&t\u0005)\te\r^3s\u00072\f7o\u001d\u0005\t\u00033\u000bi\u0004\"\u0001\u0002\u001c\u0006Ib/\u001a:jMftu.\u00168fqB,7\r^3e)\"\u0014X-\u00193t)\r\u0011\u0015Q\u0014\u0005\b\u0003?\u000b9\n1\u0001g\u0003\u001d\u0019wN\u001c;fqRD!\"a)\u0002>\u0005\u0005I\u0011BAS\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u001d\u0006\u0003BA-\u0003SKA!a+\u0002\\\t1qJ\u00196fGR\u0004")
public abstract class ZooKeeperTestHarness
extends JUnitSuite
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private KafkaZkClient zkClient;
    private AdminZkClient adminZkClient;
    private EmbeddedZookeeper zookeeper;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void verifyNoUnexpectedThreads(String string) {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads(string);
    }

    @AfterClass
    public static void tearDownClass() {
        ZooKeeperTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeClass
    public static void setUpClass() {
        ZooKeeperTestHarness$.MODULE$.setUpClass();
    }

    public static Set<String> unexpectedThreadNames() {
        return ZooKeeperTestHarness$.MODULE$.unexpectedThreadNames();
    }

    public static String ZkClientEventThreadSuffix() {
        return ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    private Logger logger$lzycompute() {
        ZooKeeperTestHarness zooKeeperTestHarness = this;
        synchronized (zooKeeperTestHarness) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    public void adminZkClient_$eq(AdminZkClient x$1) {
        this.adminZkClient = x$1;
    }

    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    public int zkPort() {
        return this.zookeeper().port();
    }

    public String zkConnect() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"127.0.0.1:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    @Before
    public void setUp() {
        this.zookeeper_$eq(new EmbeddedZookeeper());
        this.zkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return JaasUtils.isZkSecurityEnabled();
            }
        })), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
        this.adminZkClient_$eq(new AdminZkClient(this.zkClient()));
    }

    @After
    public void tearDown() {
        if (this.zkClient() != null) {
            this.zkClient().close();
        }
        if (this.zookeeper() != null) {
            CoreUtils$.MODULE$.swallow((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZooKeeperTestHarness $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.zookeeper().shutdown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(this){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assert.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public ZooKeeperTestHarness() {
        Logging.class.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.zkClient = null;
        this.adminZkClient = null;
        this.zookeeper = null;
    }
}

