/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public final class LogValidator$
implements Logging {
    public static final LogValidator$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogValidator$();
    }

    private Logger logger$lzycompute() {
        LogValidator$ logValidator$ = this;
        synchronized (logValidator$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsets(MemoryRecords records, kafka.common.LongRef offsetCounter, Time time, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte magic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, boolean isFromClient, ApiVersion interBrokerProtocolVersion) {
        LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        CompressionCodec compressionCodec = sourceCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            CompressionCodec compressionCodec2 = targetCodec;
            NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) {
                if (records.hasMatchingMagic(magic)) {
                    validationAndOffsetAssignResult = this.assignOffsetsNonCompressed(records, offsetCounter, now, compactedTopic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, isFromClient, magic);
                    return validationAndOffsetAssignResult;
                }
                validationAndOffsetAssignResult = this.convertAndAssignOffsetsNonCompressed(records, offsetCounter, compactedTopic, time, now, timestampType, timestampDiffMaxMs, magic, partitionLeaderEpoch, isFromClient);
                return validationAndOffsetAssignResult;
            }
        }
        validationAndOffsetAssignResult = this.validateMessagesAndAssignOffsetsCompressed(records, offsetCounter, time, now, sourceCodec, targetCodec, compactedTopic, magic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, isFromClient, interBrokerProtocolVersion);
        return validationAndOffsetAssignResult;
    }

    public void kafka$log$LogValidator$$validateBatch(RecordBatch batch, boolean isFromClient, byte toMagic) {
        if (isFromClient) {
            if (batch.magic() >= 2) {
                long countFromOffsets = batch.lastOffset() - batch.baseOffset() + 1L;
                if (countFromOffsets <= 0L) {
                    throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch has an invalid offset range: [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)batch.baseOffset()), BoxesRunTime.boxToLong((long)batch.lastOffset())})));
                }
                Integer count = batch.countOrNull();
                if (Predef$.MODULE$.Integer2int(count) <= 0) {
                    throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid reported count for record batch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{count})));
                }
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)countFromOffsets), (Object)batch.countOrNull())) {
                    throw new InvalidRecordException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent batch offset range [", ", ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)batch.baseOffset()), BoxesRunTime.boxToLong((long)batch.lastOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and count of records ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{count}))).toString());
                }
            }
            if (batch.hasProducerId() && batch.baseSequence() < 0) {
                throw new InvalidRecordException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number ", " in record batch "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch.baseSequence())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with producerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)batch.producerId())}))).toString());
            }
            if (batch.isControlBatch()) {
                throw new InvalidRecordException("Clients are not allowed to write control records");
            }
        }
        if (batch.isTransactional() && toMagic < 2) {
            throw new UnsupportedForMessageFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transactional records cannot be used with magic version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)toMagic)})));
        }
        if (batch.hasProducerId() && toMagic < 2) {
            throw new UnsupportedForMessageFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Idempotent records cannot be used with magic version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)toMagic)})));
        }
    }

    public void kafka$log$LogValidator$$validateRecord(RecordBatch batch, Record record2, long now, TimestampType timestampType, long timestampDiffMaxMs, boolean compactedTopic) {
        if (record2.hasMagic(batch.magic())) {
            if (batch.magic() <= 1 && batch.isCompressed()) {
                record2.ensureValid();
            }
            this.validateKey(record2, compactedTopic);
            this.validateTimestamp(batch, record2, now, timestampType, timestampDiffMaxMs);
            return;
        }
        throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log record magic does not match outer magic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)batch.magic())})));
    }

    private LogValidator.ValidationAndOffsetAssignResult convertAndAssignOffsetsNonCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, boolean compactedTopic, Time time, long now, TimestampType timestampType, long timestampDiffMaxMs, byte toMagicValue, int partitionLeaderEpoch, boolean isFromClient) {
        long startNanos = time.nanoseconds();
        int sizeInBytesAfterConversion = AbstractRecords.estimateSizeInBytes((byte)toMagicValue, (long)offsetCounter.value(), (CompressionType)CompressionType.NONE, (Iterable)records.records());
        MutableRecordBatch first = (MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToLong((long)first.producerId()), (Object)BoxesRunTime.boxToShort((short)first.producerEpoch()), (Object)BoxesRunTime.boxToInteger((int)first.baseSequence()), (Object)BoxesRunTime.boxToBoolean((boolean)first.isTransactional()));
        if (tuple4 != null) {
            Tuple4 tuple42;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple4._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple4._2());
            int sequence = BoxesRunTime.unboxToInt((Object)tuple4._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)sequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple43._2());
            int sequence2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
            ByteBuffer newBuffer = ByteBuffer.allocate(sizeInBytesAfterConversion);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)newBuffer, (byte)toMagicValue, (CompressionType)CompressionType.NONE, (TimestampType)timestampType, (long)offsetCounter.value(), (long)now, (long)producerId2, (short)producerEpoch2, (int)sequence2, (boolean)isTransactional2, (int)partitionLeaderEpoch);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(offsetCounter, compactedTopic, now, timestampType, timestampDiffMaxMs, toMagicValue, isFromClient, builder){
                public static final long serialVersionUID = 0L;
                public final kafka.common.LongRef offsetCounter$1;
                public final boolean compactedTopic$1;
                public final long now$1;
                public final TimestampType timestampType$1;
                public final long timestampDiffMaxMs$1;
                private final byte toMagicValue$1;
                private final boolean isFromClient$1;
                public final MemoryRecordsBuilder builder$1;

                public final void apply(MutableRecordBatch batch) {
                    LogValidator$.MODULE$.kafka$log$LogValidator$$validateBatch((RecordBatch)batch, this.isFromClient$1, this.toMagicValue$1);
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.convertAndAssignOffsetsNonCompressed.1 $outer;
                        private final MutableRecordBatch batch$1;

                        public final void apply(Record record2) {
                            LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecord((RecordBatch)this.batch$1, record2, this.$outer.now$1, this.$outer.timestampType$1, this.$outer.timestampDiffMaxMs$1, this.$outer.compactedTopic$1);
                            this.$outer.builder$1.appendWithOffset(this.$outer.offsetCounter$1.getAndIncrement(), record2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.batch$1 = batch$1;
                        }
                    });
                }
                {
                    this.offsetCounter$1 = offsetCounter$1;
                    this.compactedTopic$1 = compactedTopic$1;
                    this.now$1 = now$1;
                    this.timestampType$1 = timestampType$1;
                    this.timestampDiffMaxMs$1 = timestampDiffMaxMs$1;
                    this.toMagicValue$1 = toMagicValue$1;
                    this.isFromClient$1 = isFromClient$1;
                    this.builder$1 = builder$1;
                }
            });
            MemoryRecords convertedRecords = builder.build();
            MemoryRecordsBuilder.RecordsInfo info = builder.info();
            RecordConversionStats recordConversionStats = new RecordConversionStats((long)builder.uncompressedBytesWritten(), builder.numRecords(), time.nanoseconds() - startNanos);
            return new LogValidator.ValidationAndOffsetAssignResult(convertedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true, recordConversionStats);
        }
        throw new MatchError((Object)tuple4);
    }

    private LogValidator.ValidationAndOffsetAssignResult assignOffsetsNonCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, boolean compactedTopic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, boolean isFromClient, byte magic) {
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        long initialOffset = offsetCounter.value();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(offsetCounter, now, compactedTopic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, isFromClient, magic, maxTimestamp, offsetOfMaxTimestamp){
            public static final long serialVersionUID = 0L;
            public final kafka.common.LongRef offsetCounter$2;
            public final long now$2;
            public final boolean compactedTopic$2;
            public final TimestampType timestampType$2;
            public final long timestampDiffMaxMs$2;
            private final int partitionLeaderEpoch$1;
            private final boolean isFromClient$2;
            private final byte magic$1;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;

            public final void apply(MutableRecordBatch batch) {
                LogValidator$.MODULE$.kafka$log$LogValidator$$validateBatch((RecordBatch)batch, this.isFromClient$2, this.magic$1);
                LongRef maxBatchTimestamp = LongRef.create((long)-1L);
                LongRef offsetOfMaxBatchTimestamp = LongRef.create((long)-1L);
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, maxBatchTimestamp, offsetOfMaxBatchTimestamp, batch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignOffsetsNonCompressed.1 $outer;
                    private final LongRef maxBatchTimestamp$1;
                    private final LongRef offsetOfMaxBatchTimestamp$1;
                    private final MutableRecordBatch batch$2;

                    public final void apply(Record record2) {
                        LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecord((RecordBatch)this.batch$2, record2, this.$outer.now$2, this.$outer.timestampType$2, this.$outer.timestampDiffMaxMs$2, this.$outer.compactedTopic$2);
                        long offset2 = this.$outer.offsetCounter$2.getAndIncrement();
                        if (this.batch$2.magic() > 0 && record2.timestamp() > this.maxBatchTimestamp$1.elem) {
                            this.maxBatchTimestamp$1.elem = record2.timestamp();
                            this.offsetOfMaxBatchTimestamp$1.elem = offset2;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.maxBatchTimestamp$1 = maxBatchTimestamp$1;
                        this.offsetOfMaxBatchTimestamp$1 = offsetOfMaxBatchTimestamp$1;
                        this.batch$2 = batch$2;
                    }
                });
                if (batch.magic() > 0 && maxBatchTimestamp.elem > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = maxBatchTimestamp.elem;
                    this.offsetOfMaxTimestamp$1.elem = offsetOfMaxBatchTimestamp.elem;
                }
                batch.setLastOffset(this.offsetCounter$2.value() - 1L);
                if (batch.magic() >= 2) {
                    batch.setPartitionLeaderEpoch(this.partitionLeaderEpoch$1);
                }
                if (batch.magic() > 0) {
                    TimestampType timestampType = this.timestampType$2;
                    TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                    if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, this.now$2);
                    } else {
                        batch.setMaxTimestamp(this.timestampType$2, maxBatchTimestamp.elem);
                    }
                }
            }
            {
                this.offsetCounter$2 = offsetCounter$2;
                this.now$2 = now$2;
                this.compactedTopic$2 = compactedTopic$2;
                this.timestampType$2 = timestampType$2;
                this.timestampDiffMaxMs$2 = timestampDiffMaxMs$2;
                this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                this.isFromClient$2 = isFromClient$2;
                this.magic$1 = magic$1;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
            }
        });
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            maxTimestamp.elem = now;
            offsetOfMaxTimestamp.elem = magic >= 2 ? offsetCounter.value() - 1L : initialOffset;
        }
        return new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, offsetOfMaxTimestamp.elem, false, RecordConversionStats.EMPTY);
    }

    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsetsCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, Time time, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte toMagic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, boolean isFromClient, ApiVersion interBrokerProtocolVersion) {
        Tuple4 tuple4;
        block8: {
            LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
            block7: {
                Tuple4 tuple42;
                IntRef uncompressedSizeInBytes;
                ArrayBuffer validatedRecords;
                block6: {
                    CompressionCodec compressionCodec = sourceCodec;
                    CompressionCodec compressionCodec2 = targetCodec;
                    BooleanRef inPlaceAssignment = BooleanRef.create((!(compressionCodec != null ? !compressionCodec.equals(compressionCodec2) : compressionCodec2 != null) && toMagic > 0 ? 1 : 0) != 0);
                    LongRef maxTimestamp = LongRef.create((long)-1L);
                    kafka.common.LongRef expectedInnerOffset = new kafka.common.LongRef(0L);
                    validatedRecords = new ArrayBuffer();
                    uncompressedSizeInBytes = IntRef.create((int)0);
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(now, sourceCodec, targetCodec, compactedTopic, toMagic, timestampType, timestampDiffMaxMs, isFromClient, interBrokerProtocolVersion, inPlaceAssignment, maxTimestamp, expectedInnerOffset, validatedRecords, uncompressedSizeInBytes){
                        public static final long serialVersionUID = 0L;
                        public final long now$3;
                        public final CompressionCodec sourceCodec$1;
                        public final CompressionCodec targetCodec$1;
                        public final boolean compactedTopic$3;
                        public final byte toMagic$1;
                        public final TimestampType timestampType$3;
                        public final long timestampDiffMaxMs$3;
                        private final boolean isFromClient$3;
                        public final ApiVersion interBrokerProtocolVersion$1;
                        public final BooleanRef inPlaceAssignment$1;
                        public final LongRef maxTimestamp$2;
                        public final kafka.common.LongRef expectedInnerOffset$1;
                        public final ArrayBuffer validatedRecords$1;
                        public final IntRef uncompressedSizeInBytes$1;

                        public final void apply(MutableRecordBatch batch) {
                            LogValidator$.MODULE$.kafka$log$LogValidator$$validateBatch((RecordBatch)batch, this.isFromClient$3, this.toMagic$1);
                            this.uncompressedSizeInBytes$1.elem += AbstractRecords.recordBatchHeaderSizeInBytes((byte)this.toMagic$1, (CompressionType)batch.compressionType());
                            CompressionCodec compressionCodec = this.sourceCodec$1;
                            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                            if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null) && batch.isControlBatch()) {
                                this.inPlaceAssignment$1.elem = true;
                            }
                            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.validateMessagesAndAssignOffsetsCompressed.1 $outer;
                                private final MutableRecordBatch batch$3;

                                public final ArrayBuffer<Record> apply(Record record2) {
                                    CompressionCodec compressionCodec = this.$outer.sourceCodec$1;
                                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                                    if ((compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) && record2.isCompressed()) {
                                        throw new InvalidRecordException(new StringBuilder().append((Object)"Compressed outer record should not have an inner record with a ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression attribute set: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2}))).toString());
                                    }
                                    CompressionCodec compressionCodec2 = this.$outer.targetCodec$1;
                                    ZStdCompressionCodec$ zStdCompressionCodec$ = ZStdCompressionCodec$.MODULE$;
                                    if (!(compressionCodec2 != null ? !compressionCodec2.equals(zStdCompressionCodec$) : zStdCompressionCodec$ != null) && this.$outer.interBrokerProtocolVersion$1.$less(KAFKA_2_1_IV0$.MODULE$)) {
                                        throw new UnsupportedCompressionTypeException("Produce requests to inter.broker.protocol.version < 2.1 broker are not allowed to use ZStandard compression");
                                    }
                                    LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecord((RecordBatch)this.batch$3, record2, this.$outer.now$3, this.$outer.timestampType$3, this.$outer.timestampDiffMaxMs$3, this.$outer.compactedTopic$3);
                                    this.$outer.uncompressedSizeInBytes$1.elem += record2.sizeInBytes();
                                    if (this.batch$3.magic() > 0 && this.$outer.toMagic$1 > 0) {
                                        if (record2.offset() != this.$outer.expectedInnerOffset$1.getAndIncrement()) {
                                            this.$outer.inPlaceAssignment$1.elem = false;
                                        }
                                        if (record2.timestamp() > this.$outer.maxTimestamp$2.elem) {
                                            this.$outer.maxTimestamp$2.elem = record2.timestamp();
                                        }
                                    }
                                    if (!record2.hasMagic(this.$outer.toMagic$1)) {
                                        this.$outer.inPlaceAssignment$1.elem = false;
                                    }
                                    return this.$outer.validatedRecords$1.$plus$eq((Object)record2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.batch$3 = batch$3;
                                }
                            });
                        }
                        {
                            this.now$3 = now$3;
                            this.sourceCodec$1 = sourceCodec$1;
                            this.targetCodec$1 = targetCodec$1;
                            this.compactedTopic$3 = compactedTopic$3;
                            this.toMagic$1 = toMagic$1;
                            this.timestampType$3 = timestampType$3;
                            this.timestampDiffMaxMs$3 = timestampDiffMaxMs$3;
                            this.isFromClient$3 = isFromClient$3;
                            this.interBrokerProtocolVersion$1 = interBrokerProtocolVersion$1;
                            this.inPlaceAssignment$1 = inPlaceAssignment$1;
                            this.maxTimestamp$2 = maxTimestamp$2;
                            this.expectedInnerOffset$1 = expectedInnerOffset$1;
                            this.validatedRecords$1 = validatedRecords$1;
                            this.uncompressedSizeInBytes$1 = uncompressedSizeInBytes$1;
                        }
                    });
                    if (!inPlaceAssignment.elem) break block6;
                    MutableRecordBatch batch = (MutableRecordBatch)records.batches().iterator().next();
                    long lastOffset = offsetCounter.addAndGet(validatedRecords.size()) - 1L;
                    batch.setLastOffset(lastOffset);
                    TimestampType timestampType2 = timestampType;
                    TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
                    if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                        maxTimestamp.elem = now;
                    }
                    if (toMagic >= 1) {
                        batch.setMaxTimestamp(timestampType, maxTimestamp.elem);
                    }
                    if (toMagic >= 2) {
                        batch.setPartitionLeaderEpoch(partitionLeaderEpoch);
                    }
                    RecordConversionStats recordConversionStats = new RecordConversionStats((long)uncompressedSizeInBytes.elem, 0, 0L);
                    validationAndOffsetAssignResult = new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, lastOffset, false, recordConversionStats);
                    break block7;
                }
                MutableRecordBatch first = (MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head();
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToLong((long)first.producerId()), (Object)BoxesRunTime.boxToShort((short)first.producerEpoch()), (Object)BoxesRunTime.boxToInteger((int)first.baseSequence()), (Object)BoxesRunTime.boxToBoolean((boolean)first.isTransactional()));
                if (tuple4 == null) break block8;
                long producerId = BoxesRunTime.unboxToLong((Object)tuple4._1());
                short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple4._2());
                int sequence = BoxesRunTime.unboxToInt((Object)tuple4._3());
                boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)sequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional));
                long producerId2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
                short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple43._2());
                int sequence2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
                boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
                validationAndOffsetAssignResult = this.buildRecordsAndAssignOffsets(toMagic, offsetCounter, time, timestampType, CompressionType.forId((int)targetCodec.codec()), now, (Seq<Record>)validatedRecords, producerId2, producerEpoch2, sequence2, isTransactional2, partitionLeaderEpoch, isFromClient, uncompressedSizeInBytes.elem);
            }
            return validationAndOffsetAssignResult;
        }
        throw new MatchError((Object)tuple4);
    }

    private LogValidator.ValidationAndOffsetAssignResult buildRecordsAndAssignOffsets(byte magic, kafka.common.LongRef offsetCounter, Time time, TimestampType timestampType, CompressionType compressionType, long logAppendTime, Seq<Record> validatedRecords, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, int partitionLeaderEpoch, boolean isFromClient, int uncompresssedSizeInBytes) {
        long startNanos = time.nanoseconds();
        int estimatedSize = AbstractRecords.estimateSizeInBytes((byte)magic, (long)offsetCounter.value(), (CompressionType)compressionType, (Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(validatedRecords).asJava()));
        ByteBuffer buffer = ByteBuffer.allocate(estimatedSize);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)magic, (CompressionType)compressionType, (TimestampType)timestampType, (long)offsetCounter.value(), (long)logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (int)partitionLeaderEpoch);
        validatedRecords.foreach((Function1)new Serializable(offsetCounter, builder){
            public static final long serialVersionUID = 0L;
            private final kafka.common.LongRef offsetCounter$3;
            private final MemoryRecordsBuilder builder$2;

            public final void apply(Record record2) {
                this.builder$2.appendWithOffset(this.offsetCounter$3.getAndIncrement(), record2);
            }
            {
                this.offsetCounter$3 = offsetCounter$3;
                this.builder$2 = builder$2;
            }
        });
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        int conversionCount = builder.numRecords();
        RecordConversionStats recordConversionStats = new RecordConversionStats((long)(uncompresssedSizeInBytes + builder.uncompressedBytesWritten()), conversionCount, time.nanoseconds() - startNanos);
        return new LogValidator.ValidationAndOffsetAssignResult(records, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true, recordConversionStats);
    }

    private void validateKey(Record record2, boolean compactedTopic) {
        if (compactedTopic && !record2.hasKey()) {
            throw new InvalidRecordException("Compacted topic cannot accept message without key.");
        }
    }

    private void validateTimestamp(RecordBatch batch, Record record2, long now, TimestampType timestampType, long timestampDiffMaxMs) {
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            if (record2.timestamp() != -1L && package$.MODULE$.abs(record2.timestamp() - now) > timestampDiffMaxMs) {
                throw new InvalidTimestampException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp ", " of message with offset ", " is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record2.timestamp()), BoxesRunTime.boxToLong((long)record2.offset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"out of range. The timestamp should be within [", ", ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now - timestampDiffMaxMs)), BoxesRunTime.boxToLong((long)(now + timestampDiffMaxMs))}))).toString());
            }
        }
        TimestampType timestampType4 = batch.timestampType();
        TimestampType timestampType5 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType4 != null ? !timestampType4.equals(timestampType5) : timestampType5 != null)) {
            throw new InvalidTimestampException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid timestamp type in message ", ". Producer should not set "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp type to LogAppendTime."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    private LogValidator$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

