/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import integration.kafka.api.ConsumerTopicCreationTest$;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001%\u0011\u0011dQ8ogVlWM\u001d+pa&\u001c7I]3bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015Y\u0017MZ6b\u0015\u00059\u0011aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\u00111!\u0004\u0006\u0002\u000b%\u0011q\u0002\u0004\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\"A\u0011\u0003\u0001B\u0001B\u0003%!#A\u000fce>\\WM]!vi>$v\u000e]5d\u0007J,\u0017\r^5p]\u0016s\u0017M\u00197f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003mC:<'\"A\f\u0002\t)\fg/Y\u0005\u00033Q\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0013\u0003u\u0019wN\\:v[\u0016\u0014\u0018\t\u001c7po\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e\u001c\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0002 C\t\u0002\"\u0001\t\u0001\u000e\u0003\tAQ!\u0005\u000fA\u0002IAQa\u0007\u000fA\u0002IAQ\u0001\n\u0001\u0005R\u0015\n1B\u0019:pW\u0016\u00148i\\;oiV\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003FA\u0002J]RDq!\f\u0001C\u0002\u0013\u0005a&A\u0004u_BL7mX\u0019\u0016\u0003=\u0002\"a\u0005\u0019\n\u0005E\"\"AB*ue&tw\r\u0003\u00044\u0001\u0001\u0006IaL\u0001\ti>\u0004\u0018nY02A!9Q\u0007\u0001b\u0001\n\u0003q\u0013a\u0002;pa&\u001cwL\r\u0005\u0007o\u0001\u0001\u000b\u0011B\u0018\u0002\u0011Q|\u0007/[2`e\u0001Bq!\u000f\u0001C\u0002\u0013\u0005a&\u0001\tqe>$WoY3s\u00072LWM\u001c;JI\"11\b\u0001Q\u0001\n=\n\u0011\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133!\u0011\u001di\u0004A1A\u0005\u00029\n\u0001cY8ogVlWM]\"mS\u0016tG/\u00133\t\r}\u0002\u0001\u0015!\u00030\u0003E\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\r\t\u0005\u0006\u0003\u0002!\tAQ\u0001\u0016i\u0016\u001cH/Q;u_R{\u0007/[2De\u0016\fG/[8o)\u0005\u0019\u0005CA\u0014E\u0013\t)\u0005F\u0001\u0003V]&$\bF\u0001!H!\tAU*D\u0001J\u0015\tQ5*A\u0003kk:LGOC\u0001M\u0003\ry'oZ\u0005\u0003\u001d&\u0013A\u0001V3ti\"\"\u0001\u0001\u0015,X!\t\tF+D\u0001S\u0015\t\u0019\u0016*\u0001\u0004sk:tWM]\u0005\u0003+J\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001Y!\tIF,D\u0001[\u0015\tY\u0016*A\u0004sk:tWM]:\n\u0005uS&!\u0004)be\u0006lW\r^3sSj,GmB\u0003`\u0005!\u0005\u0001-A\rD_:\u001cX/\\3s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8UKN$\bC\u0001\u0011b\r\u0015\t!\u0001#\u0001c'\t\t7\r\u0005\u0002(I&\u0011Q\r\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000bu\tG\u0011A4\u0015\u0003\u0001DQ![1\u0005\u0002)\f!\u0002]1sC6,G/\u001a:t+\u0005Y\u0007c\u00017pc6\tQN\u0003\u0002o-\u0005!Q\u000f^5m\u0013\t\u0001XN\u0001\u0006D_2dWm\u0019;j_:\u00042a\n:u\u0013\t\u0019\bFA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014k&\u0011a\u000f\u0006\u0002\u0007\u001f\nTWm\u0019;)\r!D\u0018\u0011CA\n!\rI\u00181\u0002\b\u0004u\u0006\u001dabA>\u0002\u00069\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\ty\b\"\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0011!jS\u0005\u00037&K1!!\u0003[\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011QBA\b\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0004\u0003\u0013Q\u0016\u0001\u00028b[\u0016\f#!!\u0006\u0002e\t\u0014xn[3s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8>wBjH\u0006I2p]N,X.\u001a:U_BL7m\u0011:fCRLwN\\\u001f|cu\u0004")
public class ConsumerTopicCreationTest
extends IntegrationTestHarness {
    private final Boolean brokerAutoTopicCreationEnable;
    private final Boolean consumerAllowAutoCreateTopics;
    private final String topic_1;
    private final String topic_2;
    private final String producerClientId;
    private final String consumerClientId;

    @Parameterized.Parameters(name="brokerTopicCreation={0}, consumerTopicCreation={1}")
    public static Collection<Object[]> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic_1() {
        return this.topic_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Test
    public void testAutoTopicCreation() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AdminClient adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, 1))).all().get();
        producer.send(record).get();
        consumer.subscribe(Arrays.asList((Object[])new String[]{this.topic_1(), this.topic_2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumer$1.poll(Duration.ofMillis(100L)).count() > 0;
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting to consume";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        boolean topicCreated = this.zkClient().getAllTopicsInCluster().contains((Object)this.topic_2());
        if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
            Assert.assertTrue((boolean)topicCreated);
        } else {
            Assert.assertFalse((boolean)topicCreated);
        }
    }

    public ConsumerTopicCreationTest(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
        this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), brokerAutoTopicCreationEnable.toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
    }
}

