/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.nio.ByteBuffer;
import java.util.List;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C!+\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00051\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aA%oi\"9Q\u0004\u0001b\u0001\n\u0003)\u0012a\u00039beRLG/[8o\u0013\u0012Daa\b\u0001!\u0002\u00131\u0012\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB\u0011\u0001\u0005\u0004%\tAI\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004TiJLgn\u001a\u0005\u0007Y\u0001\u0001\u000b\u0011B\u0012\u0002\u000fQ|\u0007/[22A!9a\u0006\u0001b\u0001\n\u0003y\u0013\u0001\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8u+\u0005\u0001\u0004\u0003B\u00197-aj\u0011A\r\u0006\u0003gQ\n\u0011\"[7nkR\f'\r\\3\u000b\u0005UB\u0012AC2pY2,7\r^5p]&\u0011qG\r\u0002\u0004\u001b\u0006\u0004\bcA\u001d;-5\tA'\u0003\u0002<i\t\u00191+Z9\t\ru\u0002\u0001\u0015!\u00031\u0003E!x\u000e]5dc\u0005\u001b8/[4o[\u0016tG\u000f\t\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001#\u0003\u0019!x\u000e]5de!1\u0011\t\u0001Q\u0001\n\r\nq\u0001^8qS\u000e\u0014\u0004\u0005C\u0004D\u0001\t\u0007I\u0011A\u0018\u0002!Q|\u0007/[23\u0003N\u001c\u0018n\u001a8nK:$\bBB#\u0001A\u0003%\u0001'A\tu_BL7MM!tg&<g.\\3oi\u0002Bqa\u0012\u0001C\u0002\u0013\u0005!%\u0001\u0004u_BL7m\r\u0005\u0007\u0013\u0002\u0001\u000b\u0011B\u0012\u0002\u000fQ|\u0007/[24A!91\n\u0001b\u0001\n\u0003y\u0013\u0001\u0005;pa&\u001c7'Q:tS\u001etW.\u001a8u\u0011\u0019i\u0005\u0001)A\u0005a\u0005\tBo\u001c9jGN\n5o]5h]6,g\u000e\u001e\u0011\t\u000f=\u0003!\u0019!C\u0001E\u00051Ao\u001c9jGRBa!\u0015\u0001!\u0002\u0013\u0019\u0013a\u0002;pa&\u001cG\u0007\t\u0005\b'\u0002\u0011\r\u0011\"\u00010\u0003A!x\u000e]5di\u0005\u001b8/[4o[\u0016tG\u000f\u0003\u0004V\u0001\u0001\u0006I\u0001M\u0001\u0012i>\u0004\u0018n\u0019\u001bBgNLwM\\7f]R\u0004\u0003bB,\u0001\u0005\u0004%\tAI\u0001\u0007i>\u0004\u0018nY\u001b\t\re\u0003\u0001\u0015!\u0003$\u0003\u001d!x\u000e]5dk\u0001Bqa\u0017\u0001C\u0002\u0013\u0005q&\u0001\tu_BL7-N!tg&<g.\\3oi\"1Q\f\u0001Q\u0001\nA\n\u0011\u0003^8qS\u000e,\u0014i]:jO:lWM\u001c;!\u0011\u0015y\u0006\u0001\"\u0011a\u0003\u0015\u0019X\r^+q)\u0005\t\u0007CA\fc\u0013\t\u0019\u0007D\u0001\u0003V]&$\bF\u00010f!\t17.D\u0001h\u0015\tA\u0017.A\u0003kk:LGOC\u0001k\u0003\ry'oZ\u0005\u0003Y\u001e\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u0003\u0001\u0017!\u0006;fgR<&o\u001c8h%\u0016\u0004H.[2b\u0007>,h\u000e\u001e\u0015\u0003[B\u0004\"AZ9\n\u0005I<'\u0001\u0002+fgRDQ\u0001\u001e\u0001\u0005\u0002\u0001\fQ\u0003^3ti6K7o]5oOB\u000b'\u000f^5uS>t\u0007\u0007\u000b\u0002ta\")q\u000f\u0001C\u0001A\u00069B/Z:u\u0013:\u001c'/Z7f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003mBDQA\u001f\u0001\u0005\u0002\u0001\fa\u0004^3ti6\u000bg.^1m\u0003N\u001c\u0018n\u001a8nK:$xJ\u001a*fa2L7-Y:)\u0005e\u0004\b\"B?\u0001\t\u0003\u0001\u0017A\b;fgR\u0014V\r\u001d7jG\u0006\u0004F.Y2f[\u0016tG/\u00117m'\u0016\u0014h/\u001a:tQ\ta\b\u000f\u0003\u0004\u0002\u0002\u0001!\t\u0001Y\u0001#i\u0016\u001cHOU3qY&\u001c\u0017\r\u00157bG\u0016lWM\u001c;QCJ$\u0018.\u00197TKJ4XM]:)\u0005}\u0004\bbBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u001am\u0006d\u0017\u000eZ1uK2+\u0017\rZ3s\u0003:$'+\u001a9mS\u000e\f7\u000fF\u0005b\u0003\u0017\t)%a\u0012\u0002L!A\u0011QBA\u0003\u0001\u0004\ty!\u0001\u0005nKR\fG-\u0019;b!\u0011\t\t\"a\u0010\u000f\t\u0005M\u0011\u0011\b\b\u0005\u0003+\t\u0019D\u0004\u0003\u0002\u0018\u00055b\u0002BA\r\u0003SqA!a\u0007\u0002&9!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\u0019\ta\u0001\u0010:p_Rt\u0014\"\u00016\n\u0007\u0005\u001d\u0012.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0004\u000b\u0005-\"bAA\u0014S&!\u0011qFA\u0019\u0003\u0019\u0019w.\\7p]*\u0019Q!a\u000b\n\t\u0005U\u0012qG\u0001\te\u0016\fX/Z:ug*!\u0011qFA\u0019\u0013\u0011\tY$!\u0010\u0002!5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,'\u0002BA\u001b\u0003oIA!!\u0011\u0002D\tiAk\u001c9jG6+G/\u00193bi\u0006TA!a\u000f\u0002>!1Q$!\u0002A\u0002YAq!!\u0013\u0002\u0006\u0001\u0007a#\u0001\tfqB,7\r^3e\u0019\u0016\fG-\u001a:JI\"A\u0011QJA\u0003\u0001\u0004\ty%\u0001\tfqB,7\r^3e%\u0016\u0004H.[2bgB)\u0011\u0011KA,-9\u0019q#a\u0015\n\u0007\u0005U\u0003$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\nYFA\u0002TKRT1!!\u0016\u0019\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\n1c]3oI6+G/\u00193bi\u0006\u0014V-];fgR$b!a\u0019\u0002l\u0005U\u0004\u0003BA3\u0003Oj!!!\u0010\n\t\u0005%\u0014Q\b\u0002\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016D\u0001\"!\u001c\u0002^\u0001\u0007\u0011qN\u0001\be\u0016\fX/Z:u!\u0011\t)'!\u001d\n\t\u0005M\u0014Q\b\u0002\u0010\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\"Q\u0011qOA/!\u0003\u0005\r!!\u001f\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\t\u0006/\u0005m\u0014qP\u0005\u0004\u0003{B\"AB(qi&|g\u000e\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t)\tB\u0001\b]\u0016$xo\u001c:l\u0013\u0011\tI)a!\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\t\u0013\u00055\u0005!%A\u0005\n\u0005=\u0015!H:f]\u0012lU\r^1eCR\f'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E%\u0006BA=\u0003'[#!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?C\u0012AC1o]>$\u0018\r^5p]&!\u00111UAM\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment());
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment());
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment());
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment());
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$7 = this.topic1();
            scala.collection.immutable.Map<Object, Seq<Object>> x$8 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$5 = qual$2.getBrokerMetadatas$default$1();
            Option x$6 = qual$2.getBrokerMetadatas$default$2();
            Seq x$9 = qual$2.getBrokerMetadatas(x$5, x$6);
            int x$10 = 2;
            Some x$11 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$12 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$7, x$8, x$9, x$10, (Option)x$11, x$12);
            Assert.fail((String)"Add partitions should fail");
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {}
    }

    @Test
    public void testMissingPartition0() {
        try {
            AdminZkClient qual$3 = this.adminZkClient();
            String x$15 = this.topic5();
            scala.collection.immutable.Map<Object, Seq<Object>> x$16 = this.topic5Assignment();
            AdminZkClient qual$4 = this.adminZkClient();
            RackAwareMode x$13 = qual$4.getBrokerMetadatas$default$1();
            Option x$14 = qual$4.getBrokerMetadatas$default$2();
            Seq x$17 = qual$4.getBrokerMetadatas(x$13, x$14);
            int x$18 = 2;
            Some x$19 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$20 = qual$3.addPartitions$default$6();
            qual$3.addPartitions(x$15, x$16, x$17, x$18, (Option)x$19, x$20);
            Assert.fail((String)"Add partitions should fail");
        }
        catch (AdminOperationException adminOperationException) {
            Assert.assertTrue((boolean)adminOperationException.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$5 = this.adminZkClient();
        String x$23 = this.topic1();
        scala.collection.immutable.Map<Object, Seq<Object>> x$24 = this.topic1Assignment();
        AdminZkClient qual$6 = this.adminZkClient();
        RackAwareMode x$21 = qual$6.getBrokerMetadatas$default$1();
        Option x$22 = qual$6.getBrokerMetadatas$default$2();
        Seq x$25 = qual$6.getBrokerMetadatas(x$21, x$22);
        int x$26 = 3;
        Option x$27 = qual$5.addPartitions$default$5();
        boolean x$28 = qual$5.addPartitions$default$6();
        qual$5.addPartitions(x$23, x$24, x$25, x$26, x$27, x$28);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MetadataResponse.PartitionMetadata x$1) {
                return x$1.partition();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitions.size(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitions.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Assert.assertTrue((boolean)replicas.contains(((MetadataResponse.PartitionMetadata)partitions.apply(1)).leader()));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$7 = this.adminZkClient();
        String x$31 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$32 = this.topic2Assignment();
        AdminZkClient qual$8 = this.adminZkClient();
        RackAwareMode x$29 = qual$8.getBrokerMetadatas$default$1();
        Option x$30 = qual$8.getBrokerMetadatas$default$2();
        Seq x$33 = qual$8.getBrokerMetadatas(x$29, x$30);
        int x$34 = 3;
        Some x$35 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$36 = qual$7.addPartitions$default$6();
        qual$7.addPartitions(x$31, x$32, x$33, x$34, (Option)x$35, x$36);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MetadataResponse.PartitionMetadata x$2) {
                return x$2.partition();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 0 || ((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 0 || ((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$9 = this.adminZkClient();
        String x$39 = this.topic3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$40 = this.topic3Assignment();
        AdminZkClient qual$10 = this.adminZkClient();
        RackAwareMode x$37 = qual$10.getBrokerMetadatas$default$1();
        Option x$38 = qual$10.getBrokerMetadatas$default$2();
        Seq x$41 = qual$10.getBrokerMetadatas(x$37, x$38);
        int x$42 = 7;
        Option x$43 = qual$9.addPartitions$default$5();
        boolean x$44 = qual$9.addPartitions$default$6();
        qual$9.addPartitions(x$39, x$40, x$41, x$42, x$43, x$44);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$11 = this.adminZkClient();
        String x$47 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$48 = this.topic2Assignment();
        AdminZkClient qual$12 = this.adminZkClient();
        RackAwareMode x$45 = qual$12.getBrokerMetadatas$default$1();
        Option x$46 = qual$12.getBrokerMetadatas$default$2();
        Seq x$49 = qual$12.getBrokerMetadatas(x$45, x$46);
        int x$50 = 3;
        Option x$51 = qual$11.addPartitions$default$5();
        boolean x$52 = qual$11.addPartitions$default$6();
        qual$11.addPartitions(x$47, x$48, x$49, x$50, x$51, x$52);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1)new Serializable(this, partitionId){
            public static final long serialVersionUID = 0L;
            private final int partitionId$1;

            public final boolean apply(MetadataResponse.PartitionMetadata x$3) {
                return x$3.partition() == this.partitionId$1;
            }
            {
                this.partitionId$1 = partitionId$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertNotNull((String)"Partition leader should exist", (Object)partition.leader());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)partition.leaderId());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final SocketServer apply() {
                return this.$outer.anySocketServer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

