/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u000f\t\u0019\u0003K]3gKJ\u0014X\r\u001a*fa2L7-Y#mK\u000e$\u0018n\u001c8D_6l\u0017M\u001c3UKN$(BA\u0002\u0005\u0003\u0015\tG-\\5o\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\tQ8.\u0003\u0002\u000e\u0015\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001A\u0002\u0013\u00051$A\u0004tKJ4XM]:\u0016\u0003q\u00012!H\u0014+\u001d\tqBE\u0004\u0002 E5\t\u0001E\u0003\u0002\"\r\u00051AH]8pizJ\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\u0019\nq\u0001]1dW\u0006<WMC\u0001$\u0013\tA\u0013FA\u0002TKFT!!\n\u0014\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0011AB:feZ,'/\u0003\u00020Y\tY1*\u00194lCN+'O^3s\u0011\u001d\t\u0004\u00011A\u0005\u0002I\n1b]3sm\u0016\u00148o\u0018\u0013fcR\u00111g\u000e\t\u0003iUj\u0011AJ\u0005\u0003m\u0019\u0012A!\u00168ji\"9\u0001\bMA\u0001\u0002\u0004a\u0012a\u0001=%c!1!\b\u0001Q!\nq\t\u0001b]3sm\u0016\u00148\u000f\t\u0005\u0006y\u0001!\t%P\u0001\ti\u0016\f'\u000fR8x]R\t1\u0007\u000b\u0002<\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019\u000b%!B!gi\u0016\u0014\b\"\u0002%\u0001\t\u0003i\u0014\u0001\b;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017MS:p]\u0012\u000bG/\u0019\u0015\u0003\u000f*\u0003\"\u0001Q&\n\u00051\u000b%\u0001\u0002+fgRDQA\u0014\u0001\u0005\u0002u\n\u0011\u0005^3ti\n\u000b7/[2Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:D#!\u0014&")
public class PreferredReplicaElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testPreferredReplicaJsonData() {
        Set partitionsForPreferredReplicaElection = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test", 1), new TopicPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), partitionsForPreferredReplicaElection);
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = this.zkClient().getPreferredReplicaElection();
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        int preferredReplica = 0;
        Map brokerRack = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        int x$1 = 3;
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        Map x$4 = brokerRack;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$4, x$13, x$14).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.adminZkClient().createTopicWithAssignment(topic, new Properties(), expectedReplicaAssignment);
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig s) {
                return TestUtils$.MODULE$.createServer(s, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        KafkaZkClient x$15 = this.zkClient();
        String x$16 = topic;
        int x$17 = partition;
        None$ x$18 = None$.MODULE$;
        long x$19 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, x$19, (Option<Object>)x$18, x$20);
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        KafkaZkClient x$21 = this.zkClient();
        String x$22 = topic;
        int x$23 = partition;
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$26 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, x$25, (Option<Object>)x$24, x$26);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }
}

