/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.OptionSpec;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.utils.Exit$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t\t#+Z1tg&<g\u000eU1si&$\u0018n\u001c8t\u0007>lW.\u00198e\u0003J<7\u000fV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t!F\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\u00121C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0019\u0011UMZ8sK\")1\u0005\u0001C\u0001+\u0005AA/Z1s\t><h\u000e\u000b\u0002#KA\u00111DJ\u0005\u0003Oq\u0011Q!\u00114uKJDQ!\u000b\u0001\u0005\u0002U\tqf\u001d5pk2$7i\u001c:sK\u000e$H.\u001f)beN,g+\u00197jI6Kg.[7v[\u001e+g.\u001a:bi\u0016|\u0005\u000f^5p]ND#\u0001K\u0016\u0011\u0005ma\u0013BA\u0017\u001d\u0005\u0011!Vm\u001d;\t\u000b=\u0002A\u0011A\u000b\u0002]MDw.\u001e7e\u0007>\u0014(/Z2uYf\u0004\u0016M]:f-\u0006d\u0017\u000eZ'j]&lW/\\#yK\u000e,H/Z(qi&|gn\u001d\u0015\u0003]-BQA\r\u0001\u0005\u0002U\tQf\u001d5pk2$7i\u001c:sK\u000e$H.\u001f)beN,g+\u00197jI6Kg.[7v[Z+'/\u001b4z\u001fB$\u0018n\u001c8tQ\t\t4\u0006C\u00036\u0001\u0011\u0005Q#\u0001\u0012tQ>,H\u000eZ!mY><H\u000b\u001b:piRdWm\u00149uS>twJ\\#yK\u000e,H/\u001a\u0015\u0003i-BQ\u0001\u000f\u0001\u0005\u0002U\t!d\u001d5pk2$Wk]3EK\u001a\fW\u000f\u001c;t\u0013\u001a,e.\u00192mK\u0012D#aN\u0016\t\u000bm\u0002A\u0011A\u000b\u0002%MDw.\u001e7e\r\u0006LG.\u00134O_\u0006\u0013xm\u001d\u0015\u0003u-BQA\u0010\u0001\u0005\u0002U\tAc\u001d5pk2$g)Y5m\u0013\u001a\u0014E.\u00198l\u0003J<\u0007FA\u001f,\u0011\u0015\t\u0005\u0001\"\u0001\u0016\u0003\u0015\u001a\bn\\;mI:{G/\u00117m_^,\u00050Z2vi\u0016<\u0016\u000e\u001e5U_BL7m](qi&|g\u000e\u000b\u0002AW!)A\t\u0001C\u0001+\u0005\u00013\u000f[8vY\u0012tu\u000e^!mY><X\t_3dkR,w+\u001b;i\u0005J|7.\u001a:tQ\t\u00195\u0006C\u0003H\u0001\u0011\u0005Q#\u0001\u0018tQ>,H\u000e\u001a(pi\u0006cGn\\<Fq\u0016\u001cW\u000f^3XSRDw.\u001e;SK\u0006\u001c8/[4o[\u0016tGo\u00149uS>t\u0007F\u0001$,\u0011\u0015Q\u0005\u0001\"\u0001\u0016\u0003Q\u001a\bn\\;mI:{G/\u00117m_^<UM\\3sCR,w+\u001b;i_V$(I]8lKJ\u001c\u0018I\u001c3U_BL7m](qi&|gn\u001d\u0015\u0003\u0013.BQ!\u0014\u0001\u0005\u0002U\t!f\u001d5pk2$gj\u001c;BY2|woR3oKJ\fG/Z,ji\"|W\u000f\u001e\"s_.,'o](qi&|g\u000e\u000b\u0002MW!)\u0001\u000b\u0001C\u0001+\u0005I3\u000f[8vY\u0012tu\u000e^!mY><x)\u001a8fe\u0006$XmV5uQ>,H\u000fV8qS\u000e\u001cx\n\u001d;j_:D#aT\u0016\t\u000bM\u0003A\u0011A\u000b\u0002QMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u001e+g.\u001a:bi\u0016<\u0016\u000e\u001e5UQJ|G\u000f\u001e7f\u001fB$\u0018n\u001c8)\u0005I[\u0003\"\u0002,\u0001\t\u0003)\u0012\u0001L:i_VdGMT8u\u00032dwn^$f]\u0016\u0014\u0018\r^3XSRD'+Z1tg&<g.\\3oi>\u0003H/[8oQ\t)6\u0006C\u0003Z\u0001\u0011\u0005Q#A\u0017tQ>,H\u000e\u001a(pi\u0006cGn\\<WKJLg-_,ji\"|W\u000f\u001e*fCN\u001c\u0018n\u001a8nK:$x\n\u001d;j_:D#\u0001W\u0016\t\u000bq\u0003A\u0011A\u000b\u0002SMDw.\u001e7e\u001d>$\u0018\t\u001c7po\n\u0013xn[3sg2K7\u000f^,ji\"4VM]5gs>\u0003H/[8oQ\tY6\u0006C\u0003`\u0001\u0011\u0005Q#\u0001\u0014tQ>,H\u000e\u001a(pi\u0006cGn\\<UQJ|G\u000f\u001e7f/&$\bNV3sS\u001aLx\n\u001d;j_:D#AX\u0016\t\u000b\t\u0004A\u0011A\u000b\u0002IMDw.\u001e7e\u001d>$\u0018\t\u001c7poR{\u0007/[2t\u001fB$\u0018n\u001c8XSRDg+\u001a:jMfD#!Y\u0016\t\u000b\u0015\u0004A\u0011\u00014\u0002\u001dMDw.\u001e7e\r\u0006LGnV5uQR\u0019ac\u001a9\t\u000b!$\u0007\u0019A5\u0002\u00075\u001cx\r\u0005\u0002k[:\u0011\u0011b[\u0005\u0003Y*\ta\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011AN\u0003\u0005\u0006c\u0012\u0004\rA]\u0001\u0005CJ<7\u000fE\u0002\ng&L!\u0001\u001e\u0006\u0003\u000b\u0005\u0013(/Y=")
public class ReassignPartitionsCommandArgsTest {
    @Before
    public void setUp() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$1, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldUseDefaultsIfEnabled() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"});
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
        Assert.assertEquals((long)10000L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.timeoutOpt())));
        Assert.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.interBrokerThrottleOpt())));
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.shouldFailWith(ReassignPartitionsCommand$.MODULE$.helpText(), args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = (String[])((Object[])new String[]{" "});
        this.shouldFailWith("Command must include exactly one action: --generate, --execute or --verify", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokers() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"});
        this.shouldFailWith("Option \"[execute]\" can't be used with option \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--execute"});
        this.shouldFailWith("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--broker-list", "101,102", "--generate"});
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option \"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[generate]\" can't be used with option \"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify"});
        this.shouldFailWith("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = (String[])((Object[])new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"});
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[topics-to-move-json-file]\"", args);
    }

    public void shouldFailWith(String msg, String[] args) {
        try {
            ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have failed with [", "] but no failure occurred."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})));
        }
        catch (Exception exception) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected exception with message:\\n[", "]\\nbut was\\n[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, exception.getMessage()})), (boolean)exception.getMessage().startsWith(msg));
        }
    }
}

