/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.ConfigType$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003V8qS\u000e\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!IQ\u0004\u0001a\u0001\u0002\u0004%IAH\u0001\ri>\u0004\u0018nY*feZL7-Z\u000b\u0002?A\u0011\u0001E\u000b\b\u0003C!r!AI\u0014\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019A!\u0003\u0002*\u0005\u0005aAk\u001c9jG\u000e{W.\\1oI&\u00111\u0006\f\u0002\u00165>|7.Z3qKJ$v\u000e]5d'\u0016\u0014h/[2f\u0015\tI#\u0001C\u0005/\u0001\u0001\u0007\t\u0019!C\u0005_\u0005\u0001Bo\u001c9jGN+'O^5dK~#S-\u001d\u000b\u0003aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\"9q'LA\u0001\u0002\u0004y\u0012a\u0001=%c!1\u0011\b\u0001Q!\n}\tQ\u0002^8qS\u000e\u001cVM\u001d<jG\u0016\u0004\u0003\"C\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003=\u00035!Xm\u001d;U_BL7MT1nKV\tQ\b\u0005\u0002?\u0003:\u0011\u0011gP\u0005\u0003\u0001J\na\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001I\r\u0005\n\u000b\u0002\u0001\r\u00111A\u0005\n\u0019\u000b\u0011\u0003^3tiR{\u0007/[2OC6,w\fJ3r)\t\u0001t\tC\u00048\t\u0006\u0005\t\u0019A\u001f\t\r%\u0003\u0001\u0015)\u0003>\u00039!Xm\u001d;U_BL7MT1nK\u0002Bqa\u0013\u0001C\u0002\u0013%A*A\u0005`i\u0016\u001cHOT1nKV\tQ\n\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006)!/\u001e7fg*\u0011!kU\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002)\u0006\u0019qN]4\n\u0005Y{%\u0001\u0003+fgRt\u0015-\\3\t\ra\u0003\u0001\u0015!\u0003N\u0003)yF/Z:u\u001d\u0006lW\r\t\u0005\u00065\u0002!\t\u0001T\u0001\ti\u0016\u001cHOT1nK\"\u0012\u0011\f\u0018\t\u0003;zk\u0011!U\u0005\u0003?F\u0013AAU;mK\")\u0011\r\u0001C\u0001E\u0006)1/\u001a;vaR\t\u0001\u0007\u000b\u0002aIB\u0011Q,Z\u0005\u0003MF\u0013aAQ3g_J,\u0007\"\u00025\u0001\t\u0003\u0011\u0017\u0001\u0003;fCJ$wn\u001e8)\u0005\u001dT\u0007CA/l\u0013\ta\u0017KA\u0003BMR,'\u000fC\u0003o\u0001\u0011\u0005!-\u0001\u0006uKN$8I]3bi\u0016D#!\u001c9\u0011\u0005u\u000b\u0018B\u0001:R\u0005\u0011!Vm\u001d;\t\u000bQ\u0004A\u0011\u00012\u0002+Q,7\u000f^\"sK\u0006$XmV5uQ\u000e{gNZ5hg\"\u00121\u000f\u001d\u0005\u0006o\u0002!\tAY\u0001\u0016i\u0016\u001cHo\u0011:fCR,\u0017J\u001a(pi\u0016C\u0018n\u001d;tQ\t1\b\u000fC\u0003{\u0001\u0011\u0005!-A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]RD#!\u001f9\t\u000bu\u0004A\u0011\u00012\u0002MQ,7\u000f^\"sK\u0006$XmV5uQ&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u000b\u0002}a\"1\u0011\u0011\u0001\u0001\u0005\u0002\t\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\bNT3hCRLg/\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"\u0012q\u0010\u001d\u0005\u0007\u0003\u000f\u0001A\u0011\u00012\u0002IQ,7\u000f^\"sK\u0006$XmV5uQ:+w-\u0019;jm\u0016\u0004\u0016M\u001d;ji&|gnQ8v]RD3!!\u0002q\u0011\u0019\ti\u0001\u0001C\u0001E\u0006YB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019'fm\u0016d7i\u001c8gS\u001eD3!a\u0003q\u0011\u0019\t\u0019\u0002\u0001C\u0001E\u0006qA/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001c\bfAA\ta\"1\u0011\u0011\u0004\u0001\u0005\u0002\t\f1\u0004^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ^C\u0017\u000e^3mSN$\bfAA\fa\"1\u0011q\u0004\u0001\u0005\u0002\t\f\u0011\u0005^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ\u0016C8\r\\;eK&sG/\u001a:oC2D3!!\bq\u0011\u0019\t)\u0003\u0001C\u0001E\u00069B/Z:u\u00032$XM\u001d)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004\u0003G\u0001\bBBA\u0016\u0001\u0011\u0005!-A\nuKN$\u0018\t\u001c;fe\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0002*ADa!!\r\u0001\t\u0003\u0011\u0017A\t;fgR\fE\u000e^3s/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002\u00020ADa!a\u000e\u0001\t\u0003\u0011\u0017!\u0005;fgR\fE\u000e^3s\u0013\u001a,\u00050[:ug\"\u001a\u0011Q\u00079\t\r\u0005u\u0002\u0001\"\u0001c\u0003A!Xm\u001d;BYR,'oQ8oM&<7\u000fK\u0002\u0002<ADa!a\u0011\u0001\t\u0003\u0011\u0017a\f;fgR\u001cuN\u001c4jOB\u0013Xm]3sm\u0006$\u0018n\u001c8BGJ|7o\u001d)beRLG/[8o\u00032$XM]1uS>t\u0007fAA!a\"1\u0011\u0011\n\u0001\u0005\u0002\t\f\u0011\u0003^3tiR{\u0007/[2EK2,G/[8oQ\r\t9\u0005\u001d\u0005\u0007\u0003\u001f\u0002A\u0011\u00012\u0002%Q,7\u000f\u001e#fY\u0016$X-\u00134Fq&\u001cHo\u001d\u0015\u0004\u0003\u001b\u0002\bBBA+\u0001\u0011\u0005!-A\fuKN$H)\u001a7fi\u0016Le\u000e^3s]\u0006dGk\u001c9jG\"\u001a\u00111\u000b9\t\r\u0005m\u0003\u0001\"\u0001c\u0003q!Xm\u001d;EKN\u001c'/\u001b2f\u0013\u001a$v\u000e]5d\u001d>$X\t_5tiND3!!\u0017q\u0011\u0019\t\t\u0007\u0001C\u0001E\u0006\tC/Z:u\u0007J,\u0017\r^3BYR,'\u000fV8qS\u000e<\u0016\u000e\u001e5SC\u000e\\\u0017i^1sK\"\u001a\u0011q\f9\t\r\u0005\u001d\u0004\u0001\"\u0001c\u00031!Xm\u001d;EKN\u001c'/\u001b2fQ\r\t)\u0007\u001d\u0005\u0007\u0003[\u0002A\u0011\u00012\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKB|'\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\"\u001a\u00111\u000e9\t\r\u0005M\u0004\u0001\"\u0001c\u0003)\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:NCJ\\W\r\u001a$pe\u0012+G.\u001a;j_:D3!!\u001dq\u0011\u0019\tI\b\u0001C\u0001E\u0006qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2tQ\r\t9\b\u001d\u0005\u0007\u0003\u007f\u0002A\u0011\u00012\u0002[Q,7\u000f\u001e+pa&\u001cw\n]3sCRLwN\\:XSRD'+Z4fqNKXNY8m\u0013:$v\u000e]5d\u001d\u0006lW\rK\u0002\u0002~ADa!!\"\u0001\t\u0003\u0011\u0017\u0001\n;fgR\fE\u000e^3s\u0013:$XM\u001d8bYR{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u0007\u0005\r\u0005\u000f")
public class TopicCommandTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private TopicCommand.ZookeeperTopicService kafka$admin$TopicCommandTest$$topicService;
    private String kafka$admin$TopicCommandTest$$testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    public TopicCommand.ZookeeperTopicService kafka$admin$TopicCommandTest$$topicService() {
        return this.kafka$admin$TopicCommandTest$$topicService;
    }

    private void kafka$admin$TopicCommandTest$$topicService_$eq(TopicCommand.ZookeeperTopicService x$1) {
        this.kafka$admin$TopicCommandTest$$topicService = x$1;
    }

    public String kafka$admin$TopicCommandTest$$testTopicName() {
        return this.kafka$admin$TopicCommandTest$$testTopicName;
    }

    private void kafka$admin$TopicCommandTest$$testTopicName_$eq(String x$1) {
        this.kafka$admin$TopicCommandTest$$testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    @Before
    public void setup() {
        this.kafka$admin$TopicCommandTest$$topicService_$eq(new TopicCommand.ZookeeperTopicService(this.zkClient()));
        this.kafka$admin$TopicCommandTest$$testTopicName_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testName().getMethodName(), Random$.MODULE$.alphanumeric().take(10).mkString()})));
    }

    @After
    public void teardown() {
        if (this.kafka$admin$TopicCommandTest$$topicService() != null) {
            this.kafka$admin$TopicCommandTest$$topicService().close();
        }
    }

    @Test
    public void testCreate() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()})));
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().contains((Object)this.kafka$admin$TopicCommandTest$$testTopicName()));
    }

    @Test
    public void testCreateWithConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.kafka$admin$TopicCommandTest$$testTopicName());
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", "delete.retention.ms=1000"})));
        Properties configs = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandTest$$testTopicName());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.getProperty("delete.retention.ms")));
    }

    @Test
    public void testCreateIfNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().createTopic(this.createOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$1 = createOpts$1;
            }
        }, ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TopicCommand.TopicCommandOptions createNotExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--if-not-exists"}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createNotExistsOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.kafka$admin$TopicCommandTest$$testTopicName(), 0));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)replicas0);
        Seq replicas1 = this.zkClient().getReplicasForPartition(new TopicPartition(this.kafka$admin$TopicCommandTest$$testTopicName(), 1));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicas1);
        Seq replicas2 = this.zkClient().getReplicasForPartition(new TopicPartition(this.kafka$admin$TopicCommandTest$$testTopicName(), 2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)replicas2);
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().createTopic(this.createOpts$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$2 = createOpts$2;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--config", "message.format.version=boom"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().createTopic(this.createOpts2$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts2$1 = createOpts2$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    @Test
    public void testListTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandTest$$testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = topic1;
        int x$2 = 2;
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$6 = topic2;
        int x$7 = 2;
        int x$8 = 2;
        Properties x$9 = qual$2.createTopic$default$4();
        RackAwareMode x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$11 = topic3;
        int x$12 = 2;
        int x$13 = 2;
        Properties x$14 = qual$3.createTopic$default$4();
        RackAwareMode x$15 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$11, x$12, x$13, x$14, x$15);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$4 = this.adminZkClient();
        String x$16 = this.kafka$admin$TopicCommandTest$$testTopicName();
        int x$17 = 2;
        int x$18 = 2;
        Properties x$19 = qual$4.createTopic$default$4();
        RackAwareMode x$20 = qual$4.createTopic$default$5();
        qual$4.createTopic(x$16, x$17, x$18, x$19, x$20);
        AdminZkClient qual$5 = this.adminZkClient();
        String x$21 = "__consumer_offsets";
        int x$22 = 2;
        int x$23 = 2;
        Properties x$24 = qual$5.createTopic$default$4();
        RackAwareMode x$25 = qual$5.createTopic$default$5();
        qual$5.createTopic(x$21, x$22, x$23, x$24, x$25);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$6 = this.adminZkClient();
        String x$26 = this.kafka$admin$TopicCommandTest$$testTopicName();
        int x$27 = 2;
        int x$28 = 2;
        Properties x$29 = qual$6.createTopic$default$4();
        RackAwareMode x$30 = qual$6.createTopic$default$5();
        qual$6.createTopic(x$26, x$27, x$28, x$29, x$30);
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--partitions", "3"})));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandTest$$testTopicName()}))).apply((Object)this.kafka$admin$TopicCommandTest$$testTopicName())).size());
    }

    @Test
    public void testAlterAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4, 5}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$7 = this.adminZkClient();
        String x$31 = this.kafka$admin$TopicCommandTest$$testTopicName();
        int x$32 = 2;
        int x$33 = 2;
        Properties x$34 = qual$7.createTopic$default$4();
        RackAwareMode x$35 = qual$7.createTopic$default$5();
        qual$7.createTopic(x$31, x$32, x$33, x$34, x$35);
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        Seq replicas0 = this.zkClient().getReplicasForPartition(new TopicPartition(this.kafka$admin$TopicCommandTest$$testTopicName(), 2));
        Assert.assertEquals((long)3L, (long)((SeqLike)this.zkClient().getPartitionsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandTest$$testTopicName()}))).apply((Object)this.kafka$admin$TopicCommandTest$$testTopicName())).size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)replicas0);
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    @Test
    public void testAlterIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--partitions", "1"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().alterTopic(this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        TopicCommand.TopicCommandOptions alterExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--partitions", "1", "--if-exists"}));
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(alterExistsOpts);
    }

    @Test
    public void testAlterConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()})));
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--config", "cleanup.policy=compact"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output.contains("Configs:cleanup.policy=compact"));
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--config", "cleanup.policy=delete"})));
        String output2 = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((String)"The output should contain the modified config", (boolean)output2.contains("Configs:cleanup.policy=delete"));
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder().append((Object)cleanupKey).append((Object)"=").append((Object)cleanupVal).toString(), "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandTest$$testTopicName());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Properties after creation don't contain ").append((Object)cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandTest$$testTopicName());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Updated properties do not contain ").append((Object)cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.kafka$admin$TopicCommandTest$$testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.kafka$admin$TopicCommandTest$$topicService().deleteTopic(deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, deleteOffsetTopicOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOffsetTopicOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().deleteTopic(this.deleteOffsetTopicOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOffsetTopicOpts$1 = deleteOffsetTopicOpts$1;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        Assert.assertFalse((String)"Delete path for topic shouldn't exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, deleteOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().deleteTopic(this.deleteOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOpts$1 = deleteOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        TopicCommand.TopicCommandOptions deleteExistsOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--if-exists"}));
        this.kafka$admin$TopicCommandTest$$topicService().deleteTopic(deleteExistsOpts);
    }

    @Test
    public void testDeleteInternalTopic() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, deleteOffsetTopicOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOffsetTopicOpts$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().deleteTopic(this.deleteOffsetTopicOpts$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOffsetTopicOpts$2 = deleteOffsetTopicOpts$2;
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    @Test
    public void testDescribeIfTopicNotExists() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions describeOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, describeOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions describeOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(this.describeOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.describeOpts$1 = describeOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        TopicCommand.TopicCommandOptions describeOptsWithExists = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName(), "--if-exists"}));
        this.kafka$admin$TopicCommandTest$$topicService().describeTopic(describeOptsWithExists);
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        TestUtils$.MODULE$.createBrokersInZk(this.toBrokerMetadata((Map<Object, String>)rackInfo, this.toBrokerMetadata$default$2()), this.zkClient());
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandTest$$testTopicName()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().alterTopic(alterOpts);
        assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandTest$$testTopicName()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$2) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testDescribe() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$8 = this.adminZkClient();
        String x$36 = this.kafka$admin$TopicCommandTest$$testTopicName();
        int x$37 = 2;
        int x$38 = 2;
        Properties x$39 = qual$8.createTopic$default$4();
        RackAwareMode x$40 = qual$8.createTopic$default$5();
        qual$8.createTopic(x$36, x$37, x$38, x$39, x$40);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)Predef$.MODULE$.refArrayOps((Object[])rows).size());
        rows[0].startsWith("Topic:testTopic\tPartitionCount:2");
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        String config = "file.delete.delay.ms=1000";
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.kafka$admin$TopicCommandTest$$testTopicName());
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", configResource.name(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsMarkedForDeletion() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        String markedForDeletionDescribe = "MarkedForDeletion";
        String markedForDeletionList = "marked for deletion";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        TestUtils$.MODULE$.deleteBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.kafka$admin$TopicCommandTest$$topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandTest$$testTopicName()})));
        String outputWithConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$describeTopicsWithConfig$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((outputWithConfig.contains(this.kafka$admin$TopicCommandTest$$testTopicName()) && outputWithConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String outputNoConfig = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$describeTopicsNoConfig$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((outputNoConfig.contains(this.kafka$admin$TopicCommandTest$$testTopicName()) && outputNoConfig.contains(markedForDeletionDescribe) ? 1 : 0) != 0);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$listTopics$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((output.contains(this.kafka$admin$TopicCommandTest$$testTopicName()) && output.contains(markedForDeletionList) ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandTest$$testTopicName()})));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testTopicOperationsWithRegexSymbolInTopicName() {
        String topic1 = "test.topic";
        String topic2 = "test-topic";
        String escapedTopic = "\"test\\.topic\"";
        String unescapedTopic = "test.topic";
        int numPartitionsOriginal = 1;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", topic1}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts);
        TopicCommand.TopicCommandOptions createOpts2 = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--topic", topic2}));
        this.kafka$admin$TopicCommandTest$$topicService().createTopic(createOpts2);
        TopicCommand.TopicCommandOptions escapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", escapedTopic}));
        TopicCommand.TopicCommandOptions unescapedCommandOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", unescapedTopic}));
        Assert.assertFalse((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, escapedCommandOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions escapedCommandOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(this.escapedCommandOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.escapedCommandOpts$1 = escapedCommandOpts$1;
            }
        }).contains(topic2));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, unescapedCommandOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions unescapedCommandOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().describeTopic(this.unescapedCommandOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unescapedCommandOpts$1 = unescapedCommandOpts$1;
            }
        }).contains(topic2));
        Assert.assertFalse((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, escapedCommandOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions escapedCommandOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().deleteTopic(this.escapedCommandOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.escapedCommandOpts$1 = escapedCommandOpts$1;
            }
        }).contains(topic2));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, unescapedCommandOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandTest $outer;
            private final TopicCommand.TopicCommandOptions unescapedCommandOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandTest$$topicService().deleteTopic(this.unescapedCommandOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.unescapedCommandOpts$1 = unescapedCommandOpts$1;
            }
        }).contains(topic2));
    }

    @Test
    public void testAlterInternalTopicPartitionCount() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        AdminZkClient qual$9 = this.adminZkClient();
        String x$41 = "__consumer_offsets";
        int x$42 = 1;
        int x$43 = 1;
        Properties x$44 = qual$9.createTopic$default$4();
        RackAwareMode x$45 = qual$9.createTopic$default$5();
        qual$9.createTopic(x$41, x$42, x$43, x$44, x$45);
        AdminZkClient qual$10 = this.adminZkClient();
        String x$46 = "__transaction_state";
        int x$47 = 1;
        int x$48 = 1;
        Properties x$49 = qual$10.createTopic$default$4();
        RackAwareMode x$50 = qual$10.createTopic$default$5();
        qual$10.createTopic(x$46, x$47, x$48, x$49, x$50);
        this.expectAlterInternalTopicPartitionCountFailed$1("__consumer_offsets");
        this.expectAlterInternalTopicPartitionCountFailed$1("__transaction_state");
    }

    public final void kafka$admin$TopicCommandTest$$describeTopicsWithConfig$1() {
        this.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe"})));
    }

    public final void kafka$admin$TopicCommandTest$$describeTopicsNoConfig$1() {
        this.kafka$admin$TopicCommandTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--unavailable-partitions"})));
    }

    public final void kafka$admin$TopicCommandTest$$listTopics$1() {
        this.kafka$admin$TopicCommandTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list"})));
    }

    private final void expectAlterInternalTopicPartitionCountFailed$1(String topic) {
        try {
            this.kafka$admin$TopicCommandTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", topic, "--partitions", "2"})));
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public TopicCommandTest() {
        RackAwareTest$class.$init$(this);
        this._testName = new TestName();
    }
}

