/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.admin.TopicCommandWithAdminClientTest$;
import kafka.admin.TopicCommandWithAdminClientTest$$anonfun$testDescribeUnavailablePartitions$1$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u0001\u0003\u0001\u001d\u0011q\u0004V8qS\u000e\u001cu.\\7b]\u0012<\u0016\u000e\u001e5BI6Lgn\u00117jK:$H+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h!\t)b#D\u0001\u0003\u0013\t9\"AA\u0007SC\u000e\\\u0017i^1sKR+7\u000f\u001e\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\u000bu\u0001A\u0011\t\u0010\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\b\t\u0004A)jcBA\u0011(\u001d\t\u0011S%D\u0001$\u0015\t!c!\u0001\u0004=e>|GOP\u0005\u0002M\u0005)1oY1mC&\u0011\u0001&K\u0001\ba\u0006\u001c7.Y4f\u0015\u00051\u0013BA\u0016-\u0005\r\u0019V-\u001d\u0006\u0003Q%\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0003\u0002\rM,'O^3s\u0013\t\u0011tFA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0003\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00036\u00031!x\u000e]5d'\u0016\u0014h/[2f+\u00051\u0004CA\u001c?\u001d\tADH\u0004\u0002:w9\u0011!EO\u0005\u0002\u000b%\u00111\u0001B\u0005\u0003{\t\tA\u0002V8qS\u000e\u001cu.\\7b]\u0012L!a\u0010!\u0003/\u0005#W.\u001b8DY&,g\u000e\u001e+pa&\u001c7+\u001a:wS\u000e,'BA\u001f\u0003\u0011%\u0011\u0005\u00011AA\u0002\u0013%1)\u0001\tu_BL7mU3sm&\u001cWm\u0018\u0013fcR\u0011A\t\u0013\t\u0003\u000b\u001ak\u0011!K\u0005\u0003\u000f&\u0012A!\u00168ji\"9\u0011*QA\u0001\u0002\u00041\u0014a\u0001=%c!11\n\u0001Q!\nY\nQ\u0002^8qS\u000e\u001cVM\u001d<jG\u0016\u0004\u0003\"C'\u0001\u0001\u0004\u0005\r\u0011\"\u0003O\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0003=\u0003\"\u0001U-\u000e\u0003ES!a\u0001*\u000b\u0005M#\u0016aB2mS\u0016tGo\u001d\u0006\u0003\u000bUS!AV,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0016aA8sO&\u0011!,\u0015\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fC\u0005]\u0001\u0001\u0007\t\u0019!C\u0005;\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002E=\"9\u0011jWA\u0001\u0002\u0004y\u0005B\u00021\u0001A\u0003&q*\u0001\u0007bI6Lgn\u00117jK:$\b\u0005C\u0005c\u0001\u0001\u0007\t\u0019!C\u0005G\u0006iA/Z:u)>\u0004\u0018n\u0019(b[\u0016,\u0012\u0001\u001a\t\u0003K\"t!!\u00124\n\u0005\u001dL\u0013A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u0015\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0017!\u0005;fgR$v\u000e]5d\u001d\u0006lWm\u0018\u0013fcR\u0011AI\u001c\u0005\b\u0013.\f\t\u00111\u0001e\u0011\u0019\u0001\b\u0001)Q\u0005I\u0006qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0003b\u0002:\u0001\u0005\u0004%Ia]\u0001\n?R,7\u000f\u001e(b[\u0016,\u0012\u0001\u001e\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fQA];mKNT!!_,\u0002\u000b),h.\u001b;\n\u0005m4(\u0001\u0003+fgRt\u0015-\\3\t\ru\u0004\u0001\u0015!\u0003u\u0003)yF/Z:u\u001d\u0006lW\r\t\u0005\u0006\u007f\u0002!\ta]\u0001\ti\u0016\u001cHOT1nK\"\u001aa0a\u0001\u0011\t\u0005\u0015\u0011qA\u0007\u0002q&\u0019\u0011\u0011\u0002=\u0003\tI+H.\u001a\u0005\b\u0003\u001b\u0001A\u0011AA\b\u00039\t7o]3si\u0016C\u0018\u000e^\"pI\u0016$R\u0001RA\t\u00037A\u0001\"a\u0005\u0002\f\u0001\u0007\u0011QC\u0001\tKb\u0004Xm\u0019;fIB\u0019Q)a\u0006\n\u0007\u0005e\u0011FA\u0002J]RD\u0001\"!\b\u0002\f\u0001\u0007\u0011qD\u0001\u0007[\u0016$\bn\u001c3\u0011\t\u0015\u000b\t\u0003R\u0005\u0004\u0003GI#!\u0003$v]\u000e$\u0018n\u001c81\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\tq#Y:tKJ$8\t[3dW\u0006\u0013xm]#ySR\u001cu\u000eZ3\u0015\u000b\u0011\u000bY#!\f\t\u0011\u0005M\u0011Q\u0005a\u0001\u0003+A\u0001\"a\f\u0002&\u0001\u0007\u0011\u0011G\u0001\b_B$\u0018n\u001c8t!\r9\u00141G\u0005\u0004\u0003k\u0001%a\u0005+pa&\u001c7i\\7nC:$w\n\u001d;j_:\u001c\bbBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0013GJ,\u0017\r^3B]\u0012<\u0016-\u001b;U_BL7\rF\u0002E\u0003{A\u0001\"a\u0010\u00028\u0001\u0007\u0011\u0011G\u0001\u0005_B$8\u000fC\u0004\u0002D\u0001!\t!!\u0012\u0002']\f\u0017\u000e\u001e$peR{\u0007/[2De\u0016\fG/\u001a3\u0015\u000b\u0011\u000b9%a\u0013\t\u000f\u0005%\u0013\u0011\ta\u0001I\u0006IAo\u001c9jG:\u000bW.\u001a\u0005\u000b\u0003\u001b\n\t\u0005%AA\u0002\u0005U\u0011a\u0002;j[\u0016|W\u000f\u001e\u0005\b\u0003#\u0002A\u0011AA*\u0003\u0015\u0019X\r^;q)\u0005!\u0005\u0006BA(\u0003/\u0002B!!\u0002\u0002Z%\u0019\u00111\f=\u0003\r\t+gm\u001c:f\u0011\u001d\ty\u0006\u0001C\u0001\u0003'\nQa\u00197pg\u0016DC!!\u0018\u0002dA!\u0011QAA3\u0013\r\t9\u0007\u001f\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003W\u0002A\u0011AA*\u0003M!Xm\u001d;QCJ\u001cX-Q:tS\u001etW.\u001a8uQ\u0011\tI'a\u001c\u0011\t\u0005\u0015\u0011\u0011O\u0005\u0004\u0003gB(\u0001\u0002+fgRDq!a\u001e\u0001\t\u0003\t\u0019&A\u0012uKN$\b+\u0019:tK\u0006\u001b8/[4o[\u0016tG\u000fR;qY&\u001c\u0017\r^3F]R\u0014\u0018.Z:)\t\u0005U\u0014q\u000e\u0005\b\u0003{\u0002A\u0011AA*\u00031\"Xm\u001d;QCJ\u001cX-Q:tS\u001etW.\u001a8u!\u0006\u0014H/\u001b;j_:\u001cxJ\u001a#jM\u001a,'/\u001a8u'&TX\r\u000b\u0003\u0002|\u0005=\u0004bBAB\u0001\u0011\u0005\u00111K\u0001\"i\u0016\u001cHoQ8oM&<w\n\u001d;XSRD'i\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u0015\u0005\u0003\u0003\u000by\u0007C\u0004\u0002\n\u0002!\t!a\u0015\u0002\u0015Q,7\u000f^\"sK\u0006$X\r\u000b\u0003\u0002\b\u0006=\u0004bBAH\u0001\u0011\u0005\u00111K\u0001\u0016i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0007>tg-[4tQ\u0011\ti)a\u001c\t\u000f\u0005U\u0005\u0001\"\u0001\u0002T\u0005YB/Z:u\u0007J,\u0017\r^3JM&#\u0018\t\u001c:fC\u0012LX\t_5tiNDC!a%\u0002p!9\u00111\u0014\u0001\u0005\u0002\u0005M\u0013a\b;fgR\u001c%/Z1uK^KG\u000f\u001b*fa2L7-Y!tg&<g.\\3oi\"\"\u0011\u0011TA8\u0011\u001d\t\t\u000b\u0001C\u0001\u0003'\na\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138wC2LGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\u0011\ty*a\u001c\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002T\u00059C/Z:u\u0007J,\u0017\r^3XSRDg*Z4bi&4XMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\u0011\t)+a\u001c\t\u000f\u00055\u0006\u0001\"\u0001\u0002T\u0005IC/Z:u\u0007J,\u0017\r^3XSRD\u0017i]:jO:lWM\u001c;B]\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RDC!a+\u0002p!9\u00111\u0017\u0001\u0005\u0002\u0005M\u0013\u0001\f;fgR\u001c%/Z1uK^KG\u000f[!tg&<g.\\3oi\u0006sGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\u0011\t\t,a\u001c\t\u000f\u0005e\u0006\u0001\"\u0001\u0002T\u0005!C/Z:u\u0007J,\u0017\r^3XSRDg*Z4bi&4X\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0003\u00028\u0006=\u0004bBA`\u0001\u0011\u0005\u00111K\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0003\u0002>\u0006=\u0004bBAc\u0001\u0011\u0005\u00111K\u0001\u001ci\u0016\u001cH/\u00138wC2LG\rV8qS\u000edUM^3m\u0007>tg-[4)\t\u0005\r\u0017q\u000e\u0005\b\u0003\u0017\u0004A\u0011AA*\u00039!Xm\u001d;MSN$Hk\u001c9jGNDC!!3\u0002p!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0013a\u0007;fgRd\u0015n\u001d;U_BL7m],ji\"<\u0006.\u001b;fY&\u001cH\u000f\u000b\u0003\u0002P\u0006=\u0004bBAl\u0001\u0011\u0005\u00111K\u0001\"i\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\b.\u0012=dYV$W-\u00138uKJt\u0017\r\u001c\u0015\u0005\u0003+\fy\u0007C\u0004\u0002^\u0002!\t!a\u0015\u0002/Q,7\u000f^!mi\u0016\u0014\b+\u0019:uSRLwN\\\"pk:$\b\u0006BAn\u0003_Bq!a9\u0001\t\u0003\t\u0019&A\nuKN$\u0018\t\u001c;fe\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0003\u0002b\u0006=\u0004bBAu\u0001\u0011\u0005\u00111K\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3BgNLwM\\7f]R$\u0006.\u00198QCJ$\u0018\u000e^5p]NDC!a:\u0002p!9\u0011q\u001e\u0001\u0005\u0002\u0005M\u0013a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X\rU1si&$\u0018n\u001c8t)\"\fg.Q:tS\u001etW.\u001a8uQ\u0011\ti/a\u001c\t\u000f\u0005U\b\u0001\"\u0001\u0002T\u0005\u0011C/Z:u\u00032$XM],ji\"LeN^1mS\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RDC!a=\u0002p!9\u00111 \u0001\u0005\u0002\u0005M\u0013A\n;fgR\fE\u000e^3s/&$\b.\u00168ta\u0016\u001c\u0017NZ5fIB\u000b'\u000f^5uS>t7i\\;oi\"\"\u0011\u0011`A8\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003'\nQ\u0004^3ti\u0006cG/\u001a:XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0005\u0003\u007f\fy\u0007C\u0004\u0003\b\u0001!\t!a\u0015\u0002yQ,7\u000f^%g\u000bbL7\u000f^:B]\u0012LeMT8u\u000bbL7\u000f^:PaRLwN\\:J]Z\fG.\u001b3XSRD'i\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u0015\u0005\u0005\u000b\ty\u0007C\u0004\u0003\u000e\u0001!\t!a\u0015\u0002CQ,7\u000f^\"sK\u0006$X-\u00117uKJ$v\u000e]5d/&$\bNU1dW\u0006;\u0018M]3)\t\t-\u0011q\u000e\u0005\b\u0005'\u0001A\u0011AA*\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8oQ\u0011\u0011\t\"a\u001c\t\u000f\te\u0001\u0001\"\u0001\u0002T\u0005\tB/Z:u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\t\t]\u0011q\u000e\u0005\b\u0005?\u0001A\u0011AA*\u0003]!Xm\u001d;EK2,G/Z%oi\u0016\u0014h.\u00197U_BL7\r\u000b\u0003\u0003\u001e\u0005=\u0004b\u0002B\u0013\u0001\u0011\u0005\u00111K\u0001\u0013i\u0016\u001cH\u000fR3mKR,\u0017JZ#ySN$8\u000f\u000b\u0003\u0003$\u0005=\u0004b\u0002B\u0016\u0001\u0011\u0005\u00111K\u0001\ri\u0016\u001cH\u000fR3tGJL'-\u001a\u0015\u0005\u0005S\ty\u0007C\u0004\u00032\u0001!\t!a\u0015\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u00064\u0018-\u001b7bE2,\u0007+\u0019:uSRLwN\\:)\t\t=\u0012q\u000e\u0005\b\u0005o\u0001A\u0011AA*\u0003\u0015\"Xm\u001d;EKN\u001c'/\u001b2f+:$WM\u001d*fa2L7-\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u000b\u0003\u00036\u0005=\u0004b\u0002B\u001f\u0001\u0011\u0005\u00111K\u0001\"i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0005w\ty\u0007C\u0004\u0003D\u0001!\t!a\u0015\u0002=Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3Bi6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001c\b\u0006\u0002B!\u0003_BqA!\u0013\u0001\t\u0003\t\u0019&\u0001\u0014uKN$H)Z:de&\u0014W-\u00168eKJl\u0015N\\%teB\u000b'\u000f^5uS>t7/T5yK\u0012DCAa\u0012\u0002p!9!q\n\u0001\u0005\u0002\u0005M\u0013a\t;fgR$Um]2sS\n,'+\u001a9peR|e/\u001a:sS\u0012$WM\\\"p]\u001aLwm\u001d\u0015\u0005\u0005\u001b\ny\u0007C\u0004\u0003V\u0001!\t!a\u0015\u0002]Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012d\u0015n\u001d;U_BL7m],ji\"|W\u000f^%oi\u0016\u0014h.\u00197U_BL7m\u001d\u0015\u0005\u0005'\ny\u0007C\u0005\u0003\\\u0001\t\n\u0011\"\u0001\u0003^\u0005ir/Y5u\r>\u0014Hk\u001c9jG\u000e\u0013X-\u0019;fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003`)\"\u0011Q\u0003B1W\t\u0011\u0019\u0007\u0005\u0003\u0003f\t=TB\u0001B4\u0015\u0011\u0011IGa\u001b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B7S\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE$q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private TopicCommand.AdminClientTopicService kafka$admin$TopicCommandWithAdminClientTest$$topicService;
    private AdminClient adminClient;
    private String kafka$admin$TopicCommandWithAdminClientTest$$testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = 6;
        String x$13 = this.zkConnect();
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$13, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, (Map<Object, String>)x$14, x$24, x$25).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public TopicCommand.AdminClientTopicService kafka$admin$TopicCommandWithAdminClientTest$$topicService() {
        return this.kafka$admin$TopicCommandWithAdminClientTest$$topicService;
    }

    private void kafka$admin$TopicCommandWithAdminClientTest$$topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService = x$1;
    }

    private AdminClient adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    public String kafka$admin$TopicCommandWithAdminClientTest$$testTopicName() {
        return this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName;
    }

    private void kafka$admin$TopicCommandWithAdminClientTest$$testTopicName_$eq(String x$1) {
        this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final int expected$1;

            public final Nothing$ apply(int exitCode, Option<String> exitMessage) {
                return this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$mockExitProcedure$1(exitCode, exitMessage, this.expected$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expected$1 = expected$1;
            }
        });
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            return;
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions options$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.options$1.checkArgs();
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        long finishTime = System.currentTimeMillis() + (long)timeout;
        boolean result = false;
        while (true) {
            if (System.currentTimeMillis() >= finishTime && result) {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " has not been created within the given ", " time"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicName, BoxesRunTime.boxToInteger((int)timeout)})), (boolean)result);
                return;
            }
            java.util.Set topics = (java.util.Set)this.adminClient().listTopics(new ListTopicsOptions().listInternal(true)).names().get();
            boolean bl = topics.contains(topicName);
            Thread.sleep(100L);
        }
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Before
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(AdminClient.create((Properties)props));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testName().getMethodName(), Random$.MODULE$.alphanumeric().take(10).mkString()})));
    }

    @After
    public void close() {
        if (this.kafka$admin$TopicCommandWithAdminClientTest$$topicService() != null) {
            this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().close();
        }
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, List<Object>> apply() {
                return TopicCommand$.MODULE$.parseReplicaAssignment("5:5");
            }
        }, ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, List<Object>> apply() {
                return TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1");
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(this.createOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$1 = createOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$1) {
                return x$1.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$3) {
                return x$3.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
    }

    @Test
    public void testCreateWithUnspecifiedPartitionCount() {
        this.assertExitCode(1, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replication-factor", "1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(this.createOpts$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$2 = createOpts$2;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, 2), new NewTopic(topic2, 2, 2), new NewTopic(topic3, 2, 2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, 2), new NewTopic("__consumer_offsets", 2, 2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, 2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).values().get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, 2))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).values().get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, 2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, 2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, alterOpts, topicService){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions alterOpts$1;
            private final TopicCommand.AdminClientTopicService topicService$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.topicService$1.alterTopic(this.alterOpts$1);
            }
            {
                this.alterOpts$1 = alterOpts$1;
                this.topicService$1 = topicService$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "1"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "1", "--replication-factor", "1"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(alterOpts);
        assignment2 = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$2) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder().append((Object)cleanupKey).append((Object)"=").append((Object)cleanupVal).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Properties after creation don't contain ").append((Object)cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Updated properties do not contain ").append((Object)cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, deleteOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().deleteTopic(this.deleteOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOpts$1 = deleteOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, 2))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)Predef$.MODULE$.refArrayOps((Object[])rows).size());
        rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic:", "\\tPartitionCount:2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 6, 1))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).asScala()).apply((Object)this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(TopicPartitionInfo x$5) {
                    return x$5.leader().id() == 0;
                }
            }).get()).partition();
            this.killBroker(0);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partitionOnBroker0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
                public final int partitionOnBroker0$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.$outer.servers().filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(KafkaServer x$6) {
                            return x$6.config().brokerId() == 0;
                        }
                    })).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1 $outer;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(boolean result, KafkaServer server) {
                            boolean x$29;
                            boolean x$28;
                            ListenerName x$27;
                            MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
                            scala.collection.immutable.Set x$26 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$$outer().kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
                            Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$26, x$27 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$28 = qual$1.getTopicMetadata$default$3(), x$29 = qual$1.getTopicMetadata$default$4());
                            Option testPartitionMetadata = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)topicMetadatas.find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1$$anonfun$apply$mcZ$sp$2 $outer;

                                public final boolean apply(MetadataResponse.TopicMetadata x$7) {
                                    return x$7.topic().equals(this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$anonfun$$$outer().kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$$outer().kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).get()).partitionMetadata()).asScala()).find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1$$anonfun$apply$mcZ$sp$2 $outer;

                                public final boolean apply(MetadataResponse.PartitionMetadata x$8) {
                                    return x$8.partition() == this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$anonfun$$$outer().partitionOnBroker0$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Option option = testPartitionMetadata;
                            if (None$.MODULE$.equals(option)) {
                                throw Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition metadata is not found in metadata cache"})).s((Seq)Nil$.MODULE$), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
                            }
                            if (!(option instanceof Some)) throw new MatchError((Object)option);
                            Some some = (Some)option;
                            MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)some.x();
                            if (!result) return false;
                            Errors errors = metadata.error();
                            Errors errors2 = Errors.LEADER_NOT_AVAILABLE;
                            if (errors != null) {
                                if (!errors.equals(errors2)) return false;
                                return true;
                            }
                            if (errors2 == null) return true;
                            return false;
                        }

                        public /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1 kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }

                public /* synthetic */ TopicCommandWithAdminClientTest kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionOnBroker0$1 = partitionOnBroker0$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition metadata for ", " is not propagated"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--unavailable-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            Assert.assertTrue((boolean)rows[0].endsWith("Leader: none\tReplicas: 0\tIsr: "));
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, 6))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$9) {
                    return x$9.config().brokerId() == 0;
                }
            });
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, 6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$10) {
                    return x$10.config().brokerId() == 0;
                }
            });
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, 6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            Assert.assertEquals((long)1L, (long)rows.length);
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, 6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, 6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$11) {
                    return x$11.config().brokerId() == 0;
                }
            });
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{underMinIsrTopic}))));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offlineTopic}))));
            Assert.assertEquals((long)2L, (long)rows.length);
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Describe output should have contained ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config})), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output should have contained ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})), (boolean)output.contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    public final Nothing$ kafka$admin$TopicCommandWithAdminClientTest$$mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest$class.$init$(this);
        this._testName = new TestName();
    }
}

