/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AdminClientIntegrationTest$;
import kafka.api.AdminClientIntegrationTest$$anonfun$testDescribeLogDirs$1$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.auth.Cluster$;
import kafka.security.auth.Operation;
import kafka.security.auth.Topic$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectPreferredLeadersOptions;
import org.apache.kafka.clients.admin.ElectPreferredLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0001\u0003\u0001\u001d\u0011!$\u00113nS:\u001cE.[3oi&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\ti\u0001#D\u0001\u000f\u0015\tyA!A\u0003vi&d7/\u0003\u0002\u0012\u001d\t9Aj\\4hS:<\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\tI\u0001\u0001C\u0003\u0018\u0001\u0011\u0005\u0001$A\u0007hY>\u0014\u0017\r\u001c+j[\u0016|W\u000f^\u000b\u00023A\u0011!$I\u0007\u00027)\u0011A$H\u0001\u0006eVdWm\u001d\u0006\u0003=}\tQA[;oSRT\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001c\u0005\u001d!\u0016.\\3pkRD#A\u0006\u0013\u0011\u0005\u00152S\"A\u000f\n\u0005\u001dj\"\u0001\u0002*vY\u0016Dq!\u000b\u0001A\u0002\u0013\u0005!&\u0001\u0004dY&,g\u000e^\u000b\u0002WA\u0011A\u0006N\u0007\u0002[)\u0011afL\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003aE\nqa\u00197jK:$8O\u0003\u0002\u0006e)\u00111gH\u0001\u0007CB\f7\r[3\n\u0005Uj#aC!e[&t7\t\\5f]RDqa\u000e\u0001A\u0002\u0013\u0005\u0001(\u0001\u0006dY&,g\u000e^0%KF$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001Z\n\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015B\u0016\u0002\u000f\rd\u0017.\u001a8uA!9A\t\u0001b\u0001\n\u0003)\u0015!\u0002;pa&\u001cW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\n11\u000b\u001e:j]\u001eDaa\u0014\u0001!\u0002\u00131\u0015A\u0002;pa&\u001c\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u0013A\f'\u000f^5uS>tW#A*\u0011\u0005i\"\u0016BA+<\u0005\rIe\u000e\u001e\u0005\u0007/\u0002\u0001\u000b\u0011B*\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011\u0001.\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\f\u0005\u0002]?6\tQL\u0003\u0002_c\u000511m\\7n_:L!\u0001Y/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1!\r\u0001Q\u0001\nm\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\u0006I\u0002!\t%Z\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u00121m\u001a\t\u0003K!L!![\u000f\u0003\r\t+gm\u001c:f\u0011\u0015Y\u0007\u0001\"\u0011f\u0003!!X-\u0019:E_^t\u0007F\u00016n!\t)c.\u0003\u0002p;\t)\u0011I\u001a;fe\"9\u0011\u000f\u0001b\u0001\n\u0003\u0011\u0016a\u00032s_.,'oQ8v]RDaa\u001d\u0001!\u0002\u0013\u0019\u0016\u0001\u00042s_.,'oQ8v]R\u0004\u0003bB;\u0001\u0005\u0004%\tAU\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r]\u0004\u0001\u0015!\u0003T\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002Bq!\u001f\u0001C\u0002\u0013\u0005!+A\u0007qe>$WoY3s\u0007>,h\u000e\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B*\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA!)Q\u0010\u0001C!}\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0000!\u0019\t\t!!\u0005\u0002\u00189!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\r\u00051AH]8pizJ\u0011\u0001P\u0005\u0004\u0003\u001fY\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u0004<!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\t\u000511/\u001a:wKJLA!!\t\u0002\u001c\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\tAb\u0019:fCR,7i\u001c8gS\u001e$\"!!\u000b\u0011\u0011\u0005-\u0012\u0011GA\u001b\u0003\u0003j!!!\f\u000b\u0007\u0005=\"*\u0001\u0003vi&d\u0017\u0002BA\u001a\u0003[\u00111!T1q!\u0011\t9$!\u0010\u000f\u0007i\nI$C\u0002\u0002<m\na\u0001\u0015:fI\u00164\u0017bA'\u0002@)\u0019\u00111H\u001e\u0011\u0007\u001d\u000b\u0019%C\u0002\u0002F!\u0013aa\u00142kK\u000e$\bbBA%\u0001\u0011\u0005\u00111J\u0001\u000eo\u0006LGOR8s)>\u0004\u0018nY:\u0015\u000fe\ni%a\u0014\u0002V!1\u0011&a\u0012A\u0002-B\u0001\"!\u0015\u0002H\u0001\u0007\u00111K\u0001\u0010Kb\u0004Xm\u0019;fIB\u0013Xm]3oiB1\u0011\u0011AA\t\u0003kA\u0001\"a\u0016\u0002H\u0001\u0007\u00111K\u0001\u0010Kb\u0004Xm\u0019;fI6K7o]5oO\"1\u00111\f\u0001\u0005\u0002\u0015\f\u0011\u0002^3ti\u000ecwn]3)\t\u0005e\u0013q\f\t\u0004K\u0005\u0005\u0014bAA2;\t!A+Z:u\u0011\u0019\t9\u0007\u0001C\u0001K\u0006iA/Z:u\u0019&\u001cHOT8eKNDC!!\u001a\u0002`!1\u0011Q\u000e\u0001\u0005\u0002\u0015\fa\u0003^3ti\u000e\u0013X-\u0019;f\t\u0016dW\r^3U_BL7m\u001d\u0015\u0005\u0003W\ny\u0006\u0003\u0004\u0002t\u0001!\t!Z\u0001\u0014i\u0016\u001cH/T3uC\u0012\fG/\u0019*fMJ,7\u000f\u001b\u0015\u0005\u0003c\ny\u0006\u0003\u0004\u0002z\u0001!\t!Z\u0001\u0019i\u0016\u001cH/Q;uQ>\u0014\u0018N_3e\u001fB,'/\u0019;j_:\u001c\b\u0006BA<\u0003?Bq!a \u0001\t\u0003\t\t)\u0001\u000fd_:4\u0017nZ;sK\u0012\u001cE.^:uKJ\u0004VM]7jgNLwN\\:\u0015\u0005\u0005\r\u0005CBA\u001c\u0003\u000b\u000bI)\u0003\u0003\u0002\b\u0006}\"aA*fiB!\u00111RAI\u001b\t\tiIC\u0002\u0002\u0010v\u000b1!Y2m\u0013\u0011\t\u0019*!$\u0003\u0019\u0005\u001bGn\u00149fe\u0006$\u0018n\u001c8\t\r\u0005]\u0005\u0001\"\u0001f\u0003q!Xm\u001d;EKN\u001c'/\u001b2f\u001d>tW\t_5ti&tw\rV8qS\u000eDC!!&\u0002`!1\u0011Q\u0014\u0001\u0005\u0002\u0015\f1\u0003^3ti\u0012+7o\u0019:jE\u0016\u001cE.^:uKJDC!a'\u0002`!1\u00111\u0015\u0001\u0005\u0002\u0015\f1\u0003^3ti\u0012+7o\u0019:jE\u0016dun\u001a#jeNDC!!)\u0002`!1\u0011\u0011\u0016\u0001\u0005\u0002\u0015\f!\u0004^3ti\u0012+7o\u0019:jE\u0016\u0014V\r\u001d7jG\u0006dun\u001a#jeNDC!a*\u0002`!1\u0011q\u0016\u0001\u0005\u0002\u0015\fq\u0003^3ti\u0006cG/\u001a:SKBd\u0017nY1M_\u001e$\u0015N]:)\t\u00055\u0016q\f\u0005\u0007\u0003k\u0003A\u0011A3\u00027Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012\fE\u000e^3s\u0007>tg-[4tQ\u0011\t\u0019,a\u0018\t\r\u0005m\u0006\u0001\"\u0001f\u0003Q!Xm\u001d;De\u0016\fG/\u001a)beRLG/[8og\"\"\u0011\u0011XA0\u0011\u0019\t\t\r\u0001C\u0001K\u0006QB/Z:u'\u0016,7.\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\"\u0011qXA0\u0011\u0019\t9\r\u0001C\u0001K\u0006aB/Z:u\u0019><7\u000b^1si>3gm]3u\u0007\",7m\u001b9pS:$\b\u0006BAc\u0003?Ba!!4\u0001\t\u0003)\u0017\u0001\n;fgRdunZ*uCJ$xJ\u001a4tKR\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\t\u0005-\u0017q\f\u0005\u0007\u0003'\u0004A\u0011A3\u0002oQ,7\u000f\u001e*fa2L7-Y\"b]\u001a+Go\u00195Ge>lGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\u0011\t\t.a\u0018\t\r\u0005e\u0007\u0001\"\u0001f\u0003\t\"Xm\u001d;BYR,'\u000fT8h\t&\u00148/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\"\u0011q[A0\u0011\u0019\ty\u000e\u0001C\u0001K\u0006)C/Z:u\u001f\u001a47/\u001a;t\r>\u0014H+[7fg\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u0015\u0005\u0003;\fy\u0006\u0003\u0004\u0002f\u0002!\t!Z\u0001\u001ei\u0016\u001cHoQ8ogVlW-\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\"\u00111]A0\u0011\u0019\tY\u000f\u0001C\u0001K\u0006qB/Z:u\t\u0016dW\r^3SK\u000e|'\u000fZ:XSRDW\t_2faRLwN\u001c\u0015\u0005\u0003S\fy\u0006\u0003\u0004\u0002r\u0002!\t!Z\u0001\u001ci\u0016\u001cH\u000fR3tGJL'-Z\"p]\u001aLwm\u001d$peR{\u0007/[2)\t\u0005=\u0018q\f\u0005\b\u0003o\u0004A\u0011BA}\u0003u\u0019XOY:de&\u0014W-\u00118e/\u0006LGOR8s\u0003N\u001c\u0018n\u001a8nK:$H#B\u001d\u0002|\u0006u\bb\u0002#\u0002v\u0002\u0007\u0011Q\u0007\u0005\t\u0003\u007f\f)\u00101\u0001\u0003\u0002\u0005A1m\u001c8tk6,'\u000f\u0005\u0005\u0003\u0004\t\u001d!1\u0002B\u0006\u001b\t\u0011)AC\u0002\u0002\u0000>JAA!\u0003\u0003\u0006\ti1*\u00194lC\u000e{gn];nKJ\u0004RA\u000fB\u0007\u0005#I1Aa\u0004<\u0005\u0015\t%O]1z!\rQ$1C\u0005\u0004\u0005+Y$\u0001\u0002\"zi\u0016DqA!\u0007\u0001\t\u0013\u0011Y\"A\u0006tK:$'+Z2pe\u0012\u001cHcB\u001d\u0003\u001e\t-\"q\u0006\u0005\t\u0005?\u00119\u00021\u0001\u0003\"\u0005A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u0003$\t\u001d\"1\u0002B\u0006\u001b\t\u0011)CC\u0002\u0003 =JAA!\u000b\u0003&\ti1*\u00194lCB\u0013x\u000eZ;dKJDqA!\f\u0003\u0018\u0001\u00071+\u0001\u0006ok6\u0014VmY8sINDa!\u0017B\f\u0001\u0004Y\u0006B\u0002B\u001a\u0001\u0011\u0005Q-A\fuKN$\u0018J\u001c<bY&$\u0017\t\u001c;fe\u000e{gNZ5hg\"\"!\u0011GA0\u0011%\u0011I\u0004\u0001b\u0001\n\u0003\u0011Y$\u0001\u0003B\u00072\u000bTC\u0001B\u001f!\u0011\tYIa\u0010\n\t\t\u0005\u0013Q\u0012\u0002\u000b\u0003\u000ed')\u001b8eS:<\u0007\u0002\u0003B#\u0001\u0001\u0006IA!\u0010\u0002\u000b\u0005\u001bE*\r\u0011\t\r\t%\u0003\u0001\"\u0001f\u0003E!Xm\u001d;BG2|\u0005/\u001a:bi&|gn\u001d\u0015\u0005\u0005\u000f\ny\u0006\u0003\u0004\u0003P\u0001!\t!Z\u0001\u0011i\u0016\u001cH\u000fR3mCf,Gm\u00117pg\u0016DCA!\u0014\u0002`!1!Q\u000b\u0001\u0005\u0002\u0015\fa\u0002^3ti\u001a{'oY3DY>\u001cX\r\u000b\u0003\u0003T\u0005}\u0003B\u0002B.\u0001\u0011\u0005Q-\u0001\u000euKN$X*\u001b8j[Vl'+Z9vKN$H+[7f_V$8\u000f\u000b\u0003\u0003Z\u0005}\u0003B\u0002B1\u0001\u0011\u0005Q-\u0001\ruKN$8)\u00197m\u0013:4E.[4iiRKW.Z8viNDCAa\u0018\u0002`!1!q\r\u0001\u0005\u0002\u0015\f!\u0003^3ti\u000e{gn];nKJ<%o\\;qg\"\"!QMA0\u0011\u0019\u0011i\u0007\u0001C\u0001K\u0006IB/Z:u\u000b2,7\r\u001e)sK\u001a,'O]3e\u0019\u0016\fG-\u001a:tQ\u0011\u0011Y'a\u0018\t\r\tM\u0004\u0001\"\u0001f\u0003\u0001\"Xm\u001d;WC2LG-\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:)\t\tE\u0014q\f\u0005\u0007\u0005s\u0002A\u0011A3\u0002EQ,7\u000f^%om\u0006d\u0017\u000eZ%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4tQ\u0011\u00119(a\u0018\t\r\t}\u0004\u0001\"\u0001f\u0003I!Xm\u001d;M_:<Gk\u001c9jG:\u000bW.Z:)\t\tu\u0014qL\u0004\b\u0005\u000b\u0013\u0001\u0012\u0001BD\u0003i\tE-\\5o\u00072LWM\u001c;J]R,wM]1uS>tG+Z:u!\rI!\u0011\u0012\u0004\u0007\u0003\tA\tAa#\u0014\t\t%%Q\u0012\t\u0004u\t=\u0015b\u0001BIw\t1\u0011I\\=SK\u001aDqa\u0005BE\t\u0003\u0011)\n\u0006\u0002\u0003\b\"A!\u0011\u0014BE\t\u0003\u0011Y*\u0001\fdQ\u0016\u001c7NV1mS\u0012\fE\u000e^3s\u0007>tg-[4t)\u001dI$Q\u0014BP\u0005_Ca!\u000bBL\u0001\u0004Y\u0003\u0002\u0003BQ\u0005/\u0003\rAa)\u0002\u001dQ|\u0007/[2SKN|WO]2fcA!!Q\u0015BV\u001b\t\u00119KC\u0002\u0003*v\u000baaY8oM&<\u0017\u0002\u0002BW\u0005O\u0013abQ8oM&<'+Z:pkJ\u001cW\r\u0003\u0005\u00032\n]\u0005\u0019\u0001BR\u00039!x\u000e]5d%\u0016\u001cx.\u001e:dKJB\u0001B!.\u0003\n\u0012\u0005!qW\u0001\u0019G\",7m[%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cHcB\u001d\u0003:\n%'Q\u001b\u0005\t\u0005w\u0013\u0019\f1\u0001\u0003>\u0006A!p[\"mS\u0016tG\u000f\u0005\u0003\u0003@\n\u0015WB\u0001Ba\u0015\r\u0011\u0019\rB\u0001\u0003u.LAAa2\u0003B\ni1*\u00194lCj[7\t\\5f]RD\u0001Ba3\u00034\u0002\u0007!QZ\u0001\bg\u0016\u0014h/\u001a:t!\u0019\t\t!!\u0005\u0003PB!\u0011\u0011\u0004Bi\u0013\u0011\u0011\u0019.a\u0007\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\u0007S\tM\u0006\u0019A\u0016")
public class AdminClientIntegrationTest
extends IntegrationTestHarness {
    private AdminClient client = null;
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private final int brokerCount;
    private final int consumerCount;
    private final int producerCount;
    private final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, AdminClient adminClient) {
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, adminClient);
    }

    public static void checkValidAlterConfigs(AdminClient adminClient, ConfigResource configResource, ConfigResource configResource2) {
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(adminClient, configResource, configResource2);
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$27 = this.brokerCount();
        String x$28 = this.zkConnect();
        Some x$29 = new Some((Object)this.securityProtocol());
        Option<File> x$30 = this.trustStoreFile();
        Option<Properties> x$31 = this.serverSaslProperties();
        int x$32 = 2;
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$35 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$36 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$37 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$39 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$40 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$27, x$28, x$33, x$34, (Option<SecurityProtocol>)x$29, x$30, x$31, x$35, x$36, x$37, x$38, x$39, x$32, x$40);
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final Object apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.RandomPort())})));
                config.remove(KafkaConfig$.MODULE$.InterBrokerSecurityProtocolProp());
                config.setProperty(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), this.$outer.listenerName().value());
                config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.listenerName().value(), this.$outer.securityProtocol().name})));
                config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
                config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
                return config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp()) ? BoxedUnit.UNIT : config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cfgs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(Properties x$1) {
                Implicits$.MODULE$.PropertiesOps(x$1).$plus$plus$eq(this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Seq)cfgs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps2 = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps2).asScala()).foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final HashMap config$1;

            public final Object apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.config$1.put((String)key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$1 = config$1;
            }
        });
        return var1_1;
    }

    public void waitForTopics(AdminClient client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, client, expectedPresent, expectedMissing){
            public static final long serialVersionUID = 0L;
            private final AdminClient client$1;
            private final Seq expectedPresent$1;
            private final Seq expectedMissing$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                java.util.Set topics = (java.util.Set)this.client$1.listTopics().names().get();
                return this.expectedPresent$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                }) && this.expectedMissing$1.forall((Function1)new Serializable(this, topics){
                    public static final long serialVersionUID = 0L;
                    private final java.util.Set topics$1;

                    public final boolean apply(String topicName) {
                        return !this.topics$1.contains(topicName);
                    }
                    {
                        this.topics$1 = topics$1;
                    }
                });
            }
            {
                this.client$1 = client$1;
                this.expectedPresent$1 = expectedPresent$1;
                this.expectedMissing$1 = expectedMissing$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for topics";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq(AdminClient.create(this.createConfig()));
        List brokerStrs = (List)Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(",")).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Node node) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava())}))).asJava()), new NewTopic("mytopic2", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        java.util.Map results = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$3) {
                return x$3.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$5) {
                return x$5.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicDescription topic1$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                TopicPartitionInfo partition = (TopicPartitionInfo)this.topic1$1.partitions().get(partitionId);
                Assert.assertEquals((long)partitionId, (long)partition.partition());
                Assert.assertEquals((long)3L, (long)partition.replicas().size());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCreateDeleteTopics$1 $outer;

                    public final void apply(Node replica) {
                        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                        Assert.assertTrue((replica.id() < this.$outer.kafka$api$AdminClientIntegrationTest$$anonfun$$$outer().brokerCount() ? 1 : 0) != 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$6) {
                        return x$6.id();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).distinct()).size());
                Assert.assertEquals((long)3L, (long)partition.isr().size());
                Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
                Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
            }

            public /* synthetic */ AdminClientIntegrationTest kafka$api$AdminClientIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
            }
        });
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final boolean apply(KafkaServer x$7) {
                return x$7.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected(this.$outer.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), (Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        java.util.Set expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava();
        Assert.assertEquals((Object)expectedOperations, (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 3, 3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<String>)Nil$.MODULE$);
        java.util.Map topicResult = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values();
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), (Object)((TopicDescription)((KafkaFuture)topicResult.get(topic)).get()).authorizedOperations());
        topicResult = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava(), new DescribeTopicsOptions().includeAuthorizedOperations(true)).values();
        expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Topic$.MODULE$.supportedOperations().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclOperation apply(Operation operation) {
                return operation.toJava();
            }
        }, Set$.MODULE$.canBuildFrom())).asJava();
        Assert.assertEquals((Object)expectedOperations, (Object)((TopicDescription)((KafkaFuture)topicResult.get(topic)).get()).authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return (scala.collection.immutable.Set)Cluster$.MODULE$.supportedOperations().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclOperation apply(Operation operation) {
                return operation.toJava();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$8) {
                return new NewTopic(x$8, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, nonExistingTopic, results){
            public static final long serialVersionUID = 0L;
            private final String nonExistingTopic$1;
            private final java.util.Map results$1;

            public final TopicDescription apply() {
                return (TopicDescription)((KafkaFuture)this.results$1.get(this.nonExistingTopic$1)).get();
            }
            {
                this.nonExistingTopic$1 = nonExistingTopic$1;
                this.results$1 = results$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)Predef$.MODULE$.refArrayOps((Object[])brokers).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1)new Serializable(this, brokers){
            public static final long serialVersionUID = 0L;
            private final String[] brokers$1;

            public final void apply(Node node) {
                String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)Predef$.MODULE$.refArrayOps((Object[])this.brokers$1).contains((Object)hostStr));
            }
            {
                this.brokers$1 = brokers$1;
            }
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int leaderId;
                    int n = leaderId = tuple2._2$mcI$sp();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(scala.collection.immutable.Map<Object, Object> x$9) {
                return x$9.keys().toSeq();
            }
        });
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$1) {
                return x$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this, topic, partitionsByBroker, logDirInfosByBroker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            public final String topic$1;
            private final scala.collection.immutable.Map partitionsByBroker$1;
            private final java.util.Map logDirInfosByBroker$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, brokerId){
                    public static final long serialVersionUID = 0L;
                    private final int brokerId$1;

                    public final boolean apply(KafkaServer x$10) {
                        return x$10.config().brokerId() == this.brokerId$1;
                    }
                    {
                        this.brokerId$1 = brokerId$1;
                    }
                }).get();
                Seq expectedPartitions = (Seq)this.partitionsByBroker$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
                java.util.Map logDirInfos = (java.util.Map)this.logDirInfosByBroker$1.get(BoxesRunTime.boxToInteger((int)brokerId));
                Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<TopicPartition, DescribeLogDirsResponse.ReplicaInfo> apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$3) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$3;
                        if (tuple2 != null) {
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                            return map;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDescribeLogDirs$1 $outer;

                    public final boolean apply(TopicPartition x$11) {
                        String string = x$11.topic();
                        String string2 = this.$outer.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(TopicPartition x$12) {
                        return x$12.partition();
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    public final KafkaServer server$1;

                    public final void apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$4) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String logDir = (String)tuple2._1();
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1)new Serializable(this, logDir){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeLogDirs$1$$anonfun$apply$mcVI$sp$4 $outer;
                                private final String logDir$1;

                                public final void apply(TopicPartition tp) {
                                    LogManager qual$1 = this.$outer.server$1.logManager();
                                    TopicPartition x$41 = tp;
                                    boolean x$42 = qual$1.getLog$default$2();
                                    Assert.assertEquals((Object)((Log)qual$1.getLog(x$41, x$42).get()).dir().getParent(), (Object)this.logDir$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.logDir$1 = logDir$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.server$1 = server$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partitionsByBroker$1 = partitionsByBroker$1;
                this.logDirInfosByBroker$1 = logDirInfosByBroker$1;
            }
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final TopicPartitionReplica apply(Tuple2<Object, Object> x0$5) {
                Tuple2<Object, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    int brokerId = tuple2._2$mcI$sp();
                    TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(this.topic$2, partition, brokerId);
                    return topicPartitionReplica;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> x0$6) {
                Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
                    DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
                    KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, topicPartitionReplica){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartitionReplica topicPartitionReplica$1;

                        public final boolean apply(KafkaServer x$13) {
                            return x$13.config().brokerId() == this.topicPartitionReplica$1.brokerId();
                        }
                        {
                            this.topicPartitionReplica$1 = topicPartitionReplica$1;
                        }
                    }).get();
                    TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
                    LogManager qual$2 = server.logManager();
                    TopicPartition x$43 = tp;
                    boolean x$44 = qual$2.getLog$default$2();
                    Assert.assertEquals((Object)((Log)qual$2.getLog(x$43, x$44).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<KafkaServer, Object> apply(KafkaServer server) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2)));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic, randomNums){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final scala.collection.immutable.Map randomNums$1;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)this.randomNums$1.apply((Object)server)))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.randomNums$1 = randomNums$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic, randomNums){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final scala.collection.immutable.Map randomNums$1;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)this.randomNums$1.apply((Object)server)))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.randomNums$1 = randomNums$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable futures = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values();
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaFuture<Void> future) {
                ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, future){
                    public static final long serialVersionUID = 0L;
                    private final KafkaFuture future$1;

                    public final Void apply() {
                        return (Void)this.future$1.get();
                    }
                    {
                        this.future$1 = future$1;
                    }
                }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
                Assert.assertTrue((boolean)(exception.getCause() instanceof UnknownTopicOrPartitionException));
            }
        });
        this.createTopic(topic, 1, this.brokerCount(), this.createTopic$default$4());
        this.servers().foreach((Function1)new Serializable(this, topic, tp, firstReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final TopicPartition tp$1;
            private final scala.collection.immutable.Map firstReplicaAssignment$1;

            public final void apply(KafkaServer server) {
                LogManager qual$3 = server.logManager();
                TopicPartition x$45 = this.tp$1;
                boolean x$46 = qual$3.getLog$default$2();
                String logDir = ((Log)qual$3.getLog(x$45, x$46).get()).dir().getParent();
                Assert.assertEquals((Object)this.firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.firstReplicaAssignment$1 = firstReplicaAssignment$1;
            }
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1)new Serializable(this, topic, tp, secondReplicaAssignment){
            public static final long serialVersionUID = 0L;
            public final String topic$3;
            public final TopicPartition tp$1;
            public final scala.collection.immutable.Map secondReplicaAssignment$1;

            public final void apply(KafkaServer server) {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$5 $outer;
                    private final KafkaServer server$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        LogManager qual$4 = this.server$2.logManager();
                        TopicPartition x$47 = this.$outer.tp$1;
                        boolean x$48 = qual$4.getLog$default$2();
                        String logDir = ((Log)qual$4.getLog(x$47, x$48).get()).dir().getParent();
                        Object object = this.$outer.secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.$outer.topic$3, 0, this.server$2.config().brokerId()));
                        String string = logDir;
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.server$2 = server$2;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "timed out waiting for replica movement";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.secondReplicaAssignment$1 = secondReplicaAssignment$1;
            }
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)new Serializable(this, topic, running, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String topic$3;
            private final AtomicBoolean running$1;
            private final AtomicInteger numMessages$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            /*
             * WARNING - void declaration
             */
            public int apply$mcI$sp() {
                int n;
                String x$49 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.$outer.servers(), this.$outer.securityProtocol());
                SecurityProtocol x$50 = this.$outer.securityProtocol();
                Option<File> x$51 = this.$outer.trustStoreFile();
                int x$52 = 0;
                int x$53 = 10000;
                int x$54 = -1;
                long x$55 = TestUtils$.MODULE$.createProducer$default$3();
                long x$56 = TestUtils$.MODULE$.createProducer$default$4();
                int x$57 = TestUtils$.MODULE$.createProducer$default$6();
                int x$58 = TestUtils$.MODULE$.createProducer$default$7();
                int x$59 = TestUtils$.MODULE$.createProducer$default$8();
                String x$60 = TestUtils$.MODULE$.createProducer$default$9();
                Option<Properties> x$61 = TestUtils$.MODULE$.createProducer$default$13();
                ByteArraySerializer x$62 = TestUtils$.MODULE$.createProducer$default$14();
                ByteArraySerializer x$63 = TestUtils$.MODULE$.createProducer$default$15();
                KafkaProducer<K, V> producer = TestUtils$.MODULE$.createProducer(x$49, x$54, x$55, x$56, x$52, x$57, x$58, x$59, x$60, x$53, x$50, x$51, x$61, x$62, x$63);
                try {
                    while (this.running$1.get()) {
                        Future future = producer.send(new ProducerRecord(this.topic$3, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.numMessages$1})).getBytes()));
                        this.numMessages$1.incrementAndGet();
                        future.get(10L, TimeUnit.SECONDS);
                    }
                    n = this.numMessages$1.get();
                }
                catch (Throwable throwable) {
                    void var1_16;
                    var1_16.close();
                    throw throwable;
                }
                producer.close();
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.running$1 = running$1;
                this.numMessages$1 = numMessages$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.numMessages$1.get() > 10;
                }
                {
                    this.numMessages$1 = numMessages$1;
                }
            }, (Function0<String>)new Serializable(this, numMessages, producerFuture){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final scala.concurrent.Future producerFuture$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced before timeout. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.numMessages$1, this.producerFuture$1.value()}));
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.producerFuture$1 = producerFuture$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1)new Serializable(this, topic, tp, firstReplicaAssignment, producerFuture){
                public static final long serialVersionUID = 0L;
                public final String topic$3;
                public final TopicPartition tp$1;
                public final scala.collection.immutable.Map firstReplicaAssignment$1;
                public final scala.concurrent.Future producerFuture$1;

                public final void apply(KafkaServer server) {
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$7 $outer;
                        private final KafkaServer server$3;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            LogManager qual$5 = this.server$3.logManager();
                            TopicPartition x$64 = this.$outer.tp$1;
                            boolean x$65 = qual$5.getLog$default$2();
                            String logDir = ((Log)qual$5.getLog(x$64, x$65).get()).dir().getParent();
                            Object object = this.$outer.firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.$outer.topic$3, 0, this.server$3.config().brokerId()));
                            String string = logDir;
                            return !(object != null ? !object.equals(string) : string != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.server$3 = server$3;
                        }
                    }, (Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$7 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerFuture$1.value()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                }
                {
                    this.topic$3 = topic$3;
                    this.tp$1 = tp$1;
                    this.firstReplicaAssignment$1 = firstReplicaAssignment$1;
                    this.producerFuture$1 = producerFuture$1;
                }
            });
            int currentMessagesNum = numMessages.get();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages, currentMessagesNum){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final int currentMessagesNum$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.numMessages$1.get() - this.currentMessagesNum$1 > 10;
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.currentMessagesNum$1 = currentMessagesNum$1;
                }
            }, (Function0<String>)new Serializable(this, numMessages, producerFuture, currentMessagesNum){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final scala.concurrent.Future producerFuture$1;
                private final int currentMessagesNum$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced within timeout after replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.numMessages$1.get() - this.currentMessagesNum$1)), this.producerFuture$1.value()}));
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.producerFuture$1 = producerFuture$1;
                    this.currentMessagesNum$1 = currentMessagesNum$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            running.set(false);
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.set(false);
            throw throwable;
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$66 = this.servers();
        String x$67 = topic;
        int x$68 = finalNumMessages;
        SecurityProtocol x$69 = this.securityProtocol();
        Option<File> x$70 = this.trustStoreFile();
        String x$71 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$72 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        Seq<ConsumerRecord<byte[], byte[]>> consumerRecords = TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$66, x$67, x$68, x$71, x$69, x$70, x$72);
        ((IterableLike)consumerRecords.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$7) {
                Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    ConsumerRecord consumerRecord = (ConsumerRecord)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), (Object)new String((byte[])consumerRecord.value()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType().toString(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava()).values().get(topic1)).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJava()).values().get(topic2)).get()).partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)3L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic2));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2);
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$14) {
                return x$14.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$15) {
                return x$15.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1)new Serializable(this, topic1, topic2, alterResult, altered, newPartition2Assignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String topic1$2;
            private final String topic2$1;
            private final ObjectRef alterResult$1;
            private final ObjectRef altered$1;
            private final java.util.List newPartition2Assignments$1;

            public final void apply(CreatePartitionsOptions option) {
                Object object;
                Object object2;
                String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is a decrease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when requesting a noop"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)this.newPartition2Assignments$1))}))).asJava(), option);
                try {
                    object2 = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                    object2 = BoxedUnit.UNIT;
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                try {
                    object = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic2$1));
                    object = BoxedUnit.UNIT;
                }
                String unknownTopic = "an-unknown-topic";
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(unknownTopic)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidTopicException when using an unknown topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
                    Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)executionException.getCause().getMessage());
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is invalid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when #brokers != replication factor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$2), (Object)NewPartitions.increaseTo((int)4, Collections.<T>emptyList()))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$2)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$AdminClientIntegrationTest$$numPartitions$1(this.topic1$2));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$2 = topic1$2;
                this.topic2$1 = topic2$1;
                this.alterResult$1 = alterResult$1;
                this.altered$1 = altered$1;
                this.newPartition2Assignments$1 = newPartition2Assignments$1;
            }
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        Assert.assertEquals((long)4L, (long)this.kafka$api$AdminClientIntegrationTest$$numPartitions$1(topic1));
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            Assert.fail((String)"Expect InvalidTopicException when the topic is queued for deletion");
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)executionException.getCause().getMessage());
        }
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.killBroker(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, result, lowWatermark){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final ObjectRef result$1;
            private final ObjectRef lowWatermark$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Throwable throwable2;
                block2: {
                    boolean bl;
                    this.result$1.elem = this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
                    this.lowWatermark$1.elem = None$.MODULE$;
                    KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)this.result$1.elem).lowWatermarks().get(this.$outer.topicPartition());
                    try {
                        this.lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
                        bl = ((Option)this.lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
                    }
                    catch (Throwable throwable2) {
                        boolean bl2;
                        ExecutionException executionException;
                        Throwable throwable3 = throwable2;
                        if (!(throwable3 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable3).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) break block2;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                throw throwable2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.lowWatermark$1 = lowWatermark$1;
            }
        }, (Function0<String>)new Serializable(this, lowWatermark){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lowWatermark$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected low watermark of the partition to be 5 but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.lowWatermark$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "no response within the timeout";
                    }
                })}));
            }
            {
                this.lowWatermark$1 = lowWatermark$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        scala.collection.immutable.Map<Object, Object> leaders = this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int followerIndex = BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result1 = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava());
        result1.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this, expectedLEO){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int expectedLEO$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset());
                Assert.assertEquals((long)this.expectedLEO$1, (long)((Replica)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logEndOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedLEO$1 = expectedLEO$1;
            }
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, futureLogDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final String futureLogDir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.futureLogDir$1;
                LogManager qual$6 = ((KafkaServer)this.$outer.servers().apply(0)).logManager();
                TopicPartition x$73 = this.$outer.topicPartition();
                boolean x$74 = qual$6.getLog$default$2();
                String string2 = ((Log)qual$6.getLog(x$73, x$74).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.futureLogDir$1 = futureLogDir$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for replica movement";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Replica)((KafkaServer)this.servers().apply(0)).replicaManager().localReplica(this.topicPartition()).get()).logEndOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        result.all().get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava());
        result.all().get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        boolean messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 10, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 7, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;

            public final DeletedRecords apply() {
                return (DeletedRecords)((KafkaFuture)this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.$outer.topicPartition())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, nonExistPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicPartition nonExistPartition$1;

            public final DeletedRecords apply() {
                return (DeletedRecords)((KafkaFuture)this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.nonExistPartition$1), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.nonExistPartition$1)).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nonExistPartition$1 = nonExistPartition$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(AdminClient.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, nonExistentTopic, describeResult1){
            public static final long serialVersionUID = 0L;
            private final ConfigResource nonExistentTopic$1;
            private final DescribeConfigsResult describeResult1$1;

            public final Config apply() {
                return (Config)((KafkaFuture)this.describeResult1$1.values().get(this.nonExistentTopic$1)).get();
            }
            {
                this.nonExistentTopic$1 = nonExistentTopic$1;
                this.describeResult1$1 = describeResult1$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidTopic, describeResult2){
            public static final long serialVersionUID = 0L;
            private final ConfigResource invalidTopic$1;
            private final DescribeConfigsResult describeResult2$1;

            public final Config apply() {
                return (Config)((KafkaFuture)this.describeResult2$1.values().get(this.invalidTopic$1)).get();
            }
            {
                this.invalidTopic$1 = invalidTopic$1;
                this.describeResult2$1 = describeResult2$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1017))).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.consumer$1.assignment().isEmpty();
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final KafkaProducer producer$1;
            private final TopicPartition topicPartition$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.topicPartition$1.topic(), Predef$.MODULE$.int2Integer(this.topicPartition$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0<String>)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return this.producer$1.send(record);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.topicPartition$1 = topicPartition$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$16) {
                return x$16.get();
            }
        });
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    public AclBinding ACL1() {
        return this.ACL1;
    }

    @Test
    public void testAclOperations() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(this.ACL1())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(this.ACL1().toFilter())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$17) {
                return new NewTopic(x$17, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.IncorrectBrokerPort())})));
        this.client_$eq(AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$18) {
                return new NewTopic(x$18, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.IncorrectBrokerPort())})));
        config.put("request.timeout.ms", "0");
        this.client_$eq(AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$19) {
                return new NewTopic(x$19, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("request.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((AdminClient)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$20) {
                return new NewTopic(x$20, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$21) {
                return new NewTopic(x$21, 1, 1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testConsumerGroups() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testElectPreferredLeaders() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        Seq prefer0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq prefer1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Seq prefer2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)prefer0)}))), (Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)prefer0)}))), (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((long)0L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1));
        Assert.assertEquals((long)0L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2));
        ObjectRef electResult = ObjectRef.create((Object)this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition1})));
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        Assert.assertEquals((long)0L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1));
        electResult.elem = this.client().electPreferredLeaders(null);
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        Assert.assertEquals((long)0L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1));
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition2).get();
        Assert.assertEquals((long)0L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2));
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition1}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        this.waitForLeaderToBecome$1(partition1, 1);
        Throwable e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, partition2, electResult){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition2$1;
            private final ObjectRef electResult$1;

            public final Void apply() {
                return (Void)((ElectPreferredLeadersResult)this.electResult$1.elem).partitionResult(this.partition2$1).get();
            }
            {
                this.partition2$1 = partition2$1;
                this.electResult$1 = electResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330))).getCause();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getClass());
        Assert.assertEquals((Object)"Preferred leader election for partition \"elect-preferred-leaders-topic-2-0\" was not attempted", (Object)e.getMessage());
        Assert.assertEquals((long)0L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2));
        electResult.elem = this.client().electPreferredLeaders(null);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)((ElectPreferredLeadersResult)electResult.elem).partitions().get()).asScala()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TopicPartition x$23) {
                String string = x$23.topic();
                String string2 = "__consumer_offsets";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition1).get();
        this.waitForLeaderToBecome$1(partition1, 1);
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition2).get();
        this.waitForLeaderToBecome$1(partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{unknownPartition}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, electResult, unknownPartition){
            public static final long serialVersionUID = 0L;
            private final ObjectRef electResult$1;
            private final TopicPartition unknownPartition$1;

            public final Void apply() {
                return (Void)((ElectPreferredLeadersResult)this.electResult$1.elem).partitionResult(this.unknownPartition$1).get();
            }
            {
                this.electResult$1 = electResult$1;
                this.unknownPartition$1 = unknownPartition$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1348))).getCause();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)e.getMessage());
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1));
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2));
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{unknownPartition, partition1}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        this.waitForLeaderToBecome$1(partition1, 2);
        Assert.assertEquals((long)1L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2));
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, electResult, unknownPartition){
            public static final long serialVersionUID = 0L;
            private final ObjectRef electResult$1;
            private final TopicPartition unknownPartition$1;

            public final Void apply() {
                return (Void)((ElectPreferredLeadersResult)this.electResult$1.elem).partitionResult(this.unknownPartition$1).get();
            }
            {
                this.electResult$1 = electResult$1;
                this.unknownPartition$1 = unknownPartition$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1362))).getCause();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)e.getMessage());
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition2, partition2}));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        ((ElectPreferredLeadersResult)electResult.elem).partitionResult(partition2).get();
        this.waitForLeaderToBecome$1(partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition1, partition2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                java.util.Map description = (java.util.Map)this.$outer.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.partition1$1.topic(), this.partition2$1.topic()}))).asJava()).all().get();
                Iterable isr = (Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(description).asScala()).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Buffer<Node> apply(TopicDescription x$24) {
                        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$24.partitions()).asScala()).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Buffer<Node> apply(TopicPartitionInfo x$25) {
                                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$25.isr()).asScala();
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom());
                return !isr.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Node x$26) {
                        return x$26.id() == 1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expect broker 1 to no longer be in any ISR";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        ElectPreferredLeadersOptions shortTimeout = (ElectPreferredLeadersOptions)new ElectPreferredLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult.elem = this.client().electPreferredLeaders(Arrays.asList((Object[])new TopicPartition[]{partition1}), shortTimeout);
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), (Object)((ElectPreferredLeadersResult)electResult.elem).partitions().get());
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, partition1, electResult){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition1$1;
            private final ObjectRef electResult$1;

            public final Void apply() {
                return (Void)((ElectPreferredLeadersResult)this.electResult$1.elem).partitionResult(this.partition1$1).get();
            }
            {
                this.partition1$1 = partition1$1;
                this.electResult$1 = electResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})), (boolean)e.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        Assert.assertEquals((long)2L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1));
        electResult.elem = this.client().electPreferredLeaders(null, shortTimeout);
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, electResult){
            public static final long serialVersionUID = 0L;
            private final ObjectRef electResult$1;

            public final java.util.Set<TopicPartition> apply() {
                return (java.util.Set)((ElectPreferredLeadersResult)this.electResult$1.elem).partitions().get();
            }
            {
                this.electResult$1 = electResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, partition1, electResult){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition1$1;
            private final ObjectRef electResult$1;

            public final Void apply() {
                return (Void)((ElectPreferredLeadersResult)this.electResult$1.elem).partitionResult(this.partition1$1).get();
            }
            {
                this.partition1$1 = partition1$1;
                this.electResult$1 = electResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})), (boolean)e.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        e = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, partition2, electResult){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition2$1;
            private final ObjectRef electResult$1;

            public final Void apply() {
                return (Void)((ElectPreferredLeadersResult)this.electResult$1.elem).partitionResult(this.partition2$1).get();
            }
            {
                this.partition2$1 = partition2$1;
                this.electResult$1 = electResult$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402))).getCause();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, e.getClass());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})), (boolean)e.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        Assert.assertEquals((long)2L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1));
        Assert.assertEquals((long)2L, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2));
    }

    @Test
    public void testValidIncrementalAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000))).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        alterResult.all().get();
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testInvalidIncrementalAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND)}))).asJavaCollection();
        topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT)}))).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testLongTopicNames() {
        AdminClient client = AdminClient.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        Seq newTopics2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(invalidTopicName, 3, 3), new NewTopic(longTopicName, 3, 3)}));
        java.util.Map results = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics2).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assert.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0)), ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0))}))).asJava()).all(), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        client.close();
    }

    private final java.util.List partitions$1(String topic) {
        return ((TopicDescription)((KafkaFuture)this.client().describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).values().get(topic)).get()).partitions();
    }

    public final int kafka$api$AdminClientIntegrationTest$$numPartitions$1(String topic) {
        return this.partitions$1(topic).size();
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int followerIndex$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option option = ((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localReplica(this.$outer.topicPartition());
                None$ none$ = None$.MODULE$;
                return option != null ? !option.equals(none$) : none$ != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected follower to create replica for partition";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1, expectedStartOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int followerIndex$1;
            private final long expectedStartOffset$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logStartOffset() == this.expectedStartOffset$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
                this.expectedStartOffset$1 = expectedStartOffset$1;
            }
        }, (Function0<String>)new Serializable(this, expectedStartOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedStartOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected follower to discover new log start offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedStartOffset$1)}));
            }
            {
                this.expectedStartOffset$1 = expectedStartOffset$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1, expectedEndOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final int followerIndex$1;
            private final long expectedEndOffset$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Replica)((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localReplica(this.$outer.topicPartition()).get()).logEndOffset() == this.expectedEndOffset$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
                this.expectedEndOffset$1 = expectedEndOffset$1;
            }
        }, (Function0<String>)new Serializable(this, expectedEndOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedEndOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected follower to catch up to log end offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedEndOffset$1)}));
            }
            {
                this.expectedEndOffset$1 = expectedEndOffset$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public final int kafka$api$AdminClientIntegrationTest$$currentLeader$1(TopicPartition topicPartition) {
        return ((TopicPartitionInfo)((TopicDescription)((KafkaFuture)this.client().describeTopics(Arrays.asList((Object[])new String[]{topicPartition.topic()})).values().get(topicPartition.topic())).get()).partitions().get(topicPartition.partition())).leader().id();
    }

    public final int kafka$api$AdminClientIntegrationTest$$preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)((TopicDescription)((KafkaFuture)this.client().describeTopics(Arrays.asList((Object[])new String[]{topicPartition.topic()})).values().get(topicPartition.topic())).get()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    private final void waitForLeaderToBecome$1(TopicPartition topicPartition, int leader2) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, leader2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicPartition topicPartition$2;
            private final int leader$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$AdminClientIntegrationTest$$currentLeader$1(this.topicPartition$2) == this.leader$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.leader$1 = leader$1;
            }
        }, (Function0<String>)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected leader to become ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leader$1)}));
            }
            {
                this.leader$1 = leader$1;
            }
        }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private final void changePreferredLeader$1(Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1$1);
        int prior2 = this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2$1);
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1$1), (Object)newAssignment));
        }
        if (prior2 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2$1), (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment(m);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition1$1, partition2$1, preferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final int preferred$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$AdminClientIntegrationTest$$preferredLeader$1(this.partition1$1) == this.preferred$1 && this.$outer.kafka$api$AdminClientIntegrationTest$$preferredLeader$1(this.partition2$1) == this.preferred$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.preferred$1 = preferred$1;
            }
        }, (Function0<String>)new Serializable(this, partition1$1, partition2$1, preferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminClientIntegrationTest $outer;
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final int preferred$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected preferred leader to become ", ", but is ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.preferred$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$api$AdminClientIntegrationTest$$preferredLeader$1(this.partition1$1)), BoxesRunTime.boxToInteger((int)this.$outer.kafka$api$AdminClientIntegrationTest$$preferredLeader$1(this.partition2$1))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.preferred$1 = preferred$1;
            }
        }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)prior1, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition1$1));
        Assert.assertEquals((long)prior2, (long)this.kafka$api$AdminClientIntegrationTest$$currentLeader$1(partition2$1));
    }

    public AdminClientIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
        this.brokerCount = 3;
        this.consumerCount = 1;
        this.producerCount = 1;
    }
}

