/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Collections;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.IntegrationTestHarness;
import kafka.coordinator.group.GroupOverview;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T3hC\u000eL\u0018\tZ7j]\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"!\u0004\t\u000e\u00039Q!a\u0004\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Eq!a\u0002'pO\u001eLgn\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"!\u0003\u0001\t\u000f]\u0001!\u0019!C\u00011\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0004\u0013:$\bB\u0002\u0011\u0001A\u0003%\u0011$\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f\t\u0002!\u0019!C\u00011\u0005i1m\u001c8tk6,'oQ8v]RDa\u0001\n\u0001!\u0002\u0013I\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bM\u0001\u0011\r\u0011\"\u0001\u0019\u0003-\u0011'o\\6fe\u000e{WO\u001c;\t\r!\u0002\u0001\u0015!\u0003\u001a\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011\u001dQ\u0003A1A\u0005\u0002-\nqa\u001a:pkBLE-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0007BB\u001b\u0001A\u0003%A&\u0001\u0005he>,\b/\u00133!\u0011\u001d9\u0004A1A\u0005\u0002-\n\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u001e\u0001\u0005\u0004%\taK\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0007{\u0001\u0001\u000b\u0011\u0002\u0017\u0002\rQ|\u0007/[2!\u0011\u001dy\u0004A1A\u0005\u0002a\tA\u0001]1si\"1\u0011\t\u0001Q\u0001\ne\tQ\u0001]1si\u0002Bqa\u0011\u0001C\u0002\u0013\u0005A)\u0001\u0002uaV\tQ\t\u0005\u0002G\u001d6\tqI\u0003\u0002I\u0013\u000611m\\7n_:T!!\u0002&\u000b\u0005-c\u0015AB1qC\u000eDWMC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u001e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004R\u0001\u0001\u0006I!R\u0001\u0004iB\u0004\u0003bB*\u0001\u0005\u0004%\t\u0001G\u0001\u0006a\u0006\u0014HO\r\u0005\u0007+\u0002\u0001\u000b\u0011B\r\u0002\rA\f'\u000f\u001e\u001a!\u0011\u001d9\u0006A1A\u0005\u0002\u0011\u000b1\u0001\u001e93\u0011\u0019I\u0006\u0001)A\u0005\u000b\u0006!A\u000f\u001d\u001a!\u0011\u001dY\u0006\u00011A\u0005\u0002q\u000baa\u00197jK:$X#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0011!B1e[&t\u0017B\u00012`\u0005-\tE-\\5o\u00072LWM\u001c;\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u0006Q1\r\\5f]R|F%Z9\u0015\u0005\u0019L\u0007C\u0001\u000eh\u0013\tA7D\u0001\u0003V]&$\bb\u00026d\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\n\u0004B\u00027\u0001A\u0003&Q,A\u0004dY&,g\u000e\u001e\u0011\t\u000b9\u0004A\u0011I8\u0002\u000bM,G/\u00169\u0015\u0003\u0019D#!\\9\u0011\u0005I,X\"A:\u000b\u0005Qd\u0015!\u00026v]&$\u0018B\u0001<t\u0005\u0019\u0011UMZ8sK\")\u0001\u0010\u0001C!_\u0006AA/Z1s\t><h\u000e\u000b\u0002xuB\u0011!o_\u0005\u0003yN\u0014Q!\u00114uKJDQA \u0001\u0005\u0002=\fQ\u0005^3ti>3gm]3ug\u001a{'\u000fV5nKN<\u0006.\u001a8PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3)\u0007u\f\t\u0001E\u0002s\u0003\u0007I1!!\u0002t\u0005\u0011!Vm\u001d;\t\r\u0005%\u0001\u0001\"\u0001p\u00039!Xm\u001d;MSN$xI]8vaNDC!a\u0002\u0002\u0002!1\u0011q\u0002\u0001\u0005\u0002=\fA\u0004^3ti2K7\u000f^!mY\n\u0013xn[3s-\u0016\u00148/[8o\u0013:4w\u000e\u000b\u0003\u0002\u000e\u0005\u0005\u0001BBA\u000b\u0001\u0011\u0005q.A\u000euKN$x)\u001a;D_:\u001cX/\\3s\u000fJ|W\u000f]*v[6\f'/\u001f\u0015\u0005\u0003'\t\t\u0001\u0003\u0004\u0002\u001c\u0001!\ta\\\u0001\u001ai\u0016\u001cH\u000fR3tGJL'-Z\"p]N,X.\u001a:He>,\b\u000f\u000b\u0003\u0002\u001a\u0005\u0005\u0001BBA\u0011\u0001\u0011\u0005q.\u0001\u0017uKN$H)Z:de&\u0014WmQ8ogVlWM]$s_V\u0004hi\u001c:O_:,\u00050[:uK:$xI]8va\"\"\u0011qDA\u0001\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\tQd];cg\u000e\u0014\u0018NY3B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\u0006M\u0006-\u0012\u0011\b\u0005\bw\u0005\u0015\u0002\u0019AA\u0017!\u0011\ty#!\u000e\u000f\u0007i\t\t$C\u0002\u00024m\ta\u0001\u0015:fI\u00164\u0017bA\u001a\u00028)\u0019\u00111G\u000e\t\u0011\u0005m\u0012Q\u0005a\u0001\u0003{\t\u0001bY8ogVlWM\u001d\t\t\u0003\u007f\t9%a\u0013\u0002L5\u0011\u0011\u0011\t\u0006\u0005\u0003w\t\u0019EC\u0002\u0002F%\u000bqa\u00197jK:$8/\u0003\u0003\u0002J\u0005\u0005#!D&bM.\f7i\u001c8tk6,'\u000fE\u0003\u001b\u0003\u001b\n\t&C\u0002\u0002Pm\u0011Q!\u0011:sCf\u00042AGA*\u0013\r\t)f\u0007\u0002\u0005\u0005f$X\rK\u0004\u0001\u00033\ny&a\u0019\u0011\u0007i\tY&C\u0002\u0002^m\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\t\t'A1UQ\u0016\u00043kY1mC\u0002\nE-\\5o\u00072LWM\u001c;!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011j]\u00022\u0017M^8ve\u0002zg\rI8sO:\n\u0007/Y2iK:Z\u0017MZ6b]\rd\u0017.\u001a8ug:\nG-\\5o]\u0005#W.\u001b8DY&,g\u000e^\u0011\u0003\u0003K\na\u0001\r\u00182c9\u0002\u0004")
public class LegacyAdminClientTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String groupId;
    private final String clientId;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private AdminClient client = null;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.client_$eq(AdminClient$.MODULE$.createSimplePlaintext(this.brokerList()));
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        this.client().close();
        super.tearDown();
    }

    @Test
    public void testOffsetsForTimesWhenOffsetNotFound() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)0L)}))).asJava()).get(this.tp()));
    }

    @Test
    public void testListGroups() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        List groups = this.client().listAllGroupsFlattened();
        Assert.assertFalse((boolean)groups.isEmpty());
        GroupOverview group = (GroupOverview)groups.head();
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
    }

    @Test
    public void testListAllBrokerVersionInfo() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        scala.collection.immutable.Map brokerVersionInfos = this.client().listAllBrokerVersionInfo();
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)Predef$.MODULE$.refArrayOps((Object[])brokers).size(), (long)brokerVersionInfos.size());
        brokerVersionInfos.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Node, Try<NodeApiVersions>> check$ifrefutable$1) {
                Tuple2<Node, Try<NodeApiVersions>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, brokers){
            public static final long serialVersionUID = 0L;
            private final String[] brokers$1;

            public final void apply(Tuple2<Node, Try<NodeApiVersions>> x$1) {
                Tuple2<Node, Try<NodeApiVersions>> tuple2 = x$1;
                if (tuple2 != null) {
                    Node node = (Node)tuple2._1();
                    Try tryBrokerVersionInfo = (Try)tuple2._2();
                    String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)Predef$.MODULE$.refArrayOps((Object[])this.brokers$1).contains((Object)hostStr));
                    NodeApiVersions brokerVersionInfo = (NodeApiVersions)tryBrokerVersionInfo.get();
                    Assert.assertEquals((long)2L, (long)brokerVersionInfo.latestUsableVersion(ApiKeys.API_VERSIONS));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.brokers$1 = brokers$1;
            }
        });
    }

    @Test
    public void testGetConsumerGroupSummary() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        AdminClient qual$1 = this.client();
        String x$3 = this.groupId();
        long x$4 = qual$1.describeConsumerGroup$default$2();
        AdminClient.ConsumerGroupSummary group = qual$1.describeConsumerGroup(x$3, x$4);
        Assert.assertEquals((Object)"range", (Object)group.assignmentStrategy());
        Assert.assertEquals((Object)"Stable", (Object)group.state());
        Assert.assertFalse((boolean)group.consumers().isEmpty());
        AdminClient.ConsumerSummary member = (AdminClient.ConsumerSummary)((IterableLike)group.consumers().get()).head();
        Assert.assertEquals((Object)this.clientId(), (Object)member.clientId());
        Assert.assertFalse((boolean)member.host().isEmpty());
        Assert.assertFalse((boolean)member.consumerId().isEmpty());
    }

    @Test
    public void testDescribeConsumerGroup() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        AdminClient qual$2 = this.client();
        String x$5 = this.groupId();
        long x$6 = qual$2.describeConsumerGroup$default$2();
        AdminClient.ConsumerGroupSummary consumerGroupSummary = qual$2.describeConsumerGroup(x$5, x$6);
        Assert.assertEquals((long)1L, (long)((SeqLike)consumerGroupSummary.consumers().get()).size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)((List)consumerGroupSummary.consumers().get()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<TopicPartition> apply(AdminClient.ConsumerSummary x$2) {
                return x$2.assignment();
            }
        }, List$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDescribeConsumerGroupForNonExistentGroup() {
        String nonExistentGroup = new StringBuilder().append((Object)"non").append((Object)this.groupId()).toString();
        AdminClient qual$3 = this.client();
        String x$7 = nonExistentGroup;
        long x$8 = qual$3.describeConsumerGroup$default$2();
        Assert.assertTrue((String)"Expected empty ConsumerSummary list", (boolean)((SeqLike)qual$3.describeConsumerGroup(x$7, x$8).consumers().get()).isEmpty());
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumer$1.poll(0L);
                return !this.consumer$1.assignment().isEmpty();
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public LegacyAdminClientTest() {
        this.producerCount = 1;
        this.consumerCount = 2;
        this.brokerCount = 3;
        this.groupId = "my-test";
        this.clientId = "consumer-498";
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.consumerConfig().setProperty("client.id", this.clientId());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }
}

