/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001\u001d\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\t!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{KV\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012a\u00059s_\u0012,8-\u001a:Ck\u001a4WM]*ju\u0016\u0004\u0003bB\u0010\u0001\u0005\u0004%I!F\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0011\u0019\t\u0003\u0001)A\u0005-\u000512/\u001a:wKJlUm]:bO\u0016l\u0015\r\u001f\"zi\u0016\u001c\b\u0005C\u0004$\u0001\t\u0007I\u0011B\u000b\u0002;I,\u0007\u000f\\5dC\u001a+Go\u00195NCb\u0004\u0016M\u001d;ji&|gNQ=uKNDa!\n\u0001!\u0002\u00131\u0012A\b:fa2L7-\u0019$fi\u000eDW*\u0019=QCJ$\u0018\u000e^5p]\nKH/Z:!\u0011\u001d9\u0003A1A\u0005\nU\tAD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f*fgB|gn]3CsR,7\u000f\u0003\u0004*\u0001\u0001\u0006IAF\u0001\u001ee\u0016\u0004H.[2b\r\u0016$8\r['bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3tA!91\u0006\u0001b\u0001\n\u0003)\u0012A\u00038v[N+'O^3sg\"1Q\u0006\u0001Q\u0001\nY\t1B\\;n'\u0016\u0014h/\u001a:tA!9q\u0006\u0001b\u0001\n\u0003\u0001\u0014aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000f\u0001!\u0002\u0013\t\u0014\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u0015a\u0004\u0001\"\u0001>\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001 \u0011\u0007}:%J\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IB\u0001\u0007yI|w\u000e\u001e \n\u0003eI!A\u0012\r\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$\u0019!\tYe*D\u0001M\u0015\tiE!\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u00131bS1gW\u0006\u001cuN\u001c4jO\"9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0016!\u00039s_\u0012,8-\u001a:2+\u0005\u0019\u0006\u0003\u0002+_A\u0002l\u0011!\u0016\u0006\u0003-^\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u00031f\u000bqa\u00197jK:$8O\u0003\u0002\u00065*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyVKA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004/\u0005\u001c\u0017B\u00012\u0019\u0005\u0015\t%O]1z!\t9B-\u0003\u0002f1\t!!)\u001f;f\u0011\u001d9\u0007\u00011A\u0005\n!\fQ\u0002\u001d:pIV\u001cWM]\u0019`I\u0015\fHCA5m!\t9\".\u0003\u0002l1\t!QK\\5u\u0011\u001dig-!AA\u0002M\u000b1\u0001\u001f\u00132\u0011\u0019y\u0007\u0001)Q\u0005'\u0006Q\u0001O]8ek\u000e,'/\r\u0011\t\u000fE\u0004\u0001\u0019!C\u0005%\u0006I\u0001O]8ek\u000e,'O\r\u0005\bg\u0002\u0001\r\u0011\"\u0003u\u00035\u0001(o\u001c3vG\u0016\u0014(g\u0018\u0013fcR\u0011\u0011.\u001e\u0005\b[J\f\t\u00111\u0001T\u0011\u00199\b\u0001)Q\u0005'\u0006Q\u0001O]8ek\u000e,'O\r\u0011\t\u000fe\u0004\u0001\u0019!C\u0005%\u0006I\u0001O]8ek\u000e,'o\r\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u00035\u0001(o\u001c3vG\u0016\u00148g\u0018\u0013fcR\u0011\u0011. \u0005\b[j\f\t\u00111\u0001T\u0011\u0019y\b\u0001)Q\u0005'\u0006Q\u0001O]8ek\u000e,'o\r\u0011\t\u0011\u0005\r\u0001\u00011A\u0005\nI\u000b\u0011\u0002\u001d:pIV\u001cWM\u001d\u001b\t\u0013\u0005\u001d\u0001\u00011A\u0005\n\u0005%\u0011!\u00049s_\u0012,8-\u001a:5?\u0012*\u0017\u000fF\u0002j\u0003\u0017A\u0001\"\\A\u0003\u0003\u0003\u0005\ra\u0015\u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003T\u0003)\u0001(o\u001c3vG\u0016\u0014H\u0007\t\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+\ta\u0001^8qS\u000e\fTCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fk\u0005!A.\u00198h\u0013\u0011\t\t#a\u0007\u0003\rM#(/\u001b8h\u0011!\t)\u0003\u0001Q\u0001\n\u0005]\u0011a\u0002;pa&\u001c\u0017\u0007\t\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003+\ta\u0001^8qS\u000e\u0014\u0004\u0002CA\u0017\u0001\u0001\u0006I!a\u0006\u0002\u000fQ|\u0007/[23A!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0012!B:fiV\u0003H#A5)\t\u0005=\u0012q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b/\u0002\u000b),h.\u001b;\n\t\u0005\u0005\u00131\b\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u00024\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002D\u0005%\u0003\u0003BA\u001d\u0003\u0017JA!!\u0014\u0002<\t)\u0011I\u001a;fe\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0012!\b;fgR$vn\u001c'be\u001e,'+Z2pe\u0012<\u0016\u000e\u001e5BG.TVM]8)\t\u0005=\u0013Q\u000b\t\u0005\u0003s\t9&\u0003\u0003\u0002Z\u0005m\"\u0001\u0002+fgRDq!!\u0018\u0001\t\u0003\t\u0019$\u0001\u000fuKN$Hk\\8MCJ<WMU3d_J$w+\u001b;i\u0003\u000e\\wJ\\3)\t\u0005m\u0013Q\u000b\u0005\b\u0003G\u0002A\u0011BA3\u0003-\u001a\u0007.Z2l)>|G*\u0019:hKJ+7m\u001c:e\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGcA5\u0002h!9\u0011\u0011NA1\u0001\u00041\u0012\u0001D7bq\u001a+Go\u00195TSj,\u0007bBA7\u0001\u0011\u0005\u00111G\u0001.i\u0016\u001cH\u000fU1si&$\u0018n\u001c8U_>d\u0015M]4f\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032d\u0007\u0006BA6\u0003+Bq!a\u001d\u0001\t\u0003\t\u0019$\u0001\u0017uKN$(+Z:q_:\u001cX\rV8p\u0019\u0006\u0014x-\u001a$peJ+\u0007\u000f\\5dCRLwN\\,ji\"\f5m[!mY\"\"\u0011\u0011OA+\u0011\u001d\tI\b\u0001C\u0001\u0003g\tA\u0003^3ti:{g.\u0012=jgR,g\u000e\u001e+pa&\u001c\u0007\u0006BA<\u0003+Bq!a \u0001\t\u0003\t\u0019$A\nuKN$xK]8oO\n\u0013xn[3s\u0019&\u001cH\u000f\u000b\u0003\u0002~\u0005U\u0003bBAC\u0001\u0011\u0005\u00111G\u0001\u0015i\u0016\u001cH/\u00138wC2LG\rU1si&$\u0018n\u001c8)\t\u0005\r\u0015Q\u000b\u0005\b\u0003\u0017\u0003A\u0011AA\u001a\u0003M!Xm\u001d;TK:$\u0017I\u001a;fe\u000ecwn]3eQ\u0011\tI)!\u0016\t\u000f\u0005E\u0005\u0001\"\u0001\u00024\u0005iB/Z:u\u0007\u0006tgn\u001c;TK:$Gk\\%oi\u0016\u0014h.\u00197U_BL7\r\u000b\u0003\u0002\u0010\u0006U\u0003bBAL\u0001\u0011\u0005\u00111G\u0001\u0016i\u0016\u001cHOT8u\u000b:|Wo\u001a5SKBd\u0017nY1tQ\u0011\t)*!\u0016\t\u000f\u0005u\u0005\u0001\"\u0001\u00024\u0005AC/Z:u\u001d>$XI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c\u0018I\u001a;fe\n\u0013xn[3s'\",H\u000fZ8x]\"\"\u00111TA+\u0001")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer1;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer2;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer3;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer4;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$2 = this.brokerList();
        int x$3 = 0;
        int x$4 = 0;
        int x$5 = 30000;
        long x$6 = 10000L;
        long x$7 = this.producerBufferSize();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$12 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$13 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$14 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$16 = TestUtils$.MODULE$.createProducer$default$15();
        this.kafka$api$ProducerFailureHandlingTest$$producer1_$eq(TestUtils$.MODULE$.createProducer(x$2, x$3, x$6, x$7, x$4, x$8, x$9, x$10, x$11, x$5, x$12, x$13, x$14, x$15, x$16));
        String x$17 = this.brokerList();
        int x$18 = 1;
        int x$19 = 0;
        int x$20 = 30000;
        long x$21 = 10000L;
        long x$22 = this.producerBufferSize();
        int x$23 = TestUtils$.MODULE$.createProducer$default$6();
        int x$24 = TestUtils$.MODULE$.createProducer$default$7();
        int x$25 = TestUtils$.MODULE$.createProducer$default$8();
        String x$26 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$27 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$28 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$29 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$30 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$31 = TestUtils$.MODULE$.createProducer$default$15();
        this.kafka$api$ProducerFailureHandlingTest$$producer2_$eq(TestUtils$.MODULE$.createProducer(x$17, x$18, x$21, x$22, x$19, x$23, x$24, x$25, x$26, x$20, x$27, x$28, x$29, x$30, x$31));
        String x$32 = this.brokerList();
        int x$33 = -1;
        int x$34 = 0;
        int x$35 = 30000;
        long x$36 = 10000L;
        long x$37 = this.producerBufferSize();
        int x$38 = TestUtils$.MODULE$.createProducer$default$6();
        int x$39 = TestUtils$.MODULE$.createProducer$default$7();
        int x$40 = TestUtils$.MODULE$.createProducer$default$8();
        String x$41 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$42 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$43 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$44 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$45 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$46 = TestUtils$.MODULE$.createProducer$default$15();
        this.kafka$api$ProducerFailureHandlingTest$$producer3_$eq(TestUtils$.MODULE$.createProducer(x$32, x$33, x$36, x$37, x$34, x$38, x$39, x$40, x$41, x$35, x$42, x$43, x$44, x$45, x$46));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$api$ProducerFailureHandlingTest$$producer1() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer1().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer2() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer2().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer3() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer4() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer4().close();
        }
        super.tearDown();
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        String x$47 = this.topic1();
        int x$48 = this.numServers();
        int x$49 = this.createTopic$default$2();
        Properties x$50 = this.createTopic$default$4();
        this.createTopic(x$47, x$49, x$48, x$50);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        Assert.assertNotNull((Object)recordMetadata);
        Assert.assertFalse((boolean)recordMetadata.hasOffset());
        Assert.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        String x$51 = this.topic1();
        int x$52 = this.numServers();
        int x$53 = this.createTopic$default$2();
        Properties x$54 = this.createTopic$default$4();
        this.createTopic(x$51, x$53, x$52, x$54);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$1).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$1 = record$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)maxMessageSize)).toString());
        String topic10 = "topic10";
        this.createTopic(topic10, this.servers().size(), this.numServers(), topicConfig);
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        Assert.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$2;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$2).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
    }

    @Test
    public void testWrongBrokerList() {
        String x$55 = this.topic1();
        int x$56 = this.numServers();
        int x$57 = this.createTopic$default$2();
        Properties x$58 = this.createTopic$default$4();
        this.createTopic(x$55, x$57, x$56, x$58);
        this.kafka$api$ProducerFailureHandlingTest$$producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$3;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer4().send(this.record$3).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$3 = record$3;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    @Test
    public void testInvalidPartition() {
        this.createTopic(this.topic1(), 1, this.numServers(), this.createTopic$default$4());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        Throwable throwable = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, higherRecord){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord higherRecord$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.higherRecord$1).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.higherRecord$1 = higherRecord$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195))).getCause();
        if (throwable instanceof TimeoutException) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
    }

    @Test
    public void testSendAfterClosed() {
        String x$59 = this.topic1();
        int x$60 = this.numServers();
        int x$61 = this.createTopic$default$2();
        Properties x$62 = this.createTopic$default$4();
        this.createTopic(x$59, x$61, x$60, x$62);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer2().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ExecutionException thrown = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Unexpected exception while sending to an invalid topic ").append((Object)thrown.getCause()).toString(), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        block2: {
            String topicName = "minisrtest";
            Properties topicProps = new Properties();
            topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)(this.numServers() + 1))).toString());
            String x$63 = topicName;
            int x$64 = this.numServers();
            Properties x$65 = topicProps;
            int x$66 = this.createTopic$default$2();
            this.createTopic(x$63, x$66, x$64, x$65);
            ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
            try {
                this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
                Assert.fail((String)"Expected exception when producing to topic with fewer brokers than min.insync.replicas");
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof NotEnoughReplicasException) break block2;
                Assert.fail((String)"Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas");
            }
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        block2: {
            String topicName = "minisrtest2";
            Properties topicProps = new Properties();
            topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
            String x$67 = topicName;
            int x$68 = this.numServers();
            Properties x$69 = topicProps;
            int x$70 = this.createTopic$default$2();
            this.createTopic(x$67, x$70, x$68, x$69);
            ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            ((KafkaServer)this.servers().head()).shutdown();
            ((KafkaServer)this.servers().head()).awaitShutdown();
            try {
                this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
                Assert.fail((String)"Expected exception when producing to topic with fewer brokers than min.insync.replicas");
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof NotEnoughReplicasException || executionException.getCause() instanceof NotEnoughReplicasAfterAppendException || executionException.getCause() instanceof TimeoutException) break block2;
                Assert.fail((String)new StringBuilder().append((Object)"Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw ").append((Object)executionException.getCause()).toString());
            }
        }
        ((KafkaServer)this.servers().head()).startup();
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxPartitionBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxResponseBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

