/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionTest$;
import kafka.cluster.PartitionTest$$anonfun$5$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.DelayedOperationKey;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TopicPartitionOperationKey;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00069Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\t\u0003\u0013B\u0001%G\u0005\u001diU\r\u001e:jGNDaA\u0013\u0001!\u0002\u0013!\u0015\u0001C7fiJL7m\u001d\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u0002;na\u0012K'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003\u0013iK!a\u0017\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u0007?\u0002\u0001\u000b\u0015\u0002(\u0002\u000fQl\u0007\u000fR5sA!I\u0011\r\u0001a\u0001\u0002\u0004%\t!T\u0001\bY><G)\u001b:2\u0011%\u0019\u0007\u00011AA\u0002\u0013\u0005A-A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHCA-f\u0011\u001di&-!AA\u00029Caa\u001a\u0001!B\u0013q\u0015\u0001\u00037pO\u0012K'/\r\u0011\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003i\u0015a\u00027pO\u0012K'O\r\u0005\nW\u0002\u0001\r\u00111A\u0005\u00021\f1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0011\u0011,\u001c\u0005\b;*\f\t\u00111\u0001O\u0011\u0019y\u0007\u0001)Q\u0005\u001d\u0006AAn\\4ESJ\u0014\u0004\u0005C\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A:\u0011\u0005i\"\u0018BA;<\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0001=\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u00033fDq!\u0018<\u0002\u0002\u0003\u00071\u000f\u0003\u0004|\u0001\u0001\u0006Ka]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!IQ\u0010\u0001a\u0001\u0002\u0004%\tA`\u0001\u000bY><W*\u00198bO\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0005\u0003\rawnZ\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0006M_\u001el\u0015M\\1hKJD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\u0005qAn\\4NC:\fw-\u001a:`I\u0015\fHcA-\u0002\u0012!AQ,a\u0003\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0015B@\u0002\u00171|w-T1oC\u001e,'\u000f\t\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0003\tY\"A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0004\t\u0005\u0003\u0003\ty\"\u0003\u0003\u0002\"\u0005\r!!\u0003'pO\u000e{gNZ5h\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\u0002\u001b1|wmQ8oM&<w\fJ3r)\rI\u0016\u0011\u0006\u0005\n;\u0006\r\u0012\u0011!a\u0001\u0003;A\u0001\"!\f\u0001A\u0003&\u0011QD\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003bCA\u0019\u0001\u0001\u0007\t\u0019!C\u0001\u0003g\tQ\"];pi\u0006l\u0015M\\1hKJ\u001cXCAA\u001b!\u0011\t9$a\u0013\u000f\t\u0005e\u0012q\t\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\tEB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!\u0001\u0010\u0003\n\u0007\u0005%3(\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002N\u0005=#!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002JmB1\"a\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002V\u0005\t\u0012/^8uC6\u000bg.Y4feN|F%Z9\u0015\u0007e\u000b9\u0006C\u0005^\u0003#\n\t\u00111\u0001\u00026!A\u00111\f\u0001!B\u0013\t)$\u0001\brk>$\u0018-T1oC\u001e,'o\u001d\u0011\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005)1/\u001a;vaR\t\u0011\f\u000b\u0003\u0002^\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-T%A\u0003kk:LG/\u0003\u0003\u0002p\u0005%$A\u0002\"fM>\u0014X\rC\u0004\u0002t\u0001!I!!\u001e\u0002'\r\u0014X-\u0019;f\u0019><\u0007K]8qKJ$\u0018.Z:\u0015\t\u0005]\u00141\u0011\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u0010*\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001\"!\"\u0002r\u0001\u0007\u0011qQ\u0001\n_Z,'O]5eKN\u0004\u0002\"!#\u0002\u0010\u0006U\u0015Q\u0013\b\u0004\u0013\u0005-\u0015bAAG\u0015\u00051\u0001K]3eK\u001aLA!!%\u0002\u0014\n\u0019Q*\u00199\u000b\u0007\u00055%\u0002\u0005\u0003\u0002\n\u0006]\u0015\u0002BAM\u0003'\u0013aa\u0015;sS:<\u0007bBAO\u0001\u0011\u0005\u0011\u0011M\u0001\ti\u0016\f'\u000fR8x]\"\"\u00111TAQ!\u0011\t9'a)\n\t\u0005\u0015\u0016\u0011\u000e\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003S\u0003A\u0011AA1\u0003}!Xm\u001d;NC.,G*Z1eKJ,\u0006\u000fZ1uKN,\u0005o\\2i\u0007\u0006\u001c\u0007.\u001a\u0015\u0005\u0003O\u000bi\u000b\u0005\u0003\u0002h\u0005=\u0016\u0002BAY\u0003S\u0012A\u0001V3ti\"9\u0011Q\u0017\u0001\u0005\u0002\u0005\u0005\u0014A\r;fgRl\u0015m[3MK\u0006$WM\u001d#pKNtu\u000e^+qI\u0006$X-\u00129pG\"\u001c\u0015m\u00195f\r>\u0014x\n\u001c3G_Jl\u0017\r^:)\t\u0005M\u0016Q\u0016\u0005\b\u0003w\u0003A\u0011AA1\u0003!\"Xm\u001d;NCf\u0014WMU3qY\u0006\u001cWmQ;se\u0016tGoV5uQ\u001a+H/\u001e:f%\u0016\u0004H.[2bQ\u0011\tI,!,\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002b\u0005aD/Z:u\u001b\u0006L(-\u001a*fa2\f7-Z\"veJ,g\u000e^,ji\"4U\u000f^;sKJ+\u0007\u000f\\5dC\u0012KgMZ3sK:$()Y:f\u001f\u001a47/\u001a;tQ\u0011\ty,!,\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002b\u0005yC/Z:u\r\u0016$8\r[(gMN,Go\u00158baNDw\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\"\u0011QYAW\u0011\u001d\ti\r\u0001C\u0001\u0003C\n\u0011\u0007^3ti\u001a+Go\u00195PM\u001a\u001cX\r^*oCB\u001c\bn\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0003\u0002L\u00065\u0006bBAj\u0001\u0011\u0005\u0011\u0011M\u0001,i\u0016\u001cHo\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\"\u0011\u0011[AW\u0011\u001d\tI\u000e\u0001C\u0001\u0003C\nQ\u0006^3ti>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\u0011\t9.!,\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\u00051C/Z:u%\u0016\fGMU3d_J$W\t]8dQZ\u000bG.\u001b3bi&|gNR8s\u0019\u0016\fG-\u001a:)\t\u0005u\u0017Q\u0016\u0005\b\u0003K\u0004A\u0011AA1\u0003!\"Xm\u001d;SK\u0006$'+Z2pe\u0012,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\u0011\t\u0019/!,\t\u000f\u0005-\b\u0001\"\u0001\u0002b\u0005\u0019D/Z:u\r\u0016$8\r[(gMN,GOR8s)&lWm\u001d;b[B,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0005\u0003S\fi\u000bC\u0004\u0002r\u0002!\t!!\u0019\u0002kQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0005\u0003_\fi\u000bC\u0004\u0002x\u0002!\t!!\u0019\u0002QQ,7\u000f\u001e$fi\u000eDG*\u0019;fgR|eMZ:fi&s7\r\\;eKNdU-\u00193fe\u0016\u0003xn\u00195)\t\u0005U\u0018Q\u0016\u0005\b\u0003{\u0004A\u0011AA1\u0003\u0015\"Xm\u001d;N_:|Go\u001c8jG>3gm]3ug\u00063G/\u001a:MK\u0006$WM]\"iC:<W\r\u000b\u0003\u0002|\u00065\u0006b\u0002B\u0002\u0001\u0011%!QA\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$\u0002Ba\u0002\u0003\u000e\tE!1\u0004\t\u0004%\t%\u0011b\u0001B\u0006\u0005\tI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0005\u001f\u0011\t\u00011\u0001\u0017\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u0011\tM!\u0011\u0001a\u0001\u0005+\t\u0001\"[:MK\u0006$WM\u001d\t\u0004\u0013\t]\u0011b\u0001B\r\u0015\t9!i\\8mK\u0006t\u0007BCA\u0003\u0005\u0003\u0001\n\u00111\u0001\u0003\u001eA!\u0011\u0011\u0001B\u0010\u0013\u0011\u0011\t#a\u0001\u0003\u00071{w\rC\u0004\u0003&\u0001!\t!!\u0019\u0002]Q,7\u000f^!qa\u0016tGMU3d_J$7/Q:G_2dwn^3s\u0005\u0016dwn\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0015\u0005\u0005G\ti\u000bC\u0004\u0003,\u0001!\t!!\u0019\u0002;Q,7\u000f\u001e'jgR|eMZ:fi&\u001bx\u000e\\1uS>tG*\u001a<fYNDCA!\u000b\u0002.\"9!\u0011\u0007\u0001\u0005\u0002\u0005\u0005\u0014A\u0004;fgR<U\r\u001e*fa2L7-\u0019\u0015\u0005\u0005_\ti\u000bC\u0004\u00038\u0001!\t!!\u0019\u0002oQ,7\u000f^!qa\u0016tGMU3d_J$7\u000fV8G_2dwn^3s/&$\bNT8SKBd\u0017nY1UQJ|wo]#yG\u0016\u0004H/[8oQ\u0011\u0011)$!,\t\u000f\tu\u0002\u0001\"\u0001\u0002b\u0005!C/Z:u\u001b\u0006\\WMR8mY><XM],ji\"tu\u000eT3bI\u0016\u0014\u0018\nZ\"iC:<W\r\u000b\u0003\u0003<\u00055\u0006b\u0002B\"\u0001\u0011\u0005\u0011\u0011M\u0001Hi\u0016\u001cHOR8mY><XM\u001d#pKNtu\u000e\u001e&pS:L5KU+oi&d7)Y;hQR,\u0006\u000fV8PM\u001a\u001cX\r^,ji\"LgnQ;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\"\"!\u0011IAW\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003C\n!\u0005^3ti\u0012+G.Y=fI\u001a+Go\u00195BMR,'/\u00119qK:$'+Z2pe\u0012\u001c\b\u0006\u0002B$\u0003[CqAa\u0014\u0001\t\u0003\u0011\t&A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\t\u0005'\u0012yFa\u001f\u0003\u0006B!!Q\u000bB.\u001b\t\u00119FC\u0002\u0003Z\u0001\naA]3d_J$\u0017\u0002\u0002B/\u0005/\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0002\u0003B1\u0005\u001b\u0002\rAa\u0019\u0002\u000fI,7m\u001c:egB1!Q\rB8\u0005krAAa\u001a\u0003l9!\u0011Q\bB5\u0013\u0005Y\u0011b\u0001B7\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B9\u0005g\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005[R\u0001\u0003\u0002B+\u0005oJAA!\u001f\u0003X\ta1+[7qY\u0016\u0014VmY8sI\"A!Q\u0010B'\u0001\u0004\u0011y(\u0001\u0006cCN,wJ\u001a4tKR\u00042!\u0003BA\u0013\r\u0011\u0019I\u0003\u0002\u0005\u0019>tw\rC\u0005\u0003\b\n5\u0003\u0013!a\u0001-\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"DqAa#\u0001\t\u0003\u0011i)\u0001\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fGNU3d_J$7\u000f\u0006\u0005\u0003T\t=%\u0011\u0013BJ\u0011!\u0011\tG!#A\u0002\t\r\u0004\u0002\u0003B?\u0005\u0013\u0003\rAa \t\u0013\t\u001d%\u0011\u0012I\u0001\u0002\u00041\u0002b\u0002BL\u0001\u0011\u0005\u0011\u0011M\u0001\ri\u0016\u001cH/\u0011;NS:L5O\u001d\u0015\u0005\u0005+\u000bi\u000bC\u0005\u0003\u001e\u0002\t\n\u0011\"\u0003\u0003 \u0006\t3/\u001a;vaB\u000b'\u000f^5uS>tw+\u001b;i\u001b>\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0015\u0016\u0005\u0005;\u0011\u0019k\u000b\u0002\u0003&B!!q\u0015BY\u001b\t\u0011IK\u0003\u0003\u0003,\n5\u0016!C;oG\",7m[3e\u0015\r\u0011yKC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BZ\u0005S\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00119\fAI\u0001\n\u0003\u0011I,A\fde\u0016\fG/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0018\u0016\u0004-\t\r\u0006\"\u0003B`\u0001E\u0005I\u0011\u0001B]\u0003\u0011\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0004")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;
    private QuotaFactory.QuotaManagers quotaManagers;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$11 = false;
        int x$12 = CleanerConfig$.MODULE$.apply$default$1();
        long x$13 = CleanerConfig$.MODULE$.apply$default$2();
        double x$14 = CleanerConfig$.MODULE$.apply$default$3();
        int x$15 = CleanerConfig$.MODULE$.apply$default$4();
        int x$16 = CleanerConfig$.MODULE$.apply$default$5();
        double x$17 = CleanerConfig$.MODULE$.apply$default$6();
        long x$18 = CleanerConfig$.MODULE$.apply$default$7();
        String x$19 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$11, x$19), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        KafkaZkClient kafkaZkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""));
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), kafkaZkClient, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), this.quotaManagers(), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
        EasyMock.expect((Object)kafkaZkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)logProps).anyTimes();
        EasyMock.expect((Object)kafkaZkClient.conditionalUpdatePath((String)EasyMock.anyObject(), (byte[])EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), (Option)EasyMock.anyObject())).andReturn((Object)new Tuple2.mcZI.sp(true, 0)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaZkClient});
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1)new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            private final Properties logProps$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.logProps$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.logProps$1 = logProps$1;
            }
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
        this.replicaManager().shutdown(false);
        this.quotaManagers().shutdown();
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$20 = this.topicPartition();
        LogConfig x$21 = this.logConfig();
        boolean x$22 = qual$1.getOrCreateLog$default$3();
        boolean x$23 = qual$1.getOrCreateLog$default$4();
        Log log2 = qual$1.getOrCreateLog(x$20, x$21, x$22, x$23);
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Replica x$2) {
                return x$2.logEndOffset();
            }
        }));
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_10_2_IV0$.MODULE$.shortVersion())})))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$2 = this.logManager();
        TopicPartition x$24 = this.topicPartition();
        LogConfig x$25 = logConfig;
        boolean x$26 = qual$2.getOrCreateLog$default$3();
        boolean x$27 = qual$2.getOrCreateLog$default$4();
        Log log2 = qual$2.getOrCreateLog(x$24, x$25, x$26, x$27);
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())})), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log2.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderReplicaIfLocal().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Replica x$3) {
                return x$3.logEndOffset();
            }
        }));
        Assert.assertEquals((Object)None$.MODULE$, (Object)log2.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$3 = this.logManager();
        TopicPartition x$28 = this.topicPartition();
        LogConfig x$29 = this.logConfig();
        boolean x$30 = qual$3.getOrCreateLog$default$3();
        boolean x$31 = qual$3.getOrCreateLog$default$4();
        Log log1 = qual$3.getOrCreateLog(x$28, x$29, x$30, x$31);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$4 = this.logManager();
        TopicPartition x$32 = this.topicPartition();
        LogConfig x$33 = this.logConfig();
        boolean x$34 = true;
        boolean x$35 = qual$4.getOrCreateLog$default$3();
        Log log2 = qual$4.getOrCreateLog(x$32, x$33, x$35, x$34);
        int x$36 = this.brokerId();
        TopicPartition x$37 = this.topicPartition();
        MockTime x$38 = this.time();
        Some x$39 = new Some((Object)log1);
        long x$40 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$36, x$37, (Time)x$38, x$40, (Option)x$39);
        int x$41 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$42 = this.topicPartition();
        MockTime x$43 = this.time();
        Some x$44 = new Some((Object)log2);
        long x$45 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$41, x$42, (Time)x$43, x$45, (Option)x$44);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Thread thread1 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.futureLocalReplica());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$5 = this.logManager();
        TopicPartition x$46 = this.topicPartition();
        LogConfig x$47 = this.logConfig();
        boolean x$48 = qual$5.getOrCreateLog$default$3();
        boolean x$49 = qual$5.getOrCreateLog$default$4();
        Log log1 = qual$5.getOrCreateLog(x$46, x$47, x$48, x$49);
        log1.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
        log1.roll(log1.roll$default$1());
        log1.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$6 = this.logManager();
        TopicPartition x$50 = this.topicPartition();
        LogConfig x$51 = this.logConfig();
        boolean x$52 = true;
        boolean x$53 = qual$6.getOrCreateLog$default$3();
        Log log2 = qual$6.getOrCreateLog(x$50, x$51, x$53, x$52);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        log2.appendAsFollower(builder.build());
        int x$54 = this.brokerId();
        TopicPartition x$55 = this.topicPartition();
        MockTime x$56 = this.time();
        Some x$57 = new Some((Object)log1);
        long x$58 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$54, x$55, (Time)x$56, x$58, (Option)x$57);
        int x$59 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$60 = this.topicPartition();
        MockTime x$61 = this.time();
        Some x$62 = new Some((Object)log2);
        long x$63 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$59, x$60, (Time)x$61, x$63, (Option)x$62);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.localReplica());
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.futureLocalReplica());
        Assert.assertTrue((boolean)partition.maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        this.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        this.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        this.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        this.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        this.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        this.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        this.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        this.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        this.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        this.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        this.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        this.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        this.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        this.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        this.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        Option timestampAndOffsetOpt = partition.fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)timestampAndOffset.leaderEpoch);
    }

    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        Either either;
        block5: {
            Either either2;
            block9: {
                Either either3;
                block14: {
                    Either either4;
                    block18: {
                        Either either5;
                        block22: {
                            Either either6;
                            block26: {
                                Either either7;
                                block31: {
                                    Either either8;
                                    block35: {
                                        Partition partition;
                                        block33: {
                                            Left left;
                                            ApiException e;
                                            block34: {
                                                Option option;
                                                Right right;
                                                boolean bl;
                                                block32: {
                                                    Replica follower2Replica;
                                                    Replica follower1Replica;
                                                    Replica leaderReplica;
                                                    block28: {
                                                        ApiException e2;
                                                        Left left2;
                                                        boolean bl2;
                                                        block30: {
                                                            block29: {
                                                                Option option2;
                                                                Right right2;
                                                                boolean bl3;
                                                                block27: {
                                                                    block24: {
                                                                        Left left3;
                                                                        ApiException e3;
                                                                        block25: {
                                                                            Option option3;
                                                                            Right right3;
                                                                            boolean bl4;
                                                                            block23: {
                                                                                block20: {
                                                                                    Left left4;
                                                                                    ApiException e4;
                                                                                    block21: {
                                                                                        Option option4;
                                                                                        Right right4;
                                                                                        boolean bl5;
                                                                                        block19: {
                                                                                            block16: {
                                                                                                Left left5;
                                                                                                ApiException e5;
                                                                                                block17: {
                                                                                                    Option option5;
                                                                                                    Right right5;
                                                                                                    boolean bl6;
                                                                                                    block15: {
                                                                                                        block11: {
                                                                                                            ApiException e6;
                                                                                                            Left left6;
                                                                                                            boolean bl7;
                                                                                                            block13: {
                                                                                                                block12: {
                                                                                                                    Option option6;
                                                                                                                    Right right6;
                                                                                                                    boolean bl8;
                                                                                                                    block10: {
                                                                                                                        int leaderEpoch;
                                                                                                                        java.util.List isr;
                                                                                                                        java.util.List replicas;
                                                                                                                        int controllerId;
                                                                                                                        int follower2;
                                                                                                                        int leader2;
                                                                                                                        int controllerEpoch;
                                                                                                                        block7: {
                                                                                                                            block8: {
                                                                                                                                Option option7;
                                                                                                                                Right right7;
                                                                                                                                boolean bl9;
                                                                                                                                block6: {
                                                                                                                                    block3: {
                                                                                                                                        block4: {
                                                                                                                                            Option option8;
                                                                                                                                            Right right8;
                                                                                                                                            boolean bl10;
                                                                                                                                            block2: {
                                                                                                                                                controllerEpoch = 3;
                                                                                                                                                leader2 = this.brokerId();
                                                                                                                                                int follower1 = this.brokerId() + 1;
                                                                                                                                                follower2 = this.brokerId() + 2;
                                                                                                                                                controllerId = this.brokerId() + 3;
                                                                                                                                                replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
                                                                                                                                                isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
                                                                                                                                                leaderEpoch = 8;
                                                                                                                                                MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                                                                                                                                MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                                                                                                                                partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
                                                                                                                                                Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 1, replicas, true), 0));
                                                                                                                                                Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
                                                                                                                                                Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
                                                                                                                                                    public static final long serialVersionUID = 0L;

                                                                                                                                                    public final int apply(Replica x$4) {
                                                                                                                                                        return x$4.brokerId();
                                                                                                                                                    }
                                                                                                                                                }, Set$.MODULE$.canBuildFrom()));
                                                                                                                                                leaderReplica = (Replica)partition.getReplica(leader2).get();
                                                                                                                                                follower1Replica = (Replica)partition.getReplica(follower1).get();
                                                                                                                                                follower2Replica = (Replica)partition.getReplica(follower2).get();
                                                                                                                                                partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3());
                                                                                                                                                partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
                                                                                                                                                Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
                                                                                                                                                partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                                                                                                                                partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                                                                                                                                partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                                                                                                                                partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                                                                                                                                Assert.assertEquals((long)2L, (long)((Replica)partition.localReplica().get()).highWatermark().messageOffset());
                                                                                                                                                bl10 = false;
                                                                                                                                                right8 = null;
                                                                                                                                                either = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$, partition);
                                                                                                                                                if (!(either instanceof Right)) break block2;
                                                                                                                                                bl10 = true;
                                                                                                                                                right8 = (Right)either;
                                                                                                                                                Option option9 = (Option)right8.b();
                                                                                                                                                if (!(option9 instanceof Some)) break block2;
                                                                                                                                                Some some = (Some)option9;
                                                                                                                                                FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                                                                                Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                                break block3;
                                                                                                                                            }
                                                                                                                                            if (!bl10 || !None$.MODULE$.equals(option8 = (Option)right8.b())) break block4;
                                                                                                                                            Assert.fail((String)"Should have seen some offsets");
                                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                            break block3;
                                                                                                                                        }
                                                                                                                                        if (!(either instanceof Left)) break block5;
                                                                                                                                        Assert.fail((String)"Should not have seen an error");
                                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    }
                                                                                                                                    bl9 = false;
                                                                                                                                    right7 = null;
                                                                                                                                    either2 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                                                                                                                    if (!(either2 instanceof Right)) break block6;
                                                                                                                                    bl9 = true;
                                                                                                                                    right7 = (Right)either2;
                                                                                                                                    Option option10 = (Option)right7.b();
                                                                                                                                    if (!(option10 instanceof Some)) break block6;
                                                                                                                                    Some some = (Some)option10;
                                                                                                                                    FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                                                                    Assert.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                    break block7;
                                                                                                                                }
                                                                                                                                if (!bl9 || !None$.MODULE$.equals(option7 = (Option)right7.b())) break block8;
                                                                                                                                Assert.fail((String)"Should have seen some offsets");
                                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                                break block7;
                                                                                                                            }
                                                                                                                            if (!(either2 instanceof Left)) break block9;
                                                                                                                            Assert.fail((String)"Should not have seen an error");
                                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        }
                                                                                                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition));
                                                                                                                        Assert.assertTrue((boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1));
                                                                                                                        Assert.assertTrue((boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch + 2, isr, 1, replicas, false), 2));
                                                                                                                        bl8 = false;
                                                                                                                        right6 = null;
                                                                                                                        bl7 = false;
                                                                                                                        left6 = null;
                                                                                                                        either3 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                                                                                                        if (!(either3 instanceof Right)) break block10;
                                                                                                                        bl8 = true;
                                                                                                                        right6 = (Right)either3;
                                                                                                                        Option option11 = (Option)right6.b();
                                                                                                                        if (!(option11 instanceof Some)) break block10;
                                                                                                                        Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                        break block11;
                                                                                                                    }
                                                                                                                    if (!bl8 || !None$.MODULE$.equals(option6 = (Option)right6.b())) break block12;
                                                                                                                    Assert.fail((String)"Should have seen an error");
                                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                    break block11;
                                                                                                                }
                                                                                                                if (!(either3 instanceof Left)) break block13;
                                                                                                                bl7 = true;
                                                                                                                left6 = (Left)either3;
                                                                                                                ApiException e7 = (ApiException)left6.a();
                                                                                                                if (!(e7 instanceof OffsetNotAvailableException)) break block13;
                                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                                break block11;
                                                                                                            }
                                                                                                            if (!bl7 || (e6 = (ApiException)left6.a()) == null) break block14;
                                                                                                            ApiException apiException = e6;
                                                                                                            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected OffsetNotAvailableException, got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        }
                                                                                                        bl6 = false;
                                                                                                        right5 = null;
                                                                                                        either4 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$, partition);
                                                                                                        if (!(either4 instanceof Right)) break block15;
                                                                                                        bl6 = true;
                                                                                                        right5 = (Right)either4;
                                                                                                        Option option12 = (Option)right5.b();
                                                                                                        if (!(option12 instanceof Some)) break block15;
                                                                                                        Some some = (Some)option12;
                                                                                                        FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                                        Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                        break block16;
                                                                                                    }
                                                                                                    if (!bl6 || !None$.MODULE$.equals(option5 = (Option)right5.b())) break block17;
                                                                                                    Assert.fail((String)"Should have seen some offsets");
                                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                                    break block16;
                                                                                                }
                                                                                                if (!(either4 instanceof Left) || (e5 = (ApiException)(left5 = (Left)either4).a()) == null) break block18;
                                                                                                ApiException apiException = e5;
                                                                                                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            }
                                                                                            bl5 = false;
                                                                                            right4 = null;
                                                                                            either5 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                                                                            if (!(either5 instanceof Right)) break block19;
                                                                                            bl5 = true;
                                                                                            right4 = (Right)either5;
                                                                                            Option option13 = (Option)right4.b();
                                                                                            if (!(option13 instanceof Some)) break block19;
                                                                                            Some some = (Some)option13;
                                                                                            FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                            Assert.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            break block20;
                                                                                        }
                                                                                        if (!bl5 || !None$.MODULE$.equals(option4 = (Option)right4.b())) break block21;
                                                                                        Assert.fail((String)"Should have seen some offsets");
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        break block20;
                                                                                    }
                                                                                    if (!(either5 instanceof Left) || (e4 = (ApiException)(left4 = (Left)either5).a()) == null) break block22;
                                                                                    ApiException apiException = e4;
                                                                                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                }
                                                                                bl4 = false;
                                                                                right3 = null;
                                                                                either6 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                                                                if (!(either6 instanceof Right)) break block23;
                                                                                bl4 = true;
                                                                                right3 = (Right)either6;
                                                                                Option option14 = (Option)right3.b();
                                                                                if (!(option14 instanceof Some)) break block23;
                                                                                Some some = (Some)option14;
                                                                                FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                                                Assert.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                                                                                Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                break block24;
                                                                            }
                                                                            if (!bl4 || !None$.MODULE$.equals(option3 = (Option)right3.b())) break block25;
                                                                            Assert.fail((String)"Should have seen some offsets");
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block24;
                                                                        }
                                                                        if (!(either6 instanceof Left) || (e3 = (ApiException)(left3 = (Left)either6).a()) == null) break block26;
                                                                        ApiException apiException = e3;
                                                                        Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    }
                                                                    bl3 = false;
                                                                    right2 = null;
                                                                    bl2 = false;
                                                                    left2 = null;
                                                                    either7 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                                                    if (!(either7 instanceof Right)) break block27;
                                                                    bl3 = true;
                                                                    right2 = (Right)either7;
                                                                    Option option15 = (Option)right2.b();
                                                                    if (!(option15 instanceof Some)) break block27;
                                                                    Assert.fail((String)"Should have failed");
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block28;
                                                                }
                                                                if (!bl3 || !None$.MODULE$.equals(option2 = (Option)right2.b())) break block29;
                                                                Assert.fail((String)"Should have failed");
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block28;
                                                            }
                                                            if (!(either7 instanceof Left)) break block30;
                                                            bl2 = true;
                                                            left2 = (Left)either7;
                                                            ApiException e8 = (ApiException)left2.a();
                                                            if (!(e8 instanceof OffsetNotAvailableException)) break block30;
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block28;
                                                        }
                                                        if (!bl2 || (e2 = (ApiException)left2.a()) == null) break block31;
                                                        ApiException apiException = e2;
                                                        Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have seen OffsetNotAvailableException, saw ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    partition.updateReplicaLogReadResult(follower1Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                                    partition.updateReplicaLogReadResult(follower2Replica, this.readResult$1(new FetchDataInfo(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
                                                    bl = false;
                                                    right = null;
                                                    either8 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition);
                                                    if (!(either8 instanceof Right)) break block32;
                                                    bl = true;
                                                    right = (Right)either8;
                                                    Option option16 = (Option)right.b();
                                                    if (!(option16 instanceof Some)) break block32;
                                                    Some some = (Some)option16;
                                                    FileRecords.TimestampAndOffset offsetAndTimestamp = (FileRecords.TimestampAndOffset)some.x();
                                                    Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block33;
                                                }
                                                if (!bl || !None$.MODULE$.equals(option = (Option)right.b())) break block34;
                                                Assert.fail((String)"Should have seen some offsets");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block33;
                                            }
                                            if (!(either8 instanceof Left) || (e = (ApiException)(left = (Left)either8).a()) == null) break block35;
                                            ApiException apiException = e;
                                            Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ApiException ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{apiException})));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), partition));
                                        return;
                                    }
                                    throw new MatchError((Object)either8);
                                }
                                throw new MatchError((Object)either7);
                            }
                            throw new MatchError((Object)either6);
                        }
                        throw new MatchError((Object)either5);
                    }
                    throw new MatchError((Object)either4);
                }
                throw new MatchError((Object)either3);
            }
            throw new MatchError((Object)either2);
        }
        throw new MatchError((Object)either);
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log2) {
        java.util.List replicas;
        int x$68 = this.brokerId();
        TopicPartition x$69 = this.topicPartition();
        MockTime x$70 = this.time();
        Some x$71 = new Some((Object)log2);
        long x$72 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$68, x$69, (Time)x$70, x$72, (Option)x$71);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId() + 1, leaderEpoch, isr, 1, replicas, true), 0));
            Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)partition.leaderReplicaIfLocal());
        }
        return partition;
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$12 = this.logManager();
        TopicPartition x$109 = this.topicPartition();
        LogConfig x$110 = this.logConfig();
        boolean x$111 = qual$12.getOrCreateLog$default$3();
        boolean x$112 = qual$12.getOrCreateLog$default$4();
        return qual$12.getOrCreateLog(x$109, x$110, x$111, x$112);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$8 = this.logManager();
        TopicPartition x$73 = this.topicPartition();
        LogConfig x$74 = this.logConfig();
        boolean x$75 = qual$8.getOrCreateLog$default$3();
        boolean x$76 = qual$8.getOrCreateLog$default$4();
        Log log2 = qual$8.getOrCreateLog(x$73, x$74, x$75, x$76);
        int x$77 = this.brokerId();
        TopicPartition x$78 = this.topicPartition();
        MockTime x$79 = this.time();
        Some x$80 = new Some((Object)log2);
        long x$81 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$77, x$78, (Time)x$79, x$81, (Option)x$80);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$11;

            public final Option<LogAppendInfo> apply() {
                return this.partition$11.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 3L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$11 = partition$11;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)initialLogStartOffset, (long)replica.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)7L, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 7:"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$11;

            public final Option<LogAppendInfo> apply() {
                MemoryRecords records2 = this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), 3L, this.$outer.createRecords$default$3());
                return this.partition$11.appendRecordsToFollowerOrFutureReplica(records2, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$11 = partition$11;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 8:"})).s((Seq)Nil$.MODULE$), (long)9L, (long)replica.logEndOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        java.util.List replicas;
        LogManager qual$9 = this.logManager();
        TopicPartition x$82 = this.topicPartition();
        LogConfig x$83 = this.logConfig();
        boolean x$84 = qual$9.getOrCreateLog$default$3();
        boolean x$85 = qual$9.getOrCreateLog$default$4();
        Log log2 = qual$9.getOrCreateLog(x$82, x$83, x$84, x$85);
        int x$86 = this.brokerId();
        TopicPartition x$87 = this.topicPartition();
        MockTime x$88 = this.time();
        Some x$89 = new Some((Object)log2);
        long x$90 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$86, x$87, (Time)x$88, x$90, (Option)x$89);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        Partition partition = new Partition(this.topicPartition(), false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), replicaManager, this.logManager(), zkClient);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        partition.addReplicaIfNotExists(replica);
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, this.brokerId(), leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.leaderReplicaIfLocal());
        MemoryRecords records2 = this.createTransactionalRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), 0L, this.createTransactionalRecords$default$3());
        partition.appendRecordsToLeader(records2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
        replica.highWatermark_$eq(new LogOffsetMetadata(1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$, (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED), (Partition)partition).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED), (Partition)partition).offset);
    }

    @Test
    public void testGetReplica() {
        LogManager qual$10 = this.logManager();
        TopicPartition x$91 = this.topicPartition();
        LogConfig x$92 = this.logConfig();
        boolean x$93 = qual$10.getOrCreateLog$default$3();
        boolean x$94 = qual$10.getOrCreateLog$default$4();
        Log log2 = qual$10.getOrCreateLog(x$91, x$92, x$93, x$94);
        int x$95 = this.brokerId();
        TopicPartition x$96 = this.topicPartition();
        MockTime x$97 = this.time();
        Some x$98 = new Some((Object)log2);
        long x$99 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$95, x$96, (Time)x$97, x$99, (Option)x$98);
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.localReplica());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$13;

            public final Replica apply() {
                return this.partition$13.localReplicaOrException();
            }
            {
                this.partition$13 = partition$13;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.localReplica());
        Assert.assertEquals((Object)replica, (Object)partition.localReplicaOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$14;

            public final Option<LogAppendInfo> apply() {
                return this.partition$14.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 0L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$14 = partition$14;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        LeaderAndIsrRequest.PartitionState partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        partition.makeFollower(0, partitionStateInfo, 0);
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertTrue((boolean)partition.makeFollower(0, partitionStateInfo, 2));
        partitionStateInfo = new LeaderAndIsrRequest.PartitionState(0, 1, 4, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), 1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava(), false);
        Assert.assertFalse((boolean)partition.makeFollower(0, partitionStateInfo, 2));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())})), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 1, replicas, true), 0));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)partition.getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition.getReplica(leader2).get();
        Replica follower1Replica = (Replica)partition.getReplica(follower1).get();
        Replica follower2Replica = (Replica)partition.getReplica(follower2).get();
        long lastOffsetOfFirstBatch = partition.appendRecordsToLeader(batch1, true, partition.appendRecordsToLeader$default$3()).lastOffset();
        partition.appendRecordsToLeader(batch2, true, partition.appendRecordsToLeader$default$3());
        Assert.assertEquals((String)"Expected leader's HW not move", (long)leaderReplica.logStartOffset(), (long)leaderReplica.highWatermark().messageOffset());
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower2Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)leaderReplica.highWatermark().messageOffset());
        partition.makeFollower(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, follower2, leaderEpoch + 1, isr, 1, replicas, false), 1);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)partition.makeLeader(controllerEpoch, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch + 2, isr, 1, replicas, false), 2));
        long currentLeaderEpochStartOffset = leaderReplica.logEndOffset();
        partition.appendRecordsToLeader(batch3, true, partition.appendRecordsToLeader$default$3());
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch1, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$6) {
                return x$6.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        partition.updateReplicaLogReadResult(follower1Replica, this.readResult$2(new FetchDataInfo(new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)batch3, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), leaderReplica));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)partition.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$7) {
                return x$7.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDelayedFetchAfterAppendRecords() {
        java.util.List replicaIds;
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List isr = replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(int i) {
                return new TopicPartition("test-topic", i);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1)new Serializable(this, logConfig){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final LogConfig logConfig$1;

            public final Log apply(TopicPartition tp) {
                LogManager qual$11 = this.$outer.logManager();
                TopicPartition x$100 = tp;
                LogConfig x$101 = this.logConfig$1;
                boolean x$102 = qual$11.getOrCreateLog$default$3();
                boolean x$103 = qual$11.getOrCreateLog$default$4();
                return qual$11.getOrCreateLog(x$100, x$101, x$102, x$103);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logConfig$1 = logConfig$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq replicas = (IndexedSeq)logs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;

            public final Replica apply(Log log2) {
                int x$104 = this.$outer.brokerId();
                TopicPartition x$105 = log2.topicPartition();
                MockTime x$106 = this.$outer.time();
                Some x$107 = new Some((Object)log2);
                long x$108 = Replica$.MODULE$.$lessinit$greater$default$4();
                return new Replica(x$104, x$105, (Time)x$106, x$108, (Option)x$107);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq partitions = (IndexedSeq)replicas.map((Function1)new Serializable(this, replicaManager, zkClient, controllerId, controllerEpoch, leaderEpoch, replicaIds, isr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final ReplicaManager replicaManager$1;
            private final KafkaZkClient zkClient$1;
            private final int controllerId$1;
            private final int controllerEpoch$1;
            private final int leaderEpoch$1;
            private final java.util.List replicaIds$1;
            private final java.util.List isr$1;

            /*
             * WARNING - void declaration
             */
            public final Partition apply(Replica replica) {
                void var3_3;
                TopicPartition tp = replica.topicPartition();
                Partition partition = new Partition(tp, false, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.$outer.brokerId(), (Time)this.$outer.time(), this.replicaManager$1, this.$outer.logManager(), this.zkClient$1);
                partition.addReplicaIfNotExists(replica);
                partition.makeLeader(this.controllerId$1, new LeaderAndIsrRequest.PartitionState(this.controllerEpoch$1, this.$outer.brokerId(), this.leaderEpoch$1, this.isr$1, 1, this.replicaIds$1, true), 0);
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaManager$1 = replicaManager$1;
                this.zkClient$1 = zkClient$1;
                this.controllerId$1 = controllerId$1;
                this.controllerEpoch$1 = controllerEpoch$1;
                this.leaderEpoch$1 = leaderEpoch$1;
                this.replicaIds$1 = replicaIds$1;
                this.isr$1 = isr$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Capture tpKey = EasyMock.newCapture();
        replicaManager.tryCompleteDelayedFetch((DelayedOperationKey)EasyMock.capture((Capture)tpKey));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, leaderEpoch, topicPartitions, partitions, tpKey){
            private final int leaderEpoch$1;
            private final IndexedSeq topicPartitions$1;
            private final IndexedSeq partitions$1;
            private final Capture tpKey$1;

            public void answer() {
                int anotherPartition = (((TopicPartitionOperationKey)this.tpKey$1.getValue()).partition() + 1) % this.topicPartitions$1.size();
                Partition partition = (Partition)this.partitions$1.apply(anotherPartition);
                partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch$1)), true);
            }
            {
                this.leaderEpoch$1 = leaderEpoch$1;
                this.topicPartitions$1 = topicPartitions$1;
                this.partitions$1 = partitions$1;
                this.tpKey$1 = tpKey$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, zkClient});
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                executor.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, partitions, done){
                    public static final long serialVersionUID = 0L;
                    private final IndexedSeq partitions$1;
                    private final AtomicBoolean done$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        while (!this.done$1.get()) {
                            this.partitions$1.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Partition x$8) {
                                    x$8.maybeShrinkIsr(10000L);
                                }
                            });
                        }
                        return;
                    }
                    {
                        this.partitions$1 = partitions$1;
                        this.done$1 = done$1;
                    }
                }));
                IndexedSeq futures = (IndexedSeq)partitions.map((Function1)new Serializable(this, executor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PartitionTest $outer;
                    private final ExecutorService executor$1;

                    public final Future<?> apply(Partition partition) {
                        return this.executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, partition){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5 $outer;
                            public final Partition partition$15;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10000).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$5$$anonfun$apply$1 $outer;

                                    public final LogAppendInfo apply(int x$9) {
                                        return this.$outer.partition$15.appendRecordsToLeader(this.$outer.kafka$cluster$PartitionTest$$anonfun$$anonfun$$$outer().kafka$cluster$PartitionTest$$anonfun$$$outer().kafka$cluster$PartitionTest$$createRecords$1(0L), true, this.$outer.partition$15.appendRecordsToLeader$default$3());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$5 kafka$cluster$PartitionTest$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$15 = partition$15;
                            }
                        }));
                    }

                    public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executor$1 = executor$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                futures.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Future<?> x$10) {
                        return x$10.get(15L, TimeUnit.SECONDS);
                    }
                });
                done.set(true);
            }
            catch (TimeoutException timeoutException) {
                String allThreads2 = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test timed out with exception ", ", thread stack traces: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeoutException, allThreads2})));
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$2;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$2.append(x$1);
            }
            {
                this.builder$2 = builder$2;
            }
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$3;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$3.append(x$1);
            }
            {
                this.builder$3 = builder$3;
            }
        });
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader2 = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader2)}))).asJava();
        int leaderEpoch = 8;
        Partition partition = Partition$.MODULE$.apply(this.topicPartition(), (Time)this.time(), this.replicaManager());
        Assert.assertFalse((boolean)partition.isAtMinIsr());
        partition.makeLeader(controllerId, new LeaderAndIsrRequest.PartitionState(controllerEpoch, leader2, leaderEpoch, isr, 1, replicas, true), 0);
        Assert.assertTrue((boolean)partition.isAtMinIsr());
    }

    private final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        Either either;
        block4: {
            block3: {
                block2: {
                    either = partition$2.fetchOffsetSnapshotOrError(currentLeaderEpoch, true);
                    if (!(either instanceof Left)) break block2;
                    Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Errors error = (Errors)right.b();
                Assert.assertEquals((Object)expectedError, (Object)error);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)either);
    }

    private final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        Either either;
        block4: {
            block3: {
                block2: {
                    either = partition$3.fetchOffsetSnapshotOrError(currentLeaderEpoch, fetchOnlyLeader);
                    if (!(either instanceof Left)) break block2;
                    Assert.assertEquals((Object)expectedError, (Object)Errors.NONE);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(either instanceof Right)) break block4;
                Right right = (Right)either;
                Errors error = (Errors)right.b();
                Assert.assertEquals((Object)expectedError, (Object)error);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)either);
    }

    private final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected readRecords to fail with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error})));
            }
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)exception));
        }
    }

    private final LogReadResult readResult$1(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation, Partition partition$10) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)partition$10.fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(partition$10.getLeaderEpoch())), true));
        }
        catch (ApiException apiException) {
            left = package$.MODULE$.Left().apply((Object)apiException);
        }
        return left;
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel, Partition partition$12) {
        Option res = partition$12.fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel, Partition partition$12) {
        Option res = partition$12.fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final LogReadResult readResult$2(FetchDataInfo fetchInfo, Replica leaderReplica) {
        return new LogReadResult(fetchInfo, leaderReplica.highWatermark().messageOffset(), leaderReplica.logStartOffset(), leaderReplica.logEndOffset(), 0L, this.time().milliseconds(), 10240, (Option)None$.MODULE$, LogReadResult$.MODULE$.apply$default$9());
    }

    public final MemoryRecords kafka$cluster$PartitionTest$$createRecords$1(long baseOffset) {
        List records2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

