/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\rV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%I!F\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\f\u0011\u0005I9\u0012B\u0001\r\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\b5\u0001\u0001\r\u0011\"\u0003\u001c\u0003U\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010^0%KF$\"\u0001H\u0010\u0011\u0005%i\u0012B\u0001\u0010\u000b\u0005\u0011)f.\u001b;\t\u000f\u0001J\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\t\u0002\u0001\u0015)\u0003\u0017\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f\u0011\u0002\u0001\u0019!C\u0005K\u0005aQn\\2l5.\u001cE.[3oiV\ta\u0005\u0005\u0002(U5\t\u0001F\u0003\u0002*\t\u0005\u0011!p[\u0005\u0003W!\u0012QbS1gW\u0006T6n\u00117jK:$\bbB\u0017\u0001\u0001\u0004%IAL\u0001\u0011[>\u001c7NW6DY&,g\u000e^0%KF$\"\u0001H\u0018\t\u000f\u0001b\u0013\u0011!a\u0001M!1\u0011\u0007\u0001Q!\n\u0019\nQ\"\\8dWj[7\t\\5f]R\u0004\u0003bB\u001a\u0001\u0001\u0004%I\u0001N\u0001![>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u00016!\t\u0011b'\u0003\u00028\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007bB\u001d\u0001\u0001\u0004%IAO\u0001%[>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007n\u0018\u0013fcR\u0011Ad\u000f\u0005\bAa\n\t\u00111\u00016\u0011\u0019i\u0004\u0001)Q\u0005k\u0005\tSn\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2iA!9q\b\u0001a\u0001\n\u0013\u0001\u0015!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002\u0003B\u0011!CQ\u0005\u0003\u0007\n\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\rC\u0004F\u0001\u0001\u0007I\u0011\u0002$\u00023A\f'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK~#S-\u001d\u000b\u00039\u001dCq\u0001\t#\u0002\u0002\u0003\u0007\u0011\t\u0003\u0004J\u0001\u0001\u0006K!Q\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!91\n\u0001b\u0001\n\u0013a\u0015\u0001\u00032s_.,'/\u00133\u0016\u00035\u0003\"!\u0003(\n\u0005=S!aA%oi\"1\u0011\u000b\u0001Q\u0001\n5\u000b\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000fM\u0003!\u0019!C\u0005)\u000611m\u001c8gS\u001e,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\taa]3sm\u0016\u0014\u0018B\u0001.X\u0005-Y\u0015MZ6b\u0007>tg-[4\t\rq\u0003\u0001\u0015!\u0003V\u0003\u001d\u0019wN\u001c4jO\u0002BqA\u0018\u0001C\u0002\u0013%A*A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u0019\u0001\u0007\u0001)A\u0005\u001b\u0006\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001e!\t)W.D\u0001g\u0015\t9\u0007.\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b%T!A[6\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0017aA8sO&\u0011aN\u001a\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0001\b\u0001)A\u0005I\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000fI\u0004!\u0019!C\u0005g\u0006Q\u0001/\u0019:uSRLwN\\:\u0016\u0003Q\u00042!\u001e=e\u001b\u00051(BA<\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003sZ\u00141aU3r\u0011\u0019Y\b\u0001)A\u0005i\u0006Y\u0001/\u0019:uSRLwN\\:!\u0011\u0015i\b\u0001\"\u0001\u007f\u0003\u0015\u0019X\r^+q)\u0005a\u0002f\u0001?\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b-\fQA[;oSRLA!a\u0003\u0002\u0006\t1!)\u001a4pe\u0016Dq!a\u0004\u0001\t\u0013\t\t\"\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\u0005M\u0011\u0011\u0004\t\u0004%\u0005U\u0011bAA\f\u0005\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007B\u00022\u0002\u000e\u0001\u0007A\r\u0003\u0004\u0002\u001e\u0001!\tA`\u00011i\u0016\u001cHOT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGk\u001c(foB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\t\u0005m\u0011\u0011\u0005\t\u0005\u0003\u0007\t\u0019#\u0003\u0003\u0002&\u0005\u0015!\u0001\u0002+fgRDa!!\u000b\u0001\t\u0003q\u0018A\u000f;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\u0011\t9#!\t\t\r\u0005=\u0002\u0001\"\u0001\u007f\u0003m\"Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0005\u0003[\t\t\u0003\u0003\u0004\u00026\u0001!\tA`\u0001,i\u0016\u001cHOT3x!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\"\u00111GA\u0011\u0011\u0019\tY\u0004\u0001C\u0001}\u0006YE/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|gNW6Vi&d7/\u0012=dKB$\u0018n\u001c8Ge>l7I]3bi\u0016\u001cF/\u0019;fg\"\"\u0011\u0011HA\u0011\u0011\u0019\t\t\u0005\u0001C\u0001}\u0006!E/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g.\u0012:s_J\u001cu\u000eZ3Ge>l7I]3bi\u0016\u001cF/\u0019;fg\"\"\u0011qHA\u0011\u0011\u0019\t9\u0005\u0001C\u0001}\u0006aC/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0005\u0003\u000b\n\t\u0003\u0003\u0004\u0002N\u0001!\tA`\u00018i\u0016\u001cH/\u00138wC2LGMT3x!\u0006\u0014H/\u001b;j_:$vNT8oKbL7\u000f^3oiB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\t\u0005-\u0013\u0011\u0005\u0005\u0007\u0003'\u0002A\u0011\u0001@\u0002KQ,7\u000f^(oY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f)J\fgn]5uS>t\u0007\u0006BA)\u0003CAa!!\u0017\u0001\t\u0003q\u0018A\u000f;fgR|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\r\u0016:b]NLG/[8o\r>\u00148i\u001c8ue>dG.\u001a3TQV$Hm\\<oQ\u0011\t9&!\t\t\r\u0005}\u0003\u0001\"\u0001\u007f\u0003\u0019\"Xm\u001d;P]2Lg.\u001a)beRLG/[8o)>|eM\u001a7j]\u0016$&/\u00198tSRLwN\u001c\u0015\u0005\u0003;\n\t\u0003\u0003\u0004\u0002f\u0001!\tA`\u0001;i\u0016\u001cH/\u00138wC2LGm\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:DC!a\u0019\u0002\"!1\u00111\u000e\u0001\u0005\u0002y\f!\u0007^3ti&sg/\u00197jI>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$vNT3x!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0005\u0003S\n\t\u0003\u0003\u0004\u0002r\u0001!\tA`\u00010i\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c\u0015\u0005\u0003_\n\t\u0003\u0003\u0004\u0002x\u0001!\tA`\u0001Oi\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\u001c.l+RLGn]#yG\u0016\u0004H/[8o\rJ|Wn\u0015;bi\u0016dun\\6va\"\"\u0011QOA\u0011\u0011\u0019\ti\b\u0001C\u0001}\u00069E/Z:u\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\u0016\u0013(o\u001c:D_\u0012,gI]8n'R\fG/\u001a'p_.,\b\u000f\u000b\u0003\u0002|\u0005\u0005\u0002BBAB\u0001\u0011\u0005a0\u0001\u001buKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c+p\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:DC!!!\u0002\"!1\u0011\u0011\u0012\u0001\u0005\u0002y\f1\u0007^3ti&sg/\u00197jI>3g\r\\5oKB\u000b'\u000f^5uS>tGk\u001c(foB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\t\u0005\u001d\u0015\u0011\u0005\u0005\b\u0003\u001f\u0003A\u0011BAI\u0003\u0015\u0002(/\u001a9be\u0016lunY6U_\u0016cWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002\u001d\u0003'CqA]AG\u0001\u0004\t)\nE\u0003\u0002\u0018\u0006\u001dFM\u0004\u0003\u0002\u001a\u0006\rf\u0002BAN\u0003Ck!!!(\u000b\u0007\u0005}e!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0019\u0011Q\u0015\u0006\u0002\u000fA\f7m[1hK&\u0019\u00110!+\u000b\u0007\u0005\u0015&\u0002\u0003\u0004\u0002.\u0002!\tA`\u0001#i\u0016\u001cH/\u00169eCRLgnZ(gM2Lg.\u001a)beRLG/[8og\u000e{WO\u001c;)\t\u0005-\u0016\u0011\u0005\u0005\u0007\u0003g\u0003A\u0011\u0001@\u0002eQ,7\u000f\u001e(p\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:\u001c8\t[1oO\u00164uN\u001d+pa&\u001c7OQ3j]\u001e$U\r\\3uK\u0012DC!!-\u0002\"!1\u0011\u0011\u0018\u0001\u0005\u0002y\fQ\u0007^3tiV\u0003H-\u0019;j]\u001e|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|gn]\"pk:$H)\u001e:j]\u001e$v\u000e]5d\t\u0016dW\r^5p]\"\"\u0011qWA\u0011\u0001")
public class PartitionStateMachineTest {
    private ControllerContext kafka$controller$PartitionStateMachineTest$$controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private PartitionStateMachine partitionStateMachine = null;
    private final int kafka$controller$PartitionStateMachineTest$$brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));

    public ControllerContext kafka$controller$PartitionStateMachineTest$$controllerContext() {
        return this.kafka$controller$PartitionStateMachineTest$$controllerContext;
    }

    private void kafka$controller$PartitionStateMachineTest$$controllerContext_$eq(ControllerContext x$1) {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    public int kafka$controller$PartitionStateMachineTest$$brokerId() {
        return this.kafka$controller$PartitionStateMachineTest$$brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @Before
    public void setUp() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext_$eq(new ControllerContext());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new StateChangeLogger(this.kafka$controller$PartitionStateMachineTest$$brokerId(), true, (Option)None$.MODULE$), this.kafka$controller$PartitionStateMachineTest$$controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.kafka$controller$PartitionStateMachineTest$$controllerContext().partitionState(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L))})));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZkUtilsExceptionFromCreateStates() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andThrow((Throwable)new ZooKeeperClientException("test"));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()}))), this.controllerEpoch());
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L))})));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assert.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.kafka$controller$PartitionStateMachineTest$$brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.kafka$controller$PartitionStateMachineTest$$brokerId() + 1;
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5()), TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachineTest$$brokerId()));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId(), otherBrokerId})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId(), otherBrokerId})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs((Seq)Seq$.MODULE$.empty(), this.config().originals())).andReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)LogConfig$.MODULE$.apply())})), (Object)Predef$.MODULE$.Map().empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.kafka$controller$PartitionStateMachineTest$$brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZkUtilsExceptionFromStateLookup() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andThrow((Throwable)new ZooKeeperClientException(""));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assert.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assert.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.kafka$controller$PartitionStateMachineTest$$brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(partitions, leaderAndIsr);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().setLiveBrokerAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.kafka$controller$PartitionStateMachineTest$$brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final TopicPartition apply(int x$1) {
                return new TopicPartition(this.topic$1, x$1);
            }
            {
                this.topic$1 = topic$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachineTest $outer;

            public final void apply(TopicPartition partition) {
                this.$outer.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$controller$PartitionStateMachineTest$$brokerId()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.prepareMockToElectLeaderForPartitions((Seq<TopicPartition>)partitions);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient()});
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be ", " offline partition(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitions.size())})), (long)partitions.size(), (long)this.kafka$controller$PartitionStateMachineTest$$controllerContext().offlinePartitionCount());
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)OfflinePartitionLeaderElectionStrategy$.MODULE$));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be no offline partition(s)"})).s((Seq)Nil$.MODULE$), (long)0L, (long)this.kafka$controller$PartitionStateMachineTest$$controllerContext().offlinePartitionCount());
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final TopicPartition apply(int x$2) {
                return new TopicPartition(this.topic$2, x$2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().topicsToBeDeleted().add((Object)topic);
        this.kafka$controller$PartitionStateMachineTest$$controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be no offline partition(s)"})).s((Seq)Nil$.MODULE$), (long)0L, (long)this.kafka$controller$PartitionStateMachineTest$$controllerContext().offlinePartitionCount());
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(int x$3) {
                return new TopicPartition("test", x$3);
            }
        }, Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachineTest $outer;

            public final void apply(TopicPartition partition) {
                this.$outer.kafka$controller$PartitionStateMachineTest$$controllerContext().updatePartitionReplicaAssignment(partition, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$controller$PartitionStateMachineTest$$brokerId()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.kafka$controller$PartitionStateMachineTest$$controllerContext(), false);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.kafka$controller$PartitionStateMachineTest$$controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.kafka$controller$PartitionStateMachineTest$$controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachineTest $outer;

            public final void apply(TopicPartition partition) {
                PartitionAndReplica replica = new PartitionAndReplica(partition, this.$outer.kafka$controller$PartitionStateMachineTest$$brokerId());
                this.$outer.kafka$controller$PartitionStateMachineTest$$controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be ", " offline partition(s)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitions.size())})), (long)partitions.size(), (long)this.kafka$controller$PartitionStateMachineTest$$controllerContext().offlinePartitionCount());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be no offline partition(s)"})).s((Seq)Nil$.MODULE$), (long)0L, (long)this.kafka$controller$PartitionStateMachineTest$$controllerContext().offlinePartitionCount());
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        Seq getDataResponses = (Seq)partitions$1.map((Function1)new Serializable(this, stat, leaderIsrAndControllerEpoch){
            public static final long serialVersionUID = 0L;
            private final Stat stat$1;
            private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

            public final GetDataResponse apply(TopicPartition p) {
                return new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)p), TopicPartitionStateZNode$.MODULE$.encode(this.leaderIsrAndControllerEpoch$1), this.stat$1, new ResponseMetadata(0L, 0L));
            }
            {
                this.stat$1 = stat$1;
                this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(partitions$1)).andReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Seq topicsForPartitionsWithNoLiveInSyncReplicas = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        EasyMock.expect((Object)this.mockZkClient().getLogConfigs(topicsForPartitionsWithNoLiveInSyncReplicas, this.config().originals())).andReturn((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Map().empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        Map updatedLeaderAndIsr = ((TraversableOnce)partitions$1.map((Function1)new Serializable(this, leaderAndIsr$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionStateMachineTest $outer;
            private final LeaderAndIsr leaderAndIsr$1;

            public final Tuple2<TopicPartition, LeaderAndIsr> apply(TopicPartition partition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.leaderAndIsr$1.newLeaderAndIsr(this.$outer.kafka$controller$PartitionStateMachineTest$$brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$controller$PartitionStateMachineTest$$brokerId()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderAndIsr$1 = leaderAndIsr$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr(updatedLeaderAndIsr, this.controllerEpoch(), this.kafka$controller$PartitionStateMachineTest$$controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult(updatedLeaderAndIsr, (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
    }

    public PartitionStateMachineTest() {
        this.kafka$controller$PartitionStateMachineTest$$brokerId = 5;
        this.controllerEpoch = 50;
    }
}

