/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0001\u0003\u0001\u001d\u0011qCU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016$Vm\u001d;\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0013)\u0012!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\ta\u0003\u0005\u0002\u0013/%\u0011\u0001D\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bb\u0002\u000e\u0001\u0001\u0004%IaG\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\tar\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000fC\u0004!3\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004#\u0001\u0001\u0006KAF\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b\u0005C\u0004%\u0001\u0001\u0007I\u0011B\u0013\u0002\u00195|7m\u001b.l\u00072LWM\u001c;\u0016\u0003\u0019\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0003\u0002\u0005i\\\u0017BA\u0016)\u00055Y\u0015MZ6b5.\u001cE.[3oi\"9Q\u0006\u0001a\u0001\n\u0013q\u0013\u0001E7pG.T6n\u00117jK:$x\fJ3r)\tar\u0006C\u0004!Y\u0005\u0005\t\u0019\u0001\u0014\t\rE\u0002\u0001\u0015)\u0003'\u00035iwnY6[W\u000ec\u0017.\u001a8uA!91\u0007\u0001a\u0001\n\u0013!\u0014\u0001I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012!\u000e\t\u0003%YJ!a\u000e\u0002\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\"9\u0011\b\u0001a\u0001\n\u0013Q\u0014\u0001J7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"|F%Z9\u0015\u0005qY\u0004b\u0002\u00119\u0003\u0003\u0005\r!\u000e\u0005\u0007{\u0001\u0001\u000b\u0015B\u001b\u0002C5|7m[\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0011\t\u000f}\u0002\u0001\u0019!C\u0005\u0001\u0006\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKV\t\u0011\t\u0005\u0002\u0013\u0005&\u00111I\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\b\u000b\u0002\u0001\r\u0011\"\u0003G\u0003]\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f?\u0012*\u0017\u000f\u0006\u0002\u001d\u000f\"9\u0001\u0005RA\u0001\u0002\u0004\t\u0005BB%\u0001A\u0003&\u0011)\u0001\u000bsKBd\u0017nY1Ti\u0006$X-T1dQ&tW\r\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0003!\u0011'o\\6fe&#W#A'\u0011\u0005%q\u0015BA(\u000b\u0005\rIe\u000e\u001e\u0005\u0007#\u0002\u0001\u000b\u0011B'\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0003bB*\u0001\u0005\u0004%I\u0001V\u0001\u0007G>tg-[4\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0003\u0002\rM,'O^3s\u0013\tQvKA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002/\u0001A\u0003%Q+A\u0004d_:4\u0017n\u001a\u0011\t\u000fy\u0003!\u0019!C\u0005\u0019\u0006y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u0003\u0004a\u0001\u0001\u0006I!T\u0001\u0011G>tGO]8mY\u0016\u0014X\t]8dQ\u0002BqA\u0019\u0001C\u0002\u0013%1-A\u0005qCJ$\u0018\u000e^5p]V\tA\r\u0005\u0002f[6\taM\u0003\u0002hQ\u000611m\\7n_:T!!B5\u000b\u0005)\\\u0017AB1qC\u000eDWMC\u0001m\u0003\ry'oZ\u0005\u0003]\u001a\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004q\u0001\u0001\u0006I\u0001Z\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0003b\u0002:\u0001\u0005\u0004%Ia]\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cX#\u0001;\u0011\u0007UDH-D\u0001w\u0015\t9(\"\u0001\u0006d_2dWm\u0019;j_:L!!\u001f<\u0003\u0007M+\u0017\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001^\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004~\u0001\t\u0007I\u0011\u0002@\u0002\u000fI,\u0007\u000f\\5dCV\tq\u0010E\u0002\u0013\u0003\u0003I1!a\u0001\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0011\u001d\t9\u0001\u0001Q\u0001\n}\f\u0001B]3qY&\u001c\u0017\r\t\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001b\t\u0001B]3qY&\u001c\u0017m]\u000b\u0003\u0003\u001f\u00012!\u001e=\u0000\u0011!\t\u0019\u0002\u0001Q\u0001\n\u0005=\u0011!\u0003:fa2L7-Y:!\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tQa]3u+B$\u0012\u0001\b\u0015\u0005\u0003+\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019c[\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\t\tC\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003W\u0001A\u0011BA\u0017\u00031\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f)\u0011\ty#!\u000e\u0011\u0007I\t\t$C\u0002\u00024\t\u0011ABU3qY&\u001c\u0017m\u0015;bi\u0016Da!`A\u0015\u0001\u0004y\bbBA\u001d\u0001\u0011\u0005\u0011\u0011D\u0001\u001bi\u0016\u001cHo\u0015;beR,\bo\u00148mS:,\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003o\ti\u0004\u0005\u0003\u0002 \u0005}\u0012\u0002BA!\u0003C\u0011A\u0001V3ti\"9\u0011Q\t\u0001\u0005\u0002\u0005e\u0011a\u0007;fgR\u001cF/\u0019:ukB|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0002D\u0005u\u0002bBA&\u0001\u0011\u0005\u0011\u0011D\u0001$i\u0016\u001cHo\u0015;beR,\boV5uQJ+\u0007\u000f\\5dC^KG\u000f[8vi2+\u0017\rZ3sQ\u0011\tI%!\u0010\t\u000f\u0005E\u0003\u0001\"\u0001\u0002\u001a\u0005aC/Z:u\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0003\u001f\ni\u0004C\u0004\u0002X\u0001!\t!!\u0007\u0002mQ,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\t\u0005U\u0013Q\b\u0005\b\u0003;\u0002A\u0011AA\r\u0003]\"Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGk\\(gM2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"\u00111LA\u001f\u0011\u001d\t\u0019\u0007\u0001C\u0001\u00033\tq\b^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0002b\u0005u\u0002bBA5\u0001\u0011\u0005\u0011\u0011D\u0001Ci\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007\u0006BA4\u0003{Aq!a\u001c\u0001\t\u0003\tI\"\u0001\"uKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:DC!!\u001c\u0002>!9\u0011Q\u000f\u0001\u0005\u0002\u0005e\u0011a\r;fgRLeN^1mS\u0012tUm\u001e*fa2L7-\u0019+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\t\u0019(!\u0010\t\u000f\u0005m\u0004\u0001\"\u0001\u0002\u001a\u00059C/Z:u\u001d\u0016<(+\u001a9mS\u000e\fGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\tI(!\u0010\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u001a\u0005AC/Z:u\u001d\u0016<(+\u001a9mS\u000e\fGk\\(gM2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"\u0011qPA\u001f\u0011\u001d\t9\t\u0001C\u0001\u00033\tq\u0007^3ti&sg/\u00197jI:+wOU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)J\fgn]5uS>t\u0007\u0006BAC\u0003{Aq!!$\u0001\t\u0003\tI\"\u0001\u001euKN$\u0018J\u001c<bY&$g*Z<SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\"\u00111RA\u001f\u0011\u001d\t\u0019\n\u0001C\u0001\u00033\t!\b^3ti&sg/\u00197jI:+wOU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8)\t\u0005E\u0015Q\b\u0005\b\u00033\u0003A\u0011AA\r\u0003Y\"Xm\u001d;J]Z\fG.\u001b3P]2Lg.\u001a*fa2L7-\u0019+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\t9*!\u0010\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\u001a\u0005qC/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\ti*!\u0010\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002\u001a\u0005QC/Z:u\u001f:d\u0017N\\3SKBd\u0017nY1U_>sG.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006BAR\u0003{Aq!a+\u0001\t\u0003\tI\"A\u0016uKN$xJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$vn\u00144gY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\tI+!\u0010\t\u000f\u0005E\u0006\u0001\"\u0001\u0002\u001a\u0005QD/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0005\u0003_\u000bi\u0004C\u0004\u00028\u0002!\t!!\u0007\u0002{Q,7\u000f^%om\u0006d\u0017\u000eZ(oY&tWMU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\t\u0005U\u0016Q\b\u0005\b\u0003{\u0003A\u0011AA\r\u0003u\"Xm\u001d;J]Z\fG.\u001b3P]2Lg.\u001a*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000e\u0016:b]NLG/[8oQ\u0011\tY,!\u0010\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002\u001a\u00059D/Z:u\u0013:4\u0018\r\\5e\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>tuN\\3ySN$XM\u001c;SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DC!!1\u0002>!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005e\u0011a\f;fgRLeN^1mS\u0012|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006BAd\u0003{Aq!a4\u0001\t\u0003\tI\"A\u0016uKN$xJ\u001a4mS:,'+\u001a9mS\u000e\fGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\u0011\ti-!\u0010\t\u000f\u0005U\u0007\u0001\"\u0001\u0002\u001a\u0005!D/Z:u\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\t\u0005M\u0017Q\b\u0005\b\u00037\u0004A\u0011AA\r\u0003]\"Xm\u001d;PM\u001ad\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\"\u0011\u0011\\A\u001f\u0011\u001d\t\t\u000f\u0001C\u0001\u00033\ta\b^3ti&sg/\u00197jI>3g\r\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>t\u0007\u0006BAp\u0003{Aq!a:\u0001\t\u0003\tI\"A uKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\t\u0005\u0015\u0018Q\b\u0005\b\u0003[\u0004A\u0011AA\r\u0003]\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>tUm\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"\u00111^A\u001f\u0011\u001d\t\u0019\u0010\u0001C\u0001\u00033\t!\b^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\t\u0005E\u0018Q\b\u0005\b\u0003s\u0004A\u0011AA\r\u0003m\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0003o\fi\u0004C\u0004\u0002\u0000\u0002!\t!!\u0007\u0002\u007fQ,7\u000f\u001e*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\"\u0011Q`A\u001f\u0011\u001d\u0011)\u0001\u0001C\u0001\u00033\tq\b^3tiJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vNU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0003\u0004\u0005u\u0002b\u0002B\u0006\u0001\u0011\u0005\u0011\u0011D\u0001<i\u0016\u001cHOU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006\u0002B\u0005\u0003{AqA!\u0005\u0001\t\u0003\tI\"\u0001\u001euKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)>tUm\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\"!qBA\u001f\u0011\u001d\u00119\u0002\u0001C\u0001\u00033\tQ\b^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:DCA!\u0006\u0002>!9!Q\u0004\u0001\u0005\u0002\u0005e\u0011A\u0010;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7U_>3g\r\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0003\u001c\u0005u\u0002b\u0002B\u0012\u0001\u0011\u0005\u0011\u0011D\u0001Gi\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\u0011\u0011\t#!\u0010\t\u000f\t%\u0002\u0001\"\u0001\u0002\u001a\u0005IE/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000eV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\t\t\u001d\u0012Q\b\u0005\b\u0005_\u0001A\u0011AA\r\u0003\t#Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,Gk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0005\u0005[\ti\u0004C\u0004\u00036\u0001!\t!!\u0007\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007\u0006\u0002B\u001a\u0003{AqAa\u000f\u0001\t\u0003\tI\"\u0001\u001cuKN$(+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000e\u000b\u0003\u0003:\u0005u\u0002b\u0002B!\u0001\u0011\u0005\u0011\u0011D\u0001Gi\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\u0011\u0011y$!\u0010\t\u000f\t\u001d\u0003\u0001\"\u0001\u0002\u001a\u0005IE/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8)\t\t\u0015\u0013Q\b\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0003U!Xm\u001d;J]Z\fG.\u001b3Ue\u0006t7/\u001b;j_:$R\u0001\bB)\u0005+B\u0001Ba\u0015\u0003L\u0001\u0007\u0011qF\u0001\nMJ|Wn\u0015;bi\u0016D\u0001Ba\u0016\u0003L\u0001\u0007\u0011qF\u0001\bi>\u001cF/\u0019;f\u0001")
public class ReplicaStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final Seq<PartitionAndReplica> replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionAndReplica[]{this.replica()}));

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.replicaStateMachine_$eq((ReplicaStateMachine)new ZkReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private ReplicaState replicaState(PartitionAndReplica replica) {
        return this.controllerContext().replicaState(replica);
    }

    @Test
    public void testStartupOnlinePartition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map liveBrokerEpochs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint1})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokerAndEpochs(liveBrokerEpochs);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupOfflinePartition() {
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupWithReplicaWithoutLeader() {
        int shutdownBrokerId = 100;
        PartitionAndReplica offlineReplica = new PartitionAndReplica(this.partition(), shutdownBrokerId);
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map liveBrokerEpochs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint1})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokerAndEpochs(liveBrokerEpochs);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{shutdownBrokerId})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)offlineReplica));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(offlineReplica));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NewReplica$.MODULE$);
        Assert.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map liveBrokerEpochs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint1})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokerAndEpochs(liveBrokerEpochs);
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addUpdateMetadataRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (Set)EasyMock.eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}))));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        int otherBrokerId = this.brokerId() + 1;
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}));
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)replicaIds);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)adjustedLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, (Seq)replicaIds, false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo().apply((Object)this.partition()));
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NonExistentReplica$.MODULE$);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.controllerContext().putReplicaState(this.replica(), fromState);
        this.replicaStateMachine().handleStateChanges(this.replicas(), toState);
        Assert.assertEquals((Object)fromState, (Object)this.replicaState(this.replica()));
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

