/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.controller.TopicDeletionManagerTest$;
import kafka.controller.TopicDeletionManagerTest$$anonfun$initContext$1$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u000f\tABk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012\u0001\u00032s_.,'/\u00133\u0016\u0003Y\u0001\"!C\f\n\u0005aQ!aA%oi\"1!\u0004\u0001Q\u0001\nY\t\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000fq\u0001!\u0019!C\u0005;\u000511m\u001c8gS\u001e,\u0012A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0003C\u0011\taa]3sm\u0016\u0014\u0018BA\u0012!\u0005-Y\u0015MZ6b\u0007>tg-[4\t\r\u0015\u0002\u0001\u0015!\u0003\u001f\u0003\u001d\u0019wN\u001c4jO\u0002Bqa\n\u0001C\u0002\u0013%\u0001&\u0001\beK2,G/[8o\u00072LWM\u001c;\u0016\u0003%\u0002\"A\u0005\u0016\n\u0005-\u0012!A\u0004#fY\u0016$\u0018n\u001c8DY&,g\u000e\u001e\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002\u001f\u0011,G.\u001a;j_:\u001cE.[3oi\u0002BQa\f\u0001\u0005\u0002A\n!\u0003^3ti&s\u0017\u000e^5bY&T\u0018\r^5p]R\t\u0011\u0007\u0005\u0002\ne%\u00111G\u0003\u0002\u0005+:LG\u000f\u000b\u0002/kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002u\u0005\u0019qN]4\n\u0005q:$\u0001\u0002+fgRDQA\u0010\u0001\u0005\u0002A\n\u0011\u0003^3ti\n\u000b7/[2EK2,G/[8oQ\tiT\u0007C\u0003B\u0001\u0011\u0005\u0001'A\u000fuKN$H)\u001a7fi&|gnV5uQ\n\u0013xn[3s\u001f\u001a4G.\u001b8fQ\t\u0001U\u0007C\u0003E\u0001\u0011\u0005\u0001'A\u0013uKN$(I]8lKJ4\u0015-\u001b7ve\u0016\fe\r^3s\t\u0016dW\r^5p]N#\u0018M\u001d;fI\"\u00121)\u000e\u0005\u0006\u000f\u0002!\t\u0001S\u0001\fS:LGoQ8oi\u0016DH\u000fF\u0003J\u0019j3\u0007\u000e\u0005\u0002\u0013\u0015&\u00111J\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\b\"B'G\u0001\u0004q\u0015a\u00022s_.,'o\u001d\t\u0004\u001f^3bB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u0019f!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011aKC\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016LA\u0002TKFT!A\u0016\u0006\t\u000bm3\u0005\u0019\u0001/\u0002\rQ|\u0007/[2t!\ri\u0006m\u0019\b\u0003\u0013yK!a\u0018\u0006\u0002\rA\u0013X\rZ3g\u0013\t\t'MA\u0002TKRT!a\u0018\u0006\u0011\u0005u#\u0017BA3c\u0005\u0019\u0019FO]5oO\")qM\u0012a\u0001-\u0005ia.^7QCJ$\u0018\u000e^5p]NDQ!\u001b$A\u0002Y\t\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0001")
public class TopicDeletionManagerTest {
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private DeletionClient deletionClient() {
        return this.deletionClient;
    }

    @Test
    public void testInitialization() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar", "baz"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "baz"})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted().toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsIneligibleForDeletion().toSet());
    }

    @Test
    public void testBasicDeletion() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionAndReplica x$1) {
                String string = x$1.topic();
                String string2 = "foo";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testDeletionWithBrokerOffline() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1)new Serializable(this, failedBrokerId){
            public static final long serialVersionUID = 0L;
            private final int failedBrokerId$1;

            public final boolean apply(PartitionAndReplica x$2) {
                return x$2.replica() == this.failedBrokerId$1;
            }
            {
                this.failedBrokerId$1 = failedBrokerId$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)offlineReplicas, (Object)onlineReplicas);
            scala.collection.immutable.Set offlineReplicas2 = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set onlineReplicas2 = (scala.collection.immutable.Set)tuple23._2();
            replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)offlineReplicas2.toSeq(), (ReplicaState)OfflineReplica$.MODULE$);
            deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
            ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
            deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
            Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)OfflineReplica$.MODULE$));
            controllerContext.addLiveBrokersAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
            deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            deletionManager.completeReplicaDeletion((Set)offlineReplicas2);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(PartitionAndReplica x$4) {
                    String string = x$4.topic();
                    String string2 = "foo";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            }));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testBrokerFailureAfterDeletionStarted() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1)new Serializable(this, failedBrokerId){
            public static final long serialVersionUID = 0L;
            private final int failedBrokerId$2;

            public final boolean apply(PartitionAndReplica x$5) {
                return x$5.replica() == this.failedBrokerId$2;
            }
            {
                this.failedBrokerId$2 = failedBrokerId$2;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)offlineReplicas, (Object)onlineReplicas);
            scala.collection.immutable.Set offlineReplicas2 = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set onlineReplicas2 = (scala.collection.immutable.Set)tuple23._2();
            deletionManager.failReplicaDeletion((Set)offlineReplicas2);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            controllerContext.addLiveBrokersAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
            deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
            deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor) {
        ControllerContext context = new ControllerContext();
        Map brokerEpochs = ((TraversableOnce)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Broker, Object> apply(int brokerId) {
                EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokerAndEpochs(brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1)new Serializable(this, brokers, numPartitions, replicationFactor, context, leaderIndex){
            public static final long serialVersionUID = 0L;
            public final Seq brokers$1;
            private final int numPartitions$1;
            public final int replicationFactor$1;
            public final ControllerContext context$1;
            public final IntRef leaderIndex$1;

            public final void apply(String topic) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions$1).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$initContext$1 $outer;
                    private final String topic$1;

                    public final void apply(int partitionId) {
                        this.apply$mcVI$sp(partitionId);
                    }

                    public void apply$mcVI$sp(int partitionId) {
                        TopicPartition partition = new TopicPartition(this.topic$1, partitionId);
                        IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.replicationFactor$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initContext$1$$anonfun$apply$1 $outer;

                            public final int apply(int i) {
                                return this.apply$mcII$sp(i);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public int apply$mcII$sp(int i) {
                                void var2_2;
                                int replica = BoxesRunTime.unboxToInt((Object)this.$outer.kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer().brokers$1.apply((i + this.$outer.kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer().leaderIndex$1.elem) % this.$outer.kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer().brokers$1.size()));
                                return (int)var2_2;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        this.$outer.context$1.updatePartitionReplicaAssignment(partition, (Seq)replicas);
                        ++this.$outer.leaderIndex$1.elem;
                    }

                    public /* synthetic */ $anonfun$initContext$1 kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$1 = topic$1;
                    }
                });
            }
            {
                this.brokers$1 = brokers$1;
                this.numPartitions$1 = numPartitions$1;
                this.replicationFactor$1 = replicationFactor$1;
                this.context$1 = context$1;
                this.leaderIndex$1 = leaderIndex$1;
            }
        });
        return context;
    }

    public TopicDeletionManagerTest() {
        this.brokerId = 1;
    }
}

