/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0001\u0003\u0001%\u0011\u0011c\u0012:pkBlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\tA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012\u0001\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019\u0019FO]5oO\"1\u0011\u0005\u0001Q\u0001\na\tQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003bB\u0012\u0001\u0005\u0004%IaF\u0001\bOJ|W\u000f]%e\u0011\u0019)\u0003\u0001)A\u00051\u0005AqM]8va&#\u0007\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u001f\u001d\u0014x.\u001e9J]N$\u0018M\\2f\u0013\u0012,\u0012!\u000b\t\u0004\u0017)B\u0012BA\u0016\r\u0005\u0011\u0019v.\\3\t\r5\u0002\u0001\u0015!\u0003*\u0003A9'o\\;q\u0013:\u001cH/\u00198dK&#\u0007\u0005C\u00040\u0001\t\u0007I\u0011B\f\u0002\u00115,WNY3s\u0013\u0012Da!\r\u0001!\u0002\u0013A\u0012!C7f[\n,'/\u00133!\u0011\u001d\u0019\u0004A1A\u0005\n]\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\r\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u001c\u0001\u0005\u0004%IaF\u0001\u000bG2LWM\u001c;I_N$\bBB\u001d\u0001A\u0003%\u0001$A\u0006dY&,g\u000e\u001e%pgR\u0004\u0003bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5/F\u0001>!\tYa(\u0003\u0002@\u0019\t\u0019\u0011J\u001c;\t\r\u0005\u0003\u0001\u0015!\u0003>\u0003M\u0011XMY1mC:\u001cW\rV5nK>,H/T:!\u0011\u001d\u0019\u0005A1A\u0005\nq\n\u0001c]3tg&|g\u000eV5nK>,H/T:\t\r\u0015\u0003\u0001\u0015!\u0003>\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000f\t\u0005\b\u0007\u0001\u0001\r\u0011\"\u0003H+\u0005A\u0005C\u0001\u000bJ\u0013\tQ%AA\u0007He>,\b/T3uC\u0012\fG/\u0019\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0003%9'o\\;q?\u0012*\u0017\u000f\u0006\u0002O#B\u00111bT\u0005\u0003!2\u0011A!\u00168ji\"9!kSA\u0001\u0002\u0004A\u0015a\u0001=%c!1A\u000b\u0001Q!\n!\u000baa\u001a:pkB\u0004\u0003b\u0002,\u0001\u0001\u0004%IaV\u0001\u0007[\u0016l'-\u001a:\u0016\u0003a\u0003\"\u0001F-\n\u0005i\u0013!AD'f[\n,'/T3uC\u0012\fG/\u0019\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0003)iW-\u001c2fe~#S-\u001d\u000b\u0003\u001dzCqAU.\u0002\u0002\u0003\u0007\u0001\f\u0003\u0004a\u0001\u0001\u0006K\u0001W\u0001\b[\u0016l'-\u001a:!\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0015\u0019X\r^+q)\u0005q\u0005FA1f!\t17.D\u0001h\u0015\tA\u0017.A\u0003kk:LGOC\u0001k\u0003\ry'oZ\u0005\u0003Y\u001e\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u0003\u0019\u0017A\u0007;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gn\u0015;bE2,\u0007FA7q!\t1\u0017/\u0003\u0002sO\n!A+Z:u\u0011\u0015!\b\u0001\"\u0001d\u0003\u001d\"Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]\u000e{W\u000e\u001d7fi&twMU3cC2\fgnY3)\u0005M\u0004\b\"B<\u0001\t\u0003\u0019\u0017!\u000b;fgR\u001c\u0015M\u001c8piJ+'-\u00197b]\u000e,w\u000b[3o!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\r\u000b\u0002wa\")!\u0010\u0001C\u0001G\u0006YB/Z:u\u0007\u0006tgn\u001c;SK\n\fG.\u00198dK^CWM\u001c#fC\u0012D#!\u001f9\t\u000bu\u0004A\u0011A2\u0002QQ,7\u000f^*uC\ndW\rV8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,GK]1og&$\u0018n\u001c8)\u0005q\u0004\bBBA\u0001\u0001\u0011\u00051-\u0001\u000euKN$8\u000b^1cY\u0016$v\u000eR3bIR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002\u0000a\"1\u0011q\u0001\u0001\u0005\u0002\r\f1\u0007^3ti\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW\rV8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,GK]1og&$\u0018n\u001c8)\u0007\u0005\u0015\u0001\u000f\u0003\u0004\u0002\u000e\u0001!\taY\u0001'i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{G)Z1e)J\fgn]5uS>t\u0007fAA\u0006a\"1\u00111\u0003\u0001\u0005\u0002\r\fq\u0005^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p\u000b6\u0004H/\u001f+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011\u0011\u00039\t\r\u0005e\u0001\u0001\"\u0001d\u0003e!Xm\u001d;F[B$\u0018\u0010V8EK\u0006$GK]1og&$\u0018n\u001c8)\u0007\u0005]\u0001\u000f\u0003\u0004\u0002 \u0001!\taY\u0001(i\u0016\u001cH/Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f)>\u001cF/\u00192mKR\u0013\u0018M\\:ji&|g\u000eK\u0002\u0002\u001eADa!!\n\u0001\t\u0003\u0019\u0017A\t;fgR,U\u000e\u001d;z)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004\u0002$A\fI#a\u000b\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!!\f\u0011\u0007e\ty#C\u0002\u00022i\u0011Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g\u000e\u0003\u0004\u00026\u0001!\taY\u0001$i\u0016\u001cHo\u0015;bE2,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r\t\u0019\u0004\u001d\u0005\u0007\u0003w\u0001A\u0011A2\u0002[Q,7\u000f^#naRLHk\\!xC&$\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004\u0002:A\fI#a\u000b\t\r\u0005\u0005\u0003\u0001\"\u0001d\u0003m\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\b\u0003\u007f\u0001\u0018\u0011FA\u0016\u0011\u0019\t9\u0005\u0001C\u0001G\u0006yC/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\":\u0011Q\t9\u0002*\u0005-\u0002BBA'\u0001\u0011\u00051-A\u001duKN$\u0018i^1ji&twMU3cC2\fgnY3U_\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u001d\tY\u0005]A\u0015\u0003WAa!a\u0015\u0001\t\u0003\u0019\u0017a\b;fgR$U-\u00193U_\u0012+\u0017\rZ%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"1\u0011q\u000b\u0001\u0005\u0002\r\f\u0011\u0005^3ti\u0012+\u0017\r\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!!\u0016q\u0003S\tY\u0003\u0003\u0004\u0002^\u0001!\taY\u0001.i\u0016\u001cH\u000fR3bIR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fBA.a\u0006%\u00121\u0006\u0005\u0007\u0003G\u0002A\u0011A2\u0002YQ,7\u000f\u001e#fC\u0012$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fBA1a\u0006%\u00121\u0006\u0005\u0007\u0003S\u0002A\u0011A2\u0002%Q,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003O\u0002\bBBA8\u0001\u0011\u00051-A\u0012uKN$8+\u001a7fGR\u0004&o\u001c;pG>d'+Y5tKNLeMT8NK6\u0014WM]:)\u000f\u00055\u0004/!\u000b\u0002,!1\u0011Q\u000f\u0001\u0005\u0002\r\f1\u0006^3tiN+G.Z2u!J|Go\\2pY\u000eCwn\\:fg\u000e{W\u000e]1uS\ndW\r\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003g\u0002\bBBA>\u0001\u0011\u00051-A\u000buKN$8+\u001e9q_J$8\u000f\u0015:pi>\u001cw\u000e\\:)\u0007\u0005e\u0004\u000f\u0003\u0004\u0002\u0002\u0002!\taY\u0001\u0017i\u0016\u001cH/\u00138ji:+\u0007\u0010^$f]\u0016\u0014\u0018\r^5p]\"\u001a\u0011q\u00109\t\r\u0005\u001d\u0005\u0001\"\u0001d\u0003\u0001\"Xm\u001d;J]&$h*\u001a=u\u000f\u0016tWM]1uS>tW)\u001c9us\u001e\u0013x.\u001e9)\u0007\u0005\u0015\u0005\u000f\u0003\u0004\u0002\u000e\u0002!\taY\u0001\u0011i\u0016\u001cHo\u00144gg\u0016$8i\\7nSRD3!a#q\u0011\u0019\t\u0019\n\u0001C\u0001G\u00069B/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e$bS2,(/\u001a\u0015\u0004\u0003#\u0003\bBBAM\u0001\u0011\u00051-A\u0015uKN$xJ\u001a4tKR\u001cu.\\7ji\u001a\u000b\u0017\u000e\\;sK^KG\u000f[!o_RDWM\u001d)f]\u0012Lgn\u001a\u0015\u0004\u0003/\u0003\bBBAP\u0001\u0011\u00051-\u0001\u0012uKN$xJ\u001a4tKR\u001cu.\\7ji^KG\u000f[!o_RDWM\u001d)f]\u0012Lgn\u001a\u0015\u0004\u0003;\u0003\bBBAS\u0001\u0011\u00051-\u0001\u0016uKN$8i\u001c8tk6,'OQ3biN$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;)\u0007\u0005\r\u0006\u000f\u0003\u0004\u0002,\u0002!\taY\u0001)i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\n+\u0017\r^:D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004\u0003S\u0003\bBBAY\u0001\u0011\u00051-A\u001buKN$HK]1og\u0006\u001cG/[8oC2\u001cu.\\7ji&\u001b\u0018IY8si\u0016$\u0017I\u001c3D_:\u001cX/\\3s\u0007>lW.\u001b;XS:\u001c\bfAAXa\"1\u0011q\u0017\u0001\u0005\u0002\r\fQ\u0006^3ti\u001a\u000b\u0017\u000e\\3e)btwJ\u001a4tKR\u001cu.\\7ji2+\u0017M^3t\u001d>\u0004VM\u001c3j]\u001e\u001cF/\u0019;fQ\r\t)\f\u001d\u0005\u0007\u0003{\u0003A\u0011A2\u0002aQ,7\u000f\u001e*fa2\f7-Z$s_V\u0004\u0018J\\:uC:\u001cWmV5uQ\u0016k\u0007\u000f^=He>,\b/\u00138ti\u0006t7-Z%eQ\u001d\tY\f]A\u0015\u0003\u0003\u001c#!a1\u0011\t\u0005\u0015\u0017Q\u001b\b\u0005\u0003\u000f\f\tN\u0004\u0003\u0002J\u0006=WBAAf\u0015\r\ti\rC\u0001\u0007yI|w\u000e\u001e \n\u00035I1!a5\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!a6\u0002Z\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005MG\u0002\u0003\u0004\u0002^\u0002!\taY\u0001.i\u0016\u001cHOU3qY\u0006\u001cWm\u0012:pkBLen\u001d;b]\u000e,w+\u001b;i\u001d>tW\t_5ti&tw-T3nE\u0016\u0014\bfBAna\u0006%\u0012\u0011\u0019\u0005\u0007\u0003G\u0004A\u0011A2\u00021Q,7\u000f\u001e*fa2\f7-Z$s_V\u0004\u0018J\\:uC:\u001cW\rK\u0002\u0002bBDa!!;\u0001\t\u0003\u0019\u0017A\u0006;fgRLeN^8lK*{\u0017N\\\"bY2\u0014\u0017mY6)\u0007\u0005\u001d\b\u000f\u0003\u0004\u0002p\u0002!\taY\u0001\u001ai\u0016\u001cHOT8u\u0013:4xn[3K_&t7)\u00197mE\u0006\u001c7\u000eK\u0002\u0002nBDa!!>\u0001\t\u0003\u0019\u0017A\u0006;fgRLeN^8lKNKhnY\"bY2\u0014\u0017mY6)\u0007\u0005M\b\u000f\u0003\u0004\u0002|\u0002!\taY\u0001\u001ai\u0016\u001cHOT8u\u0013:4xn[3Ts:\u001c7)\u00197mE\u0006\u001c7\u000eK\u0002\u0002zBDqA!\u0001\u0001\t\u0013\u0011\u0019!A\u0006bgN,'\u000f^*uCR,G#\u0002(\u0003\u0006\t\u001d\u0001BB\u0002\u0002\u0000\u0002\u0007\u0001\n\u0003\u0005\u0003\n\u0005}\b\u0019\u0001B\u0006\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0007Q\u0011i!C\u0002\u0003\u0010\t\u0011!b\u0012:pkB\u001cF/\u0019;f\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+\t\u0011c\u001c4gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b)\u0011\u00119Ba\t\u0011\t\te!qD\u0007\u0003\u00057Q1A!\b\u0007\u0003\u0019\u0019w.\\7p]&!!\u0011\u0005B\u000e\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0005\t\u0005K\u0011\t\u00021\u0001\u0003(\u00051qN\u001a4tKR\u00042a\u0003B\u0015\u0013\r\u0011Y\u0003\u0004\u0002\u0005\u0019>tw\r")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            Assert.fail((String)"should have failed due to illegal transition");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$4 = member;
        Function1 x$5 = qual$1.add$default$2();
        qual$1.add(x$4, x$5);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$6 = otherMember;
        Function1 x$7 = qual$2.add$default$2();
        qual$2.add(x$6, x$7);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$3 = this.group();
        MemberMetadata x$8 = lastMember;
        Function1 x$9 = qual$3.add$default$2();
        qual$3.add(x$8, x$9);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        Assert.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$4 = this.group();
        MemberMetadata x$10 = member;
        Function1 x$11 = qual$4.add$default$2();
        qual$4.add(x$10, x$11);
        GroupMetadata qual$5 = this.group();
        MemberMetadata x$12 = otherMember;
        Function1 x$13 = qual$5.add$default$2();
        qual$5.add(x$12, x$13);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$6 = this.group();
        MemberMetadata x$14 = this.member();
        Function1 x$15 = qual$6.add$default$2();
        qual$6.add(x$14, x$15);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$7 = this.group();
        MemberMetadata x$16 = otherMember;
        Function1 x$17 = qual$7.add$default$2();
        qual$7.add(x$16, x$17);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testInitNextGeneration() {
        this.member().supportedProtocols_$eq(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$1) {
            }
        });
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocolOrNull());
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$8 = this.group();
        MemberMetadata x$18 = this.member();
        Function1 x$19 = qual$8.add$default$2();
        qual$8.add(x$18, x$19);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, Option$.MODULE$.empty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1)new Serializable(this, joinAwaitingMemberFenced){
            public static final long serialVersionUID = 0L;
            private final BooleanRef joinAwaitingMemberFenced$1;

            public final void apply(JoinGroupResult joinGroupResult) {
                Errors errors = joinGroupResult.error();
                Errors errors2 = Errors.FENCED_INSTANCE_ID;
                this.joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
            {
                this.joinAwaitingMemberFenced$1 = joinAwaitingMemberFenced$1;
            }
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.member().awaitingSyncCallback_$eq((Function1)new Serializable(this, syncAwaitingMemberFenced){
            public static final long serialVersionUID = 0L;
            private final BooleanRef syncAwaitingMemberFenced$1;

            public final void apply(SyncGroupResult syncGroupResult) {
                Errors errors = syncGroupResult.error();
                Errors errors2 = Errors.FENCED_INSTANCE_ID;
                this.syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
            {
                this.syncAwaitingMemberFenced$1 = syncAwaitingMemberFenced$1;
            }
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assert.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assert.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assert.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assert.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1)new Serializable(this, invoked){
            public static final long serialVersionUID = 0L;
            private final BooleanRef invoked$1;

            public final void apply(JoinGroupResult x$2) {
                this.invoked$1.elem = true;
            }
            {
                this.invoked$1 = invoked$1;
            }
        });
        Assert.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), GroupCoordinator$.MODULE$.joinError(this.member().memberId(), Errors.NONE));
        Assert.assertTrue((boolean)invoked.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$9 = this.group();
        MemberMetadata x$20 = this.member();
        Function1 x$21 = qual$9.add$default$2();
        qual$9.add(x$20, x$21);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), GroupCoordinator$.MODULE$.joinError(this.member().memberId(), Errors.NONE));
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$10 = this.group();
        MemberMetadata x$22 = this.member();
        Function1 x$23 = qual$10.add$default$2();
        qual$10.add(x$22, x$23);
        this.member().awaitingSyncCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SyncGroupResult x$3) {
            }
        });
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), new SyncGroupResult((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), Errors.NONE));
        Assert.assertTrue((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$11 = this.group();
        MemberMetadata x$24 = this.member();
        Function1 x$25 = qual$11.add$default$2();
        qual$11.add(x$24, x$25);
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), new SyncGroupResult((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), Errors.NONE));
        Assert.assertFalse((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$1;

            public final void apply(GroupState otherState) {
                Assert.assertFalse((boolean)this.group$1.is(otherState));
            }
            {
                this.group$1 = group$1;
            }
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

