/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u000f\tIBj\\4DY\u0016\fg.\u001a:J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t\t\u0013IY:ue\u0006\u001cG\u000fT8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013\u0005!#A\u0003d_\u0012,7-F\u0001\u0014!\t!b$D\u0001\u0016\u0015\t1r#\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u00031e\taaY8n[>t'BA\u0003\u001b\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\n\u0005})\"aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\t\r\u0005\u0002\u0001\u0015!\u0003\u0014\u0003\u0019\u0019w\u000eZ3dA!91\u0005\u0001b\u0001\n\u0003!\u0013\u0001\u0002;j[\u0016,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tQ!\u001e;jYNL!AK\u0014\u0003\u00115{7m\u001b+j[\u0016Da\u0001\f\u0001!\u0002\u0013)\u0013!\u0002;j[\u0016\u0004\u0003b\u0002\u0018\u0001\u0005\u0004%\taL\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\t\u0001\u0007E\u00022iYj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003oaj\u0011aF\u0005\u0003s]\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004<\u0001\u0001\u0006I\u0001M\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002BQ!\u0010\u0001\u0005\u0002y\n!\b^3ti6\u000b'o[:QCJ$\u0018\u000e^5p]N\f5o\u00144gY&tW-\u00118e!>\u0004X\u000f\\1uKN,fn\u00197fC:\f'\r\\3NKR\u0014\u0018nY:\u0015\u0003}\u0002\"!\r!\n\u0005\u0005\u0013$\u0001B+oSRDC\u0001P\"J\u0015B\u0011AiR\u0007\u0002\u000b*\u0011a\tH\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0011\u0016\u0013A\u0001V3ti\u00069A/[7f_V$hD\u0001\u001e\u0019\u0012\u0015a\u0005\u0001\"\u0001?\u0003]!Xm\u001d;NCbdunZ\"p[B\f7\r^5p]2\u000bw\r\u000b\u0002L\u0007\")q\n\u0001C\u0005!\u0006Y!/Z1e\rJ|W\u000eT8h)\t\tV\fE\u0002S+^k\u0011a\u0015\u0006\u0003)J\n!bY8mY\u0016\u001cG/[8o\u0013\t16K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\t\u0004L\u0017.\n\u0005e\u0013$A\u0002+va2,'\u0007\u0005\u000227&\u0011AL\r\u0002\u0004\u0013:$\b\"B\u0002O\u0001\u0004q\u0006CA\u0005`\u0013\t\u0001'AA\u0002M_\u001eDQA\u0019\u0001\u0005\n\r\fAb\u001e:ji\u0016\\U-\u001f#vaN$\u0002\u0002Z4jW2l'\u000f\u001e\t\u0004%\u0016<\u0016B\u00014T\u0005\r\u0019V-\u001d\u0005\u0006Q\u0006\u0004\rAW\u0001\b]Vl7*Z=t\u0011\u0015Q\u0017\r1\u0001[\u0003\u001dqW/\u001c#vaNDQaA1A\u0002yCQ!E1A\u0002MAQA\\1A\u0002=\f\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0005E\u0002\u0018BA93\u0005\u0011auN\\4\t\u000bM\f\u0007\u0019\u0001.\u0002\u0015M$\u0018M\u001d;WC2,X\rC\u0003vC\u0002\u0007!,\u0001\u0003ti\u0016\u0004\b")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test(timeout=15000L)
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            MemoryRecords largeMessageSet;
            MemoryRecords memoryRecords;
            MemoryRecords largeMessageSet2 = memoryRecords = (largeMessageSet = (MemoryRecords)tuple2._2());
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$2 = maxMessageSize;
            long x$3 = 100L;
            float x$4 = this.makeCleaner$default$2();
            int x$5 = this.makeCleaner$default$3();
            long x$6 = this.makeCleaner$default$6();
            int x$7 = this.makeCleaner$default$7();
            int x$8 = this.makeCleaner$default$8();
            long x$9 = this.makeCleaner$default$9();
            Option<Object> x$10 = this.makeCleaner$default$10();
            Properties x$11 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11));
            this.breakPartitionLog$1(this.topicPartitions()[0]);
            this.breakPartitionLog$1(this.topicPartitions()[1]);
            this.cleaner().startup();
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Log log22 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
            String uncleanableDirectory = log2.dir().getParent();
            Gauge uncleanablePartitionsCountGauge = this.getGauge$1("uncleanable-partitions-count", uncleanableDirectory);
            Gauge uncleanableBytesGauge = this.getGauge$1("uncleanable-bytes", uncleanableDirectory);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, uncleanablePartitionsCountGauge){
                public static final long serialVersionUID = 0L;
                private final Gauge uncleanablePartitionsCountGauge$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToInt((Object)this.uncleanablePartitionsCountGauge$1.value()) == 2;
                }
                {
                    this.uncleanablePartitionsCountGauge$1 = uncleanablePartitionsCountGauge$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "There should be 2 uncleanable partitions";
                }
            }, 2000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            long expectedTotalUncleanableBytes = LogCleaner$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleaner$.MODULE$.calculateCleanableBytes(log22, 0L, ((LogSegment)log22.logSegments().last()).baseOffset())._2$mcJ$sp();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, uncleanableBytesGauge, expectedTotalUncleanableBytes){
                public static final long serialVersionUID = 0L;
                private final Gauge uncleanableBytesGauge$1;
                private final long expectedTotalUncleanableBytes$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToLong((Object)this.uncleanableBytesGauge$1.value()) == this.expectedTotalUncleanableBytes$1;
                }
                {
                    this.uncleanableBytesGauge$1 = uncleanableBytesGauge$1;
                    this.expectedTotalUncleanableBytes$1 = expectedTotalUncleanableBytes$1;
                }
            }, (Function0<String>)new Serializable(this, expectedTotalUncleanableBytes){
                public static final long serialVersionUID = 0L;
                private final long expectedTotalUncleanableBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be ", " uncleanable bytes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedTotalUncleanableBytes$1)}));
                }
                {
                    this.expectedTotalUncleanableBytes$1 = expectedTotalUncleanableBytes$1;
                }
            }, 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
            Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
            Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
            Assert.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$13 = cleanerBackOffMs;
        long x$14 = minCompactionLagMs;
        int x$15 = segmentSize;
        long x$16 = maxCompactionLagMs;
        float x$17 = minCleanableDirtyRatio;
        int x$18 = this.makeCleaner$default$3();
        int x$19 = this.makeCleaner$default$5();
        int x$20 = this.makeCleaner$default$7();
        Option<Object> x$21 = this.makeCleaner$default$10();
        Properties x$22 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$17, x$18, x$13, x$19, x$14, x$20, x$15, x$16, x$21, x$22));
        Log log2 = (Log)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log2, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log2.size();
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assert.assertEquals((String)"There should be no cleaning until the max compaction lag has passed", (long)startSizeBlock0, (long)log2.size());
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log2, CompressionType.NONE, T1, 0, 0);
        log2.roll(log2.roll$default$1());
        LogSegment activeSegAtT1 = log2.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$23 = new TopicPartition("log", 0);
        long x$24 = firstBlockCleanableSegmentOffset;
        long x$25 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$23, x$24, x$25);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log2);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed at least to offset ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBlockCleanableSegmentOffset)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastCleaned)}))).toString(), (lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0);
        Assert.assertNotEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should still contain non-zero keys"})).s((Seq)Nil$.MODULE$), appends1, read1);
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$26 = new TopicPartition("log", 0);
        long x$27 = activeSegAtT1.baseOffset();
        long x$28 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$26, x$27, x$28);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log2);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should only contains zero keys now"})).s((Seq)Nil$.MODULE$), appends1, read2);
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assert.assertTrue((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed at least to offset ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)secondBlockCleanableSegmentOffset)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastCleaned2)}))).toString(), (lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Record record) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, Log log2, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log2, codec, timestamp, step, valCounter){
            public static final long serialVersionUID = 0L;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            public final long timestamp$1;
            public final int step$1;
            public final IntRef valCounter$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeKeyDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int curValue = this.$outer.valCounter$1.elem;
                        byte[] x$29 = ((Object)BoxesRunTime.boxToInteger((int)curValue)).toString().getBytes();
                        CompressionType x$30 = this.$outer.codec$1;
                        byte[] x$31 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        long x$32 = this.$outer.timestamp$1;
                        byte x$33 = TestUtils$.MODULE$.singletonRecords$default$5();
                        this.$outer.log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$29, x$31, x$30, x$32, x$33), 0, this.$outer.log$1.appendAsLeader$default$3(), this.$outer.log$1.appendAsLeader$default$4());
                        this.$outer.valCounter$1.elem += this.$outer.step$1;
                        return new Tuple2.mcII.sp(key, curValue);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.timestamp$1 = timestamp$1;
                this.step$1 = step$1;
                this.valCounter$1 = valCounter$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        Log log2 = (Log)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log2.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    private final Gauge getGauge$1(String metricName, String metricScope) {
        return (Gauge)((Tuple2)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName, metricScope){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;
            private final String metricScope$1;

            public final boolean apply(MetricName k) {
                return k.getName().endsWith(this.metricName$1) && k.getScope().endsWith(this.metricScope$1);
            }
            {
                this.metricName$1 = metricName$1;
                this.metricScope$1 = metricScope$1;
            }
        }).headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})));
            }
            {
                this.metricName$1 = metricName$1;
            }
        }))._2();
    }
}

