/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u000f\tiAj\\4D_:4\u0017n\u001a+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u00051\u0002CA\u0005\u0018\u0013\tA\"B\u0001\u0003V]&$\bFA\n\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0001+\u00051B/Z:u\u0017\u000647.Y\"p]\u001aLw\rV8Qe>\u00048\u000f\u000b\u0002#5!)a\u0005\u0001C\u0001+\u0005\u0011B/Z:u\rJ|W\u000e\u0015:paN,U\u000e\u001d;zQ\t)#\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u000buKN$hI]8n!J|\u0007o]%om\u0006d\u0017\u000e\u001a\u0015\u0003QiAQ\u0001\f\u0001\u0005\u0002U\ta\u0004^3ti&sg/\u00197jI\u000e{W\u000e]1di&|g\u000eT1h\u0007>tg-[4)\u0005-R\u0002\"B\u0018\u0001\t\u0003)\u0012!J:i_VdGMV1mS\u0012\fG/\u001a+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u000e{gNZ5hQ\tq#\u0004C\u00033\u0001\u0011%1'A\u0004jgZ\u000bG.\u001b3\u0015\u0005Q:\u0004CA\u00056\u0013\t1$BA\u0004C_>dW-\u00198\t\u000ba\n\u0004\u0019A\u001d\u0002\u0017\r|gNZ5h-\u0006dW/\u001a\t\u0003uur!!C\u001e\n\u0005qR\u0011A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001\u0010\u0006\t\u000b\u0005\u0003A\u0011\u0002\"\u0002+\u0005\u001c8/\u001a:u!J|\u0007/\u001a:us&sg/\u00197jIR\u0019acQ#\t\u000b\u0011\u0003\u0005\u0019A\u001d\u0002\t9\fW.\u001a\u0005\u0006\r\u0002\u0003\raR\u0001\u0007m\u0006dW/Z:\u0011\u0007%A\u0005\"\u0003\u0002J\u0015\tQAH]3qK\u0006$X\r\u001a ")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assert.assertTrue((KafkaConfig$.MODULE$.LogRetentionTimeMillisProp() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String config) {
                Option serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config);
                return serverConfigOpt.isDefined() && serverConfigOpt.get() != null;
            }
        }));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogConfigTest $outer;

            public final void apply(String name) {
                String string = name;
                String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string4 = LogConfig$.MODULE$.RetentionBytesProp();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string6 = LogConfig$.MODULE$.RetentionMsProp();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string8 = LogConfig$.MODULE$.CleanupPolicyProp();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string10 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
                                String string11 = string;
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string12 = LogConfig$.MODULE$.MinInSyncReplicasProp();
                                    String string13 = string;
                                    if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        String string14 = LogConfig$.MODULE$.MessageFormatVersionProp();
                                        String string15 = string;
                                        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogConfig$.MODULE$.validate(this.props$1);
            }
            {
                this.props$1 = props$1;
            }
        }, ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assert.assertTrue((boolean)this.isValid("*"));
        Assert.assertTrue((boolean)this.isValid("* "));
        Assert.assertTrue((boolean)this.isValid(""));
        Assert.assertTrue((boolean)this.isValid(" "));
        Assert.assertTrue((boolean)this.isValid("100:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assert.assertTrue((boolean)this.isValid("100:0,"));
        Assert.assertFalse((boolean)this.isValid("100"));
        Assert.assertFalse((boolean)this.isValid("100:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100:0,10 :   "));
    }

    private boolean isValid(String configValue) {
        boolean bl;
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            bl = true;
        }
        catch (ConfigException configException) {
            bl = false;
        }
        return bl;
    }

    public void kafka$log$LogConfigTest$$assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Exception apply(Object value) {
                Properties props = new Properties();
                props.setProperty(this.name$1, value.toString());
                return (Exception)Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
                    public static final long serialVersionUID = 0L;
                    private final Properties props$2;

                    public final LogConfig apply() {
                        return new LogConfig((Map)this.props$2, LogConfig$.MODULE$.apply$default$2());
                    }
                    {
                        this.props$2 = props$2;
                    }
                }, ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            }
            {
                this.name$1 = name$1;
            }
        });
    }
}

