/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.TimeIndex;
import kafka.server.FetchDataInfo;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003\u0005\u0002\"!\u0003\u0012\n\u0005\rR!aA%oi\"1Q\u0005\u0001Q\u0001\n\u0005\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f\u001d\u0002!\u0019!C\u0001A\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019I\u0003\u0001)A\u0005C\u0005aQ.\u0019=M_\u001e\fu-Z'tA!91\u0006\u0001b\u0001\n\u0003a\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000e\u0001!\u0002\u0013i\u0013!\u00037pOB\u0013x\u000e]:!\u0011\u001dA\u0004A1A\u0005\u0002e\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003i\u0002\"AE\u001e\n\u0005q\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019q\u0004\u0001)A\u0005u\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u00061An\\4ESJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bF\n!![8\n\u0005\u001d#%\u0001\u0002$jY\u0016Dq!\u0013\u0001A\u0002\u0013\u0005!*\u0001\u0006m_\u001e$\u0015N]0%KF$\"a\u0013(\u0011\u0005%a\u0015BA'\u000b\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003C\u0003\u001dawn\u001a#je\u0002Bqa\u0015\u0001A\u0002\u0013\u0005A+\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\u0016\t\u0003%YK!a\u0016\u0002\u0003\u00151{w-T1oC\u001e,'\u000fC\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001V\u0011\u0019i\u0006\u0001)Q\u0005+\u0006YAn\\4NC:\fw-\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002\u0001\fAA\\1nKV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002ec\u0005!A.\u00198h\u0013\t17M\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B1\u0002\u000b9\fW.\u001a\u0011\t\u000f)\u0004!\u0019!C\u0001W\u0006Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\u0005a\u0007CA\u0005n\u0013\tq'B\u0001\u0003M_:<\u0007B\u00029\u0001A\u0003%A.\u0001\u000ewKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0003s\u0001\u0011\u00051/A\u0003tKR,\u0006\u000fF\u0001LQ\t\tX\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006)!.\u001e8ji*\t!0A\u0002pe\u001eL!\u0001`<\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0001t\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019a/a\u0001\n\u0007\u0005\u0015qOA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\ta]\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\t\u0005\u001d\u0011Q\u0002\t\u0004m\u0006=\u0011bAA\to\n!A+Z:u\u0011\u0019\t)\u0002\u0001C\u0001g\u0006qB/Z:u\u0007J,\u0017\r^3M_\u001e<\u0016\u000e\u001e5J]Z\fG.\u001b3M_\u001e$\u0015N\u001d\u0015\u0005\u0003'\ti\u0001\u0003\u0004\u0002\u001c\u0001!\ta]\u0001\u0016i\u0016\u001cHoR3u\u001d>tW\t_5ti\u0016tG\u000fT8hQ\u0011\tI\"!\u0004\t\r\u0005\u0005\u0002\u0001\"\u0001t\u0003i!Xm\u001d;DY\u0016\fg.\u001e9FqBL'/\u001a3TK\u001elWM\u001c;tQ\u0011\ty\"!\u0004\t\r\u0005\u001d\u0002\u0001\"\u0001t\u0003\u0005\"Xm\u001d;DY\u0016\fg.\u001e9TK\u001elWM\u001c;t)>l\u0015-\u001b8uC&t7+\u001b>fQ\u0011\t)#!\u0004\t\r\u00055\u0002\u0001\"\u0001t\u0003)\"Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t/&$\bnQ8na\u0006\u001cG\u000fR3mKR,\u0007k\u001c7jGfDC!a\u000b\u0002\u000e!1\u00111\u0007\u0001\u0005\u0002M\fA\u0005^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON<\u0016\u000e\u001e5D_6\u0004\u0018m\u0019;Q_2L7-\u001f\u0015\u0005\u0003c\ti\u0001C\u0004\u0002:\u0001!I!a\u000f\u0002'Q,7\u000f\u001e#pKNtGo\u00117fC:dunZ:\u0015\u0007-\u000bi\u0004\u0003\u0005\u0002@\u0005]\u0002\u0019AA!\u0003\u0019\u0001x\u000e\\5dsB!\u00111IA%\u001d\rI\u0011QI\u0005\u0004\u0003\u000fR\u0011A\u0002)sK\u0012,g-C\u0002g\u0003\u0017R1!a\u0012\u000b\u0011\u0019\ty\u0005\u0001C\u0001g\u0006\u0011B/Z:u)&lWMQ1tK\u00124E.^:iQ\u0011\ti%!\u0004\t\r\u0005U\u0003\u0001\"\u0001t\u0003e!Xm\u001d;MK\u0006\u001cH\u000fT8bI\u0016$\u0017i]:jO:lWM\u001c;)\t\u0005M\u0013Q\u0002\u0005\u0007\u00037\u0002A\u0011A:\u0002GQ,7\u000f\u001e+x_2{w-T1oC\u001e,'o]+tS:<7+Y7f\t&\u0014h)Y5mg\"\"\u0011\u0011LA\u0007\u0011\u0019\t\t\u0007\u0001C\u0001g\u0006aB/Z:u\u0007\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018\u0010U8j]R\u001c\b\u0006BA0\u0003\u001bAa!a\u001a\u0001\t\u0003\u0019\u0018!\f;fgR\u0014VmY8wKJLH)\u001b:fGR|'/_'baBLgnZ,ji\"$&/Y5mS:<7\u000b\\1tQ\"\"\u0011QMA\u0007\u0011\u0019\ti\u0007\u0001C\u0001g\u0006\tD/Z:u%\u0016\u001cwN^3ss\u0012K'/Z2u_JLX*\u00199qS:<w+\u001b;i%\u0016d\u0017\r^5wK\u0012K'/Z2u_JL\b\u0006BA6\u0003\u001bAq!a\u001d\u0001\t\u0013\t)(\u0001\rwKJLg-_\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef$raSA<\u0003K\u000b9\u000b\u0003\u0005\u0002z\u0005E\u0004\u0019AA>\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bCBA?\u0003\u001b\u000b\u0019J\u0004\u0003\u0002\u0000\u0005%e\u0002BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015e!\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0019\u00111\u0012\u0006\u0002\u000fA\f7m[1hK&!\u0011qRAI\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0017S\u0001\u0003BAK\u0003Ck!!a&\u000b\t\u0005e\u00151T\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\tiJC\u0002\u0002 f\fa!\u00199bG\",\u0017\u0002BAR\u0003/\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004T\u0003c\u0002\r!\u0016\u0005\u0007\u0001\u0006E\u0004\u0019\u0001\"\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\u0006\u00012M]3bi\u0016dunZ'b]\u0006<WM\u001d\u000b\u0004+\u0006=\u0006BCAY\u0003S\u0003\n\u00111\u0001\u00024\u00069An\\4ESJ\u001c\b#BA?\u0003\u001b\u0013\u0005BBA\\\u0001\u0011\u00051/\u0001\u0012uKN$h)\u001b7f%\u00164WM]3oG\u0016\u001c\u0018I\u001a;fe\u0006\u001b\u0018P\\2EK2,G/\u001a\u0015\u0005\u0003k\u000bi\u0001\u0003\u0004\u0002>\u0002!\ta]\u0001#i\u0016\u001cHo\u0011:fCR,\u0017I\u001c3EK2,G/Z(wKJd\u0017\u0010T8oOR{\u0007/[2)\t\u0005m\u0016Q\u0002\u0005\u0007\u0003\u0007\u0004A\u0011A:\u0002CQ,7\u000f^\"iK\u000e\\\u0007o\\5oi\u001a{'o\u00148ms\u00063g-Z2uK\u0012dunZ:)\t\u0005\u0005\u0017Q\u0002\u0005\b\u0003\u0013\u0004A\u0011BAf\u0003\u001d\u0011X-\u00193M_\u001e$\u0002\"!4\u0002Z\u0006\u0005\u0018Q\u001d\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111\u001b\u0003\u0002\rM,'O^3s\u0013\u0011\t9.!5\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u001d\u0019\u0011q\u0019a\u0001\u00037\u00042AEAo\u0013\r\tyN\u0001\u0002\u0004\u0019><\u0007bBAr\u0003\u000f\u0004\r\u0001\\\u0001\u0007_\u001a47/\u001a;\t\u0013\u0005\u001d\u0018q\u0019I\u0001\u0002\u0004\t\u0013!C7bq2+gn\u001a;i\u0011%\tY\u000fAI\u0001\n\u0013\ti/\u0001\u000ede\u0016\fG/\u001a'pO6\u000bg.Y4fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002p*\"\u00111WAyW\t\t\u0019\u0010\u0005\u0003\u0002v\u0006}XBAA|\u0015\u0011\tI0a?\u0002\u0013Ut7\r[3dW\u0016$'bAA\u007f\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005\u0011q\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\u0003\u0001E\u0005I\u0011\u0002B\u0004\u0003E\u0011X-\u00193M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0013Q3!IAy\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$11 = new TopicPartition(this.name(), 0);
        LogConfig x$12 = this.logConfig();
        boolean x$13 = qual$1.getOrCreateLog$default$3();
        boolean x$14 = qual$1.getOrCreateLog$default$4();
        Log log2 = qual$1.getOrCreateLog(x$11, x$12, x$13, x$14);
        Assert.assertEquals((long)1L, (long)this.logManager().liveLogDirs().size());
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir(), new File("\u0000")}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        this.logManager().startup();
        LogManager qual$2 = this.logManager();
        TopicPartition x$15 = new TopicPartition(this.name(), 0);
        LogConfig x$16 = this.logConfig();
        boolean x$17 = true;
        boolean x$18 = qual$2.getOrCreateLog$default$4();
        Log log2 = qual$2.getOrCreateLog(x$15, x$16, x$17, x$18);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$3 = this.logManager();
        TopicPartition x$19 = new TopicPartition(this.name(), 0);
        boolean x$20 = qual$3.getLog$default$2();
        Option log2 = qual$3.getLog(x$19, x$20);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log2);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$4 = this.logManager();
        TopicPartition x$21 = new TopicPartition(this.name(), 0);
        LogConfig x$22 = this.logConfig();
        boolean x$23 = qual$4.getOrCreateLog$default$3();
        boolean x$24 = qual$4.getOrCreateLog$default$4();
        Log log2 = qual$4.getOrCreateLog(x$21, x$22, x$23, x$24);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final LongRef offset$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$1.appendAsLeader(set, 0, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
                this.offset$1.elem = info.lastOffset();
            }
            {
                this.log$1 = log$1;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.onHighWatermarkIncremented(log2.logEndOffset());
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$1) {
                return x$1.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log2.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log2.config().fileDeleteDelayMs()) + 1L);
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TimeIndex apply(LogSegment s) {
                s.lazyOffsetIndex().get();
                return s.lazyTimeIndex().get();
            }
        });
        Assert.assertEquals((String)"Files should have been deleted", (long)(log2.numberOfSegments() * 4 + 1), (long)log2.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log2, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log2, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$5 = this.logManager();
        TopicPartition x$25 = new TopicPartition(this.name(), 0);
        LogConfig x$26 = config;
        boolean x$27 = qual$5.getOrCreateLog$default$3();
        boolean x$28 = qual$5.getOrCreateLog$default$4();
        Log log2 = qual$5.getOrCreateLog(x$25, x$26, x$27, x$28);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final LongRef offset$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$2.appendAsLeader(set, 0, this.log$2.appendAsLeader$default$3(), this.log$2.appendAsLeader$default$4());
                this.offset$2.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
            }
            {
                this.log$2 = log$2;
                this.offset$2 = offset$2;
            }
        });
        log2.onHighWatermarkIncremented(log2.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log2.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log2.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log2.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log2.numberOfSegments() * 3 + 3), (long)log2.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)this.readLog(log2, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes());
        try {
            this.readLog(log2, 0L, this.readLog$default$3());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$6 = this.logManager();
        TopicPartition x$29 = new TopicPartition(this.name(), 0);
        LogConfig x$30 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$31 = qual$6.getOrCreateLog$default$3();
        boolean x$32 = qual$6.getOrCreateLog$default$4();
        Log log2 = qual$6.getOrCreateLog(x$29, x$30, x$31, x$32);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log2, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final LongRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$3.appendAsLeader(set, 0, this.log$3.appendAsLeader$default$3(), this.log$3.appendAsLeader$default$4());
                this.offset$3.elem = info.lastOffset();
            }
            {
                this.log$3 = log$3;
                this.offset$3 = offset$3;
            }
        });
        int numSegments = log2.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log2.numberOfSegments() > 1 ? 1 : 0) != 0);
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$2) {
                return x$2.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log2.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$7 = this.logManager();
        TopicPartition x$33 = new TopicPartition(this.name(), 0);
        LogConfig x$34 = config;
        boolean x$35 = qual$7.getOrCreateLog$default$3();
        boolean x$36 = qual$7.getOrCreateLog$default$4();
        Log log2 = qual$7.getOrCreateLog(x$33, x$34, x$35, x$36);
        long lastFlush = log2.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;

            public final LogAppendInfo apply(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                return this.log$4.appendAsLeader(set, 0, this.log$4.appendAsLeader$default$3(), this.log$4.appendAsLeader$default$4());
            }
            {
                this.log$4 = log$4;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log2.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        Seq dirs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()}));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                LogManager qual$8 = this.$outer.logManager();
                TopicPartition x$37 = new TopicPartition("test", partition);
                LogConfig x$38 = this.$outer.logConfig();
                boolean x$39 = qual$8.getOrCreateLog$default$3();
                boolean x$40 = qual$8.getOrCreateLog$default$4();
                qual$8.getOrCreateLog(x$37, x$38, x$39, x$40);
                Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.$outer.logManager().allLogs().size());
                Iterable counts = (Iterable)this.$outer.logManager().allLogs().groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Log x$3) {
                        return x$3.dir().getParent();
                    }
                }).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Iterable<Log> x$4) {
                        return x$4.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File(new StringBuilder().append((Object)TestUtils$.MODULE$.tempDir().getAbsolutePath()).append((Object)File.separator).toString())}))), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("data", this.logDir().getName()).getAbsoluteFile()})))));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1)new Serializable(this, logManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;
            private final LogManager logManager$1;

            public final Log apply(TopicPartition x$5) {
                return this.logManager$1.getOrCreateLog(x$5, this.$outer.logConfig(), this.logManager$1.getOrCreateLog$default$3(), this.logManager$1.getOrCreateLog$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logManager$1 = logManager$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log2) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$5;

                    public final LogAppendInfo apply(int _) {
                        return this.log$5.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$5.appendAsLeader$default$3(), this.log$5.appendAsLeader$default$4());
                    }
                    {
                        this.log$5 = log$5;
                    }
                });
                log2.flush();
            }
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$1;

            public final void apply(Tuple2<TopicPartition, Log> x0$1) {
                Tuple2<TopicPartition, Log> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Log log2 = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$1.apply((Object)tp)), (long)log2.recoveryPoint());
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log2.minSnapshotsOffsetToRetain())), (Object)log2.oldestProducerSnapshotOffset());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$1 = checkpoints$1;
            }
        });
    }

    private LogManager createLogManager(Seq<File> logDirs) {
        LogConfig x$41 = this.logConfig();
        Seq<File> x$42 = logDirs;
        MockTime x$43 = this.time();
        CleanerConfig x$44 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$42, x$41, x$44, x$43);
    }

    private Seq<File> createLogManager$default$1() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}));
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$9 = this.logManager();
        TopicPartition x$45 = new TopicPartition(this.name(), 0);
        LogConfig x$46 = this.logConfig();
        boolean x$47 = qual$9.getOrCreateLog$default$3();
        boolean x$48 = qual$9.getOrCreateLog$default$4();
        Log log2 = qual$9.getOrCreateLog(x$45, x$46, x$47, x$48);
        LogSegment activeSegment = log2.activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.getName().endsWith("index");
            }
        });
        LogManager qual$10 = this.logManager();
        TopicPartition x$49 = new TopicPartition(this.name(), 0);
        boolean x$50 = qual$10.asyncDelete$default$2();
        Log removedLog = qual$10.asyncDelete(x$49, x$50);
        LogSegment removedSegment = removedLog.activeSegment();
        Seq indexFilesAfterDelete = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{removedSegment.lazyOffsetIndex().file(), removedSegment.lazyTimeIndex().file(), removedSegment.txnIndex().file()}));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete).foreach((Function1)new Serializable(this, indexFilesAfterDelete){
            public static final long serialVersionUID = 0L;
            private final Seq indexFilesAfterDelete$1;

            public final void apply(File fileBeforeDelete) {
                Option fileInIndex = this.indexFilesAfterDelete$1.find((Function1)new Serializable(this, fileBeforeDelete){
                    public static final long serialVersionUID = 0L;
                    private final File fileBeforeDelete$1;

                    public final boolean apply(File x$7) {
                        String string = x$7.getName();
                        String string2 = this.fileBeforeDelete$1.getName();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.fileBeforeDelete$1 = fileBeforeDelete$1;
                    }
                });
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find index file ", " in indexFilesAfterDelete"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileBeforeDelete.getName()})), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$8) {
                        return x$8.getName();
                    }
                }));
                Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
            }
            {
                this.indexFilesAfterDelete$1 = indexFilesAfterDelete$1;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$11 = this.logManager();
        TopicPartition x$51 = new TopicPartition(invalidTopicName, 0);
        LogConfig x$52 = this.logConfig();
        boolean x$53 = qual$11.getOrCreateLog$default$3();
        boolean x$54 = qual$11.getOrCreateLog$default$4();
        Log log2 = qual$11.getOrCreateLog(x$51, x$52, x$53, x$54);
        LogManager qual$12 = this.logManager();
        TopicPartition x$55 = new TopicPartition(invalidTopicName, 0);
        boolean x$56 = qual$12.asyncDelete$default$2();
        qual$12.asyncDelete(x$55, x$56);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        Seq tps = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 0), new TopicPartition("test-a", 1), new TopicPartition("test-a", 2), new TopicPartition("test-b", 0), new TopicPartition("test-b", 1)}));
        Seq allLogs = (Seq)tps.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final Log apply(TopicPartition x$9) {
                LogManager qual$13 = this.$outer.logManager();
                TopicPartition x$57 = x$9;
                LogConfig x$58 = this.$outer.logConfig();
                boolean x$59 = qual$13.getOrCreateLog$default$3();
                boolean x$60 = qual$13.getOrCreateLog$default$4();
                return qual$13.getOrCreateLog(x$57, x$58, x$59, x$60);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log2) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$6;

                    public final LogAppendInfo apply(int _) {
                        return this.log$6.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, this.log$6.appendAsLeader$default$3(), this.log$6.appendAsLeader$default$4());
                    }
                    {
                        this.log$6 = log$6;
                    }
                });
                log2.flush();
            }
        });
        this.logManager().checkpointRecoveryOffsetsAndCleanSnapshot(this.logDir(), (Seq)allLogs.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Log x$10) {
                return x$10.dir().getName().contains("test-a");
            }
        }));
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$2;

            public final void apply(Tuple2<TopicPartition, Log> x0$2) {
                Tuple2<TopicPartition, Log> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Log log2 = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$2.apply((Object)tp)), (long)log2.recoveryPoint());
                    if (tp.topic().equals("test-a")) {
                        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log2.minSnapshotsOffsetToRetain())), (Object)log2.oldestProducerSnapshotOffset());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.assertNotEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)log2.minSnapshotsOffsetToRetain())), (Object)log2.oldestProducerSnapshotOffset());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$2 = checkpoints$2;
            }
        });
    }

    private FetchDataInfo readLog(Log log2, long offset, int maxLength) {
        return log2.read(offset, maxLength, (Option)None$.MODULE$, true, false);
    }

    private int readLog$default$3() {
        return 1024;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

