/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001\u001d\u0011qb\u00144gg\u0016$\u0018J\u001c3fqR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\t1!\u001b3y+\u00051\u0002C\u0001\n\u0018\u0013\tA\"AA\u0006PM\u001a\u001cX\r^%oI\u0016D\bb\u0002\u000e\u0001\u0001\u0004%\taG\u0001\bS\u0012Dx\fJ3r)\tar\u0004\u0005\u0002\n;%\u0011aD\u0003\u0002\u0005+:LG\u000fC\u0004!3\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004#\u0001\u0001\u0006KAF\u0001\u0005S\u0012D\b\u0005C\u0004%\u0001\t\u0007I\u0011A\u0013\u0002\u00155\f\u00070\u00128ue&,7/F\u0001'!\tIq%\u0003\u0002)\u0015\t\u0019\u0011J\u001c;\t\r)\u0002\u0001\u0015!\u0003'\u0003-i\u0017\r_#oiJLWm\u001d\u0011\t\u000f1\u0002!\u0019!C\u0001[\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0016\u00039\u0002\"!C\u0018\n\u0005AR!\u0001\u0002'p]\u001eDaA\r\u0001!\u0002\u0013q\u0013a\u00032bg\u0016|eMZ:fi\u0002BQ\u0001\u000e\u0001\u0005\u0002U\nQa]3ukB$\u0012\u0001\b\u0015\u0003g]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000b),h.\u001b;\u000b\u0003q\n1a\u001c:h\u0013\tq\u0014H\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u0001\u0002!\t!N\u0001\ti\u0016\f'\u000fZ8x]\"\u0012qH\u0011\t\u0003q\rK!\u0001R\u001d\u0003\u000b\u00053G/\u001a:\t\u000b\u0019\u0003A\u0011A\u001b\u0002!I\fg\u000eZ8n\u0019>|7.\u001e9UKN$\bFA#I!\tA\u0014*\u0003\u0002Ks\t!A+Z:u\u0011\u0015a\u0005\u0001\"\u00016\u0003Iawn\\6va\u0016CHO]3nK\u000e\u000b7/Z:)\u0005-C\u0005\"B(\u0001\t\u0003)\u0014!\u0003;fgR,e\u000e\u001e:zQ\tq\u0005\nC\u0003S\u0001\u0011\u0005Q'A\tuKN$XI\u001c;ss>3XM\u001d4m_^DC!\u0015%U+\u0006AQ\r\u001f9fGR,GmI\u0001W!\t9vL\u0004\u0002Y;:\u0011\u0011\fX\u0007\u00025*\u00111LB\u0001\u0007yI|w\u000e\u001e \n\u0003-I!A\u0018\u0006\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'B\u00010\u000b\u0011\u0015\u0019\u0007\u0001\"\u00016\u00035\t\u0007\u000f]3oIR{w.T1os\"\u0012!\r\u0013\u0005\u0006M\u0002!\t!N\u0001\u0011CB\u0004XM\u001c3PkR|em\u0014:eKJDC!\u001a%UQ\u000e\n\u0011\u000e\u0005\u0002ke6\t1N\u0003\u0002m[\u00061QM\u001d:peNT!A\\8\u0002\r\r|W.\\8o\u0015\t)\u0001O\u0003\u0002rw\u00051\u0011\r]1dQ\u0016L!a]6\u0003-%sg/\u00197jI>3gm]3u\u000bb\u001cW\r\u001d;j_:DQ!\u001e\u0001\u0005\u0002U\n\u0011\u0004^3ti\u001a+Go\u00195VaB,'OQ8v]\u0012|eMZ:fi\"\u0012A\u000f\u0013\u0005\u0006q\u0002!\t!N\u0001\u000bi\u0016\u001cHOU3pa\u0016t\u0007FA<I\u0011\u0015Y\b\u0001\"\u00016\u0003!!(/\u001e8dCR,\u0007F\u0001>I\u0011\u0015q\b\u0001\"\u00016\u000391wN]2f+:l\u0017\r\u001d+fgRD#! %\t\r\u0005\r\u0001\u0001\"\u00016\u0003\u0015\"Xm\u001d;TC:LG/\u001f'bgR|eMZ:fi\u0016\u000bX/\u00197U_\n\u000b7/Z(gMN,G\u000fK\u0002\u0002\u0002!Cq!!\u0003\u0001\t\u0003\tY!\u0001\tbgN,'\u000f^,sSR,g)Y5mgV!\u0011QBA\u001b)%a\u0012qBA\u0011\u0003G\t9\u0003\u0003\u0005\u0002\u0012\u0005\u001d\u0001\u0019AA\n\u0003\u001diWm]:bO\u0016\u0004B!!\u0006\u0002\u001c9\u0019\u0011\"a\u0006\n\u0007\u0005e!\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033Q\u0001B\u0002\u000b\u0002\b\u0001\u0007a\u0003C\u0004\u0002&\u0005\u001d\u0001\u0019\u0001\u0014\u0002\r=4gm]3u\u0011!\tI#a\u0002A\u0002\u0005-\u0012!B6mCN\u001c\bCBA\u000b\u0003[\t\t$\u0003\u0003\u00020\u0005}!!B\"mCN\u001c\b\u0003BA\u001a\u0003ka\u0001\u0001\u0002\u0005\u00028\u0005\u001d!\u0019AA\u001d\u0005\u0005!\u0016\u0003BA\u001e\u0003\u0003\u00022!CA\u001f\u0013\r\tyD\u0003\u0002\b\u001d>$\b.\u001b8h!\rI\u00111I\u0005\u0004\u0003\u000bR!aA!os\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013\u0001D7p]>$xN\\5d'\u0016\fHCBA'\u00033\ni\u0006E\u0003\u0002P\u0005Uc%\u0004\u0002\u0002R)\u0019\u00111\u000b\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u0005E#aA*fc\"9\u00111LA$\u0001\u00041\u0013\u0001\u00022bg\u0016Dq!a\u0018\u0002H\u0001\u0007a%A\u0002mK:Dq!a\u0019\u0001\t\u0003\t)'A\no_:,\u00050[:uK:$H+Z7q\r&dW\r\u0006\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014AA5p\u0015\t\t\t(\u0001\u0003kCZ\f\u0017\u0002BA;\u0003W\u0012AAR5mK\u0002")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size2 = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(int x$1) {
                return this.apply$mcJI$sp(x$1);
            }

            public long apply$mcJI$sp(int x$1) {
                return x$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size2), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x) {
                this.$outer.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        vals.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    long logical = tuple2._1$mcJ$sp();
                    int physical = tuple2._2$mcI$sp();
                    Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)this.$outer.idx().lookup(logical));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(Tuple2<Object, Object> p) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(offsets).take(30)).foreach((Function1)new Serializable(this, valMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;
            private final TreeMap valMap$1;

            public final void apply(long offset) {
                this.apply$mcVJ$sp(offset);
            }

            public void apply$mcVJ$sp(long offset) {
                OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)this.valMap$1.firstKey()) ? new OffsetPosition(this.$outer.idx().baseOffset(), 0) : new OffsetPosition(this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)this.valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
                Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)this.$outer.idx().lookup(offset));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.valMap$1 = valMap$1;
            }
        });
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.idx().append(this.$outer.idx().baseOffset() + (long)i + 1L, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.idx().append(this.$outer.idx().baseOffset() + (long)i + 1L, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)new OffsetPosition(this.$outer.idx().baseOffset() + (long)i + 1L, i), (Object)this.$outer.idx().entry(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long offset = this.$outer.idx().baseOffset() + (long)i + 1L;
                this.$outer.idx().append(offset, i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetPosition[]{first, second, third, fourth}))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndexTest $outer;

            public final void apply(OffsetPosition offsetPosition) {
                this.$outer.idx().append(offsetPosition.offset(), offsetPosition.position());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final OffsetIndex idx$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.idx$1.append((long)i, i);
            }
            {
                this.idx$1 = idx$1;
            }
        });
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.forceUnmap();
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, idx){
            public static final long serialVersionUID = 0L;
            private final OffsetIndex idx$2;

            public final OffsetPosition apply() {
                return this.idx$2.lookup(1L);
            }
            {
                this.idx$2 = idx$2;
            }
        }, ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            Assert.fail((String)message);
        }
        catch (Exception exception) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, exception.getClass());
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(this, rand, vals, last){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;
            private final ArrayBuffer vals$1;
            private final IntRef last$1;

            public final ArrayBuffer<Object> apply(int _) {
                this.last$1.elem += this.rand$1.nextInt(15) + 1;
                return this.vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.last$1.elem));
            }
            {
                this.rand$1 = rand$1;
                this.vals$1 = vals$1;
                this.last$1 = last$1;
            }
        });
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

