/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.network.DynamicConnectionQuotaTest$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0001\u0003\u0001\u001d\u0011!\u0004R=oC6L7mQ8o]\u0016\u001cG/[8o#V|G/\u0019+fgRT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011QB\u0003\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0006)\u0001!\t%F\u0001\fEJ|7.\u001a:D_VtG/F\u0001\u0017!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\rIe\u000e\u001e\u0005\b;\u0001\u0011\r\u0011\"\u0001\u001f\u0003\u0015!x\u000e]5d+\u0005y\u0002C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\u0007'R\u0014\u0018N\\4\t\r!\u0002\u0001\u0015!\u0003 \u0003\u0019!x\u000e]5dA!9!\u0006\u0001b\u0001\n\u0003Y\u0013\u0001\u00037jgR,g.\u001a:\u0016\u00031\u0002\"!\f\u001c\u000e\u00039R!aA\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\u0006e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9dF\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0003\u0004:\u0001\u0001\u0006I\u0001L\u0001\nY&\u001cH/\u001a8fe\u0002Bqa\u000f\u0001C\u0002\u0013\u0005A(\u0001\u0007m_\u000e\fG.\u00113ee\u0016\u001c8/F\u0001>!\tq\u0014)D\u0001@\u0015\t\u00015%A\u0002oKRL!AQ \u0003\u0017%sW\r^!eIJ,7o\u001d\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001f\u0002\u001b1|7-\u00197BI\u0012\u0014Xm]:!\u0011%1\u0005\u00011AA\u0002\u0013\u0005q)\u0001\u0005fq\u0016\u001cW\u000f^8s+\u0005A\u0005CA%O\u001b\u0005Q%BA&M\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001b\u000e\nA!\u001e;jY&\u0011qJ\u0013\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\"I\u0011\u000b\u0001a\u0001\u0002\u0004%\tAU\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0003'Z\u0003\"a\u0006+\n\u0005UC\"\u0001B+oSRDqa\u0016)\u0002\u0002\u0003\u0007\u0001*A\u0002yIEBa!\u0017\u0001!B\u0013A\u0015!C3yK\u000e,Ho\u001c:!\u0011\u0015Y\u0006\u0001\"\u0011]\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0006F\u0001._!\ty&-D\u0001a\u0015\t\tG'A\u0003kk:LG/\u0003\u0002dA\n1!)\u001a4pe\u0016DQ!\u001a\u0001\u0005Bq\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003I\u001e\u0004\"a\u00185\n\u0005%\u0004'!B!gi\u0016\u0014\b\"B6\u0001\t#b\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\u0019V\u000eC\u0003oU\u0002\u0007q.\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"\u0001]9\u000e\u00031K!A\u001d'\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003u\u0001\u0011\u0005A,\u0001\u000euKN$H)\u001f8b[&\u001c7i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\r\u000b\u0002tmB\u0011ql^\u0005\u0003q\u0002\u0014A\u0001V3ti\")!\u0010\u0001C\u00019\u0006\u0011C/Z:u\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|g.U;pi\u0006D#!\u001f<\t\u000bu\u0004A\u0011\u0002@\u0002%I,7m\u001c8gS\u001e,(/Z*feZ,'o\u001d\u000b\u0007'~\f\u0019!!\u0004\t\r\u0005\u0005A\u00101\u0001p\u0003!qWm\u001e)s_B\u001c\bbBA\u0003y\u0002\u0007\u0011qA\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jOB\u0019q#!\u0003\n\u0007\u0005-\u0001DA\u0004C_>dW-\u00198\t\u000f\u0005=A\u00101\u0001\u0002\u0012\u0005i\u0011\r\u0015:paR{g+\u001a:jMf\u0004raFA\n\u0003/\t9\"C\u0002\u0002\u0016a\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\r\u0003?q1aFA\u000e\u0013\r\ti\u0002G\u0001\u0007!J,G-\u001a4\n\u0007\u0019\n\tCC\u0002\u0002\u001eaAq!!\n\u0001\t\u0013\t9#A\bxC&$hi\u001c:MSN$XM\\3s)\r\u0019\u0016\u0011\u0006\u0005\t\u0003W\t\u0019\u00031\u0001\u0002\u0018\u0005aA.[:uK:,'OT1nK\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0011\u00111\u0007\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0015\tG-\\5o\u0015\r\ti$M\u0001\bG2LWM\u001c;t\u0013\u0011\t\t%a\u000e\u0003\u0017\u0005#W.\u001b8DY&,g\u000e\u001e\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003U9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$raUA%\u0003\u001b\n\t\u0006\u0003\u0005\u0002L\u0005\r\u0003\u0019AA\f\u0003!\u0001(o\u001c9OC6,\u0007\u0002CA(\u0003\u0007\u0002\r!a\u0006\u0002\u0013A\u0014x\u000e\u001d,bYV,\u0007BCA*\u0003\u0007\u0002\n\u00111\u0001\u0002V\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004/\u0005]\u0013bAA-1\t!Aj\u001c8h\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\na\u0002\u001d:pIV\u001cWMU3rk\u0016\u001cH/\u0006\u0002\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002h=\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003W\n)G\u0001\bQe>$WoY3SKF,Xm\u001d;\t\r\u0005=\u0004\u0001\"\u0001\u0016\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\bbBA:\u0001\u0011\u0005\u0011QO\u0001\bG>tg.Z2u)\u0011\t9(! \u0011\u0007y\nI(C\u0002\u0002|}\u0012aaU8dW\u0016$\bb\u0002\u0016\u0002r\u0001\u0007\u0011q\u0003\u0005\b\u0003\u0003\u0003A\u0011BAB\u0003e\u0019'/Z1uK\u0006sGMV3sS\u001aL8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0007M\u000b)\tC\u0005+\u0003\u007f\u0002\n\u00111\u0001\u0002\u0018!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0015\u0001\u0005<fe&4\u0017pQ8o]\u0016\u001cG/[8o)\r\u0019\u0016Q\u0012\u0005\t\u0003\u001f\u000b9\t1\u0001\u0002x\u000511o\\2lKRDq!a%\u0001\t\u0013\t)*\u0001\u000bwKJLg-_'bq\u000e{gN\\3di&|gn\u001d\u000b\u0006'\u0006]\u00151\u0014\u0005\b\u00033\u000b\t\n1\u0001\u0017\u00039i\u0017\r_\"p]:,7\r^5p]ND\u0001\"!(\u0002\u0012\u0002\u0007\u0011qT\u0001\u0013G>tg.Z2u/&$\bNR1jYV\u0014X\r\u0005\u0003\u0018\u0003C\u001b\u0016bAAR1\tIa)\u001e8di&|g\u000e\r\u0005\n\u0003O\u0003\u0011\u0013!C\u0005\u0003S\u000b1e\u0019:fCR,\u0017I\u001c3WKJLg-_\"p]:,7\r^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002,*\"\u0011qCAWW\t\ty\u000b\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u0013Ut7\r[3dW\u0016$'bAA]1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00161\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAa\u0001E\u0005I\u0011BAb\u0003}9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000bTC!!\u0016\u0002.\u0002")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private ExecutorService executor;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), this.brokerCount(), this.brokerCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    @After
    public void tearDown() {
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assert.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
            return;
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
    }

    @Test
    public void testDynamicConnectionQuota() {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString());
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPerIP)).toString()));
        this.verifyMaxConnections(maxConnectionsPerIP, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$connectAndVerify$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int maxConnectionsPerIPOverride = 7;
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxConnectionsPerIPOverride)})));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxConnectionsPerIPOverride)}))));
        this.verifyMaxConnections(maxConnectionsPerIPOverride, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$connectAndVerify$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testDynamicListenerConnectionQuota() {
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.MaxConnectionsProp(), (Object)"5"));
        this.verifyMaxConnections(5, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$connectAndVerify$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put(KafkaConfig$.MODULE$.ListenersProp(), newListeners);
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$1) {
                return this.$outer.connect("PLAINTEXT");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        conns = (IndexedSeq)conns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$2) {
                return this.$outer.connect("INTERNAL");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        conns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply(Socket socket) {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$verifyConnection(socket);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        conns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$3) {
                x$3.close();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialConnectionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int initialConnectionCount$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.initialConnectionCount$1 == this.$outer.connectionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialConnectionCount$1 = initialConnectionCount$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connections not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        int maxConnectionsPlaintext = 7;
        String listenerProp = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listener().configPrefix(), KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        props.put(listenerProp, ((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPlaintext)).toString());
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)((Object)BoxesRunTime.boxToInteger((int)maxConnectionsPlaintext)).toString()));
        this.verifyMaxConnections(maxConnectionsPlaintext, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$connectAndVerify$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        IndexedSeq plaintextConnections = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$4) {
                return this.$outer.connect("PLAINTEXT");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection(this.$outer.kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection$default$1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$5) {
                x$5.close();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialConnectionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int initialConnectionCount$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.initialConnectionCount$1 == this.$outer.connectionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialConnectionCount$1 = initialConnectionCount$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connections not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        IndexedSeq plaintextConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$6) {
                return this.$outer.connect("PLAINTEXT");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq internalConns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$7) {
                return this.$outer.connect("INTERNAL");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        plaintextConns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply(Socket socket) {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$verifyConnection(socket);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        internalConns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply(Socket socket) {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$verifyConnection(socket);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$8) {
                return this.$outer.connect("PLAINTEXT");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.connectionCount() <= 10;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Internal connections not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        plaintextConns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final void apply(Socket socket) {
                this.$outer.kafka$network$DynamicConnectionQuotaTest$$verifyConnection(socket);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, internalConns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final IndexedSeq internalConns$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.internalConns$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDynamicListenerConnectionQuota$6 $outer;

                    public final ByteBuffer apply(Socket socket) {
                        return this.$outer.kafka$network$DynamicConnectionQuotaTest$$anonfun$$$outer().sendAndReceive((AbstractRequest)this.$outer.kafka$network$DynamicConnectionQuotaTest$$anonfun$$$outer().kafka$network$DynamicConnectionQuotaTest$$produceRequest(), ApiKeys.PRODUCE, socket, this.$outer.kafka$network$DynamicConnectionQuotaTest$$anonfun$$$outer().sendAndReceive$default$4());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DynamicConnectionQuotaTest kafka$network$DynamicConnectionQuotaTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.internalConns$1 = internalConns$1;
            }
        }, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        plaintextConns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$9) {
                x$9.close();
            }
        });
        internalConns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$10) {
                x$10.close();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialConnectionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int initialConnectionCount$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.initialConnectionCount$1 == this.$outer.connectionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialConnectionCount$1 = initialConnectionCount$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connections not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        AdminClient adminClient = this.createAdminClient();
        TestUtils$.MODULE$.alterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, perBrokerConfig).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), this.waitForConfigOnServer$default$3());
        adminClient.close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialConnectionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int initialConnectionCount$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.initialConnectionCount$2 == this.$outer.connectionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialConnectionCount$2 = initialConnectionCount$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Admin client connection not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private void waitForListener(String listenerName) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, listenerName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final String listenerName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    Assert.assertTrue((((KafkaServer)this.$outer.servers().head()).socketServer().boundPort(ListenerName.normalised((String)this.listenerName$1)) > 0 ? 1 : 0) != 0);
                    return;
                }
                catch (KafkaException kafkaException) {
                    throw new AssertionError((Object)((Object)kafkaException));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.listenerName$1 = listenerName$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient createAdminClient() {
        void var3_3;
        String bootstrapServers2 = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers2);
        config.put("metadata.max.age.ms", "10");
        AdminClient adminClient = AdminClient.create((Properties)config);
        return var3_3;
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$.MODULE$.retry(maxWaitMs, (Function0<BoxedUnit>)new Serializable(this, propName, propValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final String propName$1;
            private final String propValue$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((Object)this.propValue$1, ((KafkaServer)this.$outer.servers().head()).config().originals().get(this.propName$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.propName$1 = propName$1;
                this.propValue$1 = propValue$1;
            }
        });
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    public ProduceRequest kafka$network$DynamicConnectionQuotaTest$$produceRequest() {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        scala.collection.immutable.Map partitionRecords = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)memoryRecords)}));
        return (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)-1, (int)3000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRecords).asJava())).build();
    }

    public int connectionCount() {
        return ((KafkaServer)this.servers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaServer)this.servers().head()).socketServer().boundPort(listenerName));
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection(String listener) {
        Socket socket = this.connect(listener);
        try {
            this.kafka$network$DynamicConnectionQuotaTest$$verifyConnection(socket);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        socket.close();
    }

    public String kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    public void kafka$network$DynamicConnectionQuotaTest$$verifyConnection(Socket socket) {
        ProduceRequest request = this.kafka$network$DynamicConnectionQuotaTest$$produceRequest();
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.PRODUCE, socket, this.sendAndReceive$default$4());
        ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)response, (short)request.version());
        Assert.assertEquals((long)1L, (long)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(produceResponse.responses()).asScala()).head();
        if (tuple2 != null) {
            ProduceResponse.PartitionResponse partitionResponse;
            ProduceResponse.PartitionResponse partitionResponse2;
            ProduceResponse.PartitionResponse partitionResponse3 = partitionResponse2 = (partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2());
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse3.error);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;

            public final Socket apply(int x$11) {
                return this.$outer.connect("PLAINTEXT");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection(this.kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection$default$1());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, maxConnections){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int maxConnections$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.connectionCount() == this.maxConnections$1 - 1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maxConnections$1 = maxConnections$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "produce request connection is not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions$.MODULE$.intercept(connectWithFailure, ClassTag$.MODULE$.apply(IOException.class), new Position("DynamicConnectionQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, maxConnections){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int maxConnections$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.connectionCount() == this.maxConnections$1 - 1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maxConnections$1 = maxConnections$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "connection is not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection(this.kafka$network$DynamicConnectionQuotaTest$$createAndVerifyConnection$default$1());
        conns.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$12) {
                x$12.close();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, initialConnectionCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConnectionQuotaTest $outer;
            private final int initialConnectionCount$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.initialConnectionCount$3 == this.$outer.connectionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialConnectionCount$3 = initialConnectionCount$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Connections not closed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    /*
     * WARNING - void declaration
     */
    public final void kafka$network$DynamicConnectionQuotaTest$$connectAndVerify$1() {
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendAndReceive((AbstractRequest)this.kafka$network$DynamicConnectionQuotaTest$$produceRequest(), ApiKeys.PRODUCE, socket, this.sendAndReceive$default$4());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        socket.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void kafka$network$DynamicConnectionQuotaTest$$connectAndVerify$2() {
        Socket socket = this.connect("PLAINTEXT");
        socket.setSoTimeout(1000);
        try {
            ByteBuffer response = this.sendAndReceive((AbstractRequest)this.kafka$network$DynamicConnectionQuotaTest$$produceRequest(), ApiKeys.PRODUCE, socket, this.sendAndReceive$default$4());
            Assert.assertEquals((long)0L, (long)response.remaining());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        socket.close();
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
    }
}

