/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.token.delegation;

import java.io.File;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Properties;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.DelegationToken$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.server.CreateTokenResult;
import kafka.server.Defaults$;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001-\u0011!\u0004R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM\u001d+fgRT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u0005)Ao\\6f]*\u0011q\u0001C\u0001\tg\u0016\u001cWO]5us*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\t\u0003\tQ8.\u0003\u0002\u0012\u001d\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u0005!A/[7f+\u0005Q\u0002CA\u000e&\u001b\u0005a\"BA\u000f\u001f\u0003\u0015)H/\u001b7t\u0015\ty\u0002%\u0001\u0004d_6lwN\u001c\u0006\u0003\u0013\u0005R!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO&\u0011a\u0005\b\u0002\t\u001b>\u001c7\u000eV5nK\"1\u0001\u0006\u0001Q\u0001\ni\tQ\u0001^5nK\u0002BqA\u000b\u0001C\u0002\u0013\u00051&A\u0003po:,'/F\u0001-!\ti\u0013'D\u0001/\u0015\ty\u0003'\u0001\u0003bkRD'BA\u0004\u001f\u0013\t\u0011dF\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\rQ\u0002\u0001\u0015!\u0003-\u0003\u0019ywO\\3sA!9a\u0007\u0001b\u0001\n\u00039\u0014a\u0002:f]\u0016<XM]\u000b\u0002qA\u0019\u0011\b\u0011\u0017\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u000f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004D\u0001\u0001\u0006I\u0001O\u0001\te\u0016tWm^3sA!9Q\t\u0001b\u0001\n\u00031\u0015!\u0004;pW\u0016tW*\u00198bO\u0016\u00148/F\u0001H!\rA5*T\u0007\u0002\u0013*\u0011!\nP\u0001\b[V$\u0018M\u00197f\u0013\ta\u0015J\u0001\u0004Ck\u001a4WM\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\"\taa]3sm\u0016\u0014\u0018B\u0001*P\u0005Y!U\r\\3hCRLwN\u001c+pW\u0016tW*\u00198bO\u0016\u0014\bB\u0002+\u0001A\u0003%q)\u0001\bu_.,g.T1oC\u001e,'o\u001d\u0011\t\u000fY\u0003!\u0019!C\u0001/\u0006IQ.Y:uKJ\\U-_\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005Y\u0006twMC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}S&AB*ue&tw\r\u0003\u0004b\u0001\u0001\u0006I\u0001W\u0001\u000b[\u0006\u001cH/\u001a:LKf\u0004\u0003bB2\u0001\u0005\u0004%\t\u0001Z\u0001\u0015[\u0006DH*\u001b4f)&lW-T:EK\u001a\fW\u000f\u001c;\u0016\u0003\u0015\u0004\"AZ4\u000e\u0003yJ!\u0001\u001b \u0003\t1{gn\u001a\u0005\u0007U\u0002\u0001\u000b\u0011B3\u0002+5\f\u0007\u0010T5gKRKW.Z't\t\u00164\u0017-\u001e7uA!9A\u000e\u0001b\u0001\n\u0003!\u0017A\u0005:f]\u0016<H+[7f\u001bN$UMZ1vYRDaA\u001c\u0001!\u0002\u0013)\u0017a\u0005:f]\u0016<H+[7f\u001bN$UMZ1vYR\u0004\u0003b\u00029\u0001\u0001\u0004%\t!]\u0001\u000bi>\\WM\\\"bG\",W#\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!C5oi\u0016\u0014h.\u00197t\u0015\t\u0019qO\u0003\u0002\u0006a%\u0011\u0011\u0010\u001e\u0002\u0015\t\u0016dWmZ1uS>tGk\\6f]\u000e\u000b7\r[3\t\u000fm\u0004\u0001\u0019!C\u0001y\u0006qAo\\6f]\u000e\u000b7\r[3`I\u0015\fHcA?\u0002\u0002A\u0011aM`\u0005\u0003\u007fz\u0012A!\u00168ji\"A\u00111\u0001>\u0002\u0002\u0003\u0007!/A\u0002yIEBq!a\u0002\u0001A\u0003&!/A\u0006u_.,gnQ1dQ\u0016\u0004\u0003\"CA\u0006\u0001\u0001\u0007I\u0011AA\u0007\u0003\u0015\u0001(o\u001c9t+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002X\u0001\u0005kRLG.\u0003\u0003\u0002\u001a\u0005M!A\u0003)s_B,'\u000f^5fg\"I\u0011Q\u0004\u0001A\u0002\u0013\u0005\u0011qD\u0001\naJ|\u0007o]0%KF$2!`A\u0011\u0011)\t\u0019!a\u0007\u0002\u0002\u0003\u0007\u0011q\u0002\u0005\t\u0003K\u0001\u0001\u0015)\u0003\u0002\u0010\u00051\u0001O]8qg\u0002B1\"!\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002,\u0005\t2M]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;\u0016\u0005\u00055\u0002c\u0001(\u00020%\u0019\u0011\u0011G(\u0003#\r\u0013X-\u0019;f)>\\WM\u001c*fgVdG\u000fC\u0006\u00026\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0012!F2sK\u0006$X\rV8lK:\u0014Vm];mi~#S-\u001d\u000b\u0004{\u0006e\u0002BCA\u0002\u0003g\t\t\u00111\u0001\u0002.!A\u0011Q\b\u0001!B\u0013\ti#\u0001\nde\u0016\fG/\u001a+pW\u0016t'+Z:vYR\u0004\u0003\"CA!\u0001\u0001\u0007I\u0011AA\"\u0003\u0015)'O]8s+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYEH\u0001\taJ|Go\\2pY&!\u0011qJA%\u0005\u0019)%O]8sg\"I\u00111\u000b\u0001A\u0002\u0013\u0005\u0011QK\u0001\nKJ\u0014xN]0%KF$2!`A,\u0011)\t\u0019!!\u0015\u0002\u0002\u0003\u0007\u0011Q\t\u0005\t\u00037\u0002\u0001\u0015)\u0003\u0002F\u00051QM\u001d:pe\u0002B\u0001\"a\u0018\u0001\u0001\u0004%\t\u0001Z\u0001\u0010Kb\u0004\u0018N]=US6,7\u000b^1na\"I\u00111\r\u0001A\u0002\u0013\u0005\u0011QM\u0001\u0014Kb\u0004\u0018N]=US6,7\u000b^1na~#S-\u001d\u000b\u0004{\u0006\u001d\u0004\"CA\u0002\u0003C\n\t\u00111\u0001f\u0011\u001d\tY\u0007\u0001Q!\n\u0015\f\u0001#\u001a=qSJLH+[7f'R\fW\u000e\u001d\u0011\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r\u0005)1/\u001a;VaR\tQ\u0010\u000b\u0003\u0002n\u0005U\u0004\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005m4%A\u0003kk:LG/\u0003\u0003\u0002\u0000\u0005e$A\u0002\"fM>\u0014X\rC\u0004\u0002\u0004\u0002!\t%!\u001d\u0002\u0011Q,\u0017M\u001d#po:DC!!!\u0002\bB!\u0011qOAE\u0013\u0011\tY)!\u001f\u0003\u000b\u00053G/\u001a:\t\u000f\u0005=\u0005\u0001\"\u0001\u0002r\u0005aC/Z:u)>\\WM\u001c*fcV,7\u000f^:XSRDG)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000eR5tC\ndW\r\u001a\u0015\u0005\u0003\u001b\u000b\u0019\n\u0005\u0003\u0002x\u0005U\u0015\u0002BAL\u0003s\u0012A\u0001V3ti\"9\u00111\u0014\u0001\u0005\u0002\u0005E\u0014a\u0004;fgR\u001c%/Z1uKR{7.\u001a8)\t\u0005e\u00151\u0013\u0005\b\u0003C\u0003A\u0011AA9\u00039!Xm\u001d;SK:,w\u000fV8lK:DC!a(\u0002\u0014\"9\u0011q\u0015\u0001\u0005\u0002\u0005E\u0014a\u0004;fgR,\u0005\u0010]5sKR{7.\u001a8)\t\u0005\u0015\u00161\u0013\u0005\b\u0003[\u0003A\u0011AA9\u0003M!Xm\u001d;SK6|g/\u001a+pW\u0016t\u0007*\\1dQ\u0011\tY+a%\t\u000f\u0005M\u0006\u0001\"\u0001\u0002r\u0005\tB/Z:u\t\u0016\u001c8M]5cKR{7.\u001a8)\t\u0005E\u00161\u0013\u0005\b\u0003s\u0003A\u0011BA^\u0003%9W\r\u001e+pW\u0016t7\u000f\u0006\u0007\u0002>\u0006m\u0017q\\Aw\u0005\u0017\u0011y\u0001\u0005\u0004\u0002@\u0006=\u00171\u001b\b\u0005\u0003\u0003\fYM\u0004\u0003\u0002D\u0006%WBAAc\u0015\r\t9MC\u0001\u0007yI|w\u000e\u001e \n\u0003}J1!!4?\u0003\u001d\u0001\u0018mY6bO\u0016L1!QAi\u0015\r\tiM\u0010\t\u0005\u0003+\f9.D\u0001w\u0013\r\tIN\u001e\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\"9\u0011Q\\A\\\u0001\u0004i\u0015\u0001\u0004;pW\u0016tW*\u00198bO\u0016\u0014\b\u0002CAq\u0003o\u0003\r!a9\u0002'MLW\u000e\u001d7f\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\u0011\t\u0005\u0015\u0018\u0011^\u0007\u0003\u0003OT!a\f\u0004\n\t\u0005-\u0018q\u001d\u0002\u0014'&l\u0007\u000f\\3BG2\fU\u000f\u001e5pe&TXM\u001d\u0005\t\u0003_\f9\f1\u0001\u0002r\u0006Y\u0001n\\:u'\u0016\u001c8/[8o!\u0011\t\u0019P!\u0002\u000f\t\u0005U\u0018q \b\u0005\u0003o\fYP\u0004\u0003\u0002D\u0006e\u0018\"A\u0005\n\u0007\u0005u\b\"A\u0004oKR<xN]6\n\t\t\u0005!1A\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0015\r\ti\u0010C\u0005\u0005\u0005\u000f\u0011IAA\u0004TKN\u001c\u0018n\u001c8\u000b\t\t\u0005!1\u0001\u0005\b\u0005\u001b\t9\f1\u0001-\u0003A\u0011X-];fgR\u0004&/\u001b8dSB\fG\u000e\u0003\u0005\u0003\u0012\u0005]\u0006\u0019\u0001B\n\u0003=\u0011X-];fgR,GmT<oKJ\u001c\b#BA`\u0003\u001fd\u0003b\u0002B\f\u0001\u0011\u0005\u0011\u0011O\u0001\u0018i\u0016\u001cH\u000fU3sS>$\u0017n\u0019+pW\u0016tW\t\u001f9jefDCA!\u0006\u0002\u0014\"9!Q\u0004\u0001\u0005\n\t}\u0011!G2sK\u0006$X\rV8lK:\u0014Vm];mi\u000e\u000bG\u000e\u001c\"bG.$2! B\u0011\u0011!\u0011\u0019Ca\u0007A\u0002\u00055\u0012a\u0001:fi\"9!q\u0005\u0001\u0005\n\t%\u0012!\u0006:f]\u0016<(+Z:q_:\u001cXmQ1mY\n\f7m\u001b\u000b\u0006{\n-\"Q\u0006\u0005\t\u0005G\u0011)\u00031\u0001\u0002F!9!q\u0006B\u0013\u0001\u0004)\u0017!\u0003;j[\u0016\u001cF/Y7q\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005k\tAd\u0019:fCR,G)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000fF\u0005N\u0005o\u0011\tEa\u0011\u0003L!A!\u0011\bB\u0019\u0001\u0004\u0011Y$\u0001\u0004d_:4\u0017n\u001a\t\u0004\u001d\nu\u0012b\u0001B \u001f\nY1*\u00194lC\u000e{gNZ5h\u0011\u0019\u0001(\u0011\u0007a\u0001e\"9\u0001D!\rA\u0002\t\u0015\u0003cA\u000e\u0003H%\u0019!\u0011\n\u000f\u0003\tQKW.\u001a\u0005\t\u0005\u001b\u0012\t\u00041\u0001\u0003P\u0005A!p[\"mS\u0016tG\u000fE\u0002\u000e\u0005#J1Aa\u0015\u000f\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0002")
public class DelegationTokenManagerTest
extends ZooKeeperTestHarness {
    private final MockTime time = new MockTime();
    private final KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner");
    private final List<KafkaPrincipal> renewer = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
    private final Buffer<DelegationTokenManager> tokenManagers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String masterKey;
    private final long maxLifeTimeMsDefault = Defaults$.MODULE$.DelegationTokenMaxLifeTimeMsDefault();
    private final long renewTimeMsDefault = Defaults$.MODULE$.DelegationTokenExpiryTimeMsDefault();
    private DelegationTokenCache tokenCache = null;
    private Properties props = null;
    private CreateTokenResult createTokenResult;
    private Errors error = Errors.NONE;
    private long expiryTimeStamp = 0L;

    public MockTime time() {
        return this.time;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public List<KafkaPrincipal> renewer() {
        return this.renewer;
    }

    public Buffer<DelegationTokenManager> tokenManagers() {
        return this.tokenManagers;
    }

    public String masterKey() {
        return this.masterKey;
    }

    public long maxLifeTimeMsDefault() {
        return this.maxLifeTimeMsDefault;
    }

    public long renewTimeMsDefault() {
        return this.renewTimeMsDefault;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public CreateTokenResult createTokenResult() {
        return this.createTokenResult;
    }

    public void createTokenResult_$eq(CreateTokenResult x$1) {
        this.createTokenResult = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    public long expiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public void expiryTimeStamp_$eq(long x$1) {
        this.expiryTimeStamp = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int x$2 = 0;
        String x$3 = this.zkConnect();
        boolean x$4 = true;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$7 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$4));
        this.props().put(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp(), ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ScramMechanism.mechanismNames()).asScala()).mkString(","));
        this.props().put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), this.masterKey());
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
    }

    @Override
    @After
    public void tearDown() {
        this.tokenManagers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelegationTokenManager x$1) {
                x$1.shutdown();
            }
        });
        super.tearDown();
    }

    @Test
    public void testTokenRequestsWithDelegationTokenDisabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.createTokenResult().error());
        Predef$.MODULE$.assert(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.createTokenResult().hmac())));
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
    }

    @Test
    public void testCreateToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        Option token = tokenManager.getToken(tokenId);
        Assert.assertTrue((!token.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Predef$.MODULE$.byteArrayOps(password).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(((DelegationToken)token.get()).hmac())));
    }

    @Test
    public void testRenewToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        long maxLifeTime = issueTime + this.maxLifeTimeMsDefault();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), maxLifeTime, tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.renewToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + this.renewTimeMsDefault();
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(86400000L);
        expectedExpiryStamp = this.time().milliseconds() + 3600000L;
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 3600000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(3600000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 691200000L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)maxLifeTime, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(691200000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)this.error());
    }

    @Test
    public void testExpireToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.expireToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + 0x6DDD00L;
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), 0x6DDD00L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        this.time().sleep(3600000L);
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        Assert.assertEquals((long)this.time().milliseconds(), (long)this.expiryTimeStamp());
    }

    @Test
    public void testRemoveTokenHmac() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(Errors ret, long timeStamp) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(ret, timeStamp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String encodedHmac = Base64.getEncoder().encodeToString(password);
        String tokenInformation = tokenManager.tokenCache().tokenIdForHmac(encodedHmac);
        Assert.assertNull((Object)tokenInformation);
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
    }

    @Test
    public void testDescribeToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        KafkaPrincipal owner1 = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal((String)"User:owner2");
        KafkaPrincipal owner3 = SecurityUtils.parseKafkaPrincipal((String)"User:owner3");
        KafkaPrincipal owner4 = SecurityUtils.parseKafkaPrincipal((String)"User:owner4");
        KafkaPrincipal renewer1 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer1");
        KafkaPrincipal renewer2 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer2");
        KafkaPrincipal renewer3 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer3");
        KafkaPrincipal renewer4 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer4");
        SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
        simpleAclAuthorizer.configure(config.originals());
        RequestChannel.Session hostSession = new RequestChannel.Session(owner1, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(owner1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer1, renewer2})), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(owner2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer3})), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String tokenId2 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4})), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String tokenId3 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner4, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 4);
        List<DelegationToken> tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:unknown")})));
        Predef$.MODULE$.assert(tokens.size() == 0);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)Nil$.MODULE$);
        Predef$.MODULE$.assert(tokens.size() == 0);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1})));
        Predef$.MODULE$.assert(tokens.size() == 2);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, null);
        Predef$.MODULE$.assert(tokens.size() == 2);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), null);
        Predef$.MODULE$.assert(tokens.size() == 0);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})));
        Predef$.MODULE$.assert(tokens.size() == 2);
        Acl acl = new Acl(owner1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        simpleAclAuthorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), new Resource((ResourceType)DelegationToken$.MODULE$, tokenId3, PatternType.LITERAL));
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})));
        Predef$.MODULE$.assert(tokens.size() == 3);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer4, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4})));
        Predef$.MODULE$.assert(tokens.size() == 2);
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3})));
        Predef$.MODULE$.assert(tokens.size() == 1);
        hostSession = new RequestChannel.Session(renewer2, InetAddress.getByName("192.168.1.1"));
        acl = new Acl(renewer2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        simpleAclAuthorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), new Resource((ResourceType)DelegationToken$.MODULE$, tokenId2, PatternType.LITERAL));
        tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3})));
        Predef$.MODULE$.assert(tokens.size() == 2);
        simpleAclAuthorizer.close();
    }

    private List<DelegationToken> getTokens(DelegationTokenManager tokenManager, SimpleAclAuthorizer simpleAclAuthorizer, RequestChannel.Session hostSession, KafkaPrincipal requestPrincipal, List<KafkaPrincipal> requestedOwners) {
        return requestedOwners != null && requestedOwners.isEmpty() ? Nil$.MODULE$ : tokenManager.getTokens((Function1)new Serializable(this, simpleAclAuthorizer, hostSession, requestPrincipal, requestedOwners){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;
            private final SimpleAclAuthorizer simpleAclAuthorizer$1;
            private final RequestChannel.Session hostSession$1;
            private final KafkaPrincipal requestPrincipal$1;
            private final List requestedOwners$1;

            public final boolean apply(TokenInformation token) {
                return this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$eligible$1(token, this.simpleAclAuthorizer$1, this.hostSession$1, this.requestPrincipal$1, this.requestedOwners$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simpleAclAuthorizer$1 = simpleAclAuthorizer$1;
                this.hostSession$1 = hostSession$1;
                this.requestPrincipal$1 = requestPrincipal$1;
                this.requestedOwners$1 = requestedOwners$1;
            }
        });
    }

    @Test
    public void testPeriodicTokenExpiry() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;

            public final void apply(CreateTokenResult ret) {
                this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 4);
        this.time().sleep(0x6DDD00L);
        tokenManager.expireTokens();
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 2);
    }

    public void kafka$security$token$delegation$DelegationTokenManagerTest$$createTokenResultCallBack(CreateTokenResult ret) {
        this.createTokenResult_$eq(ret);
    }

    public void kafka$security$token$delegation$DelegationTokenManagerTest$$renewResponseCallback(Errors ret, long timeStamp) {
        this.error_$eq(ret);
        this.expiryTimeStamp_$eq(timeStamp);
    }

    private DelegationTokenManager createDelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, tokenCache, time, zkClient);
        this.tokenManagers().$plus$eq((Object)tokenManager);
        return tokenManager;
    }

    public final boolean kafka$security$token$delegation$DelegationTokenManagerTest$$authorizeToken$1(String tokenId, SimpleAclAuthorizer simpleAclAuthorizer$1, RequestChannel.Session hostSession$1) {
        return simpleAclAuthorizer$1.authorize(hostSession$1, (Operation)Describe$.MODULE$, new Resource((ResourceType)DelegationToken$.MODULE$, tokenId, PatternType.LITERAL));
    }

    public final boolean kafka$security$token$delegation$DelegationTokenManagerTest$$eligible$1(TokenInformation token, SimpleAclAuthorizer simpleAclAuthorizer$1, RequestChannel.Session hostSession$1, KafkaPrincipal requestPrincipal$1, List requestedOwners$1) {
        return DelegationTokenManager$.MODULE$.filterToken(requestPrincipal$1, Option$.MODULE$.apply((Object)requestedOwners$1), token, (Function1)new Serializable(this, simpleAclAuthorizer$1, hostSession$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManagerTest $outer;
            private final SimpleAclAuthorizer simpleAclAuthorizer$1;
            private final RequestChannel.Session hostSession$1;

            public final boolean apply(String tokenId) {
                return this.$outer.kafka$security$token$delegation$DelegationTokenManagerTest$$authorizeToken$1(tokenId, this.simpleAclAuthorizer$1, this.hostSession$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simpleAclAuthorizer$1 = simpleAclAuthorizer$1;
                this.hostSession$1 = hostSession$1;
            }
        });
    }

    public DelegationTokenManagerTest() {
        this.masterKey = "masterKey";
    }
}

