/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u000f\t9B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012\u0001\u0005;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f)\u00051\u0002CA\u0005\u0018\u0013\tA\"B\u0001\u0003V]&$\bFA\n\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0001+\u00051C/Z:u\u0007>tg-[4Va\u0012\fG/Z,ji\"\u001cv.\\3J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005\tR\u0002\"\u0002\u0014\u0001\t\u0003)\u0012a\r;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bNU3d_:4\u0017nZ;sC\ndWMV1mS\u0012\fG/[8o\r\u0006LG.\u001e:fQ\t)#\u0004C\u0003*\u0001\u0011\u0005Q#\u0001\u000fuKN$(+Z2p]\u001aLw-\u001e:bE2,g+\u00197jI\u0006$\u0018n\u001c8)\u0005!R\u0002\"\u0002\u0017\u0001\t\u0003)\u0012a\u0005;fgR\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\bFA\u0016\u001b\u0011\u0015y\u0003\u0001\"\u0001\u0016\u0003M!Xm\u001d;D_:tWm\u0019;j_:\fVo\u001c;bQ\tq#\u0004C\u00033\u0001\u0011%1'\u0001\nwKJLg-_\"p]\u001aLw-\u00169eCR,G#\u0002\f5{\u001dc\u0005\"B\u001b2\u0001\u00041\u0014\u0001\u00028b[\u0016\u0004\"a\u000e\u001e\u000f\u0005%A\u0014BA\u001d\u000b\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eR\u0001\"\u0002 2\u0001\u0004y\u0014!\u0002<bYV,\u0007C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\u0007\u001f\nTWm\u0019;\t\u000b!\u000b\u0004\u0019A%\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!\u0003&\n\u0005-S!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001bF\u0002\r!S\u0001\u000eKb\u0004Xm\u0019;GC&dWO]3\t\u000b=\u0003A\u0011\u0002)\u0002GY,'/\u001b4z\u0007>tg-[4Va\u0012\fG/Z,ji\"LeN^1mS\u0012\u001cuN\u001c4jOR)a#\u0015,_G\")!K\u0014a\u0001'\u000611m\u001c8gS\u001e\u0004\"A\u0005+\n\u0005U\u0013!aC&bM.\f7i\u001c8gS\u001eDQa\u0016(A\u0002a\u000b\u0011b\u001c:jOB\u0013x\u000e]:\u0011\u0005ecV\"\u0001.\u000b\u0005m\u001b\u0015\u0001B;uS2L!!\u0018.\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003`\u001d\u0002\u0007\u0001-\u0001\u0006wC2LG\r\u0015:paN\u0004BaN17m%\u0011!\r\u0010\u0002\u0004\u001b\u0006\u0004\b\"\u00023O\u0001\u0004\u0001\u0017\u0001D5om\u0006d\u0017\u000e\u001a)s_B\u001c\b\"\u00024\u0001\t\u0003)\u0012\u0001\b;fgR\u0004\u0016m]:x_J$7i\u001c8gS\u001e,en\u0019:zaRLwN\u001c\u0015\u0003KjAQ!\u001b\u0001\u0005\u0002U\tQ\u0005^3tiB\u000b7o]<pe\u0012\u001cuN\u001c4jO\u0016s7m\u001c3feN+7M]3u\u0007\"\fgnZ3)\u0005!T\u0002\"\u00027\u0001\t\u0003)\u0012!\u0007;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001eD#a\u001b\u000e\t\u000b=\u0004A\u0011A\u000b\u0002\u0019Q,7\u000f^*z]>t\u00170\\:)\u00059T\u0002\"\u0002:\u0001\t\u0003)\u0012!\r;fgR$\u0015P\\1nS\u000e\u001cuN\u001c4jO&s\u0017\u000e^5bY&T\u0018\r^5p]^KG\u000f[8vi\u000e{gNZ5hg&s'l\u0013\u0015\u0003cj\u0001")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)props);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        Assert.assertSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assert.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assert.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)new Serializable(this, oldKeystore, config, dynamicConfig){
            public static final long serialVersionUID = 0L;
            private final String oldKeystore$1;
            private final KafkaConfig config$1;
            private final DynamicBrokerConfig dynamicConfig$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Properties props1 = new Properties();
                String newKeystore = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ks", ".jks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
                props1.put(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.keystore.location"})), newKeystore);
                this.dynamicConfig$1.updateBrokerConfig(0, props1);
                Assert.assertNotSame((Object)this.config$1, (Object)this.dynamicConfig$1.currentKafkaConfig());
                Assert.assertEquals((Object)newKeystore, this.config$1.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)newKeystore, this.config$1.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)newKeystore, this.config$1.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)newKeystore, this.config$1.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, (Object)this.config$1.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originals().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.values().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originalsStrings().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originalsFromThisConfig().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.valuesFromThisConfig().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.originalsFromThisConfig().get("ssl.keystore.location"));
                Assert.assertEquals((Object)this.oldKeystore$1, this.config$1.valuesFromThisConfig().get("ssl.keystore.location"));
            }
            {
                this.oldKeystore$1 = oldKeystore$1;
                this.config$1 = config$1;
                this.dynamicConfig$1 = dynamicConfig$1;
            }
        });
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$19 = 0;
        String x$20 = TestUtils$.MODULE$.MockZkConnect();
        int x$21 = 8181;
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$24 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$25 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$26 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$29 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$31 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$33 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$34 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$35 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$36 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$19, x$20, x$22, x$23, x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)origProps);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.keystore.location"}))), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$37 = 0;
        String x$38 = TestUtils$.MODULE$.MockZkConnect();
        int x$39 = 8181;
        boolean x$40 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$41 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$42 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$43 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$44 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$46 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$47 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$48 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$49 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$51 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$52 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$53 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$54 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$37, x$38, x$40, x$41, x$39, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)origProps);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(Map<String, ?> configs) {
                this.$outer.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                this.$outer.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$55 = 0;
        String x$56 = TestUtils$.MODULE$.MockZkConnect();
        int x$57 = 8181;
        boolean x$58 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$59 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$60 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$61 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$62 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$63 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$64 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$65 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$66 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$67 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$68 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$69 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$70 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$71 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$72 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$55, x$56, x$58, x$59, x$57, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, x$71, x$72);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)origProps);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, config, invalidReconfigurableProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicBrokerConfigTest $outer;
            private final KafkaConfig config$3;
            private final Set invalidReconfigurableProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.config$3.dynamicConfig().addReconfigurable(this.$outer.kafka$server$DynamicBrokerConfigTest$$createReconfigurable$1(this.invalidReconfigurableProps$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$3 = config$3;
                this.invalidReconfigurableProps$1 = invalidReconfigurableProps$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        config.dynamicConfig().addReconfigurable(this.kafka$server$DynamicBrokerConfigTest$$createReconfigurable$1(validReconfigurableProps));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, config, invalidReconfigurableProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicBrokerConfigTest $outer;
            private final KafkaConfig config$3;
            private final Set invalidReconfigurableProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.config$3.dynamicConfig().addBrokerReconfigurable(this.$outer.kafka$server$DynamicBrokerConfigTest$$createBrokerReconfigurable$1(this.invalidReconfigurableProps$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$3 = config$3;
                this.invalidReconfigurableProps$1 = invalidReconfigurableProps$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        config.dynamicConfig().addBrokerReconfigurable(this.kafka$server$DynamicBrokerConfigTest$$createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$73 = 0;
        String x$74 = TestUtils$.MODULE$.MockZkConnect();
        int x$75 = 8181;
        boolean x$76 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$77 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$78 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$79 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$80 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$81 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$82 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$83 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$84 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$85 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$86 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$87 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$88 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$89 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$90 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$73, x$74, x$76, x$77, x$75, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)configProps);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            this.updateConfig$1(perBrokerConfig, config, props);
            Assert.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        try {
            config.dynamicConfig().validate(props, perBrokerConfig);
            Assert.fail((String)"Invalid config did not fail validation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateConfig$1(perBrokerConfig, config, props);
        Assert.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$2.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$2 = props$2;
            }
        });
        invalidProps.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = this.props$2.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$2 = props$2;
            }
        });
        try {
            config.dynamicConfig().validate(props, true);
            Assert.fail((String)"Invalid config did not fail validation");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        config.dynamicConfig().updateBrokerConfig(0, props);
        validProps.foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig config$2;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Assert.assertEquals((Object)value, this.config$2.originals().get(name));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.config$2 = config$2;
            }
        });
        invalidProps.keySet().foreach((Function1)new Serializable(this, config, origProps){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig config$2;
            private final Properties origProps$1;

            public final void apply(String name) {
                Assert.assertEquals((Object)this.origProps$1.get(name), this.config$2.originals().get(name));
            }
            {
                this.config$2 = config$2;
                this.origProps$1 = origProps$1;
            }
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        Object object;
        int x$91 = 0;
        String x$92 = TestUtils$.MODULE$.MockZkConnect();
        int x$93 = 8181;
        boolean x$94 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$95 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$96 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$97 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$98 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$99 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$100 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$101 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$102 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$103 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$104 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$105 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$106 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$107 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$108 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$91, x$92, x$94, x$95, x$93, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((Map)props);
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            object = configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {
            object = BoxedUnit.UNIT;
        }
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assert.assertFalse((String)"Password not encoded", (boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"));
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assert.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$109 = 0;
        String x$110 = TestUtils$.MODULE$.MockZkConnect();
        int x$111 = 8181;
        boolean x$112 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$113 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$114 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$115 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$116 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$117 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$118 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$119 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$120 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$121 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$123 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$124 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$125 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$126 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$109, x$110, x$112, x$113, x$111, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assert.assertFalse((String)"Password not encoded", (boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"));
        config.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((Map)props);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        KafkaConfig newConfigWithNewAndOldSecret = KafkaConfig$.MODULE$.apply((Map)props);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((Map)props);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assert.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$127 = 0;
        String x$128 = TestUtils$.MODULE$.MockZkConnect();
        int x$129 = 9092;
        boolean x$130 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$131 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$132 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$133 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$134 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$135 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$136 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$137 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$138 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$139 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$140 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$141 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$142 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$143 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$144 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$127, x$128, x$130, x$131, x$129, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.apply((Map)props);
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig(kafkaServer);
        dynamicListenerConfig.validateReconfiguration(newConfig);
    }

    @Test
    public void testSynonyms() {
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.secure.ssl.keystore.type", "ssl.keystore.type"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.sasl_ssl.plain.sasl.jaas.config", "sasl.jaas.config"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.config"})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogRollTimeMillisProp(), KafkaConfig$.MODULE$.LogRollTimeHoursProp()})), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{zkClient});
        int x$145 = 0;
        String x$146 = TestUtils$.MODULE$.MockZkConnect();
        int x$147 = 9092;
        boolean x$148 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$149 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$150 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$151 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$152 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$153 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$154 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$155 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$156 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$157 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$158 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$159 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$160 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$161 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$162 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$145, x$146, x$148, x$149, x$147, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize(zkClient);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops);
    }

    public final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(Map configs) {
        int cleanerThreads2 = new StringOps(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString())).toInt();
        if (cleanerThreads2 <= 0 || cleanerThreads2 >= 5) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid cleaner threads ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cleanerThreads2)})));
        }
    }

    public final Reconfigurable kafka$server$DynamicBrokerConfigTest$$createReconfigurable$1(Set configs) {
        return new Reconfigurable(this, configs){
            private final Set configs$1;

            public void configure(Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(Map<String, ?> configs) {
            }

            public void reconfigure(Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    public final BrokerReconfigurable kafka$server$DynamicBrokerConfigTest$$createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(this, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), value, false, true);
    }

    private final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$4, Properties props$1) {
        if (perBrokerConfig$1) {
            config$4.dynamicConfig().updateBrokerConfig(0, config$4.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1));
        } else {
            config$4.dynamicConfig().updateDefaultConfig(props$1);
        }
    }
}

