/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0002ba&L!!\u0004\u0006\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C\u0001+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0001\u0016\u0003-\u0011'o\\6fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011\u001d9\u0003A1A\u0005\n!\nQ\u0001^8qS\u000e,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\"1!\u0007\u0001Q\u0001\n%\na\u0001^8qS\u000e\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%I!F\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\u0007m\u0001\u0001\u000b\u0011\u0002\f\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0011\u001dA\u0004A1A\u0005BU\t1\u0002\\8h\t&\u00148i\\;oi\"1!\b\u0001Q\u0001\nY\tA\u0002\\8h\t&\u00148i\\;oi\u0002BQ\u0001\u0010\u0001\u0005Bu\nQa]3u+B$\u0012A\u0010\t\u0003/}J!\u0001\u0011\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003w\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\u000b),h.\u001b;\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tIEI\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u0017\u0002!\t!P\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\tQU\n\u0005\u0002D\u001d&\u0011q\n\u0012\u0002\u0005)\u0016\u001cH\u000fC\u0003R\u0001\u0011\u0005Q(A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\u0001V\nC\u0003U\u0001\u0011\u0005Q(A\u0010uKN$\u0018jT#yG\u0016\u0004H/[8o\tV\u0014\u0018N\\4DQ\u0016\u001c7\u000e]8j]RD#aU'\t\u000b]\u0003A\u0011A\u001f\u0002iQ,7\u000f\u001e*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG-\u00114uKJdun\u001a#je\u001a\u000b\u0017\u000e\\;sK>sgi\u001c7m_^,'\u000f\u000b\u0002W\u001b\")!\f\u0001C\u00017\u0006)C/Z:u!J|G-^2f\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148MK\u0006$WM\u001d\u000b\u0003}qCQ!X-A\u0002y\u000b1BZ1jYV\u0014X\rV=qKB\u0011q,\u001d\b\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u00114\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019AaB\u0003i\u0005!\u0005\u0011.A\tM_\u001e$\u0015N\u001d$bS2,(/\u001a+fgR\u0004\"A\u00056\u0007\u000b\u0005\u0011\u0001\u0012A6\u0014\u0005)d\u0007CA\fn\u0013\tq\u0007D\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f)$\t\u0001\u001d\u000b\u0002S\u001a9!O\u001bI\u0001$C\u0019(!\u0005'pO\u0012K'OR1jYV\u0014X\rV=qKN\u0011\u0011\u000f\\\u0015\u0005cV\f9FB\u0003wU\"\u0005uO\u0001\u0006DQ\u0016\u001c7\u000e]8j]R\u001cR!\u001e7yuv\u0004\"!_9\u000e\u0003)\u0004\"aF>\n\u0005qD\"a\u0002)s_\u0012,8\r\u001e\t\u0003/yL!a \r\u0003\u0019M+'/[1mSj\f'\r\\3\t\r=)H\u0011AA\u0002)\t\t)\u0001\u0005\u0002zk\"A\u0011\u0011B;\u0002\u0002\u0013\u0005\u0003&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\t\u0003\u001b)\u0018\u0011!C\u0001+\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011\u0011C;\u0002\u0002\u0013\u0005\u00111C\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)\"a\u0007\u0011\u0007]\t9\"C\u0002\u0002\u001aa\u00111!\u00118z\u0011%\ti\"a\u0004\u0002\u0002\u0003\u0007a#A\u0002yIEB\u0011\"!\tv\u0003\u0003%\t%a\t\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\n\u0011\r\u0005\u001d\u0012QFA\u000b\u001b\t\tICC\u0002\u0002,a\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty#!\u000b\u0003\u0011%#XM]1u_JD\u0011\"a\rv\u0003\u0003%\t!!\u000e\u0002\u0011\r\fg.R9vC2$B!a\u000e\u0002>A\u0019q#!\u000f\n\u0007\u0005m\u0002DA\u0004C_>dW-\u00198\t\u0015\u0005u\u0011\u0011GA\u0001\u0002\u0004\t)\u0002C\u0005\u0002BU\f\t\u0011\"\u0011\u0002D\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u0017\u0011%\t9%^A\u0001\n\u0003\nI%\u0001\u0005u_N#(/\u001b8h)\u0005I\u0003\"CA'k\u0006\u0005I\u0011BA(\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0003c\u0001\u0016\u0002T%\u0019\u0011QK\u0016\u0003\r=\u0013'.Z2u\r\u001d\tIF\u001bEA\u00037\u0012AAU8mYN1\u0011q\u000b7yuvDqaDA,\t\u0003\ty\u0006\u0006\u0002\u0002bA\u0019\u00110a\u0016\t\u0013\u0005%\u0011qKA\u0001\n\u0003B\u0003\"CA\u0007\u0003/\n\t\u0011\"\u0001\u0016\u0011)\t\t\"a\u0016\u0002\u0002\u0013\u0005\u0011\u0011\u000e\u000b\u0005\u0003+\tY\u0007C\u0005\u0002\u001e\u0005\u001d\u0014\u0011!a\u0001-!Q\u0011\u0011EA,\u0003\u0003%\t%a\t\t\u0015\u0005M\u0012qKA\u0001\n\u0003\t\t\b\u0006\u0003\u00028\u0005M\u0004BCA\u000f\u0003_\n\t\u00111\u0001\u0002\u0016!Q\u0011\u0011IA,\u0003\u0003%\t%a\u0011\t\u0015\u0005\u001d\u0013qKA\u0001\n\u0003\nI\u0005\u0003\u0006\u0002N\u0005]\u0013\u0011!C\u0005\u0003\u001f:q!! k\u0011\u0003\u000b\t'\u0001\u0003S_2dwaBAAU\"\u0005\u0015QA\u0001\u000b\u0007\",7m\u001b9pS:$\bbBAC\u0001\u0011%\u0011qQ\u0001\u001egV\u00147o\u0019:jE\u0016\fe\u000eZ,bSR4uN]!tg&<g.\\3oiR)a(!#\u0002\u0018\"9q%a!A\u0002\u0005-\u0005\u0003BAG\u0003's1aFAH\u0013\r\t\t\nG\u0001\u0007!J,G-\u001a4\n\u0007A\n)JC\u0002\u0002\u0012bA\u0001\"!'\u0002\u0004\u0002\u0007\u00111T\u0001\tG>t7/^7feBA\u0011QTAV\u0003_\u000by+\u0004\u0002\u0002 *!\u0011\u0011TAQ\u0015\u0011\t\u0019+!*\u0002\u000f\rd\u0017.\u001a8ug*\u0019Q!a*\u000b\u0007\u0005%f)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003[\u000byJA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006/\u0005E\u0016QW\u0005\u0004\u0003gC\"!B!se\u0006L\bcA\f\u00028&\u0019\u0011\u0011\u0018\r\u0003\t\tKH/\u001a")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String kafka$server$LogDirFailureTest$$topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String kafka$server$LogDirFailureTest$$topic() {
        return this.kafka$server$LogDirFailureTest$$topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.kafka$server$LogDirFailureTest$$topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4());
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setHaltProcedure((Function2)new Serializable(this, statusCodeOption){
            public static final long serialVersionUID = 0L;
            private final VolatileObjectRef statusCodeOption$1;

            public final Nothing$ apply(int statusCode, Option<String> x$1) {
                this.statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
                throw new IllegalArgumentException();
            }
            {
                this.statusCodeOption$1 = statusCodeOption$1;
            }
        });
        KafkaServer server = null;
        try {
            int x$12 = this.brokerCount();
            String x$13 = this.zkConnect();
            int x$14 = 3;
            boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$3();
            boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$4();
            int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$5();
            Option<SecurityProtocol> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$6();
            Option<File> x$19 = TestUtils$.MODULE$.createBrokerConfig$default$7();
            Option<Properties> x$20 = TestUtils$.MODULE$.createBrokerConfig$default$8();
            boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$9();
            boolean x$22 = TestUtils$.MODULE$.createBrokerConfig$default$10();
            int x$23 = TestUtils$.MODULE$.createBrokerConfig$default$11();
            boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$12();
            int x$25 = TestUtils$.MODULE$.createBrokerConfig$default$13();
            boolean x$26 = TestUtils$.MODULE$.createBrokerConfig$default$14();
            int x$27 = TestUtils$.MODULE$.createBrokerConfig$default$15();
            Option<String> x$28 = TestUtils$.MODULE$.createBrokerConfig$default$16();
            boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$18();
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$13, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$14, x$29);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)new Serializable(this, logDir){
                public static final long serialVersionUID = 0L;
                private final File logDir$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Utils.delete((File)this.logDir$1);
                }
                {
                    this.logDir$1 = logDir$1;
                }
            }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            logDir.createNewFile();
            Assert.assertTrue((boolean)logDir.isFile());
            server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, statusCodeOption){
                public static final long serialVersionUID = 0L;
                private final VolatileObjectRef statusCodeOption$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return ((Option)this.statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
                }
                {
                    this.statusCodeOption$1 = statusCodeOption$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "timed out waiting for broker to halt";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        }
        catch (Throwable throwable) {
            Exit$.MODULE$.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
            }
            throw throwable;
        }
        Exit$.MODULE$.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})));
        }
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$2) {
                return x$2.partition() == 0;
            }
        }).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$1;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() == this.leaderServerId$1;
            }
            {
                this.leaderServerId$1 = leaderServerId$1;
            }
        }).get();
        int followerServerId = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$1;

            public final boolean apply(int x$5) {
                return this.apply$mcZI$sp(x$5);
            }

            public boolean apply$mcZI$sp(int x$5) {
                return x$5 != this.leaderServerId$1;
            }
            {
                this.leaderServerId$1 = leaderServerId$1;
            }
        }).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, followerServerId){
            public static final long serialVersionUID = 0L;
            private final int followerServerId$1;

            public final boolean apply(KafkaServer x$6) {
                return x$6.config().brokerId() == this.followerServerId$1;
            }
            {
                this.followerServerId$1 = followerServerId$1;
            }
        }).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.partitionNum()).find((Function1)new Serializable(this, leaderServer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogDirFailureTest $outer;
            private final KafkaServer leaderServer$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.leaderServer$1.replicaManager().getPartition(new TopicPartition(this.$outer.kafka$server$LogDirFailureTest$$topic(), i)).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Replica> apply(Partition x$7) {
                        return x$7.leaderReplicaIfLocal();
                    }
                }).isDefined();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderServer$1 = leaderServer$1;
            }
        }).get());
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.kafka$server$LogDirFailureTest$$topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.brokerCount(), (long)((Partition)leaderServer.replicaManager().getPartition(new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicas().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ReplicaFetcherThread thread) {
                Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.kafka$server$LogDirFailureTest$$topic(), consumer);
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0);
        ProducerRecord record = new ProducerRecord(this.kafka$server$LogDirFailureTest$$topic(), Predef$.MODULE$.int2Integer(0), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$8) {
                return x$8.partition() == 0;
            }
        }).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderServerId){
            public static final long serialVersionUID = 0L;
            private final int leaderServerId$2;

            public final boolean apply(KafkaServer x$9) {
                return x$9.config().brokerId() == this.leaderServerId$2;
            }
            {
                this.leaderServerId$2 = leaderServerId$2;
            }
        }).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Replica replica = leaderServer.replicaManager().localReplicaOrException(partition);
        File logDir = ((Log)replica.log().get()).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)new Serializable(this, logDir){
            public static final long serialVersionUID = 0L;
            private final File logDir$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils.delete((File)this.logDir$2);
            }
            {
                this.logDir$2 = logDir$2;
            }
        }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$30 = qual$1.roll$default$1();
                qual$1.roll(x$30);
                throw Assertions$.MODULE$.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            }
            catch (KafkaStorageException kafkaStorageException) {
                // empty catch block
            }
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, leaderServer, logDir){
            public static final long serialVersionUID = 0L;
            private final KafkaServer leaderServer$2;
            private final File logDir$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.leaderServer$2.logManager().isLogDirOnline(this.logDir$2.getAbsolutePath());
            }
            {
                this.leaderServer$2 = leaderServer$2;
                this.logDir$2 = logDir$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected log directory offline";
            }
        }, 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)leaderServer.replicaManager().localReplica(partition).isEmpty());
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw Assertions$.MODULE$.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }
        catch (ExecutionException executionException) {
            Throwable throwable;
            block13: {
                block12: {
                    block11: {
                        throwable = executionException.getCause();
                        if (!(throwable instanceof KafkaStorageException)) break block11;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block12;
                    }
                    if (!(throwable instanceof NotLeaderForPartitionException)) break block13;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, producer, record, leaderServerId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogDirFailureTest $outer;
                    private final KafkaProducer producer$1;
                    private final ProducerRecord record$1;
                    private final int leaderServerId$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.producer$1.send(this.record$1);
                        return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.producer$1.partitionsFor(this.$outer.kafka$server$LogDirFailureTest$$topic())).asScala()).find((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(PartitionInfo x$10) {
                                return x$10.partition() == 0;
                            }
                        }).get()).leader().id() != this.leaderServerId$2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.record$1 = record$1;
                        this.leaderServerId$2 = leaderServerId$2;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Expected new leader for the partition";
                    }
                }, 6000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
                TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
                KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer x$11) {
                        return x$11.kafkaController().isActive();
                    }
                }).get();
                Set offlineReplicas = controllerServer.kafkaController().controllerContext().replicasInState(this.kafka$server$LogDirFailureTest$$topic(), (ReplicaState)OfflineReplica$.MODULE$);
                Assert.assertTrue((boolean)offlineReplicas.contains((Object)new PartitionAndReplica(new TopicPartition(this.kafka$server$LogDirFailureTest$$topic(), 0), leaderServerId)));
                return;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                throw Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable2.toString()})), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            }
            throw new MatchError((Object)throwable);
        }
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.consumer$1.assignment().isEmpty();
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.kafka$server$LogDirFailureTest$$topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

