/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataRequestTest$;
import kafka.server.NotRunning$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u001d\u00111#T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0012\u0012a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0003V]&$\b\"\u0002\u000e\u0011\u0001\u0004Y\u0012A\u00039s_B,'\u000f^5fgB\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005kRLGNC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"A\u0003)s_B,'\u000f^5fg\")A\u0005\u0001C!K\u0005)1/\u001a;VaR\t1\u0003\u000b\u0002$OA\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0005\u0019qN]4\n\u00059J#A\u0002\"fM>\u0014X\rC\u00031\u0001\u0011\u0005Q%\u0001\u0011uKN$8\t\\;ti\u0016\u0014\u0018\nZ,ji\"\u0014V-];fgR4VM]:j_:\f\u0004FA\u00183!\tA3'\u0003\u00025S\t!A+Z:u\u0011\u00151\u0004\u0001\"\u0001&\u0003Q!Xm\u001d;DYV\u001cH/\u001a:JI&\u001bh+\u00197jI\"\u0012QG\r\u0005\u0006s\u0001!\t!J\u0001\u0011i\u0016\u001cHoQ8oiJ|G\u000e\\3s\u0013\u0012D#\u0001\u000f\u001a\t\u000bq\u0002A\u0011A\u0013\u0002\u0011Q,7\u000f\u001e*bG.D#a\u000f\u001a\t\u000b}\u0002A\u0011A\u0013\u0002\u001dQ,7\u000f^%t\u0013:$XM\u001d8bY\"\u0012aH\r\u0005\u0006\u0005\u0002!\t!J\u0001\u0014i\u0016\u001cHOT8U_BL7m\u001d*fcV,7\u000f\u001e\u0015\u0003\u0003JBQ!\u0012\u0001\u0005\u0002\u0015\nQ\u0003^3ti\u0006+Ho\u001c+pa&\u001c7I]3bi&|g\u000e\u000b\u0002Ee!)\u0001\n\u0001C\u0001K\u0005yC/Z:u\u0003V$xn\u0011:fCR,Gk\u001c9jG^KG\u000f[%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"\u0012qI\r\u0005\u0006\u0017\u0002!\t!J\u0001 i\u0016\u001cH/Q;u_\u000e\u0013X-\u0019;f\u001f\u001a\u001cu\u000e\u001c7jI&tw\rV8qS\u000e\u001c\bF\u0001&3\u0011\u0015q\u0005\u0001\"\u0001&\u0003Q!Xm\u001d;BY2$v\u000e]5dgJ+\u0017/^3ti\"\u0012QJ\r\u0005\u0006#\u0002!\t!J\u0001\u0015i\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1)\u0005A\u0013\u0004\"\u0002+\u0001\t\u0003)\u0016a\u0003:fcV,7\u000f\u001e#bi\u0006$2AV1w!\t9v,D\u0001Y\u0015\tI&,A\u0004nKN\u001c\u0018mZ3\u000b\u0005mc\u0016AB2p[6|gN\u0003\u0002\u0006;*\u0011alK\u0001\u0007CB\f7\r[3\n\u0005\u0001D&aE'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0007\"\u00022T\u0001\u0004\u0019\u0017A\u0002;pa&\u001c7\u000fE\u0002eY>t!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!4\u0011A\u0002\u001fs_>$h(C\u0001\u0017\u0013\tYW#A\u0004qC\u000e\\\u0017mZ3\n\u00055t'\u0001\u0002'jgRT!a[\u000b\u0011\u0005A\u001chB\u0001\u000br\u0013\t\u0011X#\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:\u0016\u0011\u001598\u000b1\u0001y\u0003Y\tG\u000e\\8x\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>t\u0007C\u0001\u000bz\u0013\tQXCA\u0004C_>dW-\u00198\t\u000bq\u0004A\u0011A\u0013\u0002/Q,7\u000f\u001e*fa2L7-\u0019#po:\u0014Vm\u001d9p]N,\u0007FA>3\u0011\u0015y\b\u0001\"\u0001&\u0003\u0019\"Xm\u001d;JgJ\fe\r^3s\u0005J|7.\u001a:TQV$Hi\\<o\u0003:$'j\\5og\n\u000b7m\u001b\u0015\u0003}JBa!!\u0002\u0001\t\u0003)\u0013\u0001\b;fgR\fE.\u001b<f\u0005J|7.\u001a:t/&$\bNT8U_BL7m\u001d\u0015\u0004\u0003\u0007\u0011\u0004bBA\u0006\u0001\u0011%\u0011QB\u0001\u0014g\u0016tG-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u000b\u0007\u0003\u001f\tY\"!\n\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006[\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\r\u0003'\u0011\u0001#T3uC\u0012\fG/\u0019*fgB|gn]3\t\u0011\u0005u\u0011\u0011\u0002a\u0001\u0003?\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0012\u0005\u0005\u0012\u0002BA\u0012\u0003'\u0011q\"T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0005\u000b\u0003O\tI\u0001%AA\u0002\u0005%\u0012a\u00033fgRLg.\u0019;j_:\u0004R\u0001FA\u0016\u0003_I1!!\f\u0016\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026\u0011\tqA\\3uo>\u00148.\u0003\u0003\u0002:\u0005M\"\u0001D*pG.,GoU3sm\u0016\u0014\b\"CA\u001f\u0001E\u0005I\u0011BA \u0003u\u0019XM\u001c3NKR\fG-\u0019;b%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAA!U\u0011\tI#a\u0011,\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0014\u0016\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\nIEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class MetadataRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())})));
    }

    @Override
    @Before
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        MetadataResponse v1MetadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        String v1ClusterId = v1MetadataResponse.clusterId();
        Assert.assertNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1 clusterId should be null"})).s((Seq)Nil$.MODULE$), (Object)v1ClusterId);
    }

    @Test
    public void testClusterIdIsValid() {
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        TestUtils.isValidClusterId((String)metadataResponse.clusterId());
    }

    @Test
    public void testControllerId() {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$1) {
                return x$1.kafkaController().isActive();
            }
        }).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertEquals((String)"Controller id should match the active controller", (long)controllerId, (long)metadataResponse.controller().id());
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$2) {
                return x$2.kafkaController().isActive();
            }
        }).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assert.assertNotEquals((String)"Controller id should switch to a new broker", (long)controllerId, (long)controllerId2);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controllerServer2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            private final KafkaServer controllerServer2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                MetadataResponse metadataResponse2 = this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
                return metadataResponse2.controller() != null && this.controllerServer2$1.dataPlaneRequestProcessor().brokerId() == metadataResponse2.controller().id();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controllerServer2$1 = controllerServer2$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Controller id should match the active controller after failover";
            }
        }, 5000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testRack() {
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Node broker) {
                Assert.assertEquals((String)"Rack information should match config", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker.id())})), (Object)broker.rack());
            }
        });
    }

    @Test
    public void testIsInternal() {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Iterable topicMetadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1)new Serializable(this, internalTopic){
            public static final long serialVersionUID = 0L;
            private final String internalTopic$1;

            public final boolean apply(MetadataResponse.TopicMetadata x$3) {
                String string = x$3.topic();
                String string2 = this.internalTopic$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.internalTopic$1 = internalTopic$1;
            }
        }).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1)new Serializable(this, notInternalTopic){
            public static final long serialVersionUID = 0L;
            private final String notInternalTopic$1;

            public final boolean apply(MetadataResponse.TopicMetadata x$4) {
                String string = x$4.topic();
                String string2 = this.notInternalTopic$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.notInternalTopic$1 = notInternalTopic$1;
            }
        }).get();
        Assert.assertTrue((String)"internalTopic should show isInternal", (boolean)internalTopicMetadata.isInternal());
        Assert.assertFalse((String)"notInternalTopic topic not should show isInternal", (boolean)notInternalTopicMetadata.isInternal());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.cluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)1).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Assert.assertTrue((String)"Response should have no topics", (boolean)metadataResponse.topicMetadata().isEmpty());
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        MetadataResponse response1 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava(), true, ApiKeys.METADATA.latestVersion()).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic1, topic2, response1);
        MetadataResponse response2 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2, topic3})), false), (short)3), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic2, topic3, response2);
        MetadataResponse response3 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic3, topic4}))).asJava(), false, (short)4).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertNull(response3.errors().get(topic3));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic4));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableLike)this.servers().tail()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
        ((IterableLike)this.servers().tail()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$6) {
                x$6.awaitShutdown();
            }
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava(), true).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        Assert.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        Assert.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assert.assertEquals((long)0L, (long)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAutoCreateOfCollidingTopics() {
        String topic1 = "testAutoCreate_Topic";
        String topic2 = "testAutoCreate.Topic";
        MetadataResponse response1 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava(), true).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertEquals((long)2L, (long)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        MetadataResponse.TopicMetadata topicMetadata2 = (MetadataResponse.TopicMetadata)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).toSeq().apply(1);
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)topicMetadata1.error());
        Assert.assertEquals((Object)topic1, (Object)topicMetadata1.topic());
        Assert.assertEquals((Object)Errors.INVALID_TOPIC_EXCEPTION, (Object)topicMetadata2.error());
        Assert.assertEquals((Object)topic2, (Object)topicMetadata2.topic());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic1, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic1, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response2 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJava(), true).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response2.topicMetadata()).asScala()).head();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.NONE})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Errors apply(MetadataResponse.PartitionMetadata x$7) {
                return x$7.error();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)1L, (long)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).head();
        Assert.assertEquals((long)0L, (long)partitionMetadata.partition());
        Assert.assertEquals((long)2L, (long)partitionMetadata.replicas().size());
        Assert.assertNotNull((Object)partitionMetadata.leader());
    }

    @Test
    public void testAllTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponseV0 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)Nil$.MODULE$, true), (short)0), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V0 Response should have no errors", (boolean)metadataResponseV0.errors().isEmpty());
        Assert.assertEquals((String)"V0 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV0.topicMetadata().size());
        MetadataResponse metadataResponseV1 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V1 Response should have no errors", (boolean)metadataResponseV1.errors().isEmpty());
        Assert.assertEquals((String)"V1 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV1.topicMetadata().size());
    }

    @Test
    public void testPreferredReplica() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic("t1", (Map<Object, Seq<Object>>)replicaAssignment);
        Seq responses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataResponse[]{this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer())), this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer()))}));
        responses.foreach((Function1)new Serializable(this, replicaAssignment){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map replicaAssignment$1;

            public final void apply(MetadataResponse response) {
                Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
                MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
                Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
                Assert.assertEquals((Object)"t1", (Object)topicMetadata.topic());
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MetadataResponse.PartitionMetadata x$8) {
                        return x$8.partition();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toSet());
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testPreferredReplica$1 $outer;

                    public final void apply(MetadataResponse.PartitionMetadata partitionMetadata) {
                        Seq assignment2 = (Seq)this.$outer.replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
                        Assert.assertEquals((Object)assignment2, (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$9) {
                                return x$9.id();
                            }
                        }, Buffer$.MODULE$.canBuildFrom()));
                        Assert.assertEquals((Object)assignment2, (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$10) {
                                return x$10.id();
                            }
                        }, Buffer$.MODULE$.canBuildFrom()));
                        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)assignment2.head()), (long)partitionMetadata.leader().id());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.replicaAssignment$1 = replicaAssignment$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public MetadataRequestData requestData(List<String> topics, boolean allowAutoTopicCreation) {
        void var3_3;
        MetadataRequestData metadataRequestData;
        MetadataRequestData data = new MetadataRequestData();
        if (topics == null) {
            metadataRequestData = data.setTopics(null);
        } else {
            topics.foreach((Function1)new Serializable(this, data){
                public static final long serialVersionUID = 0L;
                private final MetadataRequestData data$1;

                public final boolean apply(String topic) {
                    return this.data$1.topics().add(new MetadataRequestData.MetadataRequestTopic().setName(topic));
                }
                {
                    this.data$1 = data$1;
                }
            });
            metadataRequestData = BoxedUnit.UNIT;
        }
        data.setAllowAutoTopicCreation(allowAutoTopicCreation);
        return var3_3;
    }

    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true, (short)1).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        KafkaServer downNode = (KafkaServer)this.servers().find((Function1)new Serializable(this, partitionMetadata){
            public static final long serialVersionUID = 0L;
            private final MetadataResponse.PartitionMetadata partitionMetadata$1;

            public final boolean apply(KafkaServer server) {
                int serverId = server.dataPlaneRequestProcessor().brokerId();
                int leaderId = this.partitionMetadata$1.leader().id();
                Buffer replicaIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionMetadata$1.replicas()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$11) {
                        return x$11.id();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return serverId != leaderId && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
            }
            {
                this.partitionMetadata$1 = partitionMetadata$1;
            }
        }).get();
        downNode.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaDownTopic, downNode){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            private final String replicaDownTopic$1;
            public final KafkaServer downNode$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                MetadataResponse response = this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.replicaDownTopic$1}))).asJava(), true, (short)1).build(), this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
                MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
                Node replica = (Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.replicas()).asScala()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testReplicaDownResponse$1 $outer;

                    public final boolean apply(Node x$12) {
                        return x$12.id() == this.$outer.downNode$1.dataPlaneRequestProcessor().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get();
                String string = replica.host();
                String string2 = "";
                return !(string != null ? !string.equals(string2) : string2 != null) & replica.port() == -1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaDownTopic$1 = replicaDownTopic$1;
                this.downNode$1 = downNode$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Replica was not found down";
            }
        }, 5000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        MetadataResponse v0MetadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic})), true), (short)0), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Seq v0BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.brokers()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$13) {
                return x$13.id();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v0MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The downed broker should not be in the brokers list"})).s((Seq)Nil$.MODULE$), (boolean)v0BrokerIds.contains((Object)downNode));
        Assert.assertTrue((String)"Response should have one topic", (v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0);
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Errors errors = v0PartitionMetadata.error();
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assert.assertTrue((String)"PartitionMetadata should have an error", (!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response should have ", " replicas"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(replicaCount - 1))})), (v0PartitionMetadata.replicas().size() == replicaCount - 1 ? 1 : 0) != 0);
        MetadataResponse v1MetadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true, (short)1).build(), this.kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2());
        Seq v1BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.brokers()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$14) {
                return x$14.id();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v1MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The downed broker should not be in the brokers list"})).s((Seq)Nil$.MODULE$), (boolean)v1BrokerIds.contains((Object)downNode));
        Assert.assertEquals((String)"Response should have one topic", (long)1L, (long)v1MetadataResponse.topicMetadata().size());
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Assert.assertEquals((String)"PartitionMetadata should have no errors", (Object)Errors.NONE, (Object)v1PartitionMetadata.error());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response should have ", " replicas"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaCount)})), (long)replicaCount, (long)v1PartitionMetadata.replicas().size());
    }

    @Test
    public void testIsrAfterBrokerShutDownAndJoinsBack() {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4());
        ((KafkaServer)this.servers().last()).shutdown();
        ((KafkaServer)this.servers().last()).awaitShutdown();
        ((KafkaServer)this.servers().last()).startup();
        this.checkIsr$1((Seq)this.servers(), topic);
    }

    @Test
    public void testAliveBrokersWithNoTopics() {
        KafkaServer serverToShutdown = (KafkaServer)((TraversableLike)this.servers().filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$24) {
                return x$24.kafkaController().isActive();
            }
        })).last();
        serverToShutdown.shutdown();
        serverToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size() - 1);
        serverToShutdown.startup();
        this.checkMetadata$1((Seq)this.servers(), this.servers().size());
    }

    public MetadataResponse kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;

            public final SocketServer apply() {
                return this.$outer.anySocketServer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    public Option<SocketServer> kafka$server$MetadataRequestTest$$sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    private final void checkAutoCreatedTopic$1(String existingTopic, String autoCreatedTopic, MetadataResponse response) {
        Assert.assertNull(response.errors().get(existingTopic));
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, response.errors().get(autoCreatedTopic));
        Assert.assertEquals((Object)new Some((Object)((KafkaServer)this.servers().head()).config().numPartitions()), (Object)this.zkClient().getTopicPartitionCount(autoCreatedTopic));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaServer)this.servers().head()).config().numPartitions())).foreach((Function1)new Serializable(this, autoCreatedTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            private final String autoCreatedTopic$1;

            public final int apply(int i) {
                return this.apply$mcII$sp(i);
            }

            public int apply$mcII$sp(int i) {
                return TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.$outer.servers(), this.autoCreatedTopic$1, i, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.autoCreatedTopic$1 = autoCreatedTopic$1;
            }
        });
    }

    private final void checkIsr$1(Seq servers, String topic) {
        Seq activeBrokers = (Seq)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$15) {
                return x$15.brokerState().currentState() != NotRunning$.MODULE$.state();
            }
        });
        Seq expectedIsr = (Seq)((SeqLike)activeBrokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Node apply(KafkaServer broker) {
                return new Node(broker.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort(broker, TestUtils$.MODULE$.boundPort$default$2()), (String)broker.config().rack().orNull(Predef$.MODULE$.$conforms()));
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$16) {
                return x$16.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        activeBrokers.foreach((Function1)new Serializable(this, topic, expectedIsr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            public final String topic$1;
            public final Seq expectedIsr$1;

            public final void apply(KafkaServer broker) {
                ObjectRef actualIsr = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, actualIsr, broker){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkIsr$1$1 $outer;
                    private final ObjectRef actualIsr$1;
                    private final KafkaServer broker$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        MetadataResponse metadataResponse = this.$outer.kafka$server$MetadataRequestTest$$anonfun$$$outer().kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.topic$1}))).asJava(), false).build(), (Option<SocketServer>)new Some((Object)this.$outer.kafka$server$MetadataRequestTest$$anonfun$$$outer().brokerSocketServer(this.broker$1.config().brokerId())));
                        Option firstPartitionMetadata = ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).headOption().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<MetadataResponse.PartitionMetadata> apply(MetadataResponse.TopicMetadata x$17) {
                                return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$17.partitionMetadata()).asScala()).headOption();
                            }
                        });
                        this.actualIsr$1.elem = (Seq)firstPartitionMetadata.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Buffer<Node> apply(MetadataResponse.PartitionMetadata partitionMetadata) {
                                return (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).sortBy((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Node x$18) {
                                        return x$18.id();
                                    }
                                }, (Ordering)Ordering.Int$.MODULE$);
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<Nothing$> apply() {
                                return (Seq)Seq$.MODULE$.empty();
                            }
                        });
                        Seq seq = this.$outer.expectedIsr$1;
                        Seq seq2 = (Seq)this.actualIsr$1.elem;
                        return !(seq != null ? !seq.equals(seq2) : seq2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.actualIsr$1 = actualIsr$1;
                        this.broker$1 = broker$1;
                    }
                }, (Function0<String>)new Serializable(this, actualIsr, broker){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkIsr$1$1 $outer;
                    private final ObjectRef actualIsr$1;
                    private final KafkaServer broker$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic metadata not updated correctly in broker ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.broker$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ISR: ", " \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.expectedIsr$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actual ISR : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(Seq)this.actualIsr$1.elem}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.actualIsr$1 = actualIsr$1;
                        this.broker$1 = broker$1;
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }

            public /* synthetic */ MetadataRequestTest kafka$server$MetadataRequestTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.expectedIsr$1 = expectedIsr$1;
            }
        });
    }

    private final void checkMetadata$1(Seq servers, int expectedBrokersCount) {
        ObjectRef controllerMetadataResponse = ObjectRef.create((Object)None$.MODULE$);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expectedBrokersCount, controllerMetadataResponse){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            private final int expectedBrokersCount$1;
            private final ObjectRef controllerMetadataResponse$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                MetadataResponse metadataResponse = this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.$outer.controllerSocketServer()));
                this.controllerMetadataResponse$1.elem = new Some((Object)metadataResponse);
                return metadataResponse.brokers().size() == this.expectedBrokersCount$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedBrokersCount$1 = expectedBrokersCount$1;
                this.controllerMetadataResponse$1 = controllerMetadataResponse$1;
            }
        }, (Function0<String>)new Serializable(this, expectedBrokersCount, controllerMetadataResponse){
            public static final long serialVersionUID = 0L;
            private final int expectedBrokersCount$1;
            private final ObjectRef controllerMetadataResponse$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " brokers, but there are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.expectedBrokersCount$1), BoxesRunTime.boxToInteger((int)((MetadataResponse)((Option)this.controllerMetadataResponse$1.elem).get()).brokers().size())}))).append((Object)"according to the Controller").toString();
            }
            {
                this.expectedBrokersCount$1 = expectedBrokersCount$1;
                this.controllerMetadataResponse$1 = controllerMetadataResponse$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Seq brokersInController = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)((Option)controllerMetadataResponse.elem).get()).brokers()).asScala()).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$19) {
                return x$19.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        ((IterableLike)servers.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$20) {
                return x$20.brokerState().currentState() != NotRunning$.MODULE$.state();
            }
        })).foreach((Function1)new Serializable(this, brokersInController){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            public final Seq brokersInController$1;

            public final void apply(KafkaServer broker) {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, broker){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkMetadata$1$4 $outer;
                    private final KafkaServer broker$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean apply$mcZ$sp() {
                        MetadataResponse metadataResponse = this.$outer.kafka$server$MetadataRequestTest$$anonfun$$$outer().kafka$server$MetadataRequestTest$$sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.$outer.kafka$server$MetadataRequestTest$$anonfun$$$outer().brokerSocketServer(this.broker$2.config().brokerId())));
                        Seq brokers = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).toSeq().sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$21) {
                                return x$21.id();
                            }
                        }, (Ordering)Ordering.Int$.MODULE$);
                        Seq topicMetadata = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(MetadataResponse.TopicMetadata x$22) {
                                return x$22.topic();
                            }
                        }, (Ordering)Ordering.String$.MODULE$);
                        Seq seq = this.$outer.brokersInController$1;
                        Seq seq2 = brokers;
                        if (seq == null) {
                            if (seq2 != null) {
                                return false;
                            }
                        } else if (!seq.equals(seq2)) return false;
                        Object object = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).toSeq().sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(MetadataResponse.TopicMetadata x$23) {
                                return x$23.topic();
                            }
                        }, (Ordering)Ordering.String$.MODULE$);
                        Seq seq3 = topicMetadata;
                        if (object == null) {
                            if (seq3 == null) return true;
                            return false;
                        } else {
                            if (!object.equals(seq3)) return false;
                            return true;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.broker$2 = broker$2;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic metadata not updated correctly"})).s((Seq)Nil$.MODULE$);
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            }

            public /* synthetic */ MetadataRequestTest kafka$server$MetadataRequestTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokersInController$1 = brokersInController$1;
            }
        });
    }
}

