/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaManagerTest$$anon$4$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015d\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\n\u0001B_6DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\tu.\u001cG.[3oi*\u0011AIN\u0001\u0007\u0013BJE/Z2\n\u0005\u0019\u000b%\u0001\u0003.l\u00072LWM\u001c;\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0015\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHC\u0001&N!\tI1*\u0003\u0002M\u0015\t!QK\\5u\u0011\u001dqu)!AA\u0002}\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0006\u0001)Q\u0005\u007f\u0005I!p[\"mS\u0016tG\u000f\t\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002M\u000bQb[1gW\u0006T6n\u00117jK:$X#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]#\u0011A\u0001>l\u0013\tIfKA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\n7\u0002\u0001\r\u00111A\u0005\u0002q\u000b\u0011c[1gW\u0006T6n\u00117jK:$x\fJ3r)\tQU\fC\u0004O5\u0006\u0005\t\u0019\u0001+\t\r}\u0003\u0001\u0015)\u0003U\u00039Y\u0017MZ6b5.\u001cE.[3oi\u0002Bq!\u0019\u0001C\u0002\u0013\u0005!-A\u0005{WZ+'o]5p]V\t1\r\u0005\u0002\nI&\u0011QM\u0003\u0002\u0004\u0013:$\bBB4\u0001A\u0003%1-\u0001\u0006{WZ+'o]5p]\u0002Bq!\u001b\u0001C\u0002\u0013\u0005!-A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B2\u0002\u001d\r|'O]3mCRLwN\\%eA!9Q\u000e\u0001a\u0001\n\u0003\u0011\u0017aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f=\u0004\u0001\u0019!C\u0001a\u0006\u00192m\u001c8ue>dG.\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0011!*\u001d\u0005\b\u001d:\f\t\u00111\u0001d\u0011\u0019\u0019\b\u0001)Q\u0005G\u0006\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0003-\u0011'o\\6fe\u0016\u0003xn\u00195\u0016\u0003]\u0004\"!\u0003=\n\u0005eT!\u0001\u0002'p]\u001eDaa\u001f\u0001!\u0002\u00139\u0018\u0001\u00042s_.,'/\u00129pG\"\u0004\u0003\"B?\u0001\t\u0003q\u0018!B:fiV\u0003H#\u0001&)\u0007q\f\t\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AN\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0017\t)A\u0001\u0004CK\u001a|'/\u001a\u0005\u0007\u0003\u001f\u0001A\u0011\u0001@\u0002\u0011Q,\u0017M\u001d#po:DC!!\u0004\u0002\u0014A!\u00111AA\u000b\u0013\u0011\t9\"!\u0002\u0003\u000b\u00053G/\u001a:\t\r\u0005m\u0001\u0001\"\u0001\u007f\u0003\u0005\"Xm\u001d;IS\u001eDw+\u0019;fe6\u000b'o\u001b#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8hQ\u0011\tI\"a\b\u0011\t\u0005\r\u0011\u0011E\u0005\u0005\u0003G\t)A\u0001\u0003UKN$\bBBA\u0014\u0001\u0011\u0005a0A\u0015uKN$\b*[4io\u0006$XM]'be.\u0014V\r\\1uSZ,G)\u001b:fGR|'/_'baBLgn\u001a\u0015\u0005\u0003K\ty\u0002\u0003\u0004\u0002.\u0001!\tA`\u0001\u0018i\u0016\u001cH/\u00137mK\u001e\fGNU3rk&\u0014X\rZ!dWNDC!a\u000b\u0002 !1\u00111\u0007\u0001\u0005\u0002y\fA\u0005^3ti\u000ecW-\u0019:QkJ<\u0017\r^8ss>s')Z2p[&twMR8mY><XM\u001d\u0015\u0005\u0003c\ty\u0002\u0003\u0004\u0002:\u0001!\tA`\u00019i\u0016\u001cHOU3dK&4XmT;u\u001f\u001a|%\u000fZ3s'\u0016\fX/\u001a8dK\u0016C8-\u001a9uS>tw+\u001b;i\u0019><7\u000b^1si>3gm]3uQ\u0011\t9$a\b\t\r\u0005}\u0002\u0001\"\u0001\u007f\u0003\t\"Xm\u001d;SK\u0006$7i\\7nSR$X\r\u001a$fi\u000eDG*[7ji\u0016$\u0017\t\u001e'T\u001f\"\"\u0011QHA\u0010\u0011\u0019\t)\u0005\u0001C\u0001}\u0006YC/Z:u\t\u0016d\u0017-_3e\r\u0016$8\r[%oG2,H-Z:BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u000b\u0003\u0002D\u0005}\u0001BBA&\u0001\u0011\u0005a0A\u0018uKN$h)\u001a;dQ\n+\u0017p\u001c8e\u0011&<\u0007nV1uKJl\u0017M]6SKR,(O\\#naRL(+Z:q_:\u001cX\r\u000b\u0003\u0002J\u0005}\u0001BBA)\u0001\u0011\u0005a0A\u0018uKN$h)\u001a;dQ6+7o]1hKN<\u0006.\u001a8O_R4u\u000e\u001c7po\u0016\u0014hi\u001c:P]\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0002P\u0005}\u0001BBA,\u0001\u0011\u0005a0\u0001\u001fuKN$()Z2p[\u00164u\u000e\u001c7po\u0016\u0014x\u000b[3o\u0019\u0016\fG-\u001a:JgVs7\r[1oO\u0016$')\u001e;NSN\u001cX\r\u001a'fC\u0012,'/\u00169eCR,\u0007\u0006BA+\u0003?Aq!!\u0018\u0001\t\u0013\ty&\u0001\u0012qe\u0016\u0004\u0018M]3SKBd\u0017nY1NC:\fw-\u001a:B]\u0012dunZ'b]\u0006<WM\u001d\u000b\u000f\u0003C\nI(! \u0002\u0002\u0006\u0015\u0015\u0011RAO!\u001dI\u00111MA4\u0003[J1!!\u001a\u000b\u0005\u0019!V\u000f\u001d7feA\u0019!#!\u001b\n\u0007\u0005-$A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d\u0005\u0003\rawnZ\u0005\u0005\u0003o\n\tH\u0001\u0006M_\u001el\u0015M\\1hKJDq!a\u001f\u0002\\\u0001\u00071-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005}\u00141\fa\u0001G\u0006IB.Z1eKJ,\u0005o\\2i\u0013:dU-\u00193fe\u0006sG-S:s\u0011\u001d\t\u0019)a\u0017A\u0002\r\f\u0001CZ8mY><XM\u001d\"s_.,'/\u00133\t\u000f\u0005\u001d\u00151\fa\u0001G\u0006qA.Z1eKJ\u0014%o\\6fe&#\u0007\u0002CAF\u00037\u0002\r!!$\u0002\u001d\r|WO\u001c;E_^tG*\u0019;dQB!\u0011qRAM\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015AC2p]\u000e,(O]3oi*\u0019\u0011q\u0013\u000e\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\u000b\tJ\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u0011\u0005}\u00151\fa\u0001\u0003C\u000b\u0001#\u001a=qK\u000e$HK];oG\u0006$\u0018n\u001c8\u0011\u0007%\t\u0019+C\u0002\u0002&*\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002*\u0002!I!a+\u000251,\u0017\rZ3s\u0003:$\u0017j\u001d:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0011\u00055\u0016\u0011YAc\u0003\u000f\u0004B!a,\u0002<:!\u0011\u0011WA\\\u001b\t\t\u0019LC\u0002\u00026F\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003s\u000b\u0019,A\nMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH/\u0003\u0003\u0002>\u0006}&A\u0004)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003s\u000b\u0019\fC\u0004\u0002D\u0006\u001d\u0006\u0019A2\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0003\u000f\u000b9\u000b1\u0001d\u0011!\tI-a*A\u0002\u0005-\u0017AD1mSZ,'I]8lKJLEm\u001d\t\u0007\u0003\u001b\fi.a9\u000f\t\u0005=\u0017\u0011\u001c\b\u0005\u0003#\f9.\u0004\u0002\u0002T*\u0019\u0011Q\u001b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011bAAn\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002BAp\u0003C\u00141aU3r\u0015\r\tYN\u0003\t\u0004/\u0005\u0015\u0018bAAt1\t9\u0011J\u001c;fO\u0016\u0014hABAv\u0001\u0011\tiO\u0001\bDC2d'-Y2l%\u0016\u001cX\u000f\u001c;\u0016\t\u0005=\u0018Q`\n\u0004\u0003SD\u0001bB\b\u0002j\u0012\u0005\u00111\u001f\u000b\u0003\u0003k\u0004b!a>\u0002j\u0006eX\"\u0001\u0001\u0011\t\u0005m\u0018Q \u0007\u0001\t!\ty0!;C\u0002\t\u0005!!\u0001+\u0012\t\t\r!\u0011\u0002\t\u0004\u0013\t\u0015\u0011b\u0001B\u0004\u0015\t9aj\u001c;iS:<\u0007cA\u0005\u0003\f%\u0019!Q\u0002\u0006\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0003\u0012\u0005%\b\u0019!C\u0005\u0005'\tQA^1mk\u0016,\"A!\u0006\u0011\u000b%\u00119\"!?\n\u0007\te!B\u0001\u0004PaRLwN\u001c\u0005\u000b\u0005;\tI\u000f1A\u0005\n\t}\u0011!\u0003<bYV,w\fJ3r)\rQ%\u0011\u0005\u0005\n\u001d\nm\u0011\u0011!a\u0001\u0005+A\u0011B!\n\u0002j\u0002\u0006KA!\u0006\u0002\rY\fG.^3!\u0011)\u0011I#!;A\u0002\u0013%!1F\u0001\u0004MVtWC\u0001B\u0017!\u0015I!q\u0003B\u0018!\u0019I!\u0011GA}\u0015&\u0019!1\u0007\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0003B\u001c\u0003S\u0004\r\u0011\"\u0003\u0003:\u00059a-\u001e8`I\u0015\fHc\u0001&\u0003<!IaJ!\u000e\u0002\u0002\u0003\u0007!Q\u0006\u0005\n\u0005\u007f\tI\u000f)Q\u0005\u0005[\tAAZ;oA!A!1IAu\t\u0003\u0011)%A\u0006bgN,'\u000f\u001e$je\u0016$WCAA}\u0011!\u0011I%!;\u0005\u0002\t-\u0013aB5t\r&\u0014X\rZ\u000b\u0003\u0003CC\u0001Ba\u0014\u0002j\u0012\u0005!\u0011K\u0001\u0005M&\u0014X\rF\u0002K\u0005'B\u0001B!\u0005\u0003N\u0001\u0007\u0011\u0011 \u0005\t\u0005/\nI\u000f\"\u0001\u0003Z\u00051qN\u001c$je\u0016$B!!>\u0003\\!A!\u0011\u0006B+\u0001\u0004\u0011y\u0003C\u0004\u0003`\u0001!IA!\u0019\u0002\u001b\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)1\u0011\u0019Ga\"\u0003\f\n]%q\u0015BV!\u0019\t90!;\u0003fA!!q\rBA\u001d\u0011\u0011IG! \u000f\t\t-$1\u0010\b\u0005\u0005[\u0012IH\u0004\u0003\u0003p\t]d\u0002\u0002B9\u0005krA!!5\u0003t%\tq'\u0003\u00026m%\u0011Q\u0001N\u0005\u0003eMJ1!!.2\u0013\u0011\u0011y(a-\u0002\u001fA\u0013x\u000eZ;dKJ+7\u000f]8og\u0016LAAa!\u0003\u0006\n\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\t}\u00141\u0017\u0005\t\u0005\u0013\u0013i\u00061\u0001\u0002h\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0002\u0003BG\u0005;\u0002\rAa$\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003\u0002BI\u0005'k\u0011!M\u0005\u0004\u0005+\u000b$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u00053\u0013i\u00061\u0001\u0003\u001c\u00069!/Z2pe\u0012\u001c\b\u0003\u0002BO\u0005Gk!Aa(\u000b\u0007\t\u0005\u0016'\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005K\u0013yJA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u000b\u0005S\u0013i\u0006%AA\u0002\u0005\u0005\u0016\u0001D5t\rJ|Wn\u00117jK:$\bB\u0003BW\u0005;\u0002\n\u00111\u0001\u00030\u0006a!/Z9vSJ,G-Q2lgB\u0019\u0011B!-\n\u0007\tM&BA\u0003TQ>\u0014H\u000fC\u0004\u00038\u0002!IA!/\u0002\u001f\u0019,Go\u00195Bg\u000e{gn];nKJ$BBa/\u0003D\n\u0015'q\u0019Bm\u0005;\u0004b!a>\u0002j\nu\u0006c\u0001\n\u0003@&\u0019!\u0011\u0019\u0002\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\t\u0005\u0013\u0013)\f1\u0001\u0002h!A!Q\u0012B[\u0001\u0004\u0011y\t\u0003\u0005\u0003J\nU\u0006\u0019\u0001Bf\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!Q\u001aBj\u001d\u0011\u0011IGa4\n\t\tE\u00171W\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0005+\u00149NA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0005#\f\u0019\fC\u0005\u0003\\\nU\u0006\u0013!a\u0001G\u0006AQ.\u001b8CsR,7\u000f\u0003\u0006\u0003`\nU\u0006\u0013!a\u0001\u0005C\fa\"[:pY\u0006$\u0018n\u001c8MKZ,G\u000e\u0005\u0003\u00022\n\r\u0018\u0002\u0002Bs\u0003g\u0013a\"S:pY\u0006$\u0018n\u001c8MKZ,G\u000eC\u0004\u0003j\u0002!IAa;\u0002\u001f\u0019,Go\u00195Bg\u001a{G\u000e\\8xKJ$BBa/\u0003n\n=(\u0011\u001fBz\u0005kD\u0001B!#\u0003h\u0002\u0007\u0011q\r\u0005\t\u0005\u001b\u00139\u000f1\u0001\u0003\u0010\"A!\u0011\u001aBt\u0001\u0004\u0011Y\rC\u0005\u0003\\\n\u001d\b\u0013!a\u0001G\"Q!q\u001cBt!\u0003\u0005\rA!9\t\u000f\te\b\u0001\"\u0003\u0003|\u0006ia-\u001a;dQ6+7o]1hKN$bBa/\u0003~\n}81AB\u0003\u0007\u000f\u0019I\u0001\u0003\u0005\u0003\n\n]\b\u0019AA4\u0011\u001d\u0019\tAa>A\u0002\r\f\u0011B]3qY&\u001c\u0017-\u00133\t\u0011\t5%q\u001fa\u0001\u0005\u001fC\u0001B!3\u0003x\u0002\u0007!1\u001a\u0005\b\u00057\u00149\u00101\u0001d\u0011!\u0011yNa>A\u0002\t\u0005\bbBB\u0007\u0001\u0011%1qB\u0001)g\u0016$X\u000f\u001d*fa2L7-Y'b]\u0006<WM],ji\"lunY6fIB+(oZ1u_JLWm\u001d\u000b\u0007\u0003O\u001a\tba\b\t\u0011\rM11\u0002a\u0001\u0007+\tQ\u0001^5nKJ\u0004Baa\u0006\u0004\u001c5\u00111\u0011\u0004\u0006\u0004\u0007')\u0013\u0002BB\u000f\u00073\u0011\u0011\"T8dWRKW.\u001a:\t\u0015\u0005%71\u0002I\u0001\u0002\u0004\u0019\t\u0003E\u0003\u0002N\u0006u7\rC\u0005\u0004&\u0001\t\n\u0011\"\u0003\u0004(\u00059\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007SQC!!)\u0004,-\u00121Q\u0006\t\u0005\u0007_\u0019I$\u0004\u0002\u00042)!11GB\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00048)\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Yd!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004@\u0001\t\n\u0011\"\u0003\u0004B\u00059\u0012\r\u001d9f]\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007\u0007RCAa,\u0004,!I1q\t\u0001\u0012\u0002\u0013%1\u0011J\u0001\u001aM\u0016$8\r[!t\u0007>t7/^7fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004L)\u001a1ma\u000b\t\u0013\r=\u0003!%A\u0005\n\rE\u0013!\u00074fi\u000eD\u0017i]\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIU*\"aa\u0015+\t\t\u000581\u0006\u0005\n\u0007/\u0002\u0011\u0013!C\u0005\u00073\n!g]3ukB\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5N_\u000e\\W\r\u001a)ve\u001e\fGo\u001c:jKN$C-\u001a4bk2$HEM\u000b\u0003\u00077RCa!\t\u0004,!I1q\f\u0001\u0012\u0002\u0013%1\u0011J\u0001\u001aM\u0016$8\r[!t\r>dGn\\<fe\u0012\"WMZ1vYR$C\u0007C\u0005\u0004d\u0001\t\n\u0011\"\u0003\u0004R\u0005Ib-\u001a;dQ\u0006\u001bhi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0001")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private KafkaZkClient kafkaZkClient;
    private final int zkVersion;
    private final int correlationId;
    private int controllerEpoch = 0;
    private final long brokerEpoch;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
        EasyMock.expect((Object)this.zkClient().readData(EasyMock.anyString(), (Stat)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$5, Iterable<Partition> x$6) {
                }
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.kafka$server$ReplicaManagerTest$$appendRecords(rm, new TopicPartition(this.topic(), 0), records2, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
                }
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty()), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 1, 1, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$7, Iterable<Partition> x$8) {
                }
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$9, Iterable<Partition> x$10) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$1;
                private final long producerId$1;
                private final short epoch$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$1 = replicaManager$1;
                    this.producerId$1 = producerId$1;
                    this.epoch$1 = epoch$1;
                }
            });
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfRangeSequence)})).getBytes())});
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
                    Assert.assertEquals((long)0L, (long)response.logStartOffset);
                }
            });
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$11, Iterable<Partition> x$12) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$2;
                private final long producerId$2;
                private final short epoch$2;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$2, (short)this.epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$2, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$2 = replicaManager$2;
                    this.producerId$2 = producerId$2;
                    this.epoch$2 = epoch$2;
                }
            });
            ReplicaManager x$24 = replicaManager;
            TopicPartition x$25 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$26 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000, Optional.empty());
            IsolationLevel x$27 = IsolationLevel.READ_UNCOMMITTED;
            int x$28 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$24, x$25, x$26, x$28, x$27);
            ReplicaManager x$29 = replicaManager;
            TopicPartition x$30 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$31 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$32 = IsolationLevel.READ_COMMITTED;
            int x$33 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$29, x$30, x$31, x$33, x$32);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$34 = replicaManager;
            TopicPartition x$35 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$36 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$37 = IsolationLevel.READ_COMMITTED;
            int x$38 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$34, x$35, x$36, x$38, x$37);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer2.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false, this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$39 = replicaManager;
            TopicPartition x$40 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$41 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$42 = IsolationLevel.READ_COMMITTED;
            int x$43 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$39, x$40, x$41, x$43, x$42);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$44 = replicaManager;
            TopicPartition x$45 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$46 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$47 = IsolationLevel.READ_UNCOMMITTED;
            int x$48 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$44, x$45, x$46, x$48, x$47);
            ReplicaManager x$49 = replicaManager;
            TopicPartition x$50 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$51 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$52 = IsolationLevel.READ_COMMITTED;
            int x$53 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$49, x$50, x$51, x$53, x$52);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer2 = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer2, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$13, Iterable<Partition> x$14) {
                }
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1)new Serializable(this, replicaManager, producerId, epoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$3;
                private final long producerId$3;
                private final short epoch$3;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int sequence) {
                    MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$3, (short)this.epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$3, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$3 = replicaManager$3;
                    this.producerId$3 = producerId$3;
                    this.epoch$3 = epoch$3;
                }
            });
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.kafka$server$ReplicaManagerTest$$appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false, this.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ProduceResponse.PartitionResponse response) {
                    Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                }
            });
            ReplicaManager x$54 = replicaManager;
            TopicPartition x$55 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$56 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$57 = IsolationLevel.READ_UNCOMMITTED;
            int x$58 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$54, x$55, x$56, x$58, x$57);
            ReplicaManager x$59 = replicaManager;
            TopicPartition x$60 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$61 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$62 = IsolationLevel.READ_COMMITTED;
            int x$63 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$59, x$60, x$61, x$63, x$62);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer2.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$15, Iterable<Partition> x$16) {
                }
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, rm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager rm$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.rm$1, new TopicPartition(this.$outer.topic(), 0), records2, this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.rm$1 = rm$1;
                }
            });
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            Partition qual$1 = replicaManager.getOrCreatePartition(tp0);
            int x$64 = 0;
            boolean x$65 = qual$1.getOrCreateReplica$default$2();
            qual$1.getOrCreateReplica(x$64, x$65);
            Partition qual$2 = replicaManager.getOrCreatePartition(tp1);
            int x$66 = 0;
            boolean x$67 = qual$2.getOrCreateReplica$default$2();
            qual$2.getOrCreateReplica(x$66, x$67);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition0Replicas, 0, partition0Replicas, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition1Replicas, 0, partition1Replicas, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$17, Iterable<Partition> x$18) {
                }
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)new Serializable(this, replicaManager, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager replicaManager$4;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final CallbackResult<ProduceResponse.PartitionResponse> apply(int i) {
                    this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp0$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                    return this.$outer.kafka$server$ReplicaManagerTest$$appendRecords(this.replicaManager$4, this.tp1$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$4(), this.$outer.kafka$server$ReplicaManagerTest$$appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ProduceResponse.PartitionResponse response) {
                            Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.replicaManager$4 = replicaManager$4;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            });
            long x$68 = 1000L;
            int x$69 = 1;
            int x$70 = 0;
            int x$71 = Integer.MAX_VALUE;
            boolean x$72 = false;
            Seq x$73 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()))}));
            Serializable x$74 = new Serializable(this, tp0, tp1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final TopicPartition tp0$1;
                private final TopicPartition tp1$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$1(responseStatus, this.tp0$1, this.tp1$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tp0$1 = tp0$1;
                    this.tp1$1 = tp1$1;
                }
            };
            IsolationLevel x$75 = IsolationLevel.READ_UNCOMMITTED;
            ReplicaQuota x$76 = replicaManager.fetchMessages$default$7();
            replicaManager.fetchMessages(x$68, x$69, x$70, x$71, x$72, x$73, x$76, (Function1)x$74, x$75);
            Option tp0Replica = replicaManager.localReplica(tp0);
            Assert.assertTrue((boolean)tp0Replica.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Replica)tp0Replica.get()).highWatermark().messageOffset());
            replicaManager.localReplica(tp1);
            Option tp1Replica = replicaManager.localReplica(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Replica)tp1Replica.get()).highWatermark().messageOffset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown(false);
            throw throwable;
        }
        replicaManager.shutdown(false);
    }

    @Test
    public void testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
            LogManager mockLogMgr = (LogManager)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)replicaManager, (Object)mockLogMgr);
            ReplicaManager replicaManager2 = (ReplicaManager)tuple23._1();
            LogManager mockLogMgr2 = (LogManager)tuple23._2();
            Partition partition = replicaManager2.getOrCreatePartition(new TopicPartition(this.topic(), topicPartition));
            partition.getOrCreateReplica(followerBrokerId, partition.getOrCreateReplica$default$2());
            partition.makeFollower(controllerId, this.leaderAndIsrPartitionState(leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId());
            LeaderAndIsrRequest leaderAndIsrRequest0 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)this.leaderAndIsrPartitionState(leaderEpoch += leaderEpochIncrement, leaderBrokerId, (Seq<Integer>)aliveBrokerIds))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(followerBrokerId, "host1", 0), new Node(leaderBrokerId, "host2", 1)}))).asJava()).build();
            replicaManager2.becomeLeaderOrFollower(this.correlationId(), leaderAndIsrRequest0, (Function2)new Serializable(this, followerBrokerId){
                public static final long serialVersionUID = 0L;
                private final int followerBrokerId$1;

                public final void apply(Iterable<Partition> x$20, Iterable<Partition> followers) {
                    Assert.assertEquals((long)this.followerBrokerId$1, (long)((Partition)followers.head()).partitionId());
                }
                {
                    this.followerBrokerId$1 = followerBrokerId$1;
                }
            });
            Assert.assertTrue((boolean)countDownLatch.await(1000L, TimeUnit.MILLISECONDS));
            EasyMock.verify((Object[])new Object[]{mockLogMgr2});
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<ReplicaManager, LogManager> prepareReplicaManagerAndLogManager(int topicPartition, int leaderEpochInLeaderAndIsr, int followerBrokerId, int leaderBrokerId, CountDownLatch countDownLatch, boolean expectTruncation) {
        BoxedUnit boxedUnit;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        int localLogOffset = 10;
        int offsetFromLeader = 5;
        int leaderEpochFromLeader = 3;
        MockScheduler mockScheduler = new MockScheduler((Time)this.time());
        BrokerTopicStats mockBrokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel mockLogDirFailureChannel = new LogDirFailureChannel(config.logDirs().size());
        Log mockLog = new Log(this, topicPartition, config, localLogOffset, leaderEpochFromLeader, mockScheduler, mockBrokerTopicStats, mockLogDirFailureChannel){
            private final int localLogOffset$1;
            private final int leaderEpochFromLeader$1;

            public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
                Assert.assertEquals((long)leaderEpoch, (long)this.leaderEpochFromLeader$1);
                return new Some((Object)new OffsetAndEpoch((long)this.localLogOffset$1, this.leaderEpochFromLeader$1));
            }

            public Option<Object> latestEpoch() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)this.leaderEpochFromLeader$1));
            }

            public LogOffsetMetadata logEndOffsetMetadata() {
                return new LogOffsetMetadata((long)this.localLogOffset$1, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
            }
            {
                this.localLogOffset$1 = localLogOffset$1;
                this.leaderEpochFromLeader$1 = leaderEpochFromLeader$1;
                super(new File(new File((String)config$1.logDirs().head()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.topic()}))), LogConfig$.MODULE$.apply(), 0L, 0L, (Scheduler)mockScheduler$1, mockBrokerTopicStats$1, (Time)$outer.time(), 30000, 30000, new TopicPartition($outer.topic(), topicPartition$1), new ProducerStateManager(new TopicPartition($outer.topic(), topicPartition$1), new File(new File((String)config$1.logDirs().head()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.topic(), BoxesRunTime.boxToInteger((int)topicPartition$1)}))), 30000), mockLogDirFailureChannel$1);
            }
        };
        LogManager mockLogMgr = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)mockLogMgr.liveLogDirs()).andReturn(config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$21) {
                return new File(x$21).getAbsoluteFile();
            }
        }, Seq$.MODULE$.canBuildFrom())).anyTimes();
        EasyMock.expect((Object)mockLogMgr.currentDefaultConfig()).andReturn((Object)LogConfig$.MODULE$.apply());
        EasyMock.expect((Object)mockLogMgr.getOrCreateLog(new TopicPartition(this.topic(), topicPartition), LogConfig$.MODULE$.apply(), false, false)).andReturn((Object)mockLog).anyTimes();
        if (expectTruncation) {
            mockLogMgr.truncateTo((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)BoxesRunTime.boxToLong((long)offsetFromLeader))})), false);
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).once();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{mockLogMgr});
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Integer brokerId) {
                return TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokerId})), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$1;

            public final IExpectationSetters<Object> apply(Integer brokerId) {
                return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache$1.isBrokerAlive(BoxesRunTime.unboxToInt((Object)EasyMock.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId))))))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
            }
            {
                this.metadataCache$1 = metadataCache$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{metadataCache});
        MockTimer timer2 = new MockTimer();
        String x$77 = "Produce";
        MockTimer x$78 = timer2;
        boolean x$79 = false;
        int x$80 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$81 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$82 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$77, (Timer)x$78, x$80, x$81, x$79, x$82);
        String x$83 = "Fetch";
        MockTimer x$84 = timer2;
        boolean x$85 = false;
        int x$86 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$87 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$88 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$83, (Timer)x$84, x$86, x$87, x$85, x$88);
        String x$89 = "DeleteRecords";
        MockTimer x$90 = timer2;
        boolean x$91 = false;
        int x$92 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$93 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$94 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$89, (Timer)x$90, x$92, x$93, x$91, x$94);
        String x$95 = "ElectPreferredLeader";
        MockTimer x$96 = timer2;
        boolean x$97 = false;
        int x$98 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$99 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$100 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockElectPreferredLeaderPurgatory = new DelayedOperationPurgatory(x$95, (Timer)x$96, x$98, x$99, x$97, x$100);
        QuotaFactory.QuotaManagers quota = QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "");
        ReplicaFetcherMockBlockingSend blockingSend = new ReplicaFetcherMockBlockingSend((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)new EpochEndOffset(leaderEpochFromLeader, (long)offsetFromLeader))}))).asJava(), new BrokerEndPoint(1, "host1", 1), (Time)this.time());
        ReplicaManager replicaManager = new ReplicaManager(this, topicPartition, leaderEpochInLeaderAndIsr, countDownLatch, config, mockScheduler, mockBrokerTopicStats, mockLogDirFailureChannel, mockLogMgr, metadataCache, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockElectPreferredLeaderPurgatory, quota, blockingSend){
            private final /* synthetic */ ReplicaManagerTest $outer;
            public final int topicPartition$1;
            public final int leaderEpochInLeaderAndIsr$1;
            public final CountDownLatch countDownLatch$1;
            public final QuotaFactory.QuotaManagers quota$1;
            public final ReplicaFetcherMockBlockingSend blockingSend$1;

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return new ReplicaFetcherManager(this, metrics, time, threadNamePrefix, quotaManager){
                    private final /* synthetic */ $anon$4 $outer;
                    public final Metrics metrics$1;
                    public final Time time$1;

                    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                        return new ReplicaFetcherThread(this, fetcherId, sourceBroker){
                            private final /* synthetic */ $anon$4$$anon$2 $outer;

                            public void doWork() {
                                OffsetAndEpoch initialOffset = new OffsetAndEpoch(0L, this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().leaderEpochInLeaderAndIsr$1);
                                this.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().kafka$server$ReplicaManagerTest$$anon$$$outer().topic(), this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().topicPartition$1)), (Object)initialOffset)})));
                                super.doWork();
                                this.initiateShutdown();
                                this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().countDownLatch$1.countDown();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ReplicaFetcherThread-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId$1)})), fetcherId$1, sourceBroker$1, $outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().config(), $outer.failedPartitions(), $outer.replicaManager(), $outer.metrics$1, $outer.time$1, (ReplicaQuota)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().quota$1.follower(), (Option)new Some((Object)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().blockingSend$1));
                            }
                        };
                    }

                    public /* synthetic */ $anon$4 kafka$server$ReplicaManagerTest$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metrics$1 = metrics$1;
                        this.time$1 = time$1;
                        super($outer.config(), (ReplicaManager)$outer, metrics$1, time$1, threadNamePrefix$1, quotaManager$1);
                    }
                };
            }

            public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.leaderEpochInLeaderAndIsr$1 = leaderEpochInLeaderAndIsr$1;
                this.countDownLatch$1 = countDownLatch$1;
                this.quota$1 = quota$1;
                this.blockingSend$1 = blockingSend$1;
                super(config$1, $outer.metrics(), (Time)$outer.time(), $outer.kafkaZkClient(), (Scheduler)mockScheduler$1, mockLogMgr$1, new AtomicBoolean(false), quota$1, mockBrokerTopicStats$1, metadataCache$1, mockLogDirFailureChannel$1, mockProducePurgatory$1, mockFetchPurgatory$1, mockDeleteRecordsPurgatory$1, mockElectPreferredLeaderPurgatory$1, Option$.MODULE$.apply((Object)$outer.getClass().getName()));
            }
        };
        return new Tuple2((Object)replicaManager, (Object)mockLogMgr);
    }

    private LeaderAndIsrRequest.PartitionState leaderAndIsrPartitionState(int leaderEpoch, int leaderBrokerId, Seq<Integer> aliveBrokerIds) {
        return new LeaderAndIsrRequest.PartitionState(this.controllerEpoch(), leaderBrokerId, leaderEpoch, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava(), this.zkVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava(), false);
    }

    public CallbackResult<ProduceResponse.PartitionResponse> kafka$server$ReplicaManagerTest$$appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records2, boolean isFromClient, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records2)})), (Function1)new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$1;
            private final CallbackResult result$1;

            public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responses) {
                this.$outer.kafka$server$ReplicaManagerTest$$appendCallback$1(responses, this.partition$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.result$1 = result$1;
            }
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    public boolean kafka$server$ReplicaManagerTest$$appendRecords$default$4() {
        return true;
    }

    public short kafka$server$ReplicaManagerTest$$appendRecords$default$5() {
        return -1;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$101 = 1000L;
        int x$102 = replicaId;
        int x$103 = minBytes;
        int x$104 = Integer.MAX_VALUE;
        boolean x$105 = false;
        Seq x$106 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Serializable x$107 = new Serializable(this, partition, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerTest $outer;
            private final TopicPartition partition$2;
            private final CallbackResult result$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.partition$2, this.result$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
                this.result$2 = result$2;
            }
        };
        IsolationLevel x$108 = isolationLevel;
        ReplicaQuota x$109 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$101, x$102, x$103, x$104, x$105, x$106, x$109, (Function1)x$107, x$108);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer2, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$23) {
                return new File(x$23);
            }
        }, Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int brokerId) {
                return TestUtils$.MODULE$.createBroker(brokerId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId)})), brokerId, TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1)new Serializable(this, metadataCache){
            public static final long serialVersionUID = 0L;
            private final MetadataCache metadataCache$2;

            public final IExpectationSetters<Object> apply(int brokerId) {
                return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache$2.isBrokerAlive(EasyMock.eq((int)brokerId)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
            }
            {
                this.metadataCache$2 = metadataCache$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$110 = "Produce";
        MockTimer x$111 = timer2;
        boolean x$112 = false;
        int x$113 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$114 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$115 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$110, (Timer)x$111, x$113, x$114, x$112, x$115);
        String x$116 = "Fetch";
        MockTimer x$117 = timer2;
        boolean x$118 = false;
        int x$119 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$120 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$121 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$116, (Timer)x$117, x$119, x$120, x$118, x$121);
        String x$122 = "DeleteRecords";
        MockTimer x$123 = timer2;
        boolean x$124 = false;
        int x$125 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$126 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$127 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$122, (Timer)x$123, x$125, x$126, x$124, x$127);
        String x$128 = "DelayedElectPreferredLeader";
        MockTimer x$129 = timer2;
        boolean x$130 = false;
        int x$131 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$132 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$133 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDelayedElectPreferredLeaderPurgatory = new DelayedOperationPurgatory(x$128, (Timer)x$129, x$131, x$132, x$130, x$133);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockDelayedElectPreferredLeaderPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public final void kafka$server$ReplicaManagerTest$$appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 != null) {
            Tuple2 tuple22;
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
            Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
            result$2.fire(fetchData2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
        this.zkVersion = 0;
        this.correlationId = 0;
        this.brokerEpoch = 0L;
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final Object value$1;

                public final void apply(Function1<T, BoxedUnit> f) {
                    f.apply(this.value$1);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.isFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

