/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\bCA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003\r\t\u0007/[\u0005\u0003#9\u0011\u0011bU1tYN+G/\u001e9\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002CA\u0005\u0001\u0011\u00159\u0002\u0001\"\u0015\u0019\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001\u001a!\tQb%D\u0001\u001c\u0015\taR$\u0001\u0003bkRD'B\u0001\u0010 \u0003!\u0019XmY;sSRL(B\u0001\u0011\"\u0003\u0019\u0019w.\\7p]*\u0011QA\t\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(7\t\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0003aY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\\\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw\r\u0003\u00045\u0001\u0001\u0006IaK\u0001\u001aW\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNl\u0007\u0005C\u00047\u0001\t\u0007I\u0011B\u001c\u00023-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn]\u000b\u0002qA\u0019\u0011\bQ\u0016\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u000f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004D\u0001\u0001\u0006I\u0001O\u0001\u001bW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0015G\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\tq\tE\u0002I\u0013.k\u0011AP\u0005\u0003\u0015z\u0012AaU8nKB\u0011AjT\u0007\u0002\u001b*\u0011ajL\u0001\u0005kRLG.\u0003\u0002Q\u001b\nQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0003\u0001\u0015!\u0003H\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002Bq\u0001\u0016\u0001C\u0002\u0013Ec)\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0005\u0007-\u0002\u0001\u000b\u0011B$\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA!)\u0001\f\u0001C!3\u0006Y!M]8lKJ\u001cu.\u001e8u+\u0005Q\u0006C\u0001%\\\u0013\tafHA\u0002J]RDQA\u0018\u0001\u0005B}\u000bQa]3u+B$\u0012\u0001\u0019\t\u0003\u0011\u0006L!A\u0019 \u0003\tUs\u0017\u000e\u001e\u0015\u0003;\u0012\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0013\u0002\u000b),h.\u001b;\n\u0005%4'A\u0002\"fM>\u0014X\rC\u0003l\u0001\u0011\u0005s,\u0001\u0005uK\u0006\u0014Hi\\<oQ\tQW\u000e\u0005\u0002f]&\u0011qN\u001a\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006c\u0002!\taX\u00011i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\n+gm\u001c:f'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;)\u0005A\u001c\bCA3u\u0013\t)hM\u0001\u0003UKN$\b\"B<\u0001\t\u0003y\u0016a\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;BMR,'oU1tY\"\u000bg\u000eZ:iC.,'+Z9vKN$\bF\u0001<t\u0011\u0015Q\b\u0001\"\u0001`\u00031\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$x+\u001b;i+:\u001cX\u000f\u001d9peR,GMV3sg&|g\u000e\u000b\u0002zg\")Q\u0010\u0001C\u0005}\u000612/\u001a8e\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fF\u0004\u0000\u0003\u0017\tY\"!\n\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002 \u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0005\u0003\u0007\u00111#\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016Dq!!\u0004}\u0001\u0004\ty!\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u0018\u0002\u00079,G/\u0003\u0003\u0002\u001a\u0005M!AB*pG.,G\u000fC\u0004\u0002\u001eq\u0004\r!a\b\u0002\u000fI,\u0017/^3tiB!\u0011\u0011AA\u0011\u0013\u0011\t\u0019#a\u0001\u0003%\u0005\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u0005\n\u0003Oa\b\u0013!a\u0001\u0003S\t!\"\u00199j-\u0016\u00148/[8o!\u0015A\u00151FA\u0018\u0013\r\tiC\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007!\u000b\t$C\u0002\u00024y\u0012Qa\u00155peRDq!a\u000e\u0001\t\u0013\tI$\u0001\u0015tK:$7+Y:m\u0011\u0006tGm\u001d5bW\u0016\u0014V-];fgR4\u0016\r\\5eCR,'+Z:q_:\u001cX\rF\u0002a\u0003wA\u0001\"!\u0004\u00026\u0001\u0007\u0011q\u0002\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0005\u0003\u0003\n\u0001e]3oI\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\t\u0016\u0005\u0003S\t)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\tFP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup$class.initializeKerberos(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism, serviceName);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup$class.jaasClientLoginModule$default$2(this);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$2, x$1);
        try {
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$3 = this.securityProtocol();
        SocketServer x$4 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$4, x$3);
        try {
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            ApiVersionsResponse response = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            Assert.assertEquals((Object)Errors.ILLEGAL_SASL_STATE, (Object)response.error());
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$5 = this.securityProtocol();
        SocketServer x$6 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$6, x$5);
        try {
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(0);
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)apiVersionsResponse.error());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request, Option<Object> apiVersion) {
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.API_VERSIONS, socket, apiVersion);
        return ApiVersionsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<Object> sendApiVersionsRequest$default$3() {
        return None$.MODULE$;
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest(new SaslHandshakeRequestData().setMechanism("PLAIN"));
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.SASL_HANDSHAKE, socket, this.sendAndReceive$default$4());
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)response, (short)request.version());
        Assert.assertEquals((Object)Errors.NONE, (Object)handshakeResponse.error());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup$class.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAIN"}));
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

