/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.tools.DumpLogSegmentsTest$$anonfun$kafka$tools$DumpLogSegmentsTest$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u00111\u0003R;na2{wmU3h[\u0016tGo\u001d+fgRT!a\u0001\u0003\u0002\u000bQ|w\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u00051A/\u001c9ESJ,\u0012A\u0006\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t!![8\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0005\r&dW\r\u0003\u0004 \u0001\u0001\u0006IAF\u0001\bi6\u0004H)\u001b:!\u0011\u001d\t\u0003A1A\u0005\u0002U\ta\u0001\\8h\t&\u0014\bBB\u0012\u0001A\u0003%a#A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f\u0015\u0002!\u0019!C\u0001M\u0005Y1/Z4nK:$h*Y7f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001b\u0003\u0011a\u0017M\\4\n\u00051J#AB*ue&tw\r\u0003\u0004/\u0001\u0001\u0006IaJ\u0001\rg\u0016<W.\u001a8u\u001d\u0006lW\r\t\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0003-awn\u001a$jY\u0016\u0004\u0016\r\u001e5\u0016\u0003I\u0002\"a\r\u001c\u000f\u0005%!\u0014BA\u001b\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011Af\u000e\u0006\u0003k)Aa!\u000f\u0001!\u0002\u0013\u0011\u0014\u0001\u00047pO\u001aKG.\u001a)bi\"\u0004\u0003bB\u001e\u0001\u0005\u0004%\t!M\u0001\u000eS:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5\t\ru\u0002\u0001\u0015!\u00033\u00039Ig\u000eZ3y\r&dW\rU1uQ\u0002Bqa\u0010\u0001C\u0002\u0013\u0005\u0011'A\tuS6,\u0017J\u001c3fq\u001aKG.\u001a)bi\"Da!\u0011\u0001!\u0002\u0013\u0011\u0014A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002Bqa\u0011\u0001C\u0002\u0013\u0005A)\u0001\u0003uS6,W#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0011!B;uS2\u001c\u0018B\u0001&H\u0005!iunY6US6,\u0007B\u0002'\u0001A\u0003%Q)A\u0003uS6,\u0007\u0005C\u0004O\u0001\t\u0007I\u0011A(\u0002\u000f\t\fGo\u00195fgV\t\u0001\u000bE\u0002R-bk\u0011A\u0015\u0006\u0003'R\u000bq!\\;uC\ndWM\u0003\u0002V\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0013&aC!se\u0006L()\u001e4gKJ\u00042!W1e\u001d\tQvL\u0004\u0002\\=6\tAL\u0003\u0002^\r\u00051AH]8pizJ\u0011aC\u0005\u0003A*\tq\u0001]1dW\u0006<W-\u0003\u0002cG\n\u00191+Z9\u000b\u0005\u0001T\u0001CA3p\u001b\u00051'BA4i\u0003\u0019\u0011XmY8sI*\u0011\u0011N[\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015Y'B\u00017n\u0003\u0019\t\u0007/Y2iK*\ta.A\u0002pe\u001eL!\u0001\u001d4\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\t\rI\u0004\u0001\u0015!\u0003Q\u0003!\u0011\u0017\r^2iKN\u0004\u0003\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0001v\u0003\rawnZ\u000b\u0002mB\u0011q/_\u0007\u0002q*\u0011A\u000fB\u0005\u0003ub\u00141\u0001T8h\u0011%a\b\u00011AA\u0002\u0013\u0005Q0A\u0004m_\u001e|F%Z9\u0015\u0007y\f\u0019\u0001\u0005\u0002\n\u007f&\u0019\u0011\u0011\u0001\u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000bY\u0018\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005%\u0001\u0001)Q\u0005m\u0006!An\\4!\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\tQa]3u+B$\u0012A \u0015\u0005\u0003\u0017\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"\\\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003;\t9B\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003C\u0001A\u0011AA\b\u0003!!X-\u0019:E_^t\u0007\u0006BA\u0010\u0003K\u0001B!!\u0006\u0002(%!\u0011\u0011FA\f\u0005\u0015\te\r^3s\u0011\u001d\ti\u0003\u0001C\u0001\u0003\u001f\t\u0001\u0003^3tiB\u0013\u0018N\u001c;ECR\fGj\\4)\t\u0005-\u0012\u0011\u0007\t\u0005\u0003+\t\u0019$\u0003\u0003\u00026\u0005]!\u0001\u0002+fgRDq!!\u000f\u0001\t\u0003\ty!A\fuKN$H)^7q\u0013:$W\r_'jg6\fGo\u00195fg\"\"\u0011qGA\u0019\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u001f\tq\u0003^3ti\u0012+X\u000e\u001d+j[\u0016Le\u000eZ3y\u000bJ\u0014xN]:)\t\u0005u\u0012\u0011\u0007\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003I\u0011XO\u001c#v[BdunZ*fO6,g\u000e^:\u0015\u0007I\nI\u0005\u0003\u0005\u0002L\u0005\r\u0003\u0019AA'\u0003\u0011\t'oZ:\u0011\t%\tyEM\u0005\u0004\u0003#R!!B!se\u0006L\b")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir(), this.segmentName()}));
    private final String indexFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir(), this.segmentName()}));
    private final String timeIndexFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".timeindex"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir(), this.segmentName()}));
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<Seq<SimpleRecord>> batches = new ArrayBuffer();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<Seq<SimpleRecord>> batches() {
        return this.batches;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @Before
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        File x$2 = this.logDir();
        LogConfig x$3 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        long x$4 = 0L;
        long x$5 = 0L;
        MockScheduler x$6 = this.time().scheduler();
        MockTime x$7 = this.time();
        BrokerTopicStats x$8 = new BrokerTopicStats();
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        this.log_$eq(Log$.MODULE$.apply(x$2, x$3, x$4, x$5, (Scheduler)x$6, x$8, (Time)x$7, x$9, x$10, x$11));
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello there ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)firstBatchRecords);
        Log qual$1 = this.log();
        MemoryRecords x$12 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])firstBatchRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        int x$13 = 0;
        boolean x$14 = qual$1.appendAsLeader$default$3();
        ApiVersion x$15 = qual$1.appendAsLeader$default$4();
        qual$1.appendAsLeader(x$12, x$13, x$14, x$15);
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 3), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello there again ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)secondBatchRecords);
        Log qual$2 = this.log();
        MemoryRecords x$16 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])secondBatchRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        int x$17 = 0;
        boolean x$18 = qual$2.appendAsLeader$default$3();
        ApiVersion x$19 = qual$2.appendAsLeader$default$4();
        qual$2.appendAsLeader(x$16, x$17, x$18, x$19);
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 5), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello there one more time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)thirdBatchRecords);
        Log qual$3 = this.log();
        MemoryRecords x$20 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])thirdBatchRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        int x$21 = 0;
        boolean x$22 = qual$3.appendAsLeader$default$3();
        ApiVersion x$23 = qual$3.appendAsLeader$default$4();
        qual$3.appendAsLeader(x$20, x$21, x$22, x$23);
        this.log().flush();
    }

    @After
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)new Serializable(this, args){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DumpLogSegments$.MODULE$.main(this.args$1);
            }
            {
                this.args$1 = args$1;
            }
        });
        return outContent.toString();
    }

    public final boolean kafka$tools$DumpLogSegmentsTest$$isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, index, i, object){
                public static final long serialVersionUID = 0L;
                public final int index$1;
                public final IntRef i$1;
                public final Object nonLocalReturnKey1$1;

                public final void apply(Tuple2<Seq<SimpleRecord>, Object> x0$1) {
                    Tuple2<Seq<SimpleRecord>, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Seq batch = (Seq)tuple2._1();
                        if (this.i$1.elem == this.index$1) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                        ++this.i$1.elem;
                        batch.indices().foreach$mVc$sp((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$tools$DumpLogSegmentsTest$$isBatch$1$1 $outer;

                            public final void apply(int recordIndex) {
                                this.apply$mcVI$sp(recordIndex);
                            }

                            public void apply$mcVI$sp(int recordIndex) {
                                if (this.$outer.i$1.elem == this.$outer.index$1) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, false);
                                }
                                ++this.$outer.i$1.elem;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.index$1 = index$1;
                    this.i$1 = i$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No match for index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), new Position("DumpLogSegmentsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    private final void verifyRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data not printed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})), (lines.length > 2 ? 1 : 0) != 0);
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<SimpleRecord> x$1) {
                return x$1.size();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)new Serializable(this, lines, totalRecords, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DumpLogSegmentsTest $outer;
            private final String[] lines$1;
            private final int totalRecords$1;
            private final IntRef offset$1;

            public final void apply(int index) {
                this.apply$mcVI$sp(index);
            }

            public void apply$mcVI$sp(int index) {
                String line = this.lines$1[this.lines$1.length - this.totalRecords$1 - this.$outer.batches().size() + index];
                if (this.$outer.kafka$tools$DumpLogSegmentsTest$$isBatch$1(index)) {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid batch-level message record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baseOffset: ", " lastOffset: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.offset$1.elem)}))));
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid message record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DumpLogSegments$.MODULE$.RecordIndent(), BoxesRunTime.boxToInteger((int)this.offset$1.elem)}))));
                    ++this.offset$1.elem;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lines$1 = lines$1;
                this.totalRecords$1 = totalRecords$1;
                this.offset$1 = offset$1;
            }
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data should not have been printed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})), (boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"));
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

