/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u000f\tQR*\u001b:s_Jl\u0015m[3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u0015!\u0002\u0001\"\u0011\u0016\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001\f\u0011\u0007]\tCE\u0004\u0002\u0019=9\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0007yI|w\u000e\u001e \n\u0003u\tQa]2bY\u0006L!a\b\u0011\u0002\u000fA\f7m[1hK*\tQ$\u0003\u0002#G\t\u00191+Z9\u000b\u0005}\u0001\u0003CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011F\n\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003,\u0001\u0011\u0005A&\u0001\u0014uKN$8i\\7nSR|eMZ:fiN$\u0006N]8x)&lWm\\;u\u000bb\u001cW\r\u001d;j_:$\u0012!\f\t\u0003]=j\u0011\u0001I\u0005\u0003a\u0001\u0012A!\u00168ji\"\"!F\r\u001e<!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003kk:LGOC\u00018\u0003\ry'oZ\u0005\u0003sQ\u0012A\u0001V3ti\u0006AQ\r\u001f9fGR,GmI\u0001=!\tiT)D\u0001?\u0015\ty\u0004)\u0001\u0004feJ|'o\u001d\u0006\u0003\u0003\n\u000baaY8n[>t'BA\u0003D\u0015\t!e'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\rz\u0012\u0001\u0003V5nK>,H/\u0012=dKB$\u0018n\u001c8\t\u000b!\u0003A\u0011\u0001\u0017\u0002QQ,7\u000f^\"p[6LGo\u00144gg\u0016$8OU3n_Z,gj\u001c8Fq&\u001cH/\u001a8u)>\u0004\u0018nY:)\u0005\u001d\u0013\u0004\"B&\u0001\t\u0003a\u0013a\u0006;fgR\u001cu.\\7b'\u0016\u0004\u0018M]1uK\u0012\u0014VmZ3yQ\tQ%\u0007")
public class MirrorMakerIntegrationTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, new Properties());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test(expected=TimeoutException.class)
    public void testCommitOffsetsThrowTimeoutException() {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.brokerList());
        consumerProps.put("default.api.timeout.ms", "1");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("test", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        mirrorMakerConsumer.commit();
    }

    @Test
    public void testCommitOffsetsRemoveNonExistentTopics() {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.brokerList());
        consumerProps.put("default.api.timeout.ms", "2000");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic1", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic2", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        MirrorMaker$.MODULE$.commitOffsets(mirrorMakerConsumer);
        Assert.assertTrue((String)"Offsets for non-existent topics should be removed", (boolean)mirrorMakerConsumer.offsets().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCommaSeparatedRegex() {
        String topic = "new-topic";
        String msg = "a test message";
        String brokerList = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        MirrorMaker.MirrorMakerProducer producer = new MirrorMaker.MirrorMakerProducer(true, producerProps);
        MirrorMaker$.MODULE$.producer_$eq(producer);
        MirrorMaker$.MODULE$.producer().send(new ProducerRecord(topic, (Object)msg.getBytes()));
        MirrorMaker$.MODULE$.producer().close();
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", brokerList);
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"another_topic,new.*,foo"));
        mirrorMakerConsumer.init();
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, msg, mirrorMakerConsumer){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final String msg$1;
                private final MirrorMaker.ConsumerWrapper mirrorMakerConsumer$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean apply$mcZ$sp() {
                    try {
                        ConsumerRecord data = this.mirrorMakerConsumer$1.receive();
                        String string = data.topic();
                        String string2 = this.topic$1;
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        String string3 = new String((byte[])data.value());
                        String string4 = this.msg$1;
                        if (string3 == null) {
                            if (string4 == null) return true;
                            return false;
                        } else {
                            if (!string3.equals(string4)) return false;
                            return true;
                        }
                    }
                    catch (MirrorMaker.NoRecordsException noRecordsException) {
                        return false;
                    }
                }
                {
                    this.topic$1 = topic$1;
                    this.msg$1 = msg$1;
                    this.mirrorMakerConsumer$1 = mirrorMakerConsumer$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "MirrorMaker consumer should read the expected message from the expected topic within the timeout";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.close();
            throw throwable;
        }
        consumer.close();
    }
}

