/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.CoreUtilsTest;
import kafka.utils.CoreUtilsTest$;
import kafka.utils.CoreUtilsTest$$anonfun$testAtomicGetOrUpdate$1$;
import kafka.utils.CoreUtilsTest$TestException$4$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\ti1i\u001c:f+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005\u001daunZ4j]\u001eDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005=\u0001\u0001bB\f\u0001\u0005\u0004%\t\u0001G\u0001\u0011G2,8\u000f^3s\u0013\u0012\u0004\u0016\r\u001e;fe:,\u0012!\u0007\t\u00035\u0005j\u0011a\u0007\u0006\u00039u\tQA]3hKbT!AH\u0010\u0002\tU$\u0018\u000e\u001c\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u00113DA\u0004QCR$XM\u001d8\t\r\u0011\u0002\u0001\u0015!\u0003\u001a\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000e\t\u0005\u0006M\u0001!\taJ\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u0001)!\tI\u0011&\u0003\u0002+\u0015\t!QK\\5uQ\t)C\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005)!.\u001e8ji*\t\u0011'A\u0002pe\u001eL!a\r\u0018\u0003\tQ+7\u000f\u001e\u0005\u0006k\u0001!\taJ\u0001\u000bi\u0016\u001cH\u000f\u0016:z\u00032d\u0007F\u0001\u001b-\u0011\u0015A\u0004\u0001\"\u0001(\u0003Q!Xm\u001d;DSJ\u001cW\u000f\\1s\u0013R,'/\u0019;pe\"\u0012q\u0007\f\u0005\u0006w\u0001!\taJ\u0001\u000ei\u0016\u001cHOU3bI\nKH/Z:)\u0005ib\u0003\"\u0002 \u0001\t\u00039\u0013a\u0002;fgR\f%m\u001d\u0015\u0003{1BQ!\u0011\u0001\u0005\u0002\u001d\n\u0011\u0003^3tiJ+\u0007\u000f\\1dKN+hMZ5yQ\t\u0001E\u0006C\u0003E\u0001\u0011\u0005q%A\u0006uKN$(+Z1e\u0013:$\bFA\"-\u0011\u00159\u0005\u0001\"\u0001(\u0003-!Xm\u001d;DgZd\u0015n\u001d;)\u0005\u0019c\u0003\"\u0002&\u0001\t\u00039\u0013A\u0003;fgR\u001c5O^'ba\"\u0012\u0011\n\f\u0005\u0006\u001b\u0002!\taJ\u0001\u000bi\u0016\u001cH/\u00138M_\u000e\\\u0007F\u0001'-\u0011\u0015\u0001\u0006\u0001\"\u0001(\u0003m!Xm\u001d;Ve2\u001c\u0016MZ3CCN,g\u0007N#oG>$W-V+J\t\"\u0012q\n\f\u0005\u0006'\u0002!\taJ\u0001\u0019i\u0016\u001cHoR3oKJ\fG/Z+vS\u0012\f5OQ1tKZ\"\u0004F\u0001*-\u0011\u00151\u0006\u0001\"\u0001(\u0003U!Xm\u001d;Bi>l\u0017nY$fi>\u0013X\u000b\u001d3bi\u0016D#!\u0016\u0017")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoreUtilsTest$TestException$4$ TestException$2$lzycompute(VolatileObjectRef x$1) {
        CoreUtilsTest coreUtilsTest = this;
        synchronized (coreUtilsTest) {
            if (x$1.elem != null) return (CoreUtilsTest$TestException$4$)((Object)x$1.elem);
            x$1.elem = new CoreUtilsTest$TestException$4$(this);
            return (CoreUtilsTest$TestException$4$)((Object)x$1.elem);
        }
    }

    private Logger logger$lzycompute() {
        CoreUtilsTest coreUtilsTest = this;
        synchronized (coreUtilsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new KafkaException("test");
            }
        }, (Logging)this, Level.INFO);
    }

    @Test
    public void testTryAll() {
        VolatileObjectRef TestException$module = VolatileObjectRef.zero();
        scala.collection.mutable.Map recorded = Map$.MODULE$.empty();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-0"), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }, new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                public class Kafka_utils_CoreUtilsTest$TestException$3
                extends Exception
                implements Product,
                Serializable {
                    private final String key;
                    public final /* synthetic */ CoreUtilsTest $outer;

                    public String key() {
                        return this.key;
                    }

                    public Kafka_utils_CoreUtilsTest$TestException$3 copy(String key) {
                        return new Kafka_utils_CoreUtilsTest$TestException$3(this.kafka$utils$CoreUtilsTest$TestException$$$outer(), key);
                    }

                    public String copy$default$1() {
                        return this.key();
                    }

                    public String productPrefix() {
                        return "TestException";
                    }

                    public int productArity() {
                        return 1;
                    }

                    public Object productElement(int x$1) {
                        int n = x$1;
                        switch (n) {
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                            case 0: 
                        }
                        return this.key();
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Kafka_utils_CoreUtilsTest$TestException$3;
                    }

                    public int hashCode() {
                        return ScalaRunTime$.MODULE$._hashCode((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Kafka_utils_CoreUtilsTest$TestException$3)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Kafka_utils_CoreUtilsTest$TestException$3 var4_4 = (Kafka_utils_CoreUtilsTest$TestException$3)x$1;
                        String string = this.key();
                        String string2 = var4_4.key();
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public /* synthetic */ CoreUtilsTest kafka$utils$CoreUtilsTest$TestException$$$outer() {
                        return this.$outer;
                    }

                    public Kafka_utils_CoreUtilsTest$TestException$3(CoreUtilsTest $outer, String key) {
                        this.key = key;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        Product.class.$init$((Product)this);
                    }
                }
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this.$outer, "exception-1")), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }, new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-2"), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }, new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this.$outer, "exception-3")), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }})));
        scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-0"), (Object)package$.MODULE$.Right().apply((Object)"valid-0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-1"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-1"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-2"), (Object)package$.MODULE$.Right().apply((Object)"valid-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-3"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-3")))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-0"), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }, new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-1"), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }})));
        expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-0"), (Object)package$.MODULE$.Right().apply((Object)"valid-0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-1"), (Object)package$.MODULE$.Right().apply((Object)"valid-1"))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this.$outer, "exception-0")), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }, new Serializable(this, recorded){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoreUtilsTest $outer;
            private final scala.collection.mutable.Map recorded$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$utils$CoreUtilsTest$$recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this.$outer, "exception-1")), this.recorded$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recorded$1 = recorded$1;
            }
        }})));
        expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-0"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-0"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-1"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-1")))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = CoreUtils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = CoreUtils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
    }

    @Test
    public void testReadBytes() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "a", "abcd"})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String testCase) {
                byte[] bytes = testCase.getBytes();
                Assert.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
            }
        });
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * Predef$.MODULE$.intArrayOps(values).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)new Serializable(this, values, buffer){
            public static final long serialVersionUID = 0L;
            private final int[] values$1;
            private final ByteBuffer buffer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.buffer$1.putInt(i * 4, this.values$1[i]);
                Assert.assertEquals((String)"Written value should match read value.", (long)this.values$1[i], (long)CoreUtils$.MODULE$.readInt(this.buffer$1.array(), i * 4));
            }
            {
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assert.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        Map ipv6Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6);
        ipv6Map.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> m) {
                Assert.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
                Assert.assertTrue((boolean)((String)m._2()).equals("v"));
            }
        });
        String singleEntry = "key:value";
        Map singleMap = CoreUtils$.MODULE$.parseCsvMap(singleEntry);
        Object value = singleMap.getOrElse((Object)"key", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        });
        Assert.assertTrue((boolean)value.equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        Map ipv4Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4);
        ipv4Map.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> m) {
                Assert.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
                Assert.assertTrue((boolean)((String)m._2()).equals("allow"));
            }
        });
        String kvPairsSpaces = "key:value      , key:   value";
        Map spaceMap = CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces);
        spaceMap.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> m) {
                Assert.assertTrue((boolean)((String)m._1()).equals("key"));
                Assert.assertTrue((boolean)((String)m._2()).equals("value"));
            }
        });
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)CoreUtils$.MODULE$.inLock((Lock)lock, (Function0)new Serializable(this, lock){
            public static final long serialVersionUID = 0L;
            private final ReentrantLock lock$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                Assert.assertTrue((String)"Should be in lock", (boolean)this.lock$1.isHeldByCurrentThread());
                return 2;
            }
            {
                this.lock$1 = lock$1;
            }
        }));
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assert.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assert.assertEquals((long)clusterId1.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assert.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assert.assertEquals((long)clusterId2.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.traverse((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count), (Function1)new Serializable(this, createdCount, map, executionContext){
                public static final long serialVersionUID = 0L;
                public final AtomicInteger createdCount$1;
                public final scala.collection.concurrent.Map map$1;
                private final ExecutionContextExecutorService executionContext$1;

                public final Future<Object> apply(int i) {
                    return Future$.MODULE$.apply((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAtomicGetOrUpdate$1 $outer;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return ((AtomicInteger)CoreUtils$.MODULE$.atomicGetOrUpdate(this.$outer.map$1, (Object)BoxesRunTime.boxToInteger((int)0), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testAtomicGetOrUpdate$1$$anonfun$apply$1 $outer;

                                public final AtomicInteger apply() {
                                    this.$outer.kafka$utils$CoreUtilsTest$$anonfun$$anonfun$$$outer().createdCount$1.incrementAndGet();
                                    return new AtomicInteger();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            })).incrementAndGet();
                        }

                        public /* synthetic */ $anonfun$testAtomicGetOrUpdate$1 kafka$utils$CoreUtilsTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (ExecutionContext)this.executionContext$1);
                }
                {
                    this.createdCount$1 = createdCount$1;
                    this.map$1 = map$1;
                    this.executionContext$1 = executionContext$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom(), (ExecutionContext)executionContext), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES));
            Assert.assertEquals((long)count, (long)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many creations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)created)})), (created > 0 && created <= nThreads ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.shutdownNow();
            throw throwable;
        }
        executionContext.shutdownNow();
    }

    private final CoreUtilsTest$TestException$4$ TestException$2(VolatileObjectRef TestException$module$1) {
        return TestException$module$1.elem == null ? this.TestException$2$lzycompute(TestException$module$1) : (CoreUtilsTest$TestException$4$)((Object)TestException$module$1.elem);
    }

    public final void kafka$utils$CoreUtilsTest$$recordingFunction$1(Either v, scala.collection.mutable.Map recorded$1) {
        Either either;
        block4: {
            String string;
            block3: {
                block2: {
                    String key;
                    either = v;
                    if (!(either instanceof Right)) break block2;
                    Right right = (Right)either;
                    string = key = (String)right.b();
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left = (Left)either;
                Kafka_utils_CoreUtilsTest$TestException$3 e = (Kafka_utils_CoreUtilsTest$TestException$3)left.a();
                string = e.key();
            }
            String key = string;
            recorded$1.update((Object)key, (Object)v);
            return;
        }
        throw new MatchError((Object)either);
    }

    public CoreUtilsTest() {
        Logging.class.$init$((Logging)this);
        this.clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    }
}

