/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.Whitelist;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0001\u000f\tyAk\u001c9jG\u001aKG\u000e^3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005qA/Z:u/\"LG/\u001a7jgR\u001cH#\u0001\f\u0011\u0005%9\u0012B\u0001\r\u000b\u0005\u0011)f.\u001b;)\u0005MQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000f")
public class TopicFilterTest {
    @Test
    public void testWhitelists() {
        Whitelist topicFilter1 = new Whitelist("white1,white2");
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("white2", true));
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("white2", false));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("black1", true));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("black1", false));
        Whitelist topicFilter2 = new Whitelist(".+");
        Assert.assertTrue((boolean)topicFilter2.isTopicAllowed("alltopics", true));
        Assert.assertFalse((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", true));
        Assert.assertTrue((boolean)topicFilter2.isTopicAllowed("__consumer_offsets", false));
        Whitelist topicFilter3 = new Whitelist("white_listed-topic.+");
        Assert.assertTrue((boolean)topicFilter3.isTopicAllowed("white_listed-topic1", true));
        Assert.assertFalse((boolean)topicFilter3.isTopicAllowed("black1", true));
        Whitelist topicFilter4 = new Whitelist("test-(?!bad\\b)[\\w]+");
        Assert.assertTrue((boolean)topicFilter4.isTopicAllowed("test-good", true));
        Assert.assertFalse((boolean)topicFilter4.isTopicAllowed("test-bad", true));
    }
}

