/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u0013\tIA+[7feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\u0001^5nKJT!!\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\u0007\tY\u0001Aa\u0006\u0002\t)\u0016\u001cH\u000fV1tWN\u0019Q\u0003\u0007\u0011\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t1qJ\u00196fGR\u0004\"\u0001F\u0011\n\u0005\t\u0012!!\u0003+j[\u0016\u0014H+Y:l\u0011!!SC!b\u0001\n\u0003*\u0013a\u00023fY\u0006LXj]\u000b\u0002MA\u00111bJ\u0005\u0003Q1\u0011A\u0001T8oO\"A!&\u0006B\u0001B\u0003%a%\u0001\u0005eK2\f\u00170T:!\u0011!aSC!A!\u0002\u0013i\u0013AA5e!\tYa&\u0003\u00020\u0019\t\u0019\u0011J\u001c;\t\u0011E*\"\u0011!Q\u0001\nI\nQ\u0001\\1uG\"\u0004\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u000289\u0005!Q\u000f^5m\u0013\tIDG\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u0011m*\"\u0011!Q\u0001\nq\naa\\;uaV$\bcA\u001fC[5\taH\u0003\u0002@\u0001\u00069Q.\u001e;bE2,'BA!\r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0007z\u00121\"\u0011:sCf\u0014UO\u001a4fe\")\u0011#\u0006C\u0001\u000bR)a\tS%K\u0017B\u0011q)F\u0007\u0002\u0001!)A\u0005\u0012a\u0001M!)A\u0006\u0012a\u0001[!)\u0011\u0007\u0012a\u0001e!)1\b\u0012a\u0001y!1Q*\u0006Q\u0001\n9\u000b\u0011bY8na2,G/\u001a3\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E#\u0014AB1u_6L7-\u0003\u0002T!\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:DQ!V\u000b\u0005\u0002Y\u000b1A];o)\u00059\u0006CA\u0006Y\u0013\tIFB\u0001\u0003V]&$\bBB\u0002\u0001A\u0003&1\f\u0005\u0002\u00159&\u0011QL\u0001\u0002\u0006)&lWM\u001d\u0005\u0006?\u0002!\tAV\u0001\u0006g\u0016$X\u000f\u001d\u0015\u0003=\u0006\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u000b),h.\u001b;\u000b\u0003\u0019\f1a\u001c:h\u0013\tA7M\u0001\u0004CK\u001a|'/\u001a\u0005\u0006U\u0002!\tAV\u0001\ti\u0016\f'\u000fZ8x]\"\u0012\u0011\u000e\u001c\t\u0003E6L!A\\2\u0003\u000b\u00053G/\u001a:\t\u000bA\u0004A\u0011\u0001,\u0002-Q,7\u000f^!me\u0016\fG-_#ya&\u0014X\r\u001a+bg.D#a\u001c:\u0011\u0005\t\u001c\u0018B\u0001;d\u0005\u0011!Vm\u001d;\t\u000bY\u0004A\u0011\u0001,\u0002%Q,7\u000f\u001e+bg.,\u0005\u0010]5sCRLwN\u001c\u0015\u0003kJ\u0004")
public class TimerTest {
    public Timer kafka$utils$timer$TimerTest$$timer = null;

    @Before
    public void setup() {
        this.kafka$utils$timer$TimerTest$$timer = new SystemTimer("test", 1L, 3, SystemTimer$.MODULE$.$lessinit$greater$default$4());
    }

    @After
    public void teardown() {
        this.kafka$utils$timer$TimerTest$$timer.shutdown();
    }

    @Test
    public void testAlreadyExpiredTask() {
        ArrayBuffer output = new ArrayBuffer();
        IndexedSeq latches = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(-5), 0).map((Function1)new Serializable(this, output){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final ArrayBuffer output$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(1);
                this.$outer.kafka$utils$timer$TimerTest$$timer.add((TimerTask)new TestTask(this.$outer, i, i, latch, (ArrayBuffer<Object>)this.output$1));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$1 = output$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$utils$timer$TimerTest$$timer.advanceClock(0L);
        ((IterableLike)latches.take(5)).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CountDownLatch latch) {
                Assert.assertEquals((String)"already expired tasks should run immediately", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)latch.await(3L, TimeUnit.SECONDS)));
            }
        });
        Assert.assertEquals((String)"output of already expired tasks", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-5, -4, -3, -2, -1})), (Object)output.toSet());
    }

    @Test
    public void testTaskExpiration() {
        ArrayBuffer output = new ArrayBuffer();
        ArrayBuffer tasks = new ArrayBuffer();
        ArrayBuffer ids = new ArrayBuffer();
        IndexedSeq latches = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this, output, tasks, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final ArrayBuffer output$2;
            private final ArrayBuffer tasks$1;
            private final ArrayBuffer ids$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(1);
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$2 = output$2;
                this.tasks$1 = tasks$1;
                this.ids$1 = ids$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 100).map((Function1)new Serializable(this, output, tasks, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final ArrayBuffer output$2;
            private final ArrayBuffer tasks$1;
            private final ArrayBuffer ids$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(2);
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$2 = output$2;
                this.tasks$1 = tasks$1;
                this.ids$1 = ids$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(100), 500).map((Function1)new Serializable(this, output, tasks, ids){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;
            private final ArrayBuffer output$2;
            private final ArrayBuffer tasks$1;
            private final ArrayBuffer ids$1;

            /*
             * WARNING - void declaration
             */
            public final CountDownLatch apply(int i) {
                void var2_2;
                CountDownLatch latch = new CountDownLatch(1);
                this.tasks$1.$plus$eq((Object)new TestTask(this.$outer, i, i, latch, (ArrayBuffer<Object>)this.output$2));
                this.ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$2 = output$2;
                this.tasks$1 = tasks$1;
                this.ids$1 = ids$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
        tasks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimerTest $outer;

            public final void apply(TestTask task) {
                this.$outer.kafka$utils$timer$TimerTest$$timer.add((TimerTask)task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        while (this.kafka$utils$timer$TimerTest$$timer.advanceClock(2000L)) {
        }
        latches.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CountDownLatch latch) {
                latch.await();
            }
        });
        Assert.assertEquals((String)"output should match", (Object)ids.sorted((Ordering)Ordering.Int$.MODULE$), (Object)output.toSeq());
    }

    public class TestTask
    implements TimerTask {
        private final long delayMs;
        private final int id;
        private final CountDownLatch latch;
        private final ArrayBuffer<Object> output;
        private final AtomicBoolean completed;
        public final /* synthetic */ TimerTest $outer;
        private TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry;

        public TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry() {
            return this.kafka$utils$timer$TimerTask$$timerTaskEntry;
        }

        public void kafka$utils$timer$TimerTask$$timerTaskEntry_$eq(TimerTaskEntry x$1) {
            this.kafka$utils$timer$TimerTask$$timerTaskEntry = x$1;
        }

        public void cancel() {
            TimerTask.class.cancel((TimerTask)this);
        }

        public void setTimerTaskEntry(TimerTaskEntry entry) {
            TimerTask.class.setTimerTaskEntry((TimerTask)this, (TimerTaskEntry)entry);
        }

        public TimerTaskEntry getTimerTaskEntry() {
            return TimerTask.class.getTimerTaskEntry((TimerTask)this);
        }

        public long delayMs() {
            return this.delayMs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (!this.completed.compareAndSet(false, true)) return;
            ArrayBuffer<Object> arrayBuffer = this.output;
            synchronized (arrayBuffer) {
                this.output.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.id));
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : arrayBuffer
                this.latch.countDown();
                return;
            }
        }

        public /* synthetic */ TimerTest kafka$utils$timer$TimerTest$TestTask$$$outer() {
            return this.$outer;
        }

        public TestTask(TimerTest $outer, long delayMs, int id, CountDownLatch latch, ArrayBuffer<Object> output) {
            this.delayMs = delayMs;
            this.id = id;
            this.latch = latch;
            this.output = output;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            TimerTask.class.$init$((TimerTask)this);
            this.completed = new AtomicBoolean(false);
        }
    }
}

