/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.log.LogCleaner$;
import kafka.network.SocketServer$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.DynamicLogConfig$;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class DynamicBrokerConfig$ {
    public static final DynamicBrokerConfig$ MODULE$;
    private final scala.collection.mutable.Set<String> DynamicSecurityConfigs;
    private final scala.collection.mutable.Set<String> AllDynamicConfigs;
    private final Set<String> ClusterLevelListenerConfigs;
    private final scala.collection.mutable.Set<String> kafka$server$DynamicBrokerConfig$$PerBrokerConfigs;
    private final Set<String> ListenerMechanismConfigs;
    private final Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    private final Regex ListenerConfigRegex;
    private final scala.collection.mutable.Set<String> DynamicPasswordConfigs;

    static {
        new DynamicBrokerConfig$();
    }

    public scala.collection.mutable.Set<String> DynamicSecurityConfigs() {
        return this.DynamicSecurityConfigs;
    }

    public scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return this.AllDynamicConfigs;
    }

    private Set<String> ClusterLevelListenerConfigs() {
        return this.ClusterLevelListenerConfigs;
    }

    public scala.collection.mutable.Set<String> kafka$server$DynamicBrokerConfig$$PerBrokerConfigs() {
        return this.kafka$server$DynamicBrokerConfig$$PerBrokerConfigs;
    }

    private Set<String> ListenerMechanismConfigs() {
        return this.ListenerMechanismConfigs;
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs() {
        return this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs;
    }

    public Regex ListenerConfigRegex() {
        return this.ListenerConfigRegex;
    }

    private scala.collection.mutable.Set<String> DynamicPasswordConfigs() {
        return this.DynamicPasswordConfigs;
    }

    public boolean isPasswordConfig(String name) {
        return this.DynamicPasswordConfigs().exists((Function1)new Serializable(name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(String x$1) {
                return this.name$1.endsWith(x$1);
            }
            {
                this.name$1 = name$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> brokerConfigSynonyms(String name, boolean matchListenerOverride) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = name;
        String string2 = KafkaConfig$.MODULE$.LogRollTimeMillisProp();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl3 = true;
        } else {
            String string4 = KafkaConfig$.MODULE$.LogRollTimeHoursProp();
            String string5 = string;
            bl3 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl3) {
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogRollTimeMillisProp(), KafkaConfig$.MODULE$.LogRollTimeHoursProp()}));
        }
        String string6 = KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            bl2 = true;
        } else {
            String string8 = KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp();
            String string9 = string;
            bl2 = !(string8 != null ? !string8.equals(string9) : string9 != null);
        }
        if (bl2) {
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp(), KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp()}));
        }
        String string10 = KafkaConfig$.MODULE$.LogFlushIntervalMsProp();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogFlushIntervalMsProp(), KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp()}));
        }
        String string12 = KafkaConfig$.MODULE$.LogRetentionTimeMillisProp();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            bl = true;
        } else {
            String string14 = KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp();
            String string15 = string;
            if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                bl = true;
            } else {
                String string16 = KafkaConfig$.MODULE$.LogRetentionTimeHoursProp();
                String string17 = string;
                bl = !(string16 != null ? !string16.equals(string17) : string17 != null);
            }
        }
        if (bl) {
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), KafkaConfig$.MODULE$.LogRetentionTimeHoursProp()}));
        }
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
        String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
        if (!matchListenerOverride) return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
        Option mechanismConfig = this.ListenerMechanismConfigs().find((Function1)new Serializable(baseName){
            public static final long serialVersionUID = 0L;
            private final String baseName$1;

            public final boolean apply(String x$1) {
                return this.baseName$1.endsWith(x$1);
            }
            {
                this.baseName$1 = baseName$1;
            }
        });
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, (String)mechanismConfig.getOrElse((Function0)new Serializable(baseName){
            public static final long serialVersionUID = 0L;
            private final String baseName$1;

            public final String apply() {
                return this.baseName$1;
            }
            {
                this.baseName$1 = baseName$1;
            }
        })}));
    }

    public void validateConfigs(Properties props, boolean perBrokerConfig) {
        this.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Cannot update these configs dynamically");
        this.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "These security configs can be dynamically updated only per-listener using the listener prefix");
        this.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
        if (!perBrokerConfig) {
            this.checkInvalidProps$1(this.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Cannot update these configs at default cluster level, broker id must be specified");
        }
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$perBrokerConfigs(Properties props) {
        Set configNames = ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet();
        return ((SetLike)configNames.intersect(this.kafka$server$DynamicBrokerConfig$$PerBrokerConfigs())).$plus$plus((GenTraversableOnce)configNames.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String name) {
                return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerListenerConfig$1(name);
            }
        }));
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(Properties props) {
        return (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().intersect(DynamicConfig$Broker$.MODULE$.nonDynamicProps());
    }

    public Set<String> kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(Properties props) {
        return (Set)this.DynamicSecurityConfigs().filter((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final boolean apply(Object x$1) {
                return this.props$2.containsKey(x$1);
            }
            {
                this.props$2 = props$2;
            }
        });
    }

    public void kafka$server$DynamicBrokerConfig$$validateConfigTypes(Properties props) {
        Properties baseProps = new Properties();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1)new Serializable(baseProps){
            public static final long serialVersionUID = 0L;
            private final Properties baseProps$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2;
                block4: {
                    Object object;
                    block3: {
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            CharSequence charSequence = (CharSequence)tuple2._1();
                            String v = (String)tuple2._2();
                            Option option = DynamicBrokerConfig$.MODULE$.ListenerConfigRegex().unapplySeq(charSequence);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block2;
                            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
                            object = this.baseProps$1.put(baseName, v);
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        object = this.baseProps$1.put(k, v);
                    }
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.baseProps$1 = baseProps$1;
            }
        });
        DynamicConfig$Broker$.MODULE$.validate(baseProps);
    }

    public void addDynamicConfigs(ConfigDef configDef) {
        KafkaConfig$.MODULE$.configKeys().filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String elem) {
                return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)elem);
            }
        }).values().foreach((Function1)new Serializable(configDef){
            public static final long serialVersionUID = 0L;
            private final ConfigDef configDef$1;

            public final ConfigDef apply(ConfigDef.ConfigKey config) {
                return this.configDef$1.define(config.name, config.type, config.defaultValue, config.validator, config.importance, config.documentation, config.group, config.orderInGroup, config.width, config.displayName, config.dependents, config.recommender);
            }
            {
                this.configDef$1 = configDef$1;
            }
        });
    }

    public java.util.Map<String, String> dynamicConfigUpdateModes() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.AllDynamicConfigs().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String name) {
                String mode = DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$PerBrokerConfigs().contains((Object)name) ? "per-broker" : "cluster-wide";
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)mode);
            }
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    private final void checkInvalidProps$1(Set invalidPropNames, String errorMessage) {
        if (invalidPropNames.nonEmpty()) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMessage, invalidPropNames})));
        }
    }

    public final boolean kafka$server$DynamicBrokerConfig$$perBrokerListenerConfig$1(String name) {
        boolean bl;
        String string = name;
        Option option = this.ListenerConfigRegex().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseName = (String)((LinearSeqOptimized)option.get()).apply(0);
            bl = !this.ClusterLevelListenerConfigs().contains((Object)baseName);
        } else {
            bl = false;
        }
        return bl;
    }

    private DynamicBrokerConfig$() {
        MODULE$ = this;
        this.DynamicSecurityConfigs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(SslConfigs.RECONFIGURABLE_CONFIGS).asScala();
        this.AllDynamicConfigs = this.DynamicSecurityConfigs().$plus$plus(LogCleaner$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicLogConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(DynamicThreadPool$.MODULE$.ReconfigurableConfigs()).$plus$plus((GenTraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MetricReporterClassesProp()}))).$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$plus$plus(SocketServer$.MODULE$.ReconfigurableConfigs());
        this.ClusterLevelListenerConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.MaxConnectionsProp()}));
        this.kafka$server$DynamicBrokerConfig$$PerBrokerConfigs = this.DynamicSecurityConfigs().$plus$plus(DynamicListenerConfig$.MODULE$.ReconfigurableConfigs()).$minus$minus(this.ClusterLevelListenerConfigs());
        this.ListenerMechanismConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.SaslJaasConfigProp()}));
        this.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.truststore.location"}));
        this.ListenerConfigRegex = new StringOps(Predef$.MODULE$.augmentString("listener\\.name\\.[^.]*\\.(.*)")).r();
        Set passwordConfigs = ((MapLike)KafkaConfig$.MODULE$.configKeys().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, ConfigDef.ConfigKey> x$1) {
                ConfigDef.Type type = ((ConfigDef.ConfigKey)x$1._2()).type;
                ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
                return !(type != null ? !type.equals(type2) : type2 != null);
            }
        })).keySet();
        this.DynamicPasswordConfigs = (scala.collection.mutable.Set)this.AllDynamicConfigs().intersect((GenSet)passwordConfigs);
    }
}

