/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.admin.DeleteConsumerGroupsTest$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u000f\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"\u0001B+oSRDC\u0001\u0005\u000e#GA\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%\u0001\u0006k_B$8/[7qY\u0016L!!\u000b\u0014\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:DQa\u000b\u0001\u0005\u0002I\tQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003UiAQA\f\u0001\u0005\u0002I\t!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#!\f\u000e\t\u000bE\u0002A\u0011\u0001\n\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005AR\u0002\"\u0002\u001b\u0001\t\u0003\u0011\u0012a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t\u0019$\u0004C\u00038\u0001\u0011\u0005!#A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012aG\u0007\u0005\u0006u\u0001!\tAE\u0001\u0017i\u0016\u001cH\u000fR3mKR,7)\u001c3BY2<%o\\;qg\"\u0012\u0011H\u0007\u0005\u0006{\u0001!\tAE\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005qR\u0002\"\u0002!\u0001\t\u0003\u0011\u0012!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\ty$\u0004C\u0003D\u0001\u0011\u0005!#\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u0005jAQA\u0012\u0001\u0005\u0002I\t1\u0006^3ti\u0012+G.\u001a;f/&$\b.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0005\u000bj\u00113\u0005")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$1.deleteGroups();
            }
            {
                this.service$1 = service$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.GROUP_ID_NOT_FOUND})), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup}))) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.GROUP_ID_NOT_FOUND})), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((SeqLike)((Option)this.service$2.collectGroupMembers(this.$outer.group(), false)._2()).get()).size() == 1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$2 = service$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$2.deleteGroups();
            }
            {
                this.service$2 = service$2;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group. Output was: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NON_EMPTY_GROUP, output})), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((SeqLike)((Option)this.service$3.collectGroupMembers(this.$outer.group(), false)._2()).get()).size() == 1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$3 = service$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map result = service.deleteGroups();
        Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group was deleted successfully, but it shouldn't have been. Result was:(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result})), (Object)result.apply((Object)this.group()));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expected error (", ") was not detected while deleting consumer group. Result was:(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.NON_EMPTY_GROUP, result})), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.apply((Object)this.group())).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$4.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$4 = service$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$4.collectGroupState(this.$outer.group()).state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$4 = service$4;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$4.deleteGroups();
            }
            {
                this.service$4 = service$4;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group could not be deleted as expected"})).s((Seq)Nil$.MODULE$), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of requested consumer groups ('", "') was successful."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDeleteCmdAllGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        groups = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;

            public final Tuple2<String, ConsumerGroupCommandTest.ConsumerGroupExecutor> apply(int i) {
                String group = new StringBuilder().append((Object)this.$outer.group()).append((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                int x$2 = 1;
                String x$3 = group;
                String x$4 = this.$outer.addConsumerGroupExecutor$default$2();
                String x$5 = this.$outer.addConsumerGroupExecutor$default$4();
                Option<Properties> x$6 = this.$outer.addConsumerGroupExecutor$default$5();
                boolean x$7 = this.$outer.addConsumerGroupExecutor$default$6();
                ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.$outer.addConsumerGroupExecutor(x$2, x$4, x$3, x$5, x$6, x$7);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)executor);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--all-groups"});
        service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groups, service){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map groups$1;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$5.listGroups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteCmdAllGroups$1 $outer;

                    public final boolean apply(String groupId) {
                        return this.$outer.groups$1.keySet().contains((Object)groupId);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.groups$1 = groups$1;
                this.service$5 = service$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        groups.values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ConsumerGroupCommandTest.ConsumerGroupExecutor executor) {
                executor.shutdown();
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, groups, service){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map groups$1;
            public final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.groups$1.keySet().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDeleteCmdAllGroups$2 $outer;

                    public final boolean apply(String groupId) {
                        String string = this.$outer.service$5.collectGroupState(groupId).state();
                        String string2 = "Empty";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.groups$1 = groups$1;
                this.service$5 = service$5;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service$5.deleteGroups();
            }
            {
                this.service$5 = service$5;
            }
        }).trim();
        expectedGroupsForDeletion = groups.keySet();
        deletedGroupsGrepped = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(output.substring(output.indexOf(40) + 1, output.indexOf(41)))).split(',')).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.replaceAll("'", "").trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        v0 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group(s) could not be deleted as expected"})).s((Seq)Nil$.MODULE$);
        if (!output.matches(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of requested consumer groups (.*) was successful."})).s((Seq)Nil$.MODULE$))) ** GOTO lbl-1000
        v1 = deletedGroupsGrepped;
        var7_7 = expectedGroupsForDeletion;
        if (!(v1 != null ? v1.equals(var7_7) == false : var7_7 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Assert.assertTrue((String)v0, (boolean)v2);
    }

    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$6.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$6 = service$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$6.collectGroupState(this.$outer.group()).state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$6 = service$6;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map result = service.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group could not be deleted as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$7.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$7 = service$7;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$7;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$7.collectGroupState(this.$outer.group()).state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$7 = service$7;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])Predef$.MODULE$.refArrayOps((Object[])cgcArgs).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this, service2){
            public static final long serialVersionUID = 0L;
            private final ConsumerGroupCommand.ConsumerGroupService service2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.service2$1.deleteGroups();
            }
            {
                this.service2$1 = service2$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group '", "' could not be deleted due to:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup}))) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"These consumer groups were deleted successfully: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}))) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.service$8.listGroups().contains((Object)this.$outer.group());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$8 = service$8;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not initialize as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, service){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteConsumerGroupsTest $outer;
            private final ConsumerGroupCommand.ConsumerGroupService service$8;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.service$8.collectGroupState(this.$outer.group()).state();
                String string2 = "Empty";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.service$8 = service$8;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The group did not become empty as expected.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])Predef$.MODULE$.refArrayOps((Object[])cgcArgs).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Map result = service2.deleteGroups();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group deletion did not work as expected"})).s((Seq)Nil$.MODULE$), (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
    }
}

