/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.admin.TopicCommandWithAdminClientTest$;
import kafka.admin.TopicCommandWithAdminClientTest$$anonfun$testDescribeUnavailablePartitions$1$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001\u001d\u0011q\u0004V8qS\u000e\u001cu.\\7b]\u0012<\u0016\u000e\u001e5BI6Lgn\u00117jK:$H+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u000f)A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h!\t)b#D\u0001\u0003\u0013\t9\"AA\u0007SC\u000e\\\u0017i^1sKR+7\u000f\u001e\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\u000bu\u0001A\u0011\t\u0010\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\b\t\u0004A\u0015:S\"A\u0011\u000b\u0005\t\u001a\u0013AC2pY2,7\r^5p]*\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'C\t\u00191+Z9\u0011\u0005!ZS\"A\u0015\u000b\u0005)\"\u0011AB:feZ,'/\u0003\u0002-S\tY1*\u00194lC\u000e{gNZ5h\u0011\u001dq\u0003A1A\u0005\n=\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#\u0001\u0019\u0011\u0005E\u0012T\"A\u0012\n\u0005M\u001a#aA%oi\"1Q\u0007\u0001Q\u0001\nA\naB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u00021\u0011,g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'/F\u0001:!\t\t$(\u0003\u0002<G\t)1\u000b[8si\"1Q\b\u0001Q\u0001\ne\n\u0011\u0004Z3gCVdGOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA!Iq\b\u0001a\u0001\u0002\u0004%I\u0001Q\u0001\ri>\u0004\u0018nY*feZL7-Z\u000b\u0002\u0003B\u0011!\t\u0014\b\u0003\u0007*s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001d3\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019A!\u0003\u0002L\u0005\u0005aAk\u001c9jG\u000e{W.\\1oI&\u0011QJ\u0014\u0002\u0018\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fV8qS\u000e\u001cVM\u001d<jG\u0016T!a\u0013\u0002\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0013\t\u0016\u0001\u0005;pa&\u001c7+\u001a:wS\u000e,w\fJ3r)\t\u0011V\u000b\u0005\u00022'&\u0011Ak\t\u0002\u0005+:LG\u000fC\u0004W\u001f\u0006\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007\u0003\u0004Y\u0001\u0001\u0006K!Q\u0001\u000ei>\u0004\u0018nY*feZL7-\u001a\u0011\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0013Y\u0016aC1e[&t7\t\\5f]R,\u0012\u0001\u0018\t\u0003;\u001al\u0011A\u0018\u0006\u0003\u0007}S!\u0001Y1\u0002\u000f\rd\u0017.\u001a8ug*\u0011QA\u0019\u0006\u0003G\u0012\fa!\u00199bG\",'\"A3\u0002\u0007=\u0014x-\u0003\u0002h=\n)\u0011\tZ7j]\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA[\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011!k\u001b\u0005\b-\"\f\t\u00111\u0001]\u0011\u0019i\u0007\u0001)Q\u00059\u0006a\u0011\rZ7j]\u000ec\u0017.\u001a8uA!Iq\u000e\u0001a\u0001\u0002\u0004%I\u0001]\u0001\u000ei\u0016\u001cH\u000fV8qS\u000et\u0015-\\3\u0016\u0003E\u0004\"A];\u000f\u0005E\u001a\u0018B\u0001;$\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u001c\u0003\"C=\u0001\u0001\u0004\u0005\r\u0011\"\u0003{\u0003E!Xm\u001d;U_BL7MT1nK~#S-\u001d\u000b\u0003%nDqA\u0016=\u0002\u0002\u0003\u0007\u0011\u000f\u0003\u0004~\u0001\u0001\u0006K!]\u0001\u000fi\u0016\u001cH\u000fV8qS\u000et\u0015-\\3!\u0011!y\bA1A\u0005\n\u0005\u0005\u0011!C0uKN$h*Y7f+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000bI,H.Z:\u000b\u0007\u00055A-A\u0003kk:LG/\u0003\u0003\u0002\u0012\u0005\u001d!\u0001\u0003+fgRt\u0015-\\3\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0007\t!b\u0018;fgRt\u0015-\\3!\u0011\u001d\tI\u0002\u0001C\u0001\u0003\u0003\t\u0001\u0002^3ti:\u000bW.\u001a\u0015\u0005\u0003/\ti\u0002\u0005\u0003\u0002 \u0005\u0005RBAA\u0006\u0013\u0011\t\u0019#a\u0003\u0003\tI+H.\u001a\u0005\b\u0003O\u0001A\u0011AA\u0015\u00039\t7o]3si\u0016C\u0018\u000e^\"pI\u0016$RAUA\u0016\u0003_Aq!!\f\u0002&\u0001\u0007\u0001'\u0001\u0005fqB,7\r^3e\u0011!\t\t$!\nA\u0002\u0005M\u0012AB7fi\"|G\r\u0005\u00032\u0003k\u0011\u0016bAA\u001cG\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003]\t7o]3si\u000eCWmY6Be\u001e\u001cX\t_5u\u0007>$W\rF\u0003S\u0003\u007f\t\t\u0005C\u0004\u0002.\u0005e\u0002\u0019\u0001\u0019\t\u0011\u0005\r\u0013\u0011\ba\u0001\u0003\u000b\nqa\u001c9uS>t7\u000fE\u0002C\u0003\u000fJ1!!\u0013O\u0005M!v\u000e]5d\u0007>lW.\u00198e\u001fB$\u0018n\u001c8t\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001f\n!c\u0019:fCR,\u0017I\u001c3XC&$Hk\u001c9jGR\u0019!+!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003\u000b\nAa\u001c9ug\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0013aE<bSR4uN\u001d+pa&\u001c7I]3bi\u0016$G#\u0002*\u0002\\\u0005}\u0003bBA/\u0003+\u0002\r!]\u0001\ni>\u0004\u0018n\u0019(b[\u0016D\u0011\"!\u0019\u0002VA\u0005\t\u0019\u0001\u0019\u0002\u000fQLW.Z8vi\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014!B:fiV\u0004H#\u0001*)\t\u0005\r\u00141\u000e\t\u0005\u0003?\ti'\u0003\u0003\u0002p\u0005-!A\u0002\"fM>\u0014X\rC\u0004\u0002t\u0001!\t!a\u001a\u0002\u000b\rdwn]3)\t\u0005E\u0014q\u000f\t\u0005\u0003?\tI(\u0003\u0003\u0002|\u0005-!!B!gi\u0016\u0014\bbBA@\u0001\u0011\u0005\u0011qM\u0001\u0014i\u0016\u001cH\u000fU1sg\u0016\f5o]5h]6,g\u000e\u001e\u0015\u0005\u0003{\n\u0019\t\u0005\u0003\u0002 \u0005\u0015\u0015\u0002BAD\u0003\u0017\u0011A\u0001V3ti\"9\u00111\u0012\u0001\u0005\u0002\u0005\u001d\u0014a\t;fgR\u0004\u0016M]:f\u0003N\u001c\u0018n\u001a8nK:$H)\u001e9mS\u000e\fG/Z#oiJLWm\u001d\u0015\u0005\u0003\u0013\u000b\u0019\tC\u0004\u0002\u0012\u0002!\t!a\u001a\u0002YQ,7\u000f\u001e)beN,\u0017i]:jO:lWM\u001c;QCJ$\u0018\u000e^5p]N|e\rR5gM\u0016\u0014XM\u001c;TSj,\u0007\u0006BAH\u0003\u0007Cq!a&\u0001\t\u0003\t9'A\u0011uKN$8i\u001c8gS\u001e|\u0005\u000f^,ji\"\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\u000b\u0003\u0002\u0016\u0006\r\u0005bBAO\u0001\u0011\u0005\u0011qM\u0001\u000bi\u0016\u001cHo\u0011:fCR,\u0007\u0006BAN\u0003\u0007Cq!a)\u0001\t\u0003\t9'\u0001\fuKN$8I]3bi\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;tQ\u0011\t\t+a!\t\u000f\u0005%\u0006\u0001\"\u0001\u0002h\u0005\u0001C/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$(+\u001a9mS\u000e\fG/[8oQ\u0011\t9+a!\t\u000f\u0005=\u0006\u0001\"\u0001\u0002h\u0005yB/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$\b+\u0019:uSRLwN\\:)\t\u00055\u00161\u0011\u0005\b\u0003k\u0003A\u0011AA4\u0003U!Xm\u001d;De\u0016\fG/Z,ji\"\u001cuN\u001c4jONDC!a-\u0002\u0004\"9\u00111\u0018\u0001\u0005\u0002\u0005\u001d\u0014a\u0007;fgR\u001c%/Z1uK&3\u0017\n^!me\u0016\fG-_#ySN$8\u000f\u000b\u0003\u0002:\u0006\r\u0005bBAa\u0001\u0011\u0005\u0011qM\u0001 i\u0016\u001cHo\u0011:fCR,w+\u001b;i%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\b\u0006BA`\u0003\u0007Cq!a2\u0001\t\u0003\t9'\u0001\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_JDC!!2\u0002\u0004\"9\u0011Q\u001a\u0001\u0005\u0002\u0005\u001d\u0014a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_JDC!a3\u0002\u0004\"9\u00111\u001b\u0001\u0005\u0002\u0005\u001d\u0014!\u000b;fgR\u001c%/Z1uK^KG\u000f[!tg&<g.\\3oi\u0006sG\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0003\u0002R\u0006\r\u0005bBAm\u0001\u0011\u0005\u0011qM\u0001-i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3SKBd\u0017nY1uS>tg)Y2u_JDC!a6\u0002\u0004\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u001d\u0014\u0001\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\t\u0005u\u00171\u0011\u0005\b\u0003K\u0004A\u0011AA4\u0003\r#Xm\u001d;De\u0016\fG/Z,ji\",fn\u001d9fG&4\u0017.\u001a3SKBd\u0017nY1uS>tg)Y2u_J\fe\u000e\u001a)beRLG/[8og^KG\u000f\u001b.l\u00072LWM\u001c;)\t\u0005\r\u00181\u0011\u0005\b\u0003W\u0004A\u0011AA4\u0003m!Xm\u001d;J]Z\fG.\u001b3U_BL7\rT3wK2\u001cuN\u001c4jO\"\"\u0011\u0011^AB\u0011\u001d\t\t\u0010\u0001C\u0001\u0003O\na\u0002^3ti2K7\u000f\u001e+pa&\u001c7\u000f\u000b\u0003\u0002p\u0006\r\u0005bBA|\u0001\u0011\u0005\u0011qM\u0001\u001ci\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\bn\u00165ji\u0016d\u0017n\u001d;)\t\u0005U\u00181\u0011\u0005\b\u0003{\u0004A\u0011AA4\u0003\u0005\"Xm\u001d;MSN$Hk\u001c9jGN<\u0016\u000e\u001e5Fq\u000edW\u000fZ3J]R,'O\\1mQ\u0011\tY0a!\t\u000f\t\r\u0001\u0001\"\u0001\u0002h\u00059B/Z:u\u00032$XM\u001d)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0005\u0005\u0003\t\u0019\tC\u0004\u0003\n\u0001!\t!a\u001a\u0002'Q,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;)\t\t\u001d\u00111\u0011\u0005\b\u0005\u001f\u0001A\u0011AA4\u0003M\"Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8u/&$\b.T8sK\u0006\u001b8/[4o[\u0016tG\u000f\u00165b]B\u000b'\u000f^5uS>t7\u000f\u000b\u0003\u0003\u000e\u0005\r\u0005b\u0002B\u000b\u0001\u0011\u0005\u0011qM\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3QCJ$\u0018\u000e^5p]N$\u0006.\u00198BgNLwM\\7f]RDCAa\u0005\u0002\u0004\"9!1\u0004\u0001\u0005\u0002\u0005\u001d\u0014A\t;fgR\fE\u000e^3s/&$\b.\u00138wC2LG\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0003\u0003\u001a\u0005\r\u0005b\u0002B\u0011\u0001\u0011\u0005\u0011qM\u0001'i\u0016\u001cH/\u00117uKJ<\u0016\u000e\u001e5V]N\u0004XmY5gS\u0016$\u0007+\u0019:uSRLwN\\\"pk:$\b\u0006\u0002B\u0010\u0003\u0007CqAa\n\u0001\t\u0003\t9'A\u000fuKN$\u0018\t\u001c;fe^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:uQ\u0011\u0011)#a!\t\u000f\t5\u0002\u0001\"\u0001\u0002h\u0005aD/Z:u\u0013\u001a,\u00050[:ug\u0006sG-\u00134O_R,\u00050[:ug>\u0003H/[8og&sg/\u00197jI^KG\u000f\u001b\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:tQ\u0011\u0011Y#a!\t\u000f\tM\u0002\u0001\"\u0001\u0002h\u0005\tC/Z:u\u0007J,\u0017\r^3BYR,'\u000fV8qS\u000e<\u0016\u000e\u001e5SC\u000e\\\u0017i^1sK\"\"!\u0011GAB\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003O\nq\u0006^3ti\u000e{gNZ5h!J,7/\u001a:wCRLwN\\!de>\u001c8\u000fU1si&$\u0018n\u001c8BYR,'/\u0019;j_:DCAa\u000e\u0002\u0004\"9!q\b\u0001\u0005\u0002\u0005\u001d\u0014!\u0005;fgR$v\u000e]5d\t\u0016dW\r^5p]\"\"!QHAB\u0011\u001d\u0011)\u0005\u0001C\u0001\u0003O\nq\u0003^3ti\u0012+G.\u001a;f\u0013:$XM\u001d8bYR{\u0007/[2)\t\t\r\u00131\u0011\u0005\b\u0005\u0017\u0002A\u0011AA4\u0003I!Xm\u001d;EK2,G/Z%g\u000bbL7\u000f^:)\t\t%\u00131\u0011\u0005\b\u0005#\u0002A\u0011AA4\u00031!Xm\u001d;EKN\u001c'/\u001b2fQ\u0011\u0011y%a!\t\u000f\t]\u0003\u0001\"\u0001\u0002h\u0005\tC/Z:u\t\u0016\u001c8M]5cKVs\u0017M^1jY\u0006\u0014G.\u001a)beRLG/[8og\"\"!QKAB\u0011\u001d\u0011i\u0006\u0001C\u0001\u0003O\nQ\u0005^3ti\u0012+7o\u0019:jE\u0016,f\u000eZ3s%\u0016\u0004H.[2bi\u0016$\u0007+\u0019:uSRLwN\\:)\t\tm\u00131\u0011\u0005\b\u0005G\u0002A\u0011AA4\u0003\u0005\"Xm\u001d;EKN\u001c'/\u001b2f+:$WM]'j]&\u001b(\u000fU1si&$\u0018n\u001c8tQ\u0011\u0011\t'a!\t\u000f\t%\u0004\u0001\"\u0001\u0002h\u0005qB/Z:u\t\u0016\u001c8M]5cK\u0006#X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0005O\n\u0019\tC\u0004\u0003p\u0001!\t!a\u001a\u0002MQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:NSb,G\r\u000b\u0003\u0003n\u0005\r\u0005b\u0002B;\u0001\u0011\u0005\u0011qM\u0001$i\u0016\u001cH\u000fR3tGJL'-\u001a*fa>\u0014Ho\u0014<feJLG\rZ3o\u0007>tg-[4tQ\u0011\u0011\u0019(a!\t\u000f\tm\u0004\u0001\"\u0001\u0002h\u0005qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2tQ\u0011\u0011I(a!\t\u0013\t\u0005\u0005!%A\u0005\u0002\t\r\u0015!H<bSR4uN\u001d+pa&\u001c7I]3bi\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015%f\u0001\u0019\u0003\b.\u0012!\u0011\u0012\t\u0005\u0005\u0017\u0013)*\u0004\u0002\u0003\u000e*!!q\u0012BI\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0014\u000e\n!\"\u00198o_R\fG/[8o\u0013\u0011\u00119J!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor;
    private TopicCommand.AdminClientTopicService kafka$admin$TopicCommandWithAdminClientTest$$topicService;
    private Admin adminClient;
    private String kafka$admin$TopicCommandWithAdminClientTest$$testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = 6;
        String x$13 = this.zkConnect();
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$15 = this.numPartitions();
        short x$16 = this.defaultReplicationFactor();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$13, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, (Map<Object, String>)x$14, x$26, x$27, x$15, x$16).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties props) {
                return KafkaConfig$.MODULE$.fromProps(props);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public TopicCommand.AdminClientTopicService kafka$admin$TopicCommandWithAdminClientTest$$topicService() {
        return this.kafka$admin$TopicCommandWithAdminClientTest$$topicService;
    }

    private void kafka$admin$TopicCommandWithAdminClientTest$$topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    public String kafka$admin$TopicCommandWithAdminClientTest$$testTopicName() {
        return this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName;
    }

    private void kafka$admin$TopicCommandWithAdminClientTest$$testTopicName_$eq(String x$1) {
        this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final int expected$1;

            public final Nothing$ apply(int exitCode, Option<String> exitMessage) {
                return this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$mockExitProcedure$1(exitCode, exitMessage, this.expected$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expected$1 = expected$1;
            }
        });
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            return;
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions options$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.options$1.checkArgs();
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        long finishTime = System.currentTimeMillis() + (long)timeout;
        boolean result = false;
        while (true) {
            if (System.currentTimeMillis() >= finishTime && result) {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " has not been created within the given ", " time"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicName, BoxesRunTime.boxToInteger((int)timeout)})), (boolean)result);
                return;
            }
            java.util.Set topics = (java.util.Set)this.adminClient().listTopics(new ListTopicsOptions().listInternal(true)).names().get();
            boolean bl = topics.contains(topicName);
            Thread.sleep(100L);
        }
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Before
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq((Admin)AdminClient.create((Properties)props));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testName().getMethodName(), Random$.MODULE$.alphanumeric().take(10).mkString()})));
    }

    @After
    public void close() {
        if (this.kafka$admin$TopicCommandWithAdminClientTest$$topicService() != null) {
            this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().close();
        }
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, List<Object>> apply() {
                return TopicCommand$.MODULE$.parseReplicaAssignment("5:5");
            }
        }, ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, List<Object>> apply() {
                return TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1");
            }
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)2L);
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replication-factor", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)2L);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(this.createOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$1 = createOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$1) {
                return x$1.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$3) {
                return x$3.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--create", "--zookeeper", "zk", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})).checkArgs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, createOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final TopicCommand.TopicCommandOptions createOpts$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().createTopic(this.createOpts$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.createOpts$2 = createOpts$2;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic(topic2, 2, (short)2), new NewTopic(topic3, 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic("__consumer_offsets", 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).values().get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).values().get(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$4) {
                return x$4.id();
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, alterOpts, topicService){
            public static final long serialVersionUID = 0L;
            private final TopicCommand.TopicCommandOptions alterOpts$1;
            private final TopicCommand.AdminClientTopicService topicService$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.topicService$1.alterTopic(this.alterOpts$1);
            }
            {
                this.alterOpts$1 = alterOpts$1;
                this.topicService$1 = topicService$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "1"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--partitions", "1", "--replication-factor", "1"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Map assignment2 = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(alterOpts);
        assignment2 = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$2) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder().append((Object)cleanupKey).append((Object)"=").append((Object)cleanupVal).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Properties after creation don't contain ").append((Object)cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Updated properties do not contain ").append((Object)cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.kafka$admin$TopicCommandWithAdminClientTest$$topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, deleteOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
            private final TopicCommand.TopicCommandOptions deleteOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().deleteTopic(this.deleteOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteOpts$1 = deleteOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)Predef$.MODULE$.refArrayOps((Object[])rows).size());
        rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic:", "\\tPartitionCount:2"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName())).all().get()).asScala()).apply((Object)this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(TopicPartitionInfo x$5) {
                    return x$5.leader().id() == 0;
                }
            }).get()).partition();
            this.killBroker(0);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partitionOnBroker0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;
                public final int partitionOnBroker0$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.$outer.servers().filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(KafkaServer x$6) {
                            return x$6.config().brokerId() == 0;
                        }
                    })).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1 $outer;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(boolean result, KafkaServer server) {
                            boolean x$31;
                            boolean x$30;
                            ListenerName x$29;
                            MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
                            scala.collection.immutable.Set x$28 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$$outer().kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
                            Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$28, x$29 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$30 = qual$1.getTopicMetadata$default$3(), x$31 = qual$1.getTopicMetadata$default$4());
                            Option testPartitionMetadata = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)topicMetadatas.find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1$$anonfun$apply$mcZ$sp$2 $outer;

                                public final boolean apply(MetadataResponse.TopicMetadata x$7) {
                                    return x$7.topic().equals(this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$anonfun$$$outer().kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$$outer().kafka$admin$TopicCommandWithAdminClientTest$$testTopicName());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).get()).partitionMetadata()).asScala()).find((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1$$anonfun$apply$mcZ$sp$2 $outer;

                                public final boolean apply(MetadataResponse.PartitionMetadata x$8) {
                                    return x$8.partition() == this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$anonfun$$$outer().partitionOnBroker0$1;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Option option = testPartitionMetadata;
                            if (None$.MODULE$.equals(option)) {
                                throw Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition metadata is not found in metadata cache"})).s((Seq)Nil$.MODULE$), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
                            }
                            if (!(option instanceof Some)) throw new MatchError((Object)option);
                            Some some = (Some)option;
                            MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)some.x();
                            if (!result) return false;
                            Errors errors = metadata.error();
                            Errors errors2 = Errors.LEADER_NOT_AVAILABLE;
                            if (errors != null) {
                                if (!errors.equals(errors2)) return false;
                                return true;
                            }
                            if (errors2 == null) return true;
                            return false;
                        }

                        public /* synthetic */ $anonfun$testDescribeUnavailablePartitions$1 kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }

                public /* synthetic */ TopicCommandWithAdminClientTest kafka$admin$TopicCommandWithAdminClientTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partitionOnBroker0$1 = partitionOnBroker0$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition metadata for ", " is not propagated"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--unavailable-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            Assert.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$9) {
                    return x$9.config().brokerId() == 0;
                }
            });
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$10) {
                    return x$10.config().brokerId() == 0;
                }
            });
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()}))));
            Assert.assertEquals((long)1L, (long)rows.length);
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KafkaServer x$11) {
                    return x$11.config().brokerId() == 0;
                }
            });
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{underMinIsrTopic}))));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tTopic: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offlineTopic}))));
            Assert.assertEquals((long)2L, (long)rows.length);
            return;
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Describe output should have contained ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config})), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output should have contained ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()})), (boolean)output.contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicCommandWithAdminClientTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$TopicCommandWithAdminClientTest$$topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((boolean)output.contains(this.kafka$admin$TopicCommandWithAdminClientTest$$testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    public final Nothing$ kafka$admin$TopicCommandWithAdminClientTest$$mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest$class.$init$(this);
        this.numPartitions = 1;
        this.defaultReplicationFactor = (short)1;
        this._testName = new TestName();
    }
}

