/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.api.ConsumerTopicCreationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011dQ8ogVlWM\u001d+pa&\u001c7I]3bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\u0005\t\u001b\u0001\u0011\t\u0011)A\u0005\u001d\u0005i\"M]8lKJ\fU\u000f^8U_BL7m\u0011:fCRLwN\\#oC\ndW\r\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\u000f\t{w\u000e\\3b]\"Aq\u0003\u0001B\u0001B\u0003%a\"A\u000fd_:\u001cX/\\3s\u00032dwn^!vi>\u001c%/Z1uKR{\u0007/[2t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\u00191\u0004H\u000f\u0011\u0005%\u0001\u0001\"B\u0007\u0019\u0001\u0004q\u0001\"B\f\u0019\u0001\u0004q\u0001\"B\u0010\u0001\t#\u0002\u0013a\u00032s_.,'oQ8v]R,\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0004\u0013:$\bb\u0002\u0015\u0001\u0005\u0004%\t!K\u0001\bi>\u0004\u0018nY02+\u0005Q\u0003CA\b,\u0013\ta\u0003C\u0001\u0004TiJLgn\u001a\u0005\u0007]\u0001\u0001\u000b\u0011\u0002\u0016\u0002\u0011Q|\u0007/[2`c\u0001Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011&A\u0004u_BL7m\u0018\u001a\t\rI\u0002\u0001\u0015!\u0003+\u0003!!x\u000e]5d?J\u0002\u0003b\u0002\u001b\u0001\u0005\u0004%\t!K\u0001\u0011aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012DaA\u000e\u0001!\u0002\u0013Q\u0013!\u00059s_\u0012,8-\u001a:DY&,g\u000e^%eA!9\u0001\b\u0001b\u0001\n\u0003I\u0013\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0011\u0019Q\u0004\u0001)A\u0005U\u0005\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\t\u000bq\u0002A\u0011A\u001f\u0002+Q,7\u000f^!vi>$v\u000e]5d\u0007J,\u0017\r^5p]R\ta\b\u0005\u0002#\u007f%\u0011\u0001i\t\u0002\u0005+:LG\u000f\u000b\u0002<\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%#%\u0001\u0002+fgRDC\u0001A&R%B\u0011AjT\u0007\u0002\u001b*\u0011a\nR\u0001\u0007eVtg.\u001a:\n\u0005Ak%a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bR\u0001\beVtg.\u001a:t\u0013\tAVKA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\u00065\nA\taW\u0001\u001a\u0007>t7/^7feR{\u0007/[2De\u0016\fG/[8o)\u0016\u001cH\u000f\u0005\u0002\n9\u001a)\u0011A\u0001E\u0001;N\u0011AL\u0018\t\u0003E}K!\u0001Y\u0012\u0003\r\u0005s\u0017PU3g\u0011\u0015IB\f\"\u0001c)\u0005Y\u0006\"\u00023]\t\u0003)\u0017A\u00039be\u0006lW\r^3sgV\ta\rE\u0002hU2l\u0011\u0001\u001b\u0006\u0003SJ\tA!\u001e;jY&\u00111\u000e\u001b\u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001\u0012n_&\u0011an\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001fAL!!\u001d\t\u0003\r=\u0013'.Z2uQ\u0019\u00197/a\u0002\u0002\nA\u0019A/!\u0001\u000f\u0005UthB\u0001<~\u001d\t9HP\u0004\u0002yw6\t\u0011P\u0003\u0002{\r\u00051AH]8pizJ\u0011aR\u0005\u0003\u000b\u001aK!A\u0016#\n\u0005},\u0016!\u0004)be\u0006lW\r^3sSj,G-\u0003\u0003\u0002\u0004\u0005\u0015!A\u0003)be\u0006lW\r^3sg*\u0011q0V\u0001\u0005]\u0006lW-\t\u0002\u0002\f\u0005\u0011$M]8lKJ$v\u000e]5d\u0007J,\u0017\r^5p]vZ\b' \u0017!G>t7/^7feR{\u0007/[2De\u0016\fG/[8o{m\fT\u0010")
public class ConsumerTopicCreationTest
extends IntegrationTestHarness {
    private final Boolean brokerAutoTopicCreationEnable;
    private final Boolean consumerAllowAutoCreateTopics;
    private final String topic_1;
    private final String topic_2;
    private final String producerClientId;
    private final String consumerClientId;

    @Parameterized.Parameters(name="brokerTopicCreation={0}, consumerTopicCreation={1}")
    public static Collection<Object[]> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic_1() {
        return this.topic_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Test
    public void testAutoTopicCreation() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, (short)1))).all().get();
        producer.send(record).get();
        consumer.subscribe(Arrays.asList((Object[])new String[]{this.topic_1(), this.topic_2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.consumer$1.poll(Duration.ofMillis(100L)).count() > 0;
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting to consume";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        boolean topicCreated = this.zkClient().getAllTopicsInCluster().contains((Object)this.topic_2());
        if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
            Assert.assertTrue((boolean)topicCreated);
        } else {
            Assert.assertFalse((boolean)topicCreated);
        }
    }

    public ConsumerTopicCreationTest(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
        this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), brokerAutoTopicCreationEnable.toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
    }
}

