/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.FixedPortTestUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u0011a\u0003\u0016:b]N\f7\r^5p]N\u0014u.\u001e8dKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u001b)\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,W#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\r\t\u0005\b?\u0001\u0011\r\u0011\"\u0003\u0016\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKNDa!\t\u0001!\u0002\u00131\u0012AF:feZ,'/T3tg\u0006<W-T1y\u0005f$Xm\u001d\u0011\t\u000f\r\u0002!\u0019!C\u0005+\u0005ia.^7QCJ$\u0018\u000e^5p]NDa!\n\u0001!\u0002\u00131\u0012A\u00048v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\bO\u0001\u0011\r\u0011\"\u0001\u0016\u0003)qW/\\*feZ,'o\u001d\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\f\u0002\u00179,XnU3sm\u0016\u00148\u000f\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003-yW\u000f\u001e9viR{\u0007/[2\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\t1\fgn\u001a\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0004TiJLgn\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0017\u0002\u0019=,H\u000f];u)>\u0004\u0018n\u0019\u0011\t\u000fa\u0002!\u0019!C\u0005Y\u0005Q\u0011N\u001c9viR{\u0007/[2\t\ri\u0002\u0001\u0015!\u0003.\u0003-Ig\u000e];u)>\u0004\u0018n\u0019\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001?!\ty$)D\u0001A\u0015\t\t\u0015'\u0001\u0003vi&d\u0017BA\"A\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002 \u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0003\"B$\u0001\t\u0003B\u0015aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003%\u00032AS'P\u001b\u0005Y%B\u0001'\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001d.\u00131aU3r!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0004tKJ4XM]\u0005\u0003)F\u00131bS1gW\u0006\u001cuN\u001c4jO\")a\u000b\u0001C\u0001/\u0006\tB/Z:u\u0005J|7.\u001a:GC&dWO]3\u0015\u0003a\u0003\"aF-\n\u0005iC\"\u0001B+oSRD#!\u0016/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017!\u00026v]&$(\"A1\u0002\u0007=\u0014x-\u0003\u0002d=\n!A+Z:u\u0011\u0015)\u0007\u0001\"\u0003g\u0003\t\u001a'/Z1uK\u000e{gn];nKJ\fe\u000eZ*vEN\u001c'/\u001b2f)>$v\u000e]5dgR1q\r_A\u0001\u0003;\u0001B\u0001\u001b9se6\t\u0011N\u0003\u0002kW\u0006A1m\u001c8tk6,'O\u0003\u0002m[\u000691\r\\5f]R\u001c(BA\u0003o\u0015\ty\u0007-\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003c&\u0014QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\bcA\ftk&\u0011A\u000f\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003/YL!a\u001e\r\u0003\t\tKH/\u001a\u0005\u0006s\u0012\u0004\rA_\u0001\bOJ|W\u000f]%e!\tYhP\u0004\u0002\u0018y&\u0011Q\u0010G\u0001\u0007!J,G-\u001a4\n\u0005Qz(BA?\u0019\u0011\u001d\t\u0019\u0001\u001aa\u0001\u0003\u000b\ta\u0001^8qS\u000e\u001c\b#BA\u0004\u0003/Qh\u0002BA\u0005\u0003'qA!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f1\u0011A\u0002\u001fs_>$h(C\u0001\u001a\u0013\r\t)\u0002G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI\"a\u0007\u0003\t1K7\u000f\u001e\u0006\u0004\u0003+A\u0002\"CA\u0010IB\u0005\t\u0019AA\u0011\u00035\u0011X-\u00193D_6l\u0017\u000e\u001e;fIB\u0019q#a\t\n\u0007\u0005\u0015\u0002DA\u0004C_>dW-\u00198\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\u0005a1M]3bi\u0016$v\u000e]5dgR\u0011\u0011Q\u0006\t\u0007\u0003_\t)D\u0006\f\u000e\u0005\u0005E\"bAA\u001a\u0017\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003o\t\tDA\u0002NCB4a!a\u000f\u0001\t\u0005u\"a\u0004\"pk:\u001cWmU2iK\u0012,H.\u001a:\u0014\t\u0005e\u0012q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00131\t\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\rC\u0004\u0010\u0003s!\t!!\u0014\u0015\u0005\u0005=\u0003\u0003BA)\u0003si\u0011\u0001\u0001\u0005\b\u0003+\nI\u0004\"\u0011X\u0003\u0019!wnV8sW\"9\u0011\u0011LA\u001d\t\u0003:\u0016\u0001C:ikR$wn\u001e8\t\u0013\u0005u\u0003!%A\u0005\n\u0005}\u0013\u0001L2sK\u0006$XmQ8ogVlWM]!oIN+(m]2sS\n,Gk\u001c+pa&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tG\u000b\u0003\u0002\"\u0005\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0004$\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TransactionsBounceTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final int numServers;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public int numServers() {
        return this.numServers;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsBounceTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerFailure() {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribeToTopics(consumerGroup, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.inputTopic()})), this.createConsumerAndSubscribeToTopics$default$3());
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, TestUtils$.MODULE$.createTransactionalProducer$default$4(), TestUtils$.MODULE$.createTransactionalProducer$default$5());
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        IntRef numMessagesProcessed = IntRef.create((int)0);
        IntRef iteration = IntRef.create((int)0);
        try {
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)new Serializable(this, numMessagesProcessed, iteration, toRead){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numMessagesProcessed$1;
                    private final IntRef iteration$1;
                    private final int toRead$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": About to read ", " messages, processed ", " so far.."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem), BoxesRunTime.boxToInteger((int)this.toRead$1), BoxesRunTime.boxToInteger((int)this.numMessagesProcessed$1.elem)}));
                    }
                    {
                        this.numMessagesProcessed$1 = numMessagesProcessed$1;
                        this.iteration$1 = iteration$1;
                        this.toRead$1 = toRead$1;
                    }
                });
                Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                this.trace((Function0<String>)new Serializable(this, records2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TransactionsBounceTest $outer;
                    private final Seq records$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received ", " messages, sending them transactionally to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size()), this.$outer.kafka$api$TransactionsBounceTest$$outputTopic()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.records$1 = records$1;
                    }
                });
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records2.foreach((Function1)new Serializable(this, producer, shouldAbort){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TransactionsBounceTest $outer;
                    private final KafkaProducer producer$1;
                    private final boolean shouldAbort$1;

                    public final Future<RecordMetadata> apply(ConsumerRecord<byte[], byte[]> record) {
                        return this.producer$1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.$outer.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), !this.shouldAbort$1), (Callback)new ErrorLoggingCallback(this.$outer.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.shouldAbort$1 = shouldAbort$1;
                    }
                });
                this.trace((Function0<String>)new Serializable(this, records2){
                    public static final long serialVersionUID = 0L;
                    private final Seq records$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sent ", " messages. Committing offsets."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size())}));
                    }
                    {
                        this.records$1 = records$1;
                    }
                });
                producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions(consumer)).asJava(), consumerGroup);
                if (shouldAbort) {
                    this.trace((Function0<String>)new Serializable(this, records2){
                        public static final long serialVersionUID = 0L;
                        private final Seq records$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed offsets. Aborting transaction of ", " messages."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size())}));
                        }
                        {
                            this.records$1 = records$1;
                        }
                    });
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)new Serializable(this, records2){
                        public static final long serialVersionUID = 0L;
                        private final Seq records$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed offsets. committing transaction of ", " messages."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.size())}));
                        }
                        {
                            this.records$1 = records$1;
                        }
                    });
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records2.size();
                }
                ++iteration.elem;
            }
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            var4_4.close();
            var3_3.close();
            throw throwable;
        }
        producer.close();
        consumer.close();
        scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$api$TransactionsBounceTest$$outputTopic()})), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).foreach((Function1)new Serializable(this, recordsByPartition){
            public static final long serialVersionUID = 0L;
            private final HashMap recordsByPartition$1;

            public final void apply(ConsumerRecord<byte[], byte[]> record) {
                int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue(record))).toInt();
                TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
                ((BufferLike)this.recordsByPartition$1.getOrElseUpdate((Object)topicPartition, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ListBuffer<Object> apply() {
                        return new ListBuffer();
                    }
                })).append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{value}));
            }
            {
                this.recordsByPartition$1 = recordsByPartition$1;
            }
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1)new Serializable(this, outputRecords){
            public static final long serialVersionUID = 0L;
            private final ListBuffer outputRecords$1;

            public final void apply(ListBuffer<Object> x0$1) {
                ListBuffer<Object> listBuffer = x0$1;
                Assert.assertEquals((String)"Out of order messages detected", listBuffer, (Object)listBuffer.sorted((Ordering)Ordering.Int$.MODULE$));
                this.outputRecords$1.appendAll(listBuffer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.outputRecords$1 = outputRecords$1;
            }
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        Set expectedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numInputRecords).toSet();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing messages: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedValues.$minus$minus((GenTraversableOnce)recordSet)})), (Object)expectedValues, (Object)recordSet);
        verifyingConsumer.close();
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribeToTopics(String groupId, List<String> topics, boolean readCommitted) {
        String x$2 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$3 = groupId;
        boolean x$4 = readCommitted;
        boolean x$5 = false;
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$12 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$2, x$3, x$6, x$5, x$4, x$7, x$8, x$9, x$10, x$11, x$12);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribeToTopics$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.numServers = 4;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BounceScheduler $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.trace((Function0)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Shutting down server : %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.server$1.config().brokerId())}));
                        }
                        {
                            this.server$1 = server$1;
                        }
                    });
                    server.shutdown();
                    server.awaitShutdown();
                    Thread.sleep(500L);
                    this.$outer.trace((Function0)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Server %s shut down. Starting it up again.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.server$1.config().brokerId())}));
                        }
                        {
                            this.server$1 = server$1;
                        }
                    });
                    server.startup();
                    this.$outer.trace((Function0)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Restarted server: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.server$1.config().brokerId())}));
                        }
                        {
                            this.server$1 = server$1;
                        }
                    });
                    Thread.sleep(500L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BounceScheduler $outer;

                public final int apply(int partition) {
                    return this.apply$mcII$sp(partition);
                }

                public int apply$mcII$sp(int partition) {
                    return TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.$outer.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.$outer.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), partition, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

