/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u000f\t)\u0003+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\!mO>\u0014\u0018\u000e\u001e5ngR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\nU\t\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u+\u00051\u0002C\u0001\n\u0018\u0013\tA\"AA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqRDqA\u0007\u0001A\u0002\u0013%1$A\u000bd_:$(o\u001c7mKJ\u001cuN\u001c;fqR|F%Z9\u0015\u0005qy\u0002CA\u0005\u001e\u0013\tq\"B\u0001\u0003V]&$\bb\u0002\u0011\u001a\u0003\u0003\u0005\rAF\u0001\u0004q\u0012\n\u0004B\u0002\u0012\u0001A\u0003&a#\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003\"\u0002\u0013\u0001\t\u0003)\u0013!B:fiV\u0003H#\u0001\u000f)\u0005\r:\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015QWO\\5u\u0015\u0005a\u0013aA8sO&\u0011a&\u000b\u0002\u0007\u0005\u00164wN]3\t\u000bA\u0002A\u0011A\u0013\u0002EQ,7\u000f^(gM2Lg.\u001a)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8oQ\ty#\u0007\u0005\u0002)g%\u0011A'\u000b\u0002\u0005)\u0016\u001cH\u000fC\u00037\u0001\u0011\u0005Q%A'uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c'bgRL5O](gM2Lg.Z+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3)\u0005U\u0012\u0004\"B\u001d\u0001\t\u0003)\u0013\u0001\u0014;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eT1ti&\u001b(o\u00144gY&tW-\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,G\r\u000b\u00029e!)A\b\u0001C\u0001K\u0005\u0019C/Z:u%\u0016\f7o]5h]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007FA\u001e3\u0011\u0015y\u0004\u0001\"\u0001&\u0003A\"Xm\u001d;SK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5O_2Kg/Z%te\"\u0012aH\r\u0005\u0006\u0005\u0002!\t!J\u00010i\u0016\u001cHOU3bgNLwM\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\b.R7qifL5O\u001d\u0015\u0003\u0003JBQ!\u0012\u0001\u0005\u0002\u0015\n1\u0006^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\tJBQ\u0001\u0013\u0001\u0005\u0002\u0015\nq\t^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u0013:L5O\u001d(pi2Kg/\u001a\u0015\u0003\u000fJBQa\u0013\u0001\u0005\u0002\u0015\nq\t^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u001d>$\u0018J\\%te2Kg/\u001a\u0015\u0003\u0015JBQA\u0014\u0001\u0005\u0002\u0015\n!\n^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u001d>$\u0018J\\%te:{G\u000fT5wK\"\u0012QJ\r\u0005\u0006#\u0002!\t!J\u0001.i\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007F\u0001)3\u0011\u0015!\u0006\u0001\"\u0001&\u0003\u0001#Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c'bgRL5O]*ikR$\u0018N\\4E_^t\u0007FA*3\u0011\u00159\u0006\u0001\"\u0001&\u0003%#Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\!mY&\u001b(oU5nk2$\u0018M\\3pkNd\u0017p\u00155vi\u0012|wO\u001c\u0015\u0003-J\u0002")
public class PartitionLeaderElectionAlgorithmsTest {
    private ControllerContext controllerContext = null;

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        ControllerStats qual$1 = this.controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    @Test
    public void testOfflinePartitionLeaderElection() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment2, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionDisabled() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment2, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
        Assert.assertEquals((long)0L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabled() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment2, isr, liveReplicas, true, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
        Assert.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testReassignPartitionLeaderElection() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithEmptyIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElection() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaInIsrNotLive() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLive() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrNotLive() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment2, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElection() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment2, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionLastIsrShuttingDown() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment2, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionAllIsrSimultaneouslyShutdown() {
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment2, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }
}

