/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.log.BrokerCompressionTest$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001\u001d\u0011QC\u0011:pW\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aD\u0001b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001\u0013[\u0016\u001c8/Y4f\u0007>l\u0007O]3tg&|g\u000e\u0005\u0002\u0012)9\u0011\u0011BE\u0005\u0003')\ta\u0001\u0015:fI\u00164\u0017BA\u000b\u0017\u0005\u0019\u0019FO]5oO*\u00111C\u0003\u0005\t1\u0001\u0011\t\u0011)A\u0005!\u0005\t\"M]8lKJ\u001cu.\u001c9sKN\u001c\u0018n\u001c8\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\rabd\b\t\u0003;\u0001i\u0011A\u0001\u0005\u0006\u001fe\u0001\r\u0001\u0005\u0005\u00061e\u0001\r\u0001\u0005\u0005\bC\u0001\u0011\r\u0011\"\u0001#\u0003\u0019!X\u000e\u001d#jeV\t1\u0005\u0005\u0002%S5\tQE\u0003\u0002'O\u0005\u0011\u0011n\u001c\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0003GS2,\u0007B\u0002\u0017\u0001A\u0003%1%A\u0004u[B$\u0015N\u001d\u0011\t\u000f9\u0002!\u0019!C\u0001E\u00051An\\4ESJDa\u0001\r\u0001!\u0002\u0013\u0019\u0013a\u00027pO\u0012K'\u000f\t\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003\u0011!\u0018.\\3\u0016\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005e2$\u0001C'pG.$\u0016.\\3\t\rm\u0002\u0001\u0015!\u00035\u0003\u0015!\u0018.\\3!\u0011\u001di\u0004A1A\u0005\u0002y\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003}\u0002\"!\b!\n\u0005\u0005\u0013!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0019\u0005\u0001)A\u0005\u007f\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u0012\t\u0003\u0013!K!!\u0013\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t.\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\u000b),h.\u001b;\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011VJA\u0003BMR,'\u000fC\u0003U\u0001\u0011\u0005a)A\ruKN$(I]8lKJ\u001c\u0016\u000eZ3D_6\u0004(/Z:tS>t\u0007FA*W!\tau+\u0003\u0002Y\u001b\n!A+Z:uQ\u0011\u0001!\fY1\u0011\u0005msV\"\u0001/\u000b\u0005uk\u0015A\u0002:v]:,'/\u0003\u0002`9\n9!+\u001e8XSRD\u0017!\u0002<bYV,7%\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015l\u0015a\u0002:v]:,'o]\u0005\u0003O\u0012\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$w!B5\u0003\u0011\u0003Q\u0017!\u0006\"s_.,'oQ8naJ,7o]5p]R+7\u000f\u001e\t\u0003;-4Q!\u0001\u0002\t\u00021\u001c\"a\u001b\u0005\t\u000biYG\u0011\u00018\u0015\u0003)DQ\u0001]6\u0005\u0002E\f!\u0002]1sC6,G/\u001a:t+\u0005\u0011\bcA:wq6\tAO\u0003\u0002vO\u0005!Q\u000f^5m\u0013\t9HO\u0001\u0006D_2dWm\u0019;j_:\u00042!C=\u0011\u0013\tQ(BA\u0003BeJ\f\u0017\u0010\u000b\u0002pyB\u0019Q0a\u0005\u000f\u0007y\fyAD\u0002\u0000\u0003\u001bqA!!\u0001\u0002\f9!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u0019\ta\u0001\u0010:p_Rt\u0014\"\u0001)\n\u00059{\u0015BA3N\u0013\r\t\t\u0002Z\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\u0005U\u0011q\u0003\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(bAA\tI\u0002")
public class BrokerCompressionTest {
    private final String messageCompression;
    private final String brokerCompression;
    private final File tmpDir;
    private final File logDir;
    private final MockTime time;
    private final LogConfig logConfig;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBrokerSideCompression() {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(this.messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), this.brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log2 = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        log2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.forId((int)messageCompressionCode.codec()), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        if (this.brokerCompression.equals("producer")) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Compression at offset 0 should produce ").append((Object)messageCompressionCode.name()).toString(), (long)messageCompressionCode.codec(), (long)this.readBatch$1((int)0, (Log)log2).compressionType().id);
        } else {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(this.brokerCompression);
            Assert.assertEquals((String)new StringBuilder().append((Object)"Compression at offset 0 should produce ").append((Object)brokerCompressionCode.name()).toString(), (long)brokerCompressionCode.codec(), (long)this.readBatch$1((int)0, (Log)log2).compressionType().id);
        }
    }

    private final RecordBatch readBatch$1(int offset, Log log$1) {
        FetchDataInfo fetchInfo = log$1.read((long)offset, 4096, (FetchIsolation)FetchLogEnd$.MODULE$, true);
        return (RecordBatch)fetchInfo.records().batches().iterator().next();
    }

    public BrokerCompressionTest(String messageCompression, String brokerCompression) {
        this.messageCompression = messageCompression;
        this.brokerCompression = brokerCompression;
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.time = new MockTime(0L, 0L);
        this.logConfig = LogConfig$.MODULE$.apply();
    }
}

