/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerParameterizedIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001\u001d\u0011a\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t\t\u0013IY:ue\u0006\u001cG\u000fT8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti\"AQ\u0002\u0001B\u0001B\u0003%a\"\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011q\"\u0006\b\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#E\u0001\u0007!J,G-\u001a4\n\u0005Y9\"AB*ue&twM\u0003\u0002\u0015#!)\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\"a\u0007\u000f\u0011\u0005%\u0001\u0001\"B\u0007\u0019\u0001\u0004q\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0006G>$WmY\u000b\u0002AA\u0011\u0011eK\u0007\u0002E)\u00111\u0005J\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005\u00152\u0013AB2p[6|gN\u0003\u0002\u0006O)\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta#EA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0011\u0019q\u0003\u0001)A\u0005A\u000511m\u001c3fG\u0002Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011'\u0001\u0003uS6,W#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0011!B;uS2\u001c\u0018BA\u001c5\u0005!iunY6US6,\u0007BB\u001d\u0001A\u0003%!'A\u0003uS6,\u0007\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\u0010\t\u0004!y\u0002\u0015BA \u0012\u0005\u0015\t%O]1z!\t\t%)D\u0001%\u0013\t\u0019EE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\u0015\u0003\u0001\u0015!\u0003>\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0003H\u0001\u0011\u0005\u0001*A\u0006dY\u0016\fg.\u001a:UKN$H#A%\u0011\u0005AQ\u0015BA&\u0012\u0005\u0011)f.\u001b;)\u0005\u0019k\u0005C\u0001(R\u001b\u0005y%B\u0001)*\u0003\u0015QWO\\5u\u0013\t\u0011vJ\u0001\u0003UKN$\b\"\u0002+\u0001\t\u0003A\u0015a\n;fgR\u001cE.Z1og\u000e{WNY5oK\u0012\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\rV8qS\u000eD#aU'\t\u000b]\u0003A\u0011\u0001%\u0002=Q,7\u000f^\"mK\u0006tWM],ji\"lUm]:bO\u00164uN]7biZ\u0003\u0004F\u0001,N\u0011\u0015Q\u0006\u0001\"\u0001I\u00039\"Xm\u001d;DY\u0016\fg.\u001b8h\u001d\u0016\u001cH/\u001a3NKN\u001c\u0018mZ3t/&$\b.T;mi&\u0004H.\u001a,feNLwN\\:)\u0005ek\u0005\"B/\u0001\t\u0003A\u0015aF2mK\u0006tWM]\"p]\u001aLw-\u00169eCR,G+Z:uQ\taV\nC\u0003a\u0001\u0011%\u0011-\u0001\tdQ\u0016\u001c7\u000eT1ti\u000ecW-\u00198fIR!\u0011J\u00193j\u0011\u0015\u0019w\f1\u0001\u000f\u0003\u0015!x\u000e]5d\u0011\u0015)w\f1\u0001g\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u0005A9\u0017B\u00015\u0012\u0005\rIe\u000e\u001e\u0005\u0006U~\u0003\ra[\u0001\u000bM&\u00148\u000f\u001e#jeRL\bC\u0001\tm\u0013\ti\u0017C\u0001\u0003M_:<\u0007\"B8\u0001\t\u0013\u0001\u0018AG2iK\u000e\\Gj\\4BMR,'/\u00119qK:$\u0017N\\4EkB\u001cH\u0003B%rk^DQa\u00018A\u0002I\u0004\"!C:\n\u0005Q\u0014!a\u0001'pO\")aO\u001ca\u0001W\u0006I1\u000f^1siNK'0\u001a\u0005\u0006q:\u0004\r!_\u0001\bCB\u0004XM\u001c3t!\rQXp`\u0007\u0002w*\u0011A0E\u0001\u000bG>dG.Z2uS>t\u0017B\u0001@|\u0005\r\u0019V-\u001d\t\u0007!\u0005\u0005aMD6\n\u0007\u0005\r\u0011C\u0001\u0004UkBdWm\r\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0003\u0015!x.T1q)\u0011\tY!a\u0006\u0011\ri\fiAZA\t\u0013\r\tya\u001f\u0002\u0004\u001b\u0006\u0004\b#\u0002\t\u0002\u00149Y\u0017bAA\u000b#\t1A+\u001e9mKJB\u0001\"!\u0007\u0002\u0006\u0001\u0007\u00111D\u0001\t[\u0016\u001c8/Y4fgB!!0!\b\u0000\u0013\r\tyb\u001f\u0002\t\u0013R,'/\u00192mK\"9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0012a\u0003:fC\u00124%o\\7M_\u001e$B!a\u0007\u0002(!11!!\tA\u0002IDq!a\u000b\u0001\t\u0013\ti#A\rxe&$X\rR;qgNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$H#D=\u00020\u0005M\u0012qGA\u001d\u0003w\ty\u0004C\u0004\u00022\u0005%\u0002\u0019\u00014\u0002\u000f9,XnS3zg\"9\u0011QGA\u0015\u0001\u00041\u0017a\u00028v[\u0012+\bo\u001d\u0005\u0007\u0007\u0005%\u0002\u0019\u0001:\t\ry\tI\u00031\u0001!\u0011%\ti$!\u000b\u0011\u0002\u0003\u0007a-\u0001\u0005ti\u0006\u0014HoS3z\u0011!\t\t%!\u000bA\u0002\u0005\r\u0013AC7bO&\u001cg+\u00197vKB\u0019\u0001#!\u0012\n\u0007\u0005\u001d\u0013C\u0001\u0003CsR,\u0007\"CA&\u0001E\u0005I\u0011BA'\u0003\r:(/\u001b;f\tV\u00048oU5oO2,W*Z:tC\u001e,7+\u001a;%I\u00164\u0017-\u001e7uIU*\"!a\u0014+\u0007\u0019\f\tf\u000b\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!C;oG\",7m[3e\u0015\r\ti&E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA1\u0003/\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2fQ\u001d\u0001\u0011QMA9\u0003g\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wz\u0015A\u0002:v]:,'/\u0003\u0003\u0002p\u0005%$a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003k\u0002B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wz\u0015a\u0002:v]:,'o]\u0005\u0005\u0003\u007f\nIHA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0003\u0007\u0013\u0001\u0012AAC\u0003\u0019bunZ\"mK\u0006tWM\u001d)be\u0006lW\r^3sSj,G-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0004\u0013\u0005\u001deAB\u0001\u0003\u0011\u0003\tIi\u0005\u0003\u0002\b\u0006-\u0005c\u0001\t\u0002\u000e&\u0019\u0011qR\t\u0003\r\u0005s\u0017PU3g\u0011\u001dI\u0012q\u0011C\u0001\u0003'#\"!!\"\t\u0011\u0005]\u0015q\u0011C\u0001\u00033\u000b!\u0002]1sC6,G/\u001a:t+\t\tY\n\u0005\u0004\u0002\u001e\u0006\u001d\u00161V\u0007\u0003\u0003?SA!!)\u0002$\u0006!Q\u000f^5m\u0015\t\t)+\u0001\u0003kCZ\f\u0017\u0002BAU\u0003?\u0013!bQ8mY\u0016\u001cG/[8o!\r\u0001bH\u0004\u0015\u0005\u0003+\u000by\u000b\u0005\u0003\u00022\u0006%g\u0002BAZ\u0003\u000btA!!.\u0002D:!\u0011qWAa\u001d\u0011\tI,a0\u000e\u0005\u0005m&bAA_\r\u00051AH]8pizJ\u0011AK\u0005\u0003!&J1!a\u001fP\u0013\u0011\t9-!\u001f\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\tY-!4\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0002H\u0006e\u0004")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerParameterizedIntegrationTest$.MODULE$.parameters();
    }

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$12 = maxMessageSize;
            float x$13 = this.makeCleaner$default$2();
            int x$14 = this.makeCleaner$default$3();
            long x$15 = this.makeCleaner$default$4();
            long x$16 = this.makeCleaner$default$6();
            int x$17 = this.makeCleaner$default$7();
            int x$18 = this.makeCleaner$default$8();
            long x$19 = this.makeCleaner$default$9();
            Option<Object> x$20 = this.makeCleaner$default$10();
            Properties x$21 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$11, x$13, x$14, x$15, x$12, x$16, x$17, x$18, x$19, x$20, x$21));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
            int x$22 = largeMessageKey + 1;
            int x$23 = 100;
            int x$24 = 3;
            Log x$25 = log2;
            CompressionType x$26 = this.codec();
            byte x$27 = this.writeDups$default$6();
            Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$23, x$24, x$25, x$26, x$22, x$27);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 != null) {
            Log log2;
            Log log3;
            Log log4 = log3 = (log2 = (Log)tuple2._1());
            long endOffset = log4.logEndOffset();
            log4.logSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerParameterizedIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final Path apply(LogSegment x$4) {
                    return x$4.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log4, endOffset){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long endOffset$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$1.logStartOffset() == this.endOffset$1;
                }
                {
                    this.log$1 = log$1;
                    this.endOffset$1 = endOffset$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Timed out waiting for deletion of old segments";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((long)1L, (long)log4.numberOfSegments());
            this.cleaner().shutdown();
            Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
            if (tuple22 != null) {
                Tuple2 tuple23;
                Log log22 = (Log)tuple22._1();
                Seq messages = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)log22, (Object)messages);
                Log log23 = (Log)tuple24._1();
                Seq messages2 = (Seq)tuple24._2();
                Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
                Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            CompressionType compressionType3 = this.codec();
            int n = CompressionType.NONE.equals(compressionType3) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            WrappedArray x$39 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            int x$40 = maxMessageSize;
            float x$41 = this.makeCleaner$default$2();
            int x$42 = this.makeCleaner$default$3();
            long x$43 = this.makeCleaner$default$4();
            long x$44 = this.makeCleaner$default$6();
            int x$45 = this.makeCleaner$default$7();
            int x$46 = this.makeCleaner$default$8();
            long x$47 = this.makeCleaner$default$9();
            Option<Object> x$48 = this.makeCleaner$default$10();
            Properties x$49 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$39, x$41, x$42, x$43, x$40, x$44, x$45, x$46, x$47, x$48, x$49));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            int x$50 = maxMessageSize;
            Properties x$51 = this.logConfigProperties$default$1();
            float x$52 = this.logConfigProperties$default$3();
            long x$53 = this.logConfigProperties$default$4();
            int x$54 = this.logConfigProperties$default$5();
            int x$55 = this.logConfigProperties$default$6();
            long x$56 = this.logConfigProperties$default$7();
            Properties props = this.logConfigProperties(x$51, x$50, x$52, x$53, x$54, x$55, x$56);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
            int x$57 = 100;
            int x$58 = 3;
            Log x$59 = log2;
            CompressionType x$60 = this.codec();
            byte x$61 = 0;
            int x$62 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$57, x$58, x$59, x$60, x$62, x$61);
            long startSize = log2.size();
            this.cleaner().startup();
            long firstDirty = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$7) {
                    return x$7.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log2, startSize, appends);
            int x$63 = 40;
            int x$64 = 3;
            Log x$65 = log2;
            CompressionType x$66 = this.codec();
            byte x$67 = 0;
            int x$68 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$63, x$64, x$65, x$66, x$68, x$67);
            LogAppendInfo appendInfo = log2.appendAsLeader(largeMessageSet2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
            long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get());
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
            log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
            int x$69 = 30;
            int x$70 = 40;
            int x$71 = 3;
            Log x$72 = log2;
            CompressionType x$73 = this.codec();
            byte x$74 = 1;
            Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$70, x$71, x$72, x$73, x$69, x$74);
            int x$75 = 15;
            int x$76 = 5;
            int x$77 = 3;
            Log x$78 = log2;
            CompressionType x$79 = this.codec();
            byte x$80 = 2;
            Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$76, x$77, x$78, x$79, x$75, x$80);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log2.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        CompressionType compressionType = this.codec();
        CompressionType compressionType2 = CompressionType.ZSTD;
        if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null)) {
            return;
        }
        int maxMessageSize = 192;
        WrappedArray x$81 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$82 = maxMessageSize;
        int x$83 = 256;
        float x$84 = this.makeCleaner$default$2();
        int x$85 = this.makeCleaner$default$3();
        long x$86 = this.makeCleaner$default$4();
        long x$87 = this.makeCleaner$default$6();
        int x$88 = this.makeCleaner$default$7();
        long x$89 = this.makeCleaner$default$9();
        Option<Object> x$90 = this.makeCleaner$default$10();
        Properties x$91 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$81, x$84, x$85, x$86, x$82, x$87, x$88, x$83, x$89, x$90, x$91));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$92 = maxMessageSize;
        int x$93 = 256;
        Properties x$94 = this.logConfigProperties$default$1();
        float x$95 = this.logConfigProperties$default$3();
        long x$96 = this.logConfigProperties$default$4();
        int x$97 = this.logConfigProperties$default$5();
        long x$98 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$94, x$92, x$95, x$96, x$97, x$93, x$98);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$99 = 2;
        int x$100 = 3;
        Log x$101 = log2;
        CompressionType x$102 = this.codec();
        byte x$103 = 0;
        int x$104 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$99, x$100, x$101, x$102, x$104, x$103);
        int x$105 = 2;
        int x$106 = 3;
        int x$107 = 2;
        Log x$108 = log2;
        CompressionType x$109 = this.codec();
        byte x$110 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$105, x$107, x$108, x$109, x$106, x$110), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log2.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$111 = 4;
        int x$112 = 2;
        int x$113 = 2;
        Log x$114 = log2;
        CompressionType x$115 = this.codec();
        byte x$116 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$112, x$113, x$114, x$115, x$111, x$116);
        int x$117 = 4;
        int x$118 = 2;
        int x$119 = 2;
        Log x$120 = log2;
        CompressionType x$121 = this.codec();
        byte x$122 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$118, x$119, x$120, x$121, x$117, x$122), Seq$.MODULE$.canBuildFrom());
        int x$123 = 6;
        int x$124 = 2;
        int x$125 = 2;
        Log x$126 = log2;
        CompressionType x$127 = this.codec();
        byte x$128 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$124, x$125, x$126, x$127, x$123, x$128), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log2.size();
        this.cleaner().startup();
        long firstDirty = log2.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log2, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    @Test
    public void cleanerConfigUpdateTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            WrappedArray x$129 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
            long x$130 = 1L;
            int x$131 = maxMessageSize;
            Some x$132 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            float x$133 = this.makeCleaner$default$2();
            int x$134 = this.makeCleaner$default$3();
            long x$135 = this.makeCleaner$default$6();
            int x$136 = this.makeCleaner$default$7();
            int x$137 = this.makeCleaner$default$8();
            long x$138 = this.makeCleaner$default$9();
            Properties x$139 = this.makeCleaner$default$11();
            this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$129, x$133, x$134, x$130, x$131, x$135, x$136, x$137, x$138, (Option<Object>)x$132, x$139));
            Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
            this.writeDups(100, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log2.size();
            this.cleaner().startup();
            Assert.assertEquals((long)1L, (long)this.cleaner().cleanerCount());
            long firstDirty = log2.activeSegment().baseOffset();
            TopicPartition topicPartition = new TopicPartition("log", 0);
            this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
            Assert.assertTrue((String)"Should not have cleaned", (boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty());
            KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
            KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()));
            this.cleaner().reconfigure(oldConfig, newConfig);
            Assert.assertEquals((long)2L, (long)this.cleaner().cleanerCount());
            this.checkLastCleaned("log", 0, firstDirty);
            int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LogSegment x$10) {
                    return x$10.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(tuple2);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$140 = topicPartition;
        long x$141 = firstDirty;
        long x$142 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$140, x$141, x$142);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log2, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log2);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log2.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, Object>> apply(Tuple3<Object, String, Object> x0$1) {
                Tuple3<Object, String, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    String value = (String)tuple3._2();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, String, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, String, Object> apply(Record deepLogEntry) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log2, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, startKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerParameterizedIntegrationTest $outer;
            private final int numKeys$1;
            private final int startKey$1;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerParameterizedIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.kafka$log$LogCleanerParameterizedIntegrationTest$$anonfun$$$outer().incCounter();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerParameterizedIntegrationTest kafka$log$LogCleanerParameterizedIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.startKey$1 = startKey$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records2 = (IndexedSeq)kvs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    String payload = (String)tuple2._2();
                    SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log2.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().get()))).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(Tuple2<Tuple2<Object, String>, Object> x0$3) {
                Tuple2<Tuple2<Object, String>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 kv = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$28 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions()).take(1));
        Properties x$29 = logProps$1;
        long x$30 = 100L;
        float x$31 = this.makeCleaner$default$2();
        int x$32 = this.makeCleaner$default$3();
        int x$33 = this.makeCleaner$default$5();
        long x$34 = this.makeCleaner$default$6();
        int x$35 = this.makeCleaner$default$7();
        int x$36 = this.makeCleaner$default$8();
        long x$37 = this.makeCleaner$default$9();
        Option<Object> x$38 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$28, x$31, x$32, x$30, x$33, x$34, x$35, x$36, x$37, x$38, x$29));
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log2, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log2.size();
        log2.updateHighWatermark(log2.logEndOffset());
        long firstDirty = log2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log2, messages);
    }

    private final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.numThreads())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.dedupeBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.dedupeBufferLoadFactor())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.ioBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.maxMessageSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.backOffMs())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.maxIoBytesPerSecond())).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public LogCleanerParameterizedIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

