/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.CorruptIndexException;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u000f\tiA+[7f\u0013:$W\r\u001f+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\u0001\u0007I\u0011A\u000b\u0002\u0007%$\u00070F\u0001\u0017!\t\u0011r#\u0003\u0002\u0019\u0005\tIA+[7f\u0013:$W\r\u001f\u0005\b5\u0001\u0001\r\u0011\"\u0001\u001c\u0003\u001dIG\r_0%KF$\"\u0001H\u0010\u0011\u0005%i\u0012B\u0001\u0010\u000b\u0005\u0011)f.\u001b;\t\u000f\u0001J\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\t\u0002\u0001\u0015)\u0003\u0017\u0003\u0011IG\r\u001f\u0011\t\u000f\u0011\u0002!\u0019!C\u0001K\u0005QQ.\u0019=F]R\u0014\u0018.Z:\u0016\u0003\u0019\u0002\"!C\u0014\n\u0005!R!aA%oi\"1!\u0006\u0001Q\u0001\n\u0019\n1\"\\1y\u000b:$(/[3tA!9A\u0006\u0001b\u0001\n\u0003i\u0013A\u00032bg\u0016|eMZ:fiV\ta\u0006\u0005\u0002\n_%\u0011\u0001G\u0003\u0002\u0005\u0019>tw\r\u0003\u00043\u0001\u0001\u0006IAL\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b\u0005C\u00035\u0001\u0011\u0005Q'A\u0003tKR,\b\u000fF\u0001\u001dQ\t\u0019t\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005)!.\u001e8ji*\tA(A\u0002pe\u001eL!AP\u001d\u0003\r\t+gm\u001c:f\u0011\u0015\u0001\u0005\u0001\"\u00016\u0003!!X-\u0019:e_^t\u0007FA C!\tA4)\u0003\u0002Es\t)\u0011I\u001a;fe\")a\t\u0001C\u0001k\u0005QA/Z:u\u0019>|7.\u00169)\u0005\u0015C\u0005C\u0001\u001dJ\u0013\tQ\u0015H\u0001\u0003UKN$\b\"\u0002'\u0001\t\u0003)\u0014!\u0003;fgR,e\u000e\u001e:zQ\tY\u0005\nC\u0003P\u0001\u0011\u0005Q'A\tuKN$XI\u001c;ss>3XM\u001d4m_^DCA\u0014%R%\u0006AQ\r\u001f9fGR,GmI\u0001T!\t!FL\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001LB\u0001\u0007yI|w\u000e\u001e \n\u0003-I!a\u0017\u0006\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'BA.\u000b\u0011\u0015\u0001\u0007\u0001\"\u00016\u00031!Xm\u001d;UeVt7-\u0019;fQ\ty\u0006\nC\u0003d\u0001\u0011\u0005Q'\u0001\u0006uKN$\u0018\t\u001d9f]\u0012D#A\u0019%\t\u000b\u0019\u0004A\u0011B4\u0002\u001b\u0005\u0004\b/\u001a8e\u000b:$(/[3t)\ta\u0002\u000eC\u0003jK\u0002\u0007a%\u0001\u0006ok6,e\u000e\u001e:jKNDQa\u001b\u0001\u0005\u00021\f1C\\8o\u000bbL7\u000f^1oiR+W\u000e\u001d$jY\u0016$\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\f!![8\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u0005\r&dW\rC\u0003w\u0001\u0011\u0005Q'A\buKN$8+\u00198jif\u001c\u0005.Z2lQ\t)\b\n")
public class TimeIndexTest {
    private TimeIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public TimeIndex idx() {
        return this.idx;
    }

    public void idx_$eq(TimeIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new TimeIndex(this.nonExistantTempFile(), this.baseOffset(), this.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void testLookUp() {
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(100L));
        this.appendEntries(this.maxEntries() - 1);
        Assert.assertEquals((Object)new TimestampOffset(-1L, this.baseOffset()), (Object)this.idx().lookup(9L));
        Assert.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().lookup(25L));
        Assert.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().lookup(30L));
    }

    @Test
    public void testEntry() {
        this.appendEntries(this.maxEntries() - 1);
        Assert.assertEquals((Object)new TimestampOffset(10L, 55L), (Object)this.idx().entry(0));
        Assert.assertEquals((Object)new TimestampOffset(20L, 65L), (Object)this.idx().entry(1));
        Assert.assertEquals((Object)new TimestampOffset(30L, 75L), (Object)this.idx().entry(2));
        Assert.assertEquals((Object)new TimestampOffset(40L, 85L), (Object)this.idx().entry(3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void testTruncate() {
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncate();
        Assert.assertEquals((long)0L, (long)this.idx().entries());
        this.appendEntries(this.maxEntries() - 1);
        this.idx().truncateTo(10L + this.baseOffset());
        Assert.assertEquals((long)0L, (long)this.idx().entries());
    }

    @Test
    public void testAppend() {
        this.appendEntries(this.maxEntries() - 1);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TimeIndex qual$1 = this.$outer.idx();
                long x$1 = 10000L;
                long x$2 = 1000L;
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.idx().maybeAppend(10000L, (long)((this.$outer.maxEntries() - 2) * 10), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(InvalidOffsetException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.idx().maybeAppend(10000L, 1000L, true);
    }

    private void appendEntries(int numEntries) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numEntries).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndexTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TimeIndex qual$2 = this.$outer.idx();
                long x$4 = i * 10;
                long x$5 = (long)(i * 10) + this.$outer.baseOffset();
                boolean x$6 = qual$2.maybeAppend$default$3();
                qual$2.maybeAppend(x$4, x$5, x$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistantTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        file.delete();
        return var1_1;
    }

    @Test
    public void testSanityCheck() {
        this.idx().sanityCheck();
        this.appendEntries(5);
        TimestampOffset firstEntry = this.idx().entry(0);
        this.idx().sanityCheck();
        this.idx().close();
        BooleanRef shouldCorruptOffset = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptTimestamp = BooleanRef.create((boolean)false);
        BooleanRef shouldCorruptLength = BooleanRef.create((boolean)false);
        this.idx_$eq(new TimeIndex(this, firstEntry, shouldCorruptOffset, shouldCorruptTimestamp, shouldCorruptLength){
            private final TimestampOffset firstEntry$1;
            private final BooleanRef shouldCorruptOffset$1;
            private final BooleanRef shouldCorruptTimestamp$1;
            private final BooleanRef shouldCorruptLength$1;

            public TimestampOffset lastEntry() {
                TimestampOffset superLastEntry = super.lastEntry();
                long offset = this.shouldCorruptOffset$1.elem ? this.baseOffset() - 1L : superLastEntry.offset();
                long timestamp = this.shouldCorruptTimestamp$1.elem ? this.firstEntry$1.timestamp() - 1L : superLastEntry.timestamp();
                return new TimestampOffset(timestamp, offset);
            }

            public long length() {
                long superLength = super.length();
                return this.shouldCorruptLength$1.elem ? superLength - 1L : superLength;
            }
            {
                this.firstEntry$1 = firstEntry$1;
                this.shouldCorruptOffset$1 = shouldCorruptOffset$1;
                this.shouldCorruptTimestamp$1 = shouldCorruptTimestamp$1;
                this.shouldCorruptLength$1 = shouldCorruptLength$1;
                super($outer.idx().file(), $outer.baseOffset(), $outer.maxEntries() * 12, TimeIndex$.MODULE$.$lessinit$greater$default$4());
            }
        });
        shouldCorruptOffset.elem = true;
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.idx().sanityCheck();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        shouldCorruptOffset.elem = false;
        shouldCorruptTimestamp.elem = true;
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.idx().sanityCheck();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        shouldCorruptTimestamp.elem = false;
        shouldCorruptLength.elem = true;
        Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.idx().sanityCheck();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(CorruptIndexException.class), new Position("TimeIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        shouldCorruptLength.elem = false;
        this.idx().sanityCheck();
        this.idx().close();
    }

    public TimeIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

