/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.auth.Resource$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclAuthorizerTest$;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r]f\u0001B\u0001\u0003\u0001%\u0011\u0011#Q2m\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0006bkRDwN]5{KJT!!\u0002\u0004\u0002\u0011M,7-\u001e:jifT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tAB\u0003\u0002\u000e\r\u0005\u0011!p[\u0005\u0003\u001f1\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\tA\"\u00197m_^\u0014V-\u00193BG2,\u0012\u0001\u0007\t\u00033\rj\u0011A\u0007\u0006\u00037q\t1!Y2m\u0015\tib$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f}Q!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO&\u0011AE\u0007\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010\u0003\u0004'\u0001\u0001\u0006I\u0001G\u0001\u000eC2dwn\u001e*fC\u0012\f5\r\u001c\u0011\t\u000f!\u0002!\u0019!C\u0005/\u0005i\u0011\r\u001c7po^\u0013\u0018\u000e^3BG2DaA\u000b\u0001!\u0002\u0013A\u0012AD1mY><xK]5uK\u0006\u001bG\u000e\t\u0005\bY\u0001\u0011\r\u0011\"\u0003\u0018\u0003-!WM\\=SK\u0006$\u0017i\u00197\t\r9\u0002\u0001\u0015!\u0003\u0019\u00031!WM\\=SK\u0006$\u0017i\u00197!\u0011\u001d\u0001\u0004A1A\u0005\nE\n\u0001c^5mI\u000e\u000b'\u000f\u001a*fg>,(oY3\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u000f\u0002\u0011I,7o\\;sG\u0016L!a\u000e\u001b\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:Da!\u000f\u0001!\u0002\u0013\u0011\u0014!E<jY\u0012\u001c\u0015M\u001d3SKN|WO]2fA!91\b\u0001b\u0001\n\u0013\t\u0014\u0001\u00059sK\u001aL\u00070\u001a3SKN|WO]2f\u0011\u0019i\u0004\u0001)A\u0005e\u0005\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\t\u000f}\u0002!\u0019!C\u0005c\u0005y1\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\r\u0003\u0004B\u0001\u0001\u0006IAM\u0001\u0011G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002Bqa\u0011\u0001C\u0002\u0013%A)A\txS2$7-\u0019:e!JLgnY5qC2,\u0012!\u0012\t\u0003\r*k\u0011a\u0012\u0006\u0003\u0011&\u000bA!Y;uQ*\u0011Q\u0001H\u0005\u0003\u0017\u001e\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG\u000e\u0003\u0004N\u0001\u0001\u0006I!R\u0001\u0013o&dGmY1sIB\u0013\u0018N\\2ja\u0006d\u0007\u0005C\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u001b\u0005\u001cG.Q;uQ>\u0014\u0018N_3s+\u0005\t\u0006C\u0001\u000bS\u0013\t\u0019&AA\u0007BG2\fU\u000f\u001e5pe&TXM\u001d\u0005\u0007+\u0002\u0001\u000b\u0011B)\u0002\u001d\u0005\u001cG.Q;uQ>\u0014\u0018N_3sA!9q\u000b\u0001b\u0001\n\u0013\u0001\u0016AD1dY\u0006+H\u000f[8sSj,'O\r\u0005\u00073\u0002\u0001\u000b\u0011B)\u0002\u001f\u0005\u001cG.Q;uQ>\u0014\u0018N_3se\u0001B\u0011\"\u000e\u0001A\u0002\u0003\u0007I\u0011B\u0019\t\u0013q\u0003\u0001\u0019!a\u0001\n\u0013i\u0016\u0001\u0004:fg>,(oY3`I\u0015\fHC\u00010e!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u0011)f.\u001b;\t\u000f\u0015\\\u0016\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\r\u001d\u0004\u0001\u0015)\u00033\u0003%\u0011Xm]8ve\u000e,\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u00026\u0002\u0015M,\b/\u001a:Vg\u0016\u00148/F\u0001l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0003mC:<'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014aa\u0015;sS:<\u0007B\u0002;\u0001A\u0003%1.A\u0006tkB,'/V:feN\u0004\u0003b\u0002<\u0001\u0005\u0004%IA[\u0001\tkN,'O\\1nK\"1\u0001\u0010\u0001Q\u0001\n-\f\u0011\"^:fe:\fW.\u001a\u0011\t\u000fi\u0004!\u0019!C\u0005\t\u0006I\u0001O]5oG&\u0004\u0018\r\u001c\u0005\u0007y\u0002\u0001\u000b\u0011B#\u0002\u0015A\u0014\u0018N\\2ja\u0006d\u0007\u0005C\u0004\u007f\u0001\t\u0007I\u0011B@\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u000f\u0002\u0011I,\u0017/^3tiNLA!a\u0003\u0002\u0006\tq!+Z9vKN$8i\u001c8uKb$\b\u0002CA\b\u0001\u0001\u0006I!!\u0001\u0002\u001fI,\u0017/^3ti\u000e{g\u000e^3yi\u0002B1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0016\u000511m\u001c8gS\u001e,\"!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\u0007\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011EA\u000e\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011qE\u0001\u000bG>tg-[4`I\u0015\fHc\u00010\u0002*!IQ-a\t\u0002\u0002\u0003\u0007\u0011q\u0003\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u0018\u000591m\u001c8gS\u001e\u0004\u0003bCA\u0019\u0001\u0001\u0007\t\u0019!C\u0005\u0003g\tqB_8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e^\u000b\u0003\u0003k\u0001B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003w1\u0011!\u0003>p_.,W\r]3s\u0013\u0011\ty$!\u000f\u0003\u001fi{wnS3fa\u0016\u00148\t\\5f]RD1\"a\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002F\u0005\u0019\"p\\8LK\u0016\u0004XM]\"mS\u0016tGo\u0018\u0013fcR\u0019a,a\u0012\t\u0013\u0015\f\t%!AA\u0002\u0005U\u0002\u0002CA&\u0001\u0001\u0006K!!\u000e\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004cABA(\u0001\u0001\t\tFA\bDkN$x.\u001c)sS:\u001c\u0017\u000e]1m'\r\ti%\u0012\u0005\f\u0003+\niE!A!\u0002\u0013\t9&A\u0007qe&t7-\u001b9bYRK\b/\u001a\t\u0005\u00033\nyFD\u0002`\u00037J1!!\u0018a\u0003\u0019\u0001&/\u001a3fM&\u0019!/!\u0019\u000b\u0007\u0005u\u0003\rC\u0006\u0002f\u00055#\u0011!Q\u0001\n\u0005]\u0013\u0001\u00028b[\u0016Dq!EA'\t\u0003\tI\u0007\u0006\u0004\u0002l\u0005=\u0014\u0011\u000f\t\u0005\u0003[\ni%D\u0001\u0001\u0011!\t)&a\u001aA\u0002\u0005]\u0003\u0002CA3\u0003O\u0002\r!a\u0016\t\u0011\u0005U\u0014Q\nC!\u0003o\na!Z9vC2\u001cH\u0003BA=\u0003\u007f\u00022aXA>\u0013\r\ti\b\u0019\u0002\b\u0005>|G.Z1o\u0011!\t\t)a\u001dA\u0002\u0005\r\u0015!A8\u0011\u0007}\u000b))C\u0002\u0002\b\u0002\u00141!\u00118z\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000bQa]3u+B$\u0012A\u0018\u0015\u0005\u0003\u0013\u000b\t\n\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9*I\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00037\u000b)J\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003?\u0003A\u0011IAG\u0003!!X-\u0019:E_^t\u0007\u0006BAO\u0003G\u0003B!a%\u0002&&!\u0011qUAK\u0005\u0015\te\r^3s\u0011\u001d\tY\u000b\u0001C\u0001\u0003\u001b\u000bq\u0005^3ti\u0006+H\u000f[8sSj,G\u000b\u001b:poN|eNT8o\u0019&$XM]1m%\u0016\u001cx.\u001e:dK\"B\u0011\u0011VAX\u0003k\u000b9\f\u0005\u0003\u0002\u0014\u0006E\u0016\u0002BAZ\u0003+\u0013A\u0001V3ti\u0006AQ\r\u001f9fGR,Gm\t\u0002\u0002:B!\u00111XAf\u001d\u0011\ti,a2\u000f\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1\t\u0003\u0019a$o\\8u}%\t\u0011-C\u0002\u0002J\u0002\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0006='\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0019\u0011\u0011\u001a1\t\u000f\u0005M\u0007\u0001\"\u0001\u0002\u000e\u0006\u0011C/Z:u\u0003V$\bn\u001c:ju\u0016<\u0016\u000e\u001e5F[B$\u0018PU3t_V\u00148-\u001a(b[\u0016DC!!5\u00020\"9\u0011\u0011\u001c\u0001\u0005\u0002\u00055\u0015a\u0007;fgR,U\u000e\u001d;z\u0003\u000edG\u000b\u001b:poN,\u0005pY3qi&|g\u000e\u000b\u0003\u0002X\u0006=\u0006bBAp\u0001\u0011\u0005\u0011QR\u0001\ri\u0016\u001cH\u000fV8qS\u000e\f5\r\u001c\u0015\u0005\u0003;\fy\u000bC\u0004\u0002f\u0002!\t!!$\u0002EQ,7\u000f^!mY><\u0018iY2fgN<\u0016\u000e\u001e5DkN$x.\u001c)sS:\u001c\u0017\u000e]1mQ\u0011\t\u0019/a,\t\u000f\u0005-\b\u0001\"\u0001\u0002\u000e\u00069B/Z:u\t\u0016t\u0017\u0010V1lKN\u0004&/Z2fI\u0016t7-\u001a\u0015\u0005\u0003S\fy\u000bC\u0004\u0002r\u0002!\t!!$\u0002%Q,7\u000f^!mY><\u0018\t\u001c7BG\u000e,7o\u001d\u0015\u0005\u0003_\fy\u000bC\u0004\u0002x\u0002!\t!!$\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgNDC!!>\u00020\"9\u0011Q \u0001\u0005\u0002\u00055\u0015!\u000b;fgR\u001cV\u000f]3s+N,'oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D\u0015m]!dG\u0016\u001c8\u000f\u000b\u0003\u0002|\u0006=\u0006b\u0002B\u0002\u0001\u0011\u0005\u0011QR\u0001\u0011i\u0016\u001cHoV5mI\u000e\u000b'\u000fZ!dYNDCA!\u0001\u00020\"9!\u0011\u0002\u0001\u0005\u0002\u00055\u0015A\u0004;fgRtu.Q2m\r>,h\u000e\u001a\u0015\u0005\u0005\u000f\ty\u000bC\u0004\u0003\u0010\u0001!\t!!$\u0002-Q,7\u000f\u001e(p\u0003\u000edgi\\;oI>3XM\u001d:jI\u0016DCA!\u0004\u00020\"9!Q\u0003\u0001\u0005\u0002\u00055\u0015!\u0006;fgR\f5\r\\'b]\u0006<W-\\3oi\u0006\u0003\u0016j\u001d\u0015\u0005\u0005'\ty\u000bC\u0004\u0003\u001c\u0001!\t!!$\u0002\u001bQ,7\u000f\u001e'pC\u0012\u001c\u0015m\u00195fQ\u0011\u0011I\"a,\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002\u000e\u0006AB/Z:u\u0007\"\fgnZ3MSN$XM\\3s)&l\u0017N\\4)\t\t}\u0011q\u0016\u0005\b\u0005O\u0001A\u0011AAG\u00035\"Xm\u001d;M_\u000e\fGnQ8oGV\u0014(/\u001a8u\u001b>$\u0017NZ5dCRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0005\u0005K\ty\u000bC\u0004\u0003.\u0001!\t!!$\u0002gQ,7\u000f\u001e#jgR\u0014\u0018NY;uK\u0012\u001cuN\\2veJ,g\u000e^'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\b\u0006\u0002B\u0016\u0003_CqAa\r\u0001\t\u0003\ti)A\u0017uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u00170T8eS\u001aL7-\u0019;j_:|eMU3t_V\u00148-Z!dYNDCA!\r\u00020\"9!\u0011\b\u0001\u0005\u0002\u00055\u0015A\u0005;fgR\f5\r\\%oQ\u0016\u0014\u0018\u000e^1oG\u0016DCAa\u000e\u00020\"9!q\b\u0001\u0005\n\t\u0005\u0013a\u0006;fgRLU\u000e\u001d7jG\u0006$\u0018n\u001c8t\u001f\u001a\fE\u000e\\8x)\u0015q&1\tB'\u0011!\u0011)E!\u0010A\u0002\t\u001d\u0013\u0001\u00039be\u0016tGo\u00149\u0011\u0007e\u0011I%C\u0002\u0003Li\u0011A\"Q2m\u001fB,'/\u0019;j_:D\u0001Ba\u0014\u0003>\u0001\u0007!\u0011K\u0001\u000bC2dwn^3e\u001fB\u001c\bCBA-\u0005'\u00129%\u0003\u0003\u0003V\u0005\u0005$aA*fi\"9!\u0011\f\u0001\u0005\n\tm\u0013A\u0006;fgRLU\u000e\u001d7jG\u0006$\u0018n\u001c8t\u001f\u001a$UM\\=\u0015\u000by\u0013iFa\u0018\t\u0011\t\u0015#q\u000ba\u0001\u0005\u000fB\u0001B!\u0019\u0003X\u0001\u0007!\u0011K\u0001\nI\u0016t\u0017.\u001a3PaNDqA!\u001a\u0001\t\u0003\ti)A\u0015uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u0017\u0010R3mKRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0005\u0005G\ny\u000bC\u0004\u0003l\u0001!\t!!$\u0002gQ,7\u000f^!dG\u0016\u001c8/\u00117m_^,G-\u00134BY2|w/Q2m\u000bbL7\u000f^:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007\u0006\u0002B5\u0003_CqA!\u001d\u0001\t\u0003\ti)A\u0010uKN$H)\u001a7fi\u0016\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016DCAa\u001c\u00020\"9!q\u000f\u0001\u0005\u0002\u00055\u0015A\t;fgR$U\r\\3uK\u0006cG.Q2m\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\r\u000b\u0003\u0003v\u0005=\u0006b\u0002B?\u0001\u0011\u0005\u0011QR\u00014i\u0016\u001cH/Q2dKN\u001c\u0018\t\u001c7po\u0016$\u0017JZ!mY><\u0018i\u00197Fq&\u001cHo](o!J,g-\u001b=fIJ+7o\\;sG\u0016DCAa\u001f\u00020\"9!1\u0011\u0001\u0005\u0002\u00055\u0015a\b;fgR$U\r\\3uK\u0006\u001bGn\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\"!\u0011QAX\u0011\u001d\u0011I\t\u0001C\u0001\u0003\u001b\u000b!\u0005^3ti\u0012+G.\u001a;f\u00032d\u0017i\u00197P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007\u0006\u0002BD\u0003_CqAa$\u0001\t\u0003\ti)\u0001\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\u001c'ji\u0016\u0014\u0018\r\u001c*fg>,(oY3)\t\t5\u0015q\u0016\u0005\b\u0005+\u0003A\u0011AAG\u0003u!Xm\u001d;BI\u0012\f5\r\\:P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007\u0006\u0002BJ\u0003_CqAa'\u0001\t\u0003\ti)A\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\u0011\u0011I*a,\t\u000f\t\u0005\u0006\u0001\"\u0001\u0002\u000e\u0006\tC/Z:u\u0003V$\bn\u001c:ju\u0016<\u0016\u000e\u001e5Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\"!qTAX\u0011\u001d\u00119\u000b\u0001C\u0001\u0003\u001b\u000bq\u0004^3tiNKgn\u001a7f\u0007\"\f'/Y2uKJ\u0014Vm]8ve\u000e,\u0017i\u00197tQ\u0011\u0011)+a,\t\u000f\t5\u0006\u0001\"\u0001\u0002\u000e\u0006!B/Z:u\u000f\u0016$\u0018i\u00197t!JLgnY5qC2DCAa+\u00020\"9!1\u0017\u0001\u0005\u0002\u00055\u0015A\u0004;fgR\f5\r\\:GS2$XM\u001d\u0015\u0005\u0005c\u000by\u000bC\u0004\u0003:\u0002!\t!!$\u0002yQ,7\u000f\u001e+ie><8o\u00148BI\u0012\u0004&/\u001a4jq\u0016$\u0017i\u00197JM&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8U_>dun\u001e\u0015\u0005\u0005o\u000by\u000bC\u0004\u0003@\u0002!\t!!$\u0002wQ,7\u000f^,sSR,7/\u0012=uK:$W\rZ!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^%g\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+G\u000f\u000b\u0003\u0003>\u0006=\u0006b\u0002Bc\u0001\u0011\u0005\u0011QR\u0001Fi\u0016\u001cHo\u0016:ji\u0016\u001cX\t\u001f;f]\u0012,G-Q2m\u0007\"\fgnZ3Fm\u0016tGo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7Bi2+\u0017m\u001d;LC\u001a\\\u0017M\u0016\u001a)\t\t\r\u0017q\u0016\u0005\b\u0005\u0017\u0004A\u0011AAG\u0003a$Xm\u001d;Xe&$Xm\u001d'ji\u0016\u0014\u0018\r\\,sSR,7\u000fT5uKJ\fG.Q2m\u0007\"\fgnZ3Fm\u0016tGo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7MKN\u001cH\u000b[1o\u0017\u000647.\u0019,3KJ\fG.Q2m\u0007\"\fgnZ3t\r>\u0014x\n\u001c3feB\u0013x\u000e^8d_24VM]:j_:\u001c\b\u0006\u0002Be\u0003_CqA!5\u0001\t\u0003\ti)A uKN$xK]5uKNd\u0015\u000e^3sC2\f5\r\\\"iC:<W-\u0012<f]R<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|G.S:LC\u001a\\\u0017M\u0016\u001a)\t\t=\u0017q\u0016\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0003\t:\u0017N^3o\u0003V$\bn\u001c:ju\u0016\u0014x+\u001b;i!J|Go\\2pYZ+'o]5p]R\u0019aLa7\t\u0011\tu'Q\u001ba\u0001\u0005?\fq\u0002\u001d:pi>\u001cw\u000e\u001c,feNLwN\u001c\t\u0006?\n\u0005(Q]\u0005\u0004\u0005G\u0004'AB(qi&|g\u000e\u0005\u0003\u0003h\n5XB\u0001Bu\u0015\r\u0011YOB\u0001\u0004CBL\u0017\u0002\u0002Bx\u0005S\u0014!\"\u00119j-\u0016\u00148/[8o\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005k\f\u0011dZ3u\u0003\u000ed7\t[1oO\u0016,e/\u001a8u\u0003N\u001cFO]5oOR\u00191Na>\t\u0011\te(\u0011\u001fa\u0001\u0005w\f1\u0002]1ui\u0016\u0014h\u000eV=qKB\u00191G!@\n\u0007\t}HGA\u0006QCR$XM\u001d8UsB,\u0007bBB\u0002\u0001\u0011%1QA\u0001\u0013G\"\fgnZ3BG2\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0006\u0004\b\r%1QBB\t\u0007+\u0001R!!\u0017\u0003TaA\u0001ba\u0003\u0004\u0002\u0001\u00071qA\u0001\r_JLw-\u001b8bY\u0006\u001bGn\u001d\u0005\t\u0007\u001f\u0019\t\u00011\u0001\u0004\b\u0005I\u0011\r\u001a3fI\u0006\u001bGn\u001d\u0005\t\u0007'\u0019\t\u00011\u0001\u0004\b\u0005Y!/Z7pm\u0016$\u0017i\u00197t\u0011!)4\u0011\u0001I\u0001\u0002\u0004\u0011\u0004bBB\r\u0001\u0011%11D\u0001\u0012]\u0016<(+Z9vKN$8i\u001c8uKb$H\u0003CA\u0001\u0007;\u0019yba\f\t\ri\u001c9\u00021\u0001F\u0011!\u0019\tca\u0006A\u0002\r\r\u0012!D2mS\u0016tG/\u00113ee\u0016\u001c8\u000f\u0005\u0003\u0004&\r-RBAB\u0014\u0015\r\u0019Ic\\\u0001\u0004]\u0016$\u0018\u0002BB\u0017\u0007O\u00111\"\u00138fi\u0006#GM]3tg\"Q1\u0011GB\f!\u0003\u0005\raa\r\u0002\r\u0005\u0004\u0018nS3z!\u0011\u0019)da\u000f\u000e\u0005\r]\"bAB\u001d9\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0004>\r]\"aB!qS.+\u0017p\u001d\u0005\b\u0007\u0003\u0002A\u0011BB\"\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0006\u0002z\r\u00153qIB%\u0007\u001bBaaAB \u0001\u0004\t\u0006b\u0002@\u0004@\u0001\u0007\u0011\u0011\u0001\u0005\t\u0007\u0017\u001ay\u00041\u0001\u0003H\u0005Iq\u000e]3sCRLwN\u001c\u0005\u0007k\r}\u0002\u0019\u0001\u001a\t\u000f\rE\u0003\u0001\"\u0003\u0004T\u00059\u0011\r\u001a3BG2\u001cHc\u00020\u0004V\r]31\f\u0005\u0007\u0007\r=\u0003\u0019A)\t\u0011\re3q\na\u0001\u0007\u000f\tA!Y2fg\"91QLB(\u0001\u0004\u0011\u0014a\u0004:fg>,(oY3QCR$XM\u001d8\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d\u0005Q!/Z7pm\u0016\f5\r\\:\u0015\u0011\u0005e4QMB4\u0007SBaaAB0\u0001\u0004\t\u0006\u0002CB-\u0007?\u0002\raa\u0002\t\u000f\ru3q\fa\u0001e!91Q\u000e\u0001\u0005\n\r=\u0014aB4fi\u0006\u001bGn\u001d\u000b\u0007\u0007\u000f\u0019\tha\u001d\t\r\r\u0019Y\u00071\u0001R\u0011\u001d\u0019ifa\u001bA\u0002IBqa!\u001c\u0001\t\u0013\u00199\b\u0006\u0004\u0004z\r\u000551\u0011\t\u0007\u00033\u0012\u0019fa\u001f\u0011\u0007e\u0019i(C\u0002\u0004\u0000i\u0011!\"Q2m\u0005&tG-\u001b8h\u0011\u0019\u00191Q\u000fa\u0001#\"1!p!\u001eA\u0002\u0015Cqa!\u001c\u0001\t\u0013\u00199\t\u0006\u0003\u0004z\r%\u0005BB\u0002\u0004\u0006\u0002\u0007\u0011\u000bC\u0004\u0004\u000e\u0002!Iaa$\u0002\u000fY\fG.\u001b3PaR!\u0011\u0011PBI\u0011!\u0019\u0019ja#A\u0002\t\u001d\u0013AA8q\u0011%\u00199\nAI\u0001\n\u0013\u0019I*A\u000eoK^\u0014V-];fgR\u001cuN\u001c;fqR$C-\u001a4bk2$HeM\u000b\u0003\u00077SCaa\r\u0004\u001e.\u00121q\u0014\t\u0005\u0007C\u001bY+\u0004\u0002\u0004$*!1QUBT\u0003%)hn\u00195fG.,GMC\u0002\u0004*\u0002\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019ika)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00042\u0002\t\n\u0011\"\u0003\u00044\u0006a2\r[1oO\u0016\f5\r\\!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\"TCAB[U\r\u00114Q\u0014")
public class AclAuthorizerTest
extends ZooKeeperTestHarness {
    private final AccessControlEntry kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
    private final AccessControlEntry allowWriteAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
    private final AccessControlEntry kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
    private final ResourcePattern wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
    private final ResourcePattern kafka$security$authorizer$AclAuthorizerTest$$clusterResource = new ResourcePattern(ResourceType.CLUSTER, Resource$.MODULE$.ClusterResourceName(), PatternType.LITERAL);
    private final KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AuthorizerUtils$.MODULE$.WildcardPrincipal());
    private final AclAuthorizer kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer = new AclAuthorizer();
    private final AclAuthorizer kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2 = new AclAuthorizer();
    private ResourcePattern kafka$security$authorizer$AclAuthorizerTest$$resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestContext requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), this.newRequestContext$default$3());
    private KafkaConfig kafka$security$authorizer$AclAuthorizerTest$$config;
    private ZooKeeperClient zooKeeperClient;

    public AccessControlEntry kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    public AccessControlEntry kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    public ResourcePattern kafka$security$authorizer$AclAuthorizerTest$$clusterResource() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    public AclAuthorizer kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer;
    }

    public AclAuthorizer kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2;
    }

    public ResourcePattern kafka$security$authorizer$AclAuthorizerTest$$resource() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$resource;
    }

    private void kafka$security$authorizer$AclAuthorizerTest$$resource_$eq(ResourcePattern x$1) {
        this.kafka$security$authorizer$AclAuthorizerTest$$resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    public KafkaConfig kafka$security$authorizer$AclAuthorizerTest$$config() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$config;
    }

    private void kafka$security$authorizer$AclAuthorizerTest$$config_$eq(KafkaConfig x$1) {
        this.kafka$security$authorizer$AclAuthorizerTest$$config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.kafka$security$authorizer$AclAuthorizerTest$$config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().configure(this.kafka$security$authorizer$AclAuthorizerTest$$config().originals());
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2().configure(this.kafka$security$authorizer$AclAuthorizerTest$$config().originals());
        this.kafka$security$authorizer$AclAuthorizerTest$$resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().close();
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNonLiteralResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assert.assertFalse((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)((Object)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.$outer.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})), (boolean)(e.getCause() instanceof IllegalArgumentException));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host2Context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.WRITE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host2Context, AclOperation.WRITE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.ALTER, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host2Context, AclOperation.ALTER, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), user2Context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), user3Context, AclOperation.WRITE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host2Context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), session, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), session1, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), session2, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), session, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testWildCardAcls() {
        Assert.assertFalse((String)"when acls = [], authorizer should fail close.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assert.assertTrue((String)"User1 should have READ access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have WRITE access from host1", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), host1Context, AclOperation.WRITE, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [], authorizer should deny op.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        AclAuthorizer testAuthorizer = new AclAuthorizer();
        try {
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.", (boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        testAuthorizer.close();
    }

    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user1, acl1, acl2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            private final KafkaPrincipal user1$1;
            private final AccessControlEntry acl1$1;
            private final AccessControlEntry acl2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.acl1$1, this.acl2$1}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAclManagementAPIs$1 $outer;

                    public final AclBinding apply(AccessControlEntry acl) {
                        return new AclBinding(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$resource(), acl);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Set$.MODULE$.canBuildFrom());
                Set<AclBinding> set = this.$outer.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.user1$1);
                return !(object != null ? !object.equals(set) : set != null);
            }

            public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user1$1 = user1$1;
                this.acl1$1 = acl1$1;
                this.acl2$1 = acl2$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "changes not propagated in timeout period";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, user2, acl3, acl4, acl5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            private final KafkaPrincipal user2$1;
            private final AccessControlEntry acl3$1;
            private final AccessControlEntry acl4$1;
            private final AccessControlEntry acl5$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Object object = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.acl3$1, this.acl4$1, this.acl5$1}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAclManagementAPIs$2 $outer;

                    public final AclBinding apply(AccessControlEntry acl) {
                        return new AclBinding(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$resource(), acl);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Set$.MODULE$.canBuildFrom());
                Set<AclBinding> set = this.$outer.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.user2$1);
                return !(object != null ? !object.equals(set) : set != null);
            }

            public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user2$1 = user2$1;
                this.acl3$1 = acl3$1;
                this.acl4$1 = acl4$1;
                this.acl5$1 = acl5$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "changes not propagated in timeout period";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Map resourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;

            public final Set<AccessControlEntry> apply(Tuple2<ResourcePattern, Set<AccessControlEntry>> x0$1) {
                Tuple2<ResourcePattern, Set<AccessControlEntry>> tuple2 = x0$1;
                if (tuple2 != null) {
                    ResourcePattern key = (ResourcePattern)tuple2._1();
                    Set value = (Set)tuple2._2();
                    Set<AccessControlEntry> set = this.$outer.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
                    return set;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Set expectedAcls = ((TraversableOnce)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$security$authorizer$AclAuthorizerTest$$resource()), acls)).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Set<AclBinding> apply(Tuple2<ResourcePattern, Set<AccessControlEntry>> x0$2) {
                Tuple2<ResourcePattern, Set<AccessControlEntry>> tuple2 = x0$2;
                if (tuple2 != null) {
                    ResourcePattern res = (ResourcePattern)tuple2._1();
                    Set resAcls = (Set)tuple2._2();
                    Set set = (Set)resAcls.map((Function1)new Serializable(this, res){
                        public static final long serialVersionUID = 0L;
                        private final ResourcePattern res$1;

                        public final AclBinding apply(AccessControlEntry acl) {
                            return new AclBinding(this.res$1, acl);
                        }
                        {
                            this.res$1 = res$1;
                        }
                    }, Set$.MODULE$.canBuildFrom());
                    return set;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, expectedAcls){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            private final Set expectedAcls$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Set set = this.expectedAcls$1;
                Set<AclBinding> set2 = this.$outer.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer());
                return !(set != null ? !set.equals(set2) : set2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedAcls$1 = expectedAcls$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "changes not propagated in timeout period.";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        acls = this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.changeAclAndVerify$default$4());
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        Assert.assertTrue((!this.zkClient().resourceExists(AuthorizerUtils$.MODULE$.convertToResource(this.kafka$security$authorizer$AclAuthorizerTest$$resource())) ? 1 : 0) != 0);
        acls = this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.changeAclAndVerify$default$4());
        this.kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(AuthorizerUtils$.MODULE$.convertToResource(this.kafka$security$authorizer$AclAuthorizerTest$$resource())) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadCache() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)acls, this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set acls1 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        AclAuthorizer authorizer = new AclAuthorizer();
        try {
            authorizer.configure(this.kafka$security$authorizer$AclAuthorizerTest$$config().originals());
            Assert.assertEquals((Object)acls, this.getAcls(authorizer, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
            Assert.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
        catch (Throwable throwable) {
            void var8_8;
            var8_8.close();
            throw throwable;
        }
        authorizer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(this, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            Future<?> future = executor.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, aclAuthorizer3){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AclAuthorizerTest $outer;
                private final AclAuthorizer aclAuthorizer3$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.aclAuthorizer3$1.configure(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$config().originals());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.aclAuthorizer3$1 = aclAuthorizer3$1;
                }
            }));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)}));
            this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)acls, this.kafka$security$authorizer$AclAuthorizerTest$$resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            var4_4.close();
            var3_3.shutdownNow();
            throw throwable;
        }
        aclAuthorizer3.close();
        executor.shutdownNow();
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), commonResource);
    }

    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        boolean deleted = this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3}))), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), commonResource);
    }

    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        IndexedSeq acls = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<AccessControlEntry, Object> apply(int i) {
                KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                return new Tuple2((Object)new AccessControlEntry(useri.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)BoxesRunTime.boxToInteger((int)i));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1)new Serializable(this, commonResource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            public final ResourcePattern commonResource$1;

            public final Function0<Object> apply(Tuple2<AccessControlEntry, Object> x0$3) {
                Tuple2<AccessControlEntry, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    AccessControlEntry acl = (AccessControlEntry)tuple2._1();
                    int aclId = tuple2._2$mcI$sp();
                    Serializable serializable = new Serializable(this, acl, aclId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$6 $outer;
                        private final AccessControlEntry acl$1;
                        private final int aclId$1;

                        public final Object apply() {
                            if (this.aclId$1 % 2 == 0) {
                                this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.acl$1}))), this.$outer.commonResource$1);
                            } else {
                                this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.acl$1}))), this.$outer.commonResource$1);
                            }
                            return this.aclId$1 % 10 == 0 ? BoxesRunTime.boxToBoolean((boolean)this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.acl$1}))), this.$outer.commonResource$1)) : BoxedUnit.UNIT;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.acl$1 = acl$1;
                            this.aclId$1 = aclId$1;
                        }
                    };
                    return serializable;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commonResource$1 = commonResource$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set expectedAcls = ((TraversableOnce)((TraversableLike)acls.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<AccessControlEntry, Object> x0$4) {
                Tuple2<AccessControlEntry, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    int aclId = tuple2._2$mcI$sp();
                    boolean bl = aclId % 10 != 0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AccessControlEntry apply(Tuple2<AccessControlEntry, Object> x$1) {
                return (AccessControlEntry)x$1._1();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), commonResource);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.kafka$security$authorizer$AclAuthorizerTest$$clusterResource());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;

            public final boolean apply(AclOperation op) {
                return this.$outer.kafka$security$authorizer$AclAuthorizerTest$$validOp(op);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).foreach((Function1)new Serializable(this, parentOp, allowedOps, hostContext){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            private final AclOperation parentOp$1;
            private final Set allowedOps$1;
            private final RequestContext hostContext$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(AclOperation op) {
                boolean authorized;
                block3: {
                    block2: {
                        authorized = this.$outer.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.hostContext$1, op, this.$outer.kafka$security$authorizer$AclAuthorizerTest$$clusterResource());
                        if (this.allowedOps$1.contains((Object)op)) break block2;
                        AclOperation aclOperation = op;
                        AclOperation aclOperation2 = this.parentOp$1;
                        if (aclOperation != null ? !aclOperation.equals(aclOperation2) : aclOperation2 != null) break block3;
                    }
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW ", " should imply ALLOW ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$1, op})), (boolean)authorized);
                    return;
                }
                Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALLOW ", " should not imply ALLOW ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$1, op})), (boolean)authorized);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parentOp$1 = parentOp$1;
                this.allowedOps$1 = allowedOps$1;
                this.hostContext$1 = hostContext$1;
            }
        });
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.kafka$security$authorizer$AclAuthorizerTest$$clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)acls, this.kafka$security$authorizer$AclAuthorizerTest$$clusterResource());
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;

            public final boolean apply(AclOperation op) {
                return this.$outer.kafka$security$authorizer$AclAuthorizerTest$$validOp(op);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).foreach((Function1)new Serializable(this, parentOp, deniedOps, host1Context){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            private final AclOperation parentOp$2;
            private final Set deniedOps$1;
            private final RequestContext host1Context$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(AclOperation op) {
                boolean authorized;
                block3: {
                    block2: {
                        authorized = this.$outer.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.host1Context$1, op, this.$outer.kafka$security$authorizer$AclAuthorizerTest$$clusterResource());
                        if (this.deniedOps$1.contains((Object)op)) break block2;
                        AclOperation aclOperation = op;
                        AclOperation aclOperation2 = this.parentOp$2;
                        if (aclOperation != null ? !aclOperation.equals(aclOperation2) : aclOperation2 != null) break block3;
                    }
                    Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DENY ", " should imply DENY ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$2, op})), (boolean)authorized);
                    return;
                }
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DENY ", " should not imply DENY ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentOp$2, op})), (boolean)authorized);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parentOp$2 = parentOp$2;
                this.deniedOps$1 = deniedOps$1;
                this.host1Context$1 = host1Context$1;
            }
        });
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)acls, this.kafka$security$authorizer$AclAuthorizerTest$$clusterResource());
    }

    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        IndexedSeq concurrentFuctions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1)new Serializable(this, acl){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;
            public final AccessControlEntry acl$2;

            public final Function0<Object> apply(int x$2) {
                return new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.$outer.acl$2}))), this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$resource());
                        return this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.$outer.acl$2}))), this.$outer.kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer().kafka$security$authorizer$AclAuthorizerTest$$resource());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }

            public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.acl$2 = acl$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer2(), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), this.wildCardResource());
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), this.wildCardResource());
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), this.prefixedResource());
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl()}))), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl(), this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()})), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), this.wildCardResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl(), this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()})), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), this.prefixedResource());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl(), this.allowWriteAcl(), this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()})), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.prefixedResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.wildCardResource()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).append((Object)"-zzz").toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"fooo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"fo-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"fop-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"fon-").append((Object)UUID.randomUUID()).toString(), PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), this.prefixedResource());
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, this.kafka$security$authorizer$AclAuthorizerTest$$resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.kafka$security$authorizer$AclAuthorizerTest$$authorize(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AuthorizerUtils$.MODULE$.WildcardPrincipal(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.kafka$security$authorizer$AclAuthorizerTest$$resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.kafka$security$authorizer$AclAuthorizerTest$$getAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), this.principal()).size());
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"foo-").append((Object)UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder().append((Object)"bar-").append((Object)UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AuthorizerUtils$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4}))).asJava());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().acls(AclBindingFilter.ANY)).asScala()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().acls(matchingFilter)).asScala()).toSet());
        List filters = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{matchingFilter, acl1.toFilter(), new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY)}));
        Buffer deleteResults = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclDeleteResult apply(CompletionStage x$3) {
                return (AclDeleteResult)x$3.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)List$.MODULE$.empty(), (Object)deleteResults.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AclDeleteResult x$4) {
                return x$4.exception().isPresent();
            }
        }));
        filters.indices().foreach$mVc$sp((Function1)new Serializable(this, deleteResults){
            public static final long serialVersionUID = 0L;
            private final Buffer deleteResults$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)this.deleteResults$1.apply(i)).aclBindingDeleteResults()).asScala()).toSet().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AclDeleteResult.AclBindingDeleteResult x$5) {
                        return x$5.exception().isPresent();
                    }
                }));
            }
            {
                this.deleteResults$1 = deleteResults$1;
            }
        });
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclBinding apply(AclDeleteResult.AclBindingDeleteResult x$6) {
                return x$6.aclBinding();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclBinding apply(AclDeleteResult.AclBindingDeleteResult x$7) {
                return x$7.aclBinding();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclBinding apply(AclDeleteResult.AclBindingDeleteResult x$8) {
                return x$8.aclBinding();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclBinding apply(AclDeleteResult.AclBindingDeleteResult x$9) {
                return x$9.aclBinding();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)((Object)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AclAuthorizerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.$outer.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.$outer.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})), (boolean)(e.getCause() instanceof UnsupportedVersionException));
    }

    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.empty());
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(AuthorizerUtils$.MODULE$.convertToResource(resource)).bytes(), StandardCharsets.UTF_8);
        this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.kafka$security$authorizer$AclAuthorizerTest$$denyReadAcl()}))), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        protocolVersion.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(ApiVersion version) {
                return this.props$1.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), version.toString());
            }
            {
                this.props$1 = props$1;
            }
        });
        this.kafka$security$authorizer$AclAuthorizerTest$$config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer().configure(this.kafka$security$authorizer$AclAuthorizerTest$$config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        children.maybeThrow();
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)children.children().size());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{store.changeStore().aclChangePath(), children.children().head()})), GetDataRequest$.MODULE$.apply$default$2()));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    public Set<AccessControlEntry> kafka$security$authorizer$AclAuthorizerTest$$changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.kafka$security$authorizer$AclAuthorizerTest$$addAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), addedAcls, resource);
            acls = (Set)acls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.kafka$security$authorizer$AclAuthorizerTest$$removeAcls(this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.kafka$security$authorizer$AclAuthorizerTest$$aclAuthorizer(), resource);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.kafka$security$authorizer$AclAuthorizerTest$$resource();
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public boolean kafka$security$authorizer$AclAuthorizerTest$$authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    public void kafka$security$authorizer$AclAuthorizerTest$$addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1)new Serializable(this, resourcePattern){
            public static final long serialVersionUID = 0L;
            private final ResourcePattern resourcePattern$1;

            public final AclBinding apply(AccessControlEntry ace) {
                return new AclBinding(this.resourcePattern$1, ace);
            }
            {
                this.resourcePattern$1 = resourcePattern$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclCreateResult apply(CompletionStage x$10) {
                return (AclCreateResult)x$10.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AclCreateResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply(ApiException e) {
                        throw e;
                    }
                });
            }
        });
    }

    public boolean kafka$security$authorizer$AclAuthorizerTest$$removeAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1)new Serializable(this, resourcePattern){
            public static final long serialVersionUID = 0L;
            private final ResourcePattern resourcePattern$2;

            public final AclBindingFilter apply(AccessControlEntry ace) {
                return new AclBinding(this.resourcePattern$2, ace).toFilter();
            }
            {
                this.resourcePattern$2 = resourcePattern$2;
            }
        }, Set$.MODULE$.canBuildFrom());
        return ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclDeleteResult apply(CompletionStage x$11) {
                return (AclDeleteResult)x$11.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AclDeleteResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply(ApiException e) {
                        throw e;
                    }
                });
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result.aclBindingDeleteResults()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(AclDeleteResult.AclBindingDeleteResult r) {
                        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.exception())).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Nothing$ apply(ApiException e) {
                                throw e;
                            }
                        });
                    }
                });
                return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result.aclBindingDeleteResults()).asScala()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AclDeleteResult.AclBindingDeleteResult x$12) {
                        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$12.exception())).isEmpty();
                    }
                });
            }
        });
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        Set acls = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet();
        return (Set)acls.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AccessControlEntry apply(AclBinding x$13) {
                return x$13.entry();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public Set<AclBinding> kafka$security$authorizer$AclAuthorizerTest$$getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).toSet();
    }

    public Set<AclBinding> kafka$security$authorizer$AclAuthorizerTest$$getAcls(AclAuthorizer authorizer) {
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean kafka$security$authorizer$AclAuthorizerTest$$validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null) {
            if (aclOperation2 == null) return false;
        } else if (aclOperation.equals(aclOperation2)) return false;
        AclOperation aclOperation3 = op;
        AclOperation aclOperation4 = AclOperation.UNKNOWN;
        if (aclOperation3 != null) {
            if (!aclOperation3.equals(aclOperation4)) return true;
            return false;
        }
        if (aclOperation4 == null) return false;
        return true;
    }

    public AclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

