/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001\u000f\tQ\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002'\rdW-\u00198NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001B+oSRD#a\u0005\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t1!)\u001a4pe\u0016DQa\t\u0001\u0005\n\u0011\nabZ3u\u001b\u0016$(/[2WC2,X\r\u0006\u0002&QA\u0011\u0011BJ\u0005\u0003O)\u00111!\u00118z\u0011\u0015I#\u00051\u0001+\u0003\u0011q\u0017-\\3\u0011\u0005-rcBA\u0005-\u0013\ti#\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003_A\u0012aa\u0015;sS:<'BA\u0017\u000b\u0011\u0015\u0011\u0004\u0001\"\u0001\u0016\u0003e!Xm\u001d;BI\u0012\fe\u000e\u001a*f[>4X\rU1si&$\u0018n\u001c8)\u0005E\"\u0004CA\u000e6\u0013\t1DD\u0001\u0003UKN$\b\"\u0002\u001d\u0001\t\u0003)\u0012A\b;fgRlU\r\u001e:jG\u001a\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\t9D\u0007C\u0003<\u0001\u0011\u0005Q#A\ruKN$H)Z1e)\"\u0014X-\u00193D_VtG/T3ue&\u001c\u0007F\u0001\u001e5\u0001")
public class AbstractFetcherManagerTest {
    @Before
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(MetricName x$1) {
                String string = x$1.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        }).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        fetcher.addPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(fetchOffset, leaderEpoch))})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply(fetchOffset, leaderEpoch, (ReplicaState)Truncating$.MODULE$)));
        fetcher.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{fetcher});
        fetcherManager.addFetcherForPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assert.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        EasyMock.verify((Object[])new Object[]{fetcher});
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        fetcher.addPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(fetchOffset, leaderEpoch))})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{fetcher});
        fetcherManager.addFetcherForPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assert.assertEquals((long)1L, (long)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher});
        EasyMock.reset((Object[])new Object[]{fetcher});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{fetcher});
        Assert.assertEquals((long)0L, (long)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher});
    }
}

