/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u000f\t\u0001b)\u001a;dQN+7o]5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012!D4m_\n\fG\u000eV5nK>,H/F\u0001\u0017!\t9b$D\u0001\u0019\u0015\tI\"$A\u0003sk2,7O\u0003\u0002\u001c9\u0005)!.\u001e8ji*\tQ$A\u0002pe\u001eL!a\b\r\u0003\u000fQKW.Z8vi\"\u00121#\t\t\u0003E\rj\u0011AG\u0005\u0003Ii\u0011AAU;mK\")a\u0005\u0001C\u0001O\u0005\u0001B/Z:u\u001d\u0016<8+Z:tS>t\u0017\n\u001a\u000b\u0002QA\u0011\u0011\"K\u0005\u0003U)\u0011A!\u00168ji\"\u0012Q\u0005\f\t\u0003E5J!A\f\u000e\u0003\tQ+7\u000f\u001e\u0005\u0006a\u0001!\t!M\u0001\u0014CN\u001cXM\u001d;DC\u000eDWmQ8oi\u0006Lgn\u001d\u000b\u0004QI:\u0004\"B\u001a0\u0001\u0004!\u0014!B2bG\",\u0007C\u0001\n6\u0013\t1$AA\tGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016DQ\u0001O\u0018A\u0002e\n!b]3tg&|g.\u00133t!\rI!\bP\u0005\u0003w)\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tIQ(\u0003\u0002?\u0015\t\u0019\u0011J\u001c;\t\u000b\u0001\u0003A\u0011B!\u0002\u0017\u0011,X.\\=De\u0016\fG/\u001a\u000b\u0003\u0005F#\u0012a\u0011\t\u0004\t2sU\"A#\u000b\u0005\u0019;\u0015!B;uS2\u001c(B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011QA\u0013\u0006\u0003\u0017r\ta!\u00199bG\",\u0017BA'F\u0005qIU\u000e\u001d7jG&$H*\u001b8lK\u0012D\u0015m\u001d5D_2dWm\u0019;j_:\u0004\"AE(\n\u0005A\u0013!aD\"bG\",G\rU1si&$\u0018n\u001c8\t\u000bI{\u0004\u0019\u0001\u001f\u0002\tML'0\u001a\u0005\u0006)\u0002!\taJ\u0001\u0011i\u0016\u001cHoU3tg&|gnQ1dQ\u0016D#a\u0015\u0017\t\u000b]\u0003A\u0011A\u0014\u00021Q,7\u000f\u001e*fg&TXmQ1dQ\u0016$7+Z:tS>t7\u000f\u000b\u0002WY!9!\f\u0001b\u0001\n\u0003Y\u0016aD#N!RKv\fU!S)~c\u0015j\u0015+\u0016\u0003q\u00032!\u00182e\u001b\u0005q&BA0a\u0003\u0011)H/\u001b7\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002fM6\tq)\u0003\u0002h\u000f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB5\u0001A\u0003%A,\u0001\tF\u001bB#\u0016l\u0018)B%R{F*S*UA!)1\u000e\u0001C\u0001O\u0005\tB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f^:)\u0005)d\u0003\"\u00028\u0001\t\u00039\u0013a\u0007;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|g\u000e\u000b\u0002nY!)\u0011\u000f\u0001C\u0001O\u0005AB/Z:u5\u0016\u0014xnU5{K\u001a+Go\u00195TKN\u001c\u0018n\u001c8)\u0005Ad\u0003")
public class FetchSessionTest {
    private final List<TopicPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)new Serializable(this, cache){
            public static final long serialVersionUID = 0L;
            private final FetchSessionCache cache$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int id = this.cache$1.newSessionId();
                Assert.assertTrue((id > 0 ? 1 : 0) != 0);
            }
            {
                this.cache$1 = cache$1;
            }
        });
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)new Serializable(this, cache, sessionIds, i){
            public static final long serialVersionUID = 0L;
            private final FetchSessionCache cache$2;
            private final Seq sessionIds$1;
            private final IntRef i$1;

            public final void apply(int sessionId) {
                this.apply$mcVI$sp(sessionId);
            }

            public void apply$mcVI$sp(int sessionId) {
                ++this.i$1.elem;
                Assert.assertTrue((String)new StringBuilder().append((Object)"Missing session ").append((Object)BoxesRunTime.boxToInteger((int)this.i$1.elem)).append((Object)" out of ").append((Object)BoxesRunTime.boxToInteger((int)this.sessionIds$1.size())).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)sessionId)).append((Object)")").toString(), (boolean)this.cache$2.get(sessionId).isDefined());
            }
            {
                this.cache$2 = cache$2;
                this.sessionIds$1 = sessionIds$1;
                this.i$1 = i$1;
            }
        });
        Assert.assertEquals((long)sessionIds.size(), (long)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    public ImplicitLinkedHashCollection<CachedPartition> kafka$server$FetchSessionTest$$dummyCreate(int size2) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size2);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), size2 - 1).foreach((Function1)new Serializable(this, cacheMap){
            public static final long serialVersionUID = 0L;
            private final ImplicitLinkedHashCollection cacheMap$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.cacheMap$1.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", i));
            }
            {
                this.cacheMap$1 = cacheMap$1;
            }
        });
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assert.assertEquals((long)0L, (long)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(10);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int id2 = cache.maybeCreateSession(10L, false, 20, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(20);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int id3 = cache.maybeCreateSession(20L, false, 30, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(30);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(30L, false, 40, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(40);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(40L, false, 5, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(11);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(50);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(410L, false, 5, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        int id6 = cache.maybeCreateSession(410L, true, 5, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assert.assertEquals((long)0L, (long)cache.totalPartitions());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assert.assertEquals((long)2L, (long)session1.size());
        Assert.assertEquals((long)2L, (long)cache.totalPartitions());
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assert.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assert.assertEquals((long)6L, (long)cache.totalPartitions());
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchSessionTest $outer;

            public final ImplicitLinkedHashCollection<CachedPartition> apply() {
                return this.$outer.kafka$server$FetchSessionTest$$dummyCreate(5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assert.assertEquals((long)9L, (long)cache.totalPartitions());
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2}));
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assert.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assert.assertEquals((long)3L, (long)session2.size());
        Assert.assertEquals((long)4L, (long)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assert.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    public List<TopicPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        int prevSessionId;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        FetchContext context = fetchManager.newContext(FetchMetadata.LEGACY, new HashMap(), this.EMPTY_PART_LIST(), true);
        Assert.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData2.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context2 = fetchManager.newContext(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2)new Serializable(this, reqData2Iter){
            public static final long serialVersionUID = 0L;
            private final java.util.Iterator reqData2Iter$1;

            public final void apply(TopicPartition topicPart, FetchRequest.PartitionData data) {
                Map.Entry entry = (Map.Entry)this.reqData2Iter$1.next();
                Assert.assertEquals(entry.getKey(), (Object)topicPart);
                Assert.assertEquals(entry.getValue(), (Object)data);
            }
            {
                this.reqData2Iter$1 = reqData2Iter$1;
            }
        });
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 0)).get()));
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals(respData2, (Object)resp2.responseData());
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context3.getClass());
        Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchContext context4 = fetchManager.newContext(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context4.getClass());
        Assert.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData5 = new LinkedHashMap();
        FetchContext context5 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2)new Serializable(this, reqData5Iter){
            public static final long serialVersionUID = 0L;
            private final java.util.Iterator reqData5Iter$1;

            public final void apply(TopicPartition topicPart, FetchRequest.PartitionData data) {
                Map.Entry entry = (Map.Entry)this.reqData5Iter$1.next();
                Assert.assertEquals(entry.getKey(), (Object)topicPart);
                Assert.assertEquals(entry.getValue(), (Object)data);
            }
            {
                this.reqData5Iter$1 = reqData5Iter$1;
            }
        });
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(new TopicPartition("foo", 1)).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assert.assertEquals((long)resp2.sessionId(), (long)resp5.sessionId());
        Assert.assertEquals((long)0L, (long)resp5.responseData().size());
        FetchContext context6 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context6.getClass());
        Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData7 = new LinkedHashMap();
        FetchContext context7 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false);
        FetchResponse resp7 = context7.getThrottledResponse(100);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assert.assertEquals((long)resp2.sessionId(), (long)resp7.sessionId());
        Assert.assertEquals((long)100L, (long)resp7.throttleTimeMs());
        int nextSessionId = prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
            reqData8.put(new TopicPartition("bar", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            FetchContext context8 = fetchManager.newContext(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false);
            Assert.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assert.assertEquals((long)0L, (long)cache.size());
            LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData8 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
            respData8.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            respData8.put(new TopicPartition("bar", 1), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assert.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while ((nextSessionId = resp8.sessionId()) == prevSessionId);
    }

    @Test
    public void testIncrementalFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resp1.responseData().size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(15L, 0L, 0, Optional.empty()));
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assert.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Set parts2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 1), new TopicPartition("bar", 0)}));
        Iterator reqData2Iter = parts2.iterator();
        context2.foreachPartition((Function2)new Serializable(this, reqData2Iter){
            public static final long serialVersionUID = 0L;
            private final Iterator reqData2Iter$2;

            public final void apply(TopicPartition topicPart, FetchRequest.PartitionData data) {
                Assert.assertEquals((Object)this.reqData2Iter$2.next(), (Object)topicPart);
            }
            {
                this.reqData2Iter$2 = reqData2Iter$2;
            }
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("foo", 0)));
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        Assert.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("bar", 0)).get()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("bar", 2)));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        respData2.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((long)1L, (long)resp2.responseData().size());
        Assert.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resp1.responseData().size());
        LinkedHashMap reqData2 = new LinkedHashMap();
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        removed2.add(new TopicPartition("foo", 1));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assert.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((long)0L, (long)resp2.sessionId());
        Assert.assertTrue((boolean)resp2.responseData().isEmpty());
        Assert.assertEquals((long)0L, (long)cache.size());
    }
}

